/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class ElementSignature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ClassReferenceMirror[] EMPTY_CLASS_REFERENCE_MIRROR = new ClassReferenceMirror[0];
    private final String signature;
    private final ClassReferenceMirror type;
    private final ClassReferenceMirror genericDeclaration;
    private final ClassReferenceMirror[] parameters;

    public static ElementSignature GetSignature(String signature) {
        return null;
    }

    private ElementSignature(String signature) {
        this.signature = signature;
        boolean inGenericDeclaration = false;
        boolean inParameters = false;
        char start = signature.charAt(0);
        if (start == '<') {
            inGenericDeclaration = true;
            signature = signature.substring(1);
        }
        if (start == '(') {
            inParameters = true;
            signature = signature.substring(1);
        }
        StringBuilder buffer = new StringBuilder();
        ClassReferenceMirror genericDeclaration = null;
        ClassReferenceMirror[] parameters = null;
        try {
            for (int i = 0; i < signature.length(); ++i) {
                char c = signature.charAt(i);
                if (inGenericDeclaration) {
                    if (c == '>') {
                        String[] parts = buffer.toString().split(":");
                        genericDeclaration = new ClassReferenceMirror(parts[1], parts[0]);
                        buffer = new StringBuilder();
                        inGenericDeclaration = false;
                        inParameters = true;
                        ++i;
                        continue;
                    }
                    buffer.append(c);
                }
                if (inParameters) {
                    if (c == ')') {
                        parameters = this.parseParameters(buffer.toString());
                        buffer = new StringBuilder();
                        inParameters = false;
                        continue;
                    }
                    buffer.append(c);
                }
                if (inGenericDeclaration || inParameters) continue;
                buffer.append(c);
            }
            this.genericDeclaration = genericDeclaration;
            this.parameters = parameters;
            this.type = this.parseParameters(buffer.toString())[0];
        }
        catch (StackOverflowError e) {
            throw new Error("Got SOE while processing " + signature, e);
        }
    }

    private ClassReferenceMirror[] parseParameters(String params) {
        if ("".equals(params)) {
            return EMPTY_CLASS_REFERENCE_MIRROR;
        }
        ArrayList<ClassReferenceMirror> ret = new ArrayList<ClassReferenceMirror>();
        int arrayStack = 0;
        block0: for (int i = 0; i < params.length(); ++i) {
            char c = params.charAt(i);
            if (c == 'Z') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "Z"));
                arrayStack = 0;
                continue;
            }
            if (c == 'B') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "B"));
                arrayStack = 0;
                continue;
            }
            if (c == 'S') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "S"));
                arrayStack = 0;
                continue;
            }
            if (c == 'I') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "I"));
                arrayStack = 0;
                continue;
            }
            if (c == 'J') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "J"));
                arrayStack = 0;
                continue;
            }
            if (c == 'F') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "F"));
                arrayStack = 0;
                continue;
            }
            if (c == 'D') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "D"));
                arrayStack = 0;
                continue;
            }
            if (c == 'C') {
                ret.add(new ClassReferenceMirror(StringUtils.stringMultiply(arrayStack, "[") + "C"));
                arrayStack = 0;
                continue;
            }
            if (c == 'V') {
                ret.add(new ClassReferenceMirror("V"));
                continue;
            }
            if (c == '[') {
                ++arrayStack;
                continue;
            }
            if (c != 'L' && c != 'T') continue;
            boolean isObject = c == 'L';
            StringBuilder b = new StringBuilder();
            int angleStack = 0;
            for (int j = i + 1; j < params.length(); ++j) {
                i = j;
                char z = params.charAt(j);
                if (z == ';' && angleStack == 0) {
                    ret.add(this.parseObject(c + b.toString() + z));
                    continue block0;
                }
                if (z == '<') {
                    ++angleStack;
                    b.append(z);
                    continue;
                }
                if (z == '>') {
                    --angleStack;
                    b.append(z);
                    continue;
                }
                b.append(z);
            }
        }
        return ret.toArray(new ClassReferenceMirror[ret.size()]);
    }

    private ClassReferenceMirror parseObject(String obj) {
        if ("*".equals(obj)) {
            return ClassReferenceMirror.WILDCARD;
        }
        if (!obj.contains("<")) {
            return new ClassReferenceMirror(obj);
        }
        String rootType = obj.replaceAll("(.*?)<.*>;", "$1");
        ClassReferenceMirror[] params = this.parseParameters(obj.replaceAll(".*?<(.*)>;", "$1"));
        return new ClassReferenceMirror(rootType + ";", params);
    }

    public boolean isMethod() {
        return this.signature.contains("(");
    }

    public ClassReferenceMirror getType() {
        return new ClassReferenceMirror(this.signature.replaceAll("(?:<.*>)?(?:\\(.*\\))?(.*?)", "$1"));
    }

    public String toString() {
        return (this.genericDeclaration == null ? "" : this.genericDeclaration.toString()) + (this.parameters == null ? "" : Arrays.deepToString(this.parameters)) + this.type.toString();
    }
}

