/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.PureUtilities.ClassLoading.DynamicEnum;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.MDynamicEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@MDynamicEnum(value="com.commandhelper.PotionEffectType")
public abstract class MCPotionEffectType<Concrete>
extends DynamicEnum<MCVanillaPotionEffectType, Concrete> {
    protected static final Map<String, MCPotionEffectType> MAP = new HashMap<String, MCPotionEffectType>();
    protected static final Map<Integer, MCPotionEffectType> ID_MAP = new HashMap<Integer, MCPotionEffectType>();

    public MCPotionEffectType(MCVanillaPotionEffectType mcVanillaEffect, Concrete concrete) {
        super(mcVanillaEffect, concrete);
    }

    public static MCPotionEffectType valueOf(String test) throws IllegalArgumentException {
        MCPotionEffectType ret = MAP.get(test);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown potion effect type: " + test);
        }
        return ret;
    }

    public static Set<String> types() {
        if (MAP.isEmpty()) {
            HashSet<String> dummy = new HashSet<String>();
            for (MCVanillaPotionEffectType s : MCVanillaPotionEffectType.values()) {
                if (s.equals((Object)MCVanillaPotionEffectType.UNKNOWN)) continue;
                dummy.add(s.name());
            }
            return dummy;
        }
        return new TreeSet<String>(MAP.keySet());
    }

    public static List<MCPotionEffectType> values() {
        if (MAP.isEmpty()) {
            ArrayList<MCPotionEffectType> dummy = new ArrayList<MCPotionEffectType>();
            for (final MCVanillaPotionEffectType s : MCVanillaPotionEffectType.values()) {
                if (s.equals((Object)MCVanillaPotionEffectType.UNKNOWN)) continue;
                dummy.add(new MCPotionEffectType<Object>(s, null){

                    @Override
                    public String name() {
                        return s.name();
                    }
                });
            }
            return dummy;
        }
        return new ArrayList<MCPotionEffectType>(MAP.values());
    }

    public static MCPotionEffectType getById(int id) {
        MCPotionEffectType ret = ID_MAP.get(id);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown potion effect id: " + id);
        }
        return ret;
    }

    public int getId() {
        return ((MCVanillaPotionEffectType)((Object)this.getAbstracted())).getId();
    }

    public static enum MCVanillaPotionEffectType {
        UNKNOWN(0, MCVersion.NEVER),
        SPEED(1),
        SLOWNESS(2),
        HASTE(3),
        MINING_FATIGUE(4),
        STRENGTH(5),
        INSTANT_HEALTH(6),
        INSTANT_DAMAGE(7),
        JUMP_BOOST(8),
        NAUSEA(9),
        REGENERATION(10),
        RESISTANCE(11),
        FIRE_RESISTANCE(12),
        WATER_BREATHING(13),
        INVISIBILITY(14),
        BLINDNESS(15),
        NIGHT_VISION(16),
        HUNGER(17),
        WEAKNESS(18),
        POISON(19),
        WITHER(20),
        HEALTH_BOOST(21),
        ABSORPTION(22),
        SATURATION(23),
        GLOWING(24),
        LEVITATION(25),
        LUCK(26),
        BAD_LUCK(27),
        SLOW_FALLING(28),
        CONDUIT_POWER(29),
        DOLPHINS_GRACE(30, MCVersion.MC1_14),
        BAD_OMEN(31, MCVersion.MC1_14),
        HERO_OF_THE_VILLAGE(32, MCVersion.MC1_14),
        DARKNESS(33, MCVersion.MC1_19),
        TRIAL_OMEN(34, MCVersion.MC1_20_6),
        RAID_OMEN(35, MCVersion.MC1_20_6),
        WIND_CHARGED(36, MCVersion.MC1_20_6),
        WEAVING(37, MCVersion.MC1_20_6),
        OOZING(38, MCVersion.MC1_20_6),
        INFESTED(39, MCVersion.MC1_20_6),
        BREATH_OF_THE_NAUTILUS(40, MCVersion.MC1_21_11);

        private final int id;
        private final MCVersion since;

        private MCVanillaPotionEffectType(int id) {
            this.id = id;
            this.since = MCVersion.MC1_0;
        }

        private MCVanillaPotionEffectType(int id, MCVersion version) {
            this.id = id;
            this.since = version;
        }

        public int getId() {
            return this.id;
        }

        public boolean existsIn(MCVersion version) {
            return version.gte(this.since);
        }
    }
}

