/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.snapins;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.snapins.PackagePermission;

public enum CorePermissions implements PackagePermission
{
    FILE_READ("CORE.FILE.READ", PackagePermission.ThreatLevel.CAUTIOUS, "This permission grants read access to the filesystem, via the VFS only, therefore making it relatively safe compared to raw filesystem access.", MSVersion.V3_3_1),
    FILE_WRITE("CORE.FILE.WRITE", PackagePermission.ThreatLevel.CAUTIOUS, "This permission grants write access to the filesystem, via the VFS only, therefore making it relatively safe compared to raw filesystem access.", MSVersion.V3_3_1),
    FILE_RAW("CORE.FILE.RAW", PackagePermission.ThreatLevel.DANGEROUS, "This permission grants raw read/write access to the filesystem, outside of the VFS, which on most systems could allow for full control of the system", MSVersion.V3_3_1, new PackagePermission[]{FILE_READ, FILE_WRITE}),
    NETWORK("CORE.NETWORK", PackagePermission.ThreatLevel.CAUTIOUS, "This permission grants raw network access. If filesystem access is not allowed, this is a relatively safe permission to allow, but can be misused by malicious code to transmit sensitive data.", MSVersion.V3_3_1),
    GLOBAL_PERSISTENCE("CORE.GLOBAL_PERSISTENCE", PackagePermission.ThreatLevel.TRIVIAL, "This permission grants access to the global persistence storage. This generally cannot be abused, other than to delete other package's data.", MSVersion.V3_3_1);

    private final String[] namespace;
    private final PackagePermission.ThreatLevel threatLevel;
    private final String docs;
    private final MSVersion since;
    private final PackagePermission[] implied;

    private CorePermissions(String permission, PackagePermission.ThreatLevel threatLevel, String docs, MSVersion since) {
        this(permission, threatLevel, docs, since, (PackagePermission[])null);
    }

    private CorePermissions(String permission, PackagePermission.ThreatLevel threatLevel, String docs, MSVersion since, PackagePermission implied) {
        this(permission, threatLevel, docs, since, new PackagePermission[]{implied});
    }

    private CorePermissions(String permission, PackagePermission.ThreatLevel threatLevel, String docs, MSVersion since, PackagePermission[] implied) {
        this.namespace = permission.split("\\.");
        this.threatLevel = threatLevel;
        this.docs = docs;
        this.since = since;
        this.implied = implied == null ? new PackagePermission[0] : implied;
    }

    @Override
    public String[] getNamespace() {
        String[] array2 = new String[this.namespace.length];
        System.arraycopy(this.namespace, 0, array2, 0, array2.length);
        return array2;
    }

    @Override
    public PackagePermission.ThreatLevel getThreatLevel() {
        return this.threatLevel;
    }

    @Override
    public String getName() {
        return StringUtils.Join(this.namespace, ".");
    }

    @Override
    public String docs() {
        return this.docs;
    }

    @Override
    public MSVersion since() {
        return this.since;
    }
}

