/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.perf4j.logback;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.LayoutBase;
import com.laytonsmith.libs.org.perf4j.GroupedTimingStatistics;
import com.laytonsmith.libs.org.perf4j.helpers.GroupedTimingStatisticsCsvFormatter;
import com.laytonsmith.libs.org.perf4j.helpers.MiscUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsCsvLayout
extends LayoutBase<LoggingEvent> {
    private boolean pivot = false;
    private String columns = "tag,start,stop,mean,min,max,stddev,count";
    private boolean printNonStatistics = false;
    protected GroupedTimingStatisticsCsvFormatter csvFormatter;

    public boolean isPivot() {
        return this.pivot;
    }

    public void setPivot(boolean pivot) {
        this.pivot = pivot;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public boolean isPrintNonStatistics() {
        return this.printNonStatistics;
    }

    public void setPrintNonStatistics(boolean printNonStatistics) {
        this.printNonStatistics = printNonStatistics;
    }

    public String doLayout(LoggingEvent event) {
        try {
            return this.csvFormatter.format((GroupedTimingStatistics)event.getArgumentArray()[0]);
        }
        catch (ClassCastException cce) {
            if (this.isPrintNonStatistics()) {
                return MiscUtils.escapeStringForCsv(event.getFormattedMessage(), new StringBuilder()).append(MiscUtils.NEWLINE).toString();
            }
            return "";
        }
    }

    public void start() {
        super.start();
        this.csvFormatter = new GroupedTimingStatisticsCsvFormatter(this.isPivot(), this.getColumns());
    }
}

