/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.geometric;

import com.laytonsmith.libs.org.postgresql.geometric.PGpoint;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PGobject;
import com.laytonsmith.libs.org.postgresql.util.PGtokenizer;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint[] points;

    public PGpath(PGpoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public PGpath() {
        this.setType("path");
    }

    public PGpath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = PGtokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = PGtokenizer.removePara(s);
        } else {
            throw new PSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", s), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGtokenizer t = new PGtokenizer(s, ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        for (int p2 = 0; p2 < npoints; ++p2) {
            this.points[p2] = new PGpoint(t.getToken(p2));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGpath) {
            PGpath p2 = (PGpath)obj;
            if (p2.points.length != this.points.length) {
                return false;
            }
            if (p2.open != this.open) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p2.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash2 ^= this.points[i].hashCode();
        }
        return hash2;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGpath newPGpath = (PGpath)super.clone();
        if (newPGpath.points != null) {
            newPGpath.points = (PGpoint[])newPGpath.points.clone();
            for (int i = 0; i < newPGpath.points.length; ++i) {
                newPGpath.points[i] = (PGpoint)newPGpath.points[i].clone();
            }
        }
        return newPGpath;
    }

    @Override
    public String getValue() {
        StringBuffer b = new StringBuffer(this.open ? "[" : "(");
        for (int p2 = 0; p2 < this.points.length; ++p2) {
            if (p2 > 0) {
                b.append(",");
            }
            b.append(this.points[p2].toString());
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

