/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.csc;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.laytonsmith.libs.redis.clients.jedis.csc.ClientSideCache;
import com.laytonsmith.libs.redis.clients.jedis.csc.ClientSideCacheable;
import com.laytonsmith.libs.redis.clients.jedis.csc.DefaultClientSideCacheable;
import com.laytonsmith.libs.redis.clients.jedis.csc.hash.CommandLongHasher;
import com.laytonsmith.libs.redis.clients.jedis.csc.hash.OpenHftCommandHasher;
import java.util.concurrent.TimeUnit;

public class CaffeineClientSideCache
extends ClientSideCache {
    private final Cache<Long, Object> cache;

    public CaffeineClientSideCache(Cache<Long, Object> caffeineCache) {
        this(caffeineCache, (ClientSideCacheable)DefaultClientSideCacheable.INSTANCE);
    }

    public CaffeineClientSideCache(Cache<Long, Object> caffeineCache, ClientSideCacheable cacheable) {
        this(caffeineCache, new OpenHftCommandHasher(OpenHftCommandHasher.DEFAULT_HASH_FUNCTION), cacheable);
    }

    public CaffeineClientSideCache(Cache<Long, Object> caffeineCache, CommandLongHasher commandHasher, ClientSideCacheable cacheable) {
        super(commandHasher, cacheable);
        this.cache = caffeineCache;
    }

    @Override
    protected final void invalidateAllHashes() {
        this.cache.invalidateAll();
    }

    @Override
    protected void invalidateHashes(Iterable<Long> hashes) {
        this.cache.invalidateAll(hashes);
    }

    @Override
    protected void putValue(long hash2, Object value) {
        this.cache.put((Object)hash2, value);
    }

    @Override
    protected Object getValue(long hash2) {
        return this.cache.getIfPresent((Object)hash2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long maximumSize = 10000L;
        private long expireTime = 100L;
        private final TimeUnit expireTimeUnit = TimeUnit.SECONDS;
        private CommandLongHasher commandHasher = null;
        private ClientSideCacheable cacheable = DefaultClientSideCacheable.INSTANCE;

        private Builder() {
        }

        public Builder maximumSize(int size) {
            this.maximumSize = size;
            return this;
        }

        public Builder ttl(int seconds) {
            this.expireTime = seconds;
            return this;
        }

        public Builder commandHasher(CommandLongHasher commandHasher) {
            this.commandHasher = commandHasher;
            return this;
        }

        public Builder cacheable(ClientSideCacheable cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public CaffeineClientSideCache build() {
            Caffeine cb = Caffeine.newBuilder();
            cb.maximumSize(this.maximumSize);
            cb.expireAfterWrite(this.expireTime, this.expireTimeUnit);
            return this.commandHasher != null ? new CaffeineClientSideCache((Cache<Long, Object>)cb.build(), this.commandHasher, this.cacheable) : new CaffeineClientSideCache((Cache<Long, Object>)cb.build(), this.cacheable);
        }
    }
}

