/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCAttributeModifier;
import com.laytonsmith.abstraction.MCNamespacedKey;
import com.laytonsmith.abstraction.bukkit.BukkitMCNamespacedKey;
import com.laytonsmith.abstraction.enums.EnumConvertor;
import com.laytonsmith.abstraction.enums.MCAttribute;
import com.laytonsmith.abstraction.enums.MCEquipmentSlot;
import com.laytonsmith.abstraction.enums.MCEquipmentSlotGroup;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCAttribute;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEquipmentSlot;
import com.laytonsmith.annotations.abstractionenum;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;

public class BukkitMCAttributeModifier
implements MCAttributeModifier {
    private Attribute a;
    private AttributeModifier am;

    public BukkitMCAttributeModifier(Attribute a, AttributeModifier am) {
        this.a = a;
        this.am = am;
    }

    @Override
    public Object getHandle() {
        return this.am;
    }

    @Override
    public MCNamespacedKey getKey() {
        return new BukkitMCNamespacedKey(this.am.getKey());
    }

    @Override
    public String getAttributeName() {
        return this.am.getName();
    }

    @Override
    public MCAttribute getAttribute() {
        return BukkitMCAttribute.valueOfConcrete(this.a);
    }

    @Override
    public MCEquipmentSlot getEquipmentSlot() {
        EquipmentSlot slot = this.am.getSlot();
        if (slot == null) {
            return null;
        }
        return (MCEquipmentSlot)((Object)BukkitMCEquipmentSlot.getConvertor().getAbstractedEnum(slot));
    }

    @Override
    public MCEquipmentSlotGroup getEquipmentSlotGroup() {
        EquipmentSlotGroup slotGroup = this.am.getSlotGroup();
        if (slotGroup == EquipmentSlotGroup.ANY) {
            return MCEquipmentSlotGroup.ANY;
        }
        if (slotGroup == EquipmentSlotGroup.ARMOR) {
            return MCEquipmentSlotGroup.ARMOR;
        }
        if (slotGroup == EquipmentSlotGroup.HAND) {
            return MCEquipmentSlotGroup.HAND;
        }
        if (slotGroup.toString().equals("body")) {
            return MCEquipmentSlotGroup.BODY;
        }
        if (slotGroup.toString().equals("saddle")) {
            return MCEquipmentSlotGroup.SADDLE;
        }
        return null;
    }

    @Override
    public MCAttributeModifier.Operation getOperation() {
        return (MCAttributeModifier.Operation)((Object)Operation.getConvertor().getAbstractedEnum(this.am.getOperation()));
    }

    @Override
    public double getAmount() {
        return this.am.getAmount();
    }

    @Override
    public UUID getUniqueId() {
        return this.am.getUniqueId();
    }

    public String toString() {
        return this.am.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof MCAttributeModifier && this.am.equals(((MCAttributeModifier)obj).getHandle());
    }

    public int hashCode() {
        return this.am.hashCode();
    }

    @abstractionenum(implementation=Implementation.Type.BUKKIT, forAbstractEnum=MCAttributeModifier.Operation.class, forConcreteEnum=AttributeModifier.Operation.class)
    public static class Operation
    extends EnumConvertor<MCAttributeModifier.Operation, AttributeModifier.Operation> {
        private static Operation instance;

        public static Operation getConvertor() {
            if (instance == null) {
                instance = new Operation();
            }
            return instance;
        }
    }
}

