/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Web;

import com.laytonsmith.PureUtilities.Web.HTTPHeader;
import com.laytonsmith.PureUtilities.Web.HTTPHeaders;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HTTPResponse {
    private String rawResponse = null;
    private final HTTPHeaders headers;
    private final String responseText;
    private final int responseCode;
    private final byte[] content;
    private final String httpVersion;

    public HTTPResponse(String responseText, int responseCode, Map<String, List<String>> headers, byte[] response, String httpVersion) {
        this.responseText = responseText;
        this.responseCode = responseCode;
        ArrayList<HTTPHeader> h = new ArrayList<HTTPHeader>();
        for (String key : headers.keySet()) {
            for (String value : headers.get(key)) {
                h.add(new HTTPHeader(key, value));
            }
        }
        this.headers = new HTTPHeaders(h);
        this.content = response;
        this.httpVersion = httpVersion;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentAsString() {
        try {
            return this.getContentAsString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public String getContentAsString(String encoding) throws UnsupportedEncodingException {
        return new String(this.getContent(), encoding);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Deprecated
    public String getFirstHeader(String key) {
        return this.headers.getFirstHeader(key);
    }

    @Deprecated
    public Set<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    @Deprecated
    public List<String> getHeaders(String key) {
        return this.headers.getHeaders(key);
    }

    public HTTPHeaders getHeaderObject() {
        return this.headers;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public String toString() {
        if (this.rawResponse == null) {
            this.rawResponse = "HTTP/" + this.httpVersion + " " + this.responseCode + " " + this.responseText + "\n";
            for (HTTPHeader h : this.headers) {
                if (h.getHeader() == null) continue;
                this.rawResponse = this.rawResponse + h.getHeader() + ": " + h.getValue() + "\n";
            }
            this.rawResponse = this.rawResponse + "\n<bytes of length " + this.content.length + ">";
        }
        return this.rawResponse;
    }
}

