/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.database;

import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.database.SQLProfile;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Profiles.ProfileType(type="mssql")
public class MSSQLProfile
extends SQLProfile {
    private final String host;
    private final String instance;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private static final List<String> HANDLED_LIST = Arrays.asList("database", "username", "password", "host", "instance", "port");
    private final Map<String, String> extraParameters = new HashMap<String, String>();

    public MSSQLProfile(String id, Map<String, String> elements) throws Profiles.InvalidProfileException {
        super(id, elements);
        if (!elements.containsKey("database")) {
            throw new Profiles.InvalidProfileException("Required \"database\" tag is missing for profile \"" + id + "\"");
        }
        this.database = elements.get("database");
        this.username = elements.containsKey("username") ? elements.get("username") : null;
        this.password = elements.containsKey("password") ? elements.get("password") : null;
        if (elements.containsKey("azureHost")) {
            String host = elements.get("azureHost") + ".database.windows.net";
            elements.remove("azureHost");
            elements.put("host", host);
        }
        this.host = elements.containsKey("host") ? elements.get("host") : "localhost";
        this.instance = elements.containsKey("instance") ? "\\" + elements.get("instance") : "";
        if (elements.containsKey("port")) {
            try {
                this.port = Integer.parseInt(elements.get("port"));
            }
            catch (NumberFormatException ex) {
                throw new Profiles.InvalidProfileException(ex.getMessage());
            }
        } else {
            this.port = 1433;
        }
        if (elements.containsKey("integratedSecurity")) {
            String dllName = (String)ReflectionUtils.get(SQLServerDriver.class, "AUTH_DLL_NAME");
            if (!new File(MethodScriptFileLocations.getDefault().getWindowsNativeDirectory(), dllName + ".dll").exists()) {
                if (OSUtils.GetOS().isWindows()) {
                    throw new Profiles.InvalidProfileException("integratedSecurity was configured, but MethodScript is not properly configured. Please run `mscript -- install-mssql-auth` to automatically configure your system.");
                }
                throw new Profiles.InvalidProfileException("Integrated Security is only available on Windows.");
            }
        }
        for (Map.Entry<String, String> entry : elements.entrySet()) {
            if (HANDLED_LIST.contains(entry.getKey())) continue;
            this.extraParameters.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getConnectionString() throws SQLException {
        try {
            Class.forName(SQLServerDriver.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Cannot load MSSQL. Check your installation and try again");
        }
        String connectionString = "jdbc:sqlserver://" + this.host;
        if (this.instance != null) {
            connectionString = connectionString + "\\" + this.instance;
        }
        connectionString = connectionString + ":" + this.port;
        connectionString = connectionString + ";";
        if (this.username != null) {
            connectionString = connectionString + "user=" + this.username + ";";
        }
        if (this.password != null) {
            connectionString = connectionString + "password=" + this.password + ";";
        }
        connectionString = connectionString + "databaseName=" + this.database + ";";
        for (Map.Entry<String, String> params : this.extraParameters.entrySet()) {
            connectionString = connectionString + params.getKey() + "=" + params.getValue() + ";";
        }
        return connectionString;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.host + this.instance + ":" + this.port;
    }
}

