/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.EarlyBindingKeyword;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.Compiler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;

@Keyword.keyword(value="switch")
public class SwitchKeyword
extends EarlyBindingKeyword {
    @Override
    public int process(TokenStream stream, Environment env, int keywordPosition) throws ConfigCompileException {
        ListIterator<Token> it;
        int codeStart = -1;
        int parenthesisStack = 0;
        ListIterator it2 = stream.listIterator(keywordPosition);
        while (it2.hasNext()) {
            int ind = it2.nextIndex();
            Token token = (Token)it2.next();
            Token next = null;
            if (it2.hasNext()) {
                next = (Token)it2.next();
                it2.previous();
                it2.previous();
                it2.next();
            }
            if (token.type == Token.TType.FUNC_START) {
                ++parenthesisStack;
            }
            if (token.type != Token.TType.FUNC_END) continue;
            if (--parenthesisStack == 0 && next != null && next.type == Token.TType.LCURLY_BRACKET) {
                codeStart = ind + 1;
                break;
            }
            if (parenthesisStack != 0) continue;
            return keywordPosition;
        }
        if (codeStart == -1) {
            return keywordPosition;
        }
        ArrayList<Token> newStream = new ArrayList<Token>();
        int codeEnd = -1;
        Comparator tokenComparator = (o1, o2) -> o1.toString().compareTo(o2.toString());
        TreeSet caseLabels = new TreeSet(tokenComparator);
        boolean inCase = false;
        boolean inDefault = false;
        boolean inCode = false;
        boolean pastDefault = false;
        boolean firstComma = false;
        int parenthesisStack2 = 0;
        int braceStack = 0;
        int bracketStack = 0;
        ListIterator it22 = stream.listIterator(codeStart + 1);
        block9: while (it22.hasNext()) {
            int i = it22.nextIndex();
            Token t = (Token)it22.next();
            if (inCode) {
                if (null != t.type) {
                    switch (t.type) {
                        case FUNC_START: {
                            ++parenthesisStack2;
                            newStream.add(t);
                            continue block9;
                        }
                        case FUNC_END: {
                            --parenthesisStack2;
                            newStream.add(t);
                            continue block9;
                        }
                        case LSQUARE_BRACKET: {
                            ++bracketStack;
                            newStream.add(t);
                            continue block9;
                        }
                        case RSQUARE_BRACKET: {
                            --bracketStack;
                            newStream.add(t);
                            continue block9;
                        }
                        case LCURLY_BRACKET: {
                            ++braceStack;
                            newStream.add(t);
                            continue block9;
                        }
                        case RCURLY_BRACKET: {
                            if (--braceStack == -1) {
                                codeEnd = i;
                                break block9;
                            }
                            newStream.add(t);
                            continue block9;
                        }
                    }
                }
            } else {
                if (t.type == Token.TType.COMMENT || t.type == Token.TType.SMART_COMMENT) continue;
                if (t.type == Token.TType.RCURLY_BRACKET) {
                    --braceStack;
                    codeEnd = i;
                    break;
                }
            }
            if (parenthesisStack2 > 0 || braceStack > 0 || bracketStack > 0) {
                newStream.add(t);
                continue;
            }
            if (i == codeStart + 1 && !CKeyword.isKeyword(t, "case") && !CKeyword.isKeyword(t, "default")) {
                throw new ConfigCompileException("Expected a case or default keyword here", t.target);
            }
            if (CKeyword.isKeyword(t, "case")) {
                inCase = true;
                inCode = false;
                continue;
            }
            if (CKeyword.isKeyword(t, "default")) {
                if (!caseLabels.isEmpty()) {
                    caseLabels = new TreeSet(tokenComparator);
                }
                if (!it22.hasNext()) {
                    throw new ConfigCompileException("Expected colon after default keyword", t.target);
                }
                Token next = (Token)it22.next();
                if (next.type != Token.TType.LABEL) {
                    throw new ConfigCompileException("Expected colon after default keyword", next.target);
                }
                inDefault = true;
                inCode = true;
                continue;
            }
            if (!caseLabels.isEmpty() && (inCode || inDefault)) {
                if (firstComma) {
                    newStream.add(new Token(Token.TType.COMMA, ",", Target.UNKNOWN));
                }
                firstComma = true;
                if (caseLabels.size() > 1) {
                    newStream.add(new Token(Token.TType.FUNC_NAME, "array", Target.UNKNOWN));
                    newStream.add(new Token(Token.TType.FUNC_START, "(", Target.UNKNOWN));
                }
                boolean first = true;
                for (List list : caseLabels) {
                    if (!first) {
                        newStream.add(new Token(Token.TType.COMMA, ",", Target.UNKNOWN));
                    }
                    first = false;
                    for (Token tt : list) {
                        if (tt.type == Token.TType.SMART_STRING) {
                            tt = Compiler.__smart_string__.getDumbStringOrFail(tt);
                        }
                        newStream.add(tt);
                    }
                }
                if (caseLabels.size() > 1) {
                    newStream.add(new Token(Token.TType.FUNC_END, ")", Target.UNKNOWN));
                }
                newStream.add(new Token(Token.TType.COMMA, ",", Target.UNKNOWN));
                caseLabels = new TreeSet(tokenComparator);
                if (inDefault) {
                    inCode = true;
                    inDefault = false;
                    newStream.add(t);
                    continue;
                }
                newStream.add(t);
                continue;
            }
            if (inCase) {
                if (pastDefault) {
                    throw new ConfigCompileException("Unexpected case clause. Default case must come last.", t.target);
                }
                ArrayList<Token> caseTokens = new ArrayList<Token>();
                while (t.type != Token.TType.LABEL) {
                    if (t.type != Token.TType.LIT && t.type != Token.TType.SLICE && t.type != Token.TType.STRING && t.type != Token.TType.INTEGER && t.type != Token.TType.KEYWORD && t.type != Token.TType.DOT && t.type != Token.TType.SMART_STRING) {
                        throw new ConfigCompileException("Unsupported type in case clause", t.target);
                    }
                    caseTokens.add(t);
                    if (!it22.hasNext()) {
                        throw new ConfigCompileException("Incomplete case clause", t.target);
                    }
                    t = (Token)it22.next();
                }
                caseLabels.add(caseTokens);
                inCase = false;
                inCode = true;
                continue;
            }
            if (inDefault && !pastDefault) {
                newStream.add(new Token(Token.TType.COMMA, ",", Target.UNKNOWN));
                pastDefault = true;
            }
            newStream.add(t);
        }
        if (braceStack != -1) {
            throw new ConfigCompileException("Missing end brace", ((Token)stream.get((int)codeStart)).target);
        }
        if (!caseLabels.isEmpty()) {
            Token first = (Token)((List)new ArrayList(caseLabels).get(0)).get(0);
            CompilerWarning warning = new CompilerWarning("Useless case clause", first.target, FileOptions.SuppressWarning.UselessCode);
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(stream.getFileOptions(), warning);
        }
        if (!newStream.isEmpty()) {
            it = stream.listIterator(codeStart - 1);
            Token token = (Token)it.next();
            it.set(new Token(Token.TType.COMMA, ",", token.target.copy()));
        } else {
            it = stream.listIterator(codeStart);
        }
        for (int i = codeStart; i <= codeEnd; ++i) {
            it.next();
            it.remove();
        }
        if (!newStream.isEmpty()) {
            it.add(new Token(Token.TType.FUNC_END, ")", Target.UNKNOWN));
            it.previous();
            it.previous();
            it.next();
        }
        ListIterator it222 = newStream.listIterator();
        while (it222.hasNext()) {
            it.add((Token)it222.next());
        }
        return keywordPosition;
    }

    @Override
    public String docs() {
        return "Defines a switch block, which is a more efficient, but narrower version of an if/else if/else chain.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

