/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCRecipeChoice;
import com.laytonsmith.abstraction.MCShapelessRecipe;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCRecipe;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;

public class BukkitMCShapelessRecipe
extends BukkitMCRecipe
implements MCShapelessRecipe {
    private final ShapelessRecipe recipe;

    public BukkitMCShapelessRecipe(ShapelessRecipe recipe) {
        super((Recipe)recipe);
        this.recipe = recipe;
    }

    @Override
    public String getKey() {
        return this.recipe.getKey().getKey();
    }

    @Override
    public MCRecipeType getRecipeType() {
        return MCRecipeType.SHAPELESS;
    }

    @Override
    public String getGroup() {
        return this.recipe.getGroup();
    }

    @Override
    public void setGroup(String group) {
        this.recipe.setGroup(group);
    }

    @Override
    public Object getHandle() {
        return this.recipe;
    }

    @Override
    public MCItemStack getResult() {
        return new BukkitMCItemStack(this.recipe.getResult());
    }

    @Override
    public List<MCRecipeChoice> getIngredients() {
        List choiceList = this.recipe.getChoiceList();
        ArrayList<MCRecipeChoice> ret = new ArrayList<MCRecipeChoice>(choiceList.size());
        for (RecipeChoice recipeChoice : choiceList) {
            MCRecipeChoice choice;
            if (recipeChoice instanceof RecipeChoice.MaterialChoice) {
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
                choice = new MCRecipeChoice.MaterialChoice();
                for (Material material : materialChoice.getChoices()) {
                    ((MCRecipeChoice.MaterialChoice)choice).addMaterial(BukkitMCMaterial.valueOfConcrete(material));
                }
                ret.add(choice);
                continue;
            }
            if (!(recipeChoice instanceof RecipeChoice.ExactChoice)) continue;
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)recipeChoice;
            choice = new MCRecipeChoice.ExactChoice();
            for (ItemStack itemStack : exactChoice.getChoices()) {
                ((MCRecipeChoice.ExactChoice)choice).addItem(new BukkitMCItemStack(itemStack));
            }
            ret.add(choice);
        }
        return ret;
    }

    @Override
    public void addIngredient(MCMaterial ingredient, int amount) {
        this.recipe.addIngredient(amount, (Material)ingredient.getHandle());
    }

    @Override
    public void addIngredient(MCMaterial ingredient) {
        this.recipe.addIngredient((Material)ingredient.getHandle());
    }

    @Override
    public void addIngredient(MCRecipeChoice choice) {
        if (choice instanceof MCRecipeChoice.ExactChoice) {
            ArrayList<ItemStack> itemChoice = new ArrayList<ItemStack>();
            for (MCItemStack itemStack : ((MCRecipeChoice.ExactChoice)choice).getItems()) {
                itemChoice.add((ItemStack)itemStack.getHandle());
            }
            this.recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(itemChoice));
        } else if (choice instanceof MCRecipeChoice.MaterialChoice) {
            ArrayList<Material> materialChoice = new ArrayList<Material>();
            for (MCMaterial material : ((MCRecipeChoice.MaterialChoice)choice).getMaterials()) {
                materialChoice.add((Material)material.getHandle());
            }
            this.recipe.addIngredient((RecipeChoice)new RecipeChoice.MaterialChoice(materialChoice));
        }
    }
}

