/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.MCArmorMeta;
import com.laytonsmith.abstraction.MCAttributeModifier;
import com.laytonsmith.abstraction.MCAxolotlBucketMeta;
import com.laytonsmith.abstraction.MCBannerMeta;
import com.laytonsmith.abstraction.MCBlockStateMeta;
import com.laytonsmith.abstraction.MCBookMeta;
import com.laytonsmith.abstraction.MCBrewerInventory;
import com.laytonsmith.abstraction.MCBundleMeta;
import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCColorableArmorMeta;
import com.laytonsmith.abstraction.MCCompassMeta;
import com.laytonsmith.abstraction.MCCookingRecipe;
import com.laytonsmith.abstraction.MCCooldownComponent;
import com.laytonsmith.abstraction.MCCreatureSpawner;
import com.laytonsmith.abstraction.MCCrossbowMeta;
import com.laytonsmith.abstraction.MCEnchantmentStorageMeta;
import com.laytonsmith.abstraction.MCEquippableComponent;
import com.laytonsmith.abstraction.MCFireworkBuilder;
import com.laytonsmith.abstraction.MCFireworkEffect;
import com.laytonsmith.abstraction.MCFireworkEffectMeta;
import com.laytonsmith.abstraction.MCFireworkMeta;
import com.laytonsmith.abstraction.MCFoodComponent;
import com.laytonsmith.abstraction.MCFurnaceInventory;
import com.laytonsmith.abstraction.MCInventory;
import com.laytonsmith.abstraction.MCInventoryHolder;
import com.laytonsmith.abstraction.MCItemFactory;
import com.laytonsmith.abstraction.MCItemMeta;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCKnowledgeBookMeta;
import com.laytonsmith.abstraction.MCLeatherArmorMeta;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCMapMeta;
import com.laytonsmith.abstraction.MCMetadataValue;
import com.laytonsmith.abstraction.MCMusicInstrumentMeta;
import com.laytonsmith.abstraction.MCNamespacedKey;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.MCOminousBottleMeta;
import com.laytonsmith.abstraction.MCParticleData;
import com.laytonsmith.abstraction.MCPattern;
import com.laytonsmith.abstraction.MCPlayerProfile;
import com.laytonsmith.abstraction.MCPlugin;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCPotionMeta;
import com.laytonsmith.abstraction.MCProfileProperty;
import com.laytonsmith.abstraction.MCRecipe;
import com.laytonsmith.abstraction.MCRecipeChoice;
import com.laytonsmith.abstraction.MCShapedRecipe;
import com.laytonsmith.abstraction.MCShapelessRecipe;
import com.laytonsmith.abstraction.MCSkullMeta;
import com.laytonsmith.abstraction.MCSmithingRecipe;
import com.laytonsmith.abstraction.MCStonecuttingRecipe;
import com.laytonsmith.abstraction.MCSuspiciousStewMeta;
import com.laytonsmith.abstraction.MCTropicalFishBucketMeta;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.blocks.MCBanner;
import com.laytonsmith.abstraction.blocks.MCBeehive;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.blocks.MCBrewingStand;
import com.laytonsmith.abstraction.blocks.MCCommandBlock;
import com.laytonsmith.abstraction.blocks.MCDecoratedPot;
import com.laytonsmith.abstraction.blocks.MCFurnace;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.blocks.MCSign;
import com.laytonsmith.abstraction.blocks.MCSignText;
import com.laytonsmith.abstraction.entities.MCTropicalFish;
import com.laytonsmith.abstraction.enums.MCAttribute;
import com.laytonsmith.abstraction.enums.MCAxolotlType;
import com.laytonsmith.abstraction.enums.MCDyeColor;
import com.laytonsmith.abstraction.enums.MCEnchantment;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCEquipmentSlot;
import com.laytonsmith.abstraction.enums.MCEquipmentSlotGroup;
import com.laytonsmith.abstraction.enums.MCFireworkType;
import com.laytonsmith.abstraction.enums.MCItemFlag;
import com.laytonsmith.abstraction.enums.MCItemRarity;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.MCPatternShape;
import com.laytonsmith.abstraction.enums.MCPotionEffectType;
import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import com.laytonsmith.abstraction.enums.MCTagType;
import com.laytonsmith.abstraction.enums.MCTrimMaterial;
import com.laytonsmith.abstraction.enums.MCTrimPattern;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREEnchantmentException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.MatchResult;

public class ObjectGenerator {
    private static ObjectGenerator pog = null;

    public static ObjectGenerator GetGenerator() {
        if (pog == null) {
            pog = new ObjectGenerator();
        }
        return pog;
    }

    public CArray location(MCLocation l) {
        return this.location(l, true);
    }

    public CArray location(MCLocation l, boolean includeYawAndPitch) {
        CArray ca = CArray.GetAssociativeArray(Target.UNKNOWN);
        CDouble x = new CDouble(l.getX(), Target.UNKNOWN);
        CDouble y = new CDouble(l.getY(), Target.UNKNOWN);
        CDouble z = new CDouble(l.getZ(), Target.UNKNOWN);
        Construct world = l.getWorld() != null ? new CString(l.getWorld().getName(), Target.UNKNOWN) : CNull.NULL;
        ca.set("0", (Mixed)x, Target.UNKNOWN);
        ca.set("1", (Mixed)y, Target.UNKNOWN);
        ca.set("2", (Mixed)z, Target.UNKNOWN);
        ca.set("3", (Mixed)world, Target.UNKNOWN);
        ca.set("x", (Mixed)x, Target.UNKNOWN);
        ca.set("y", (Mixed)y, Target.UNKNOWN);
        ca.set("z", (Mixed)z, Target.UNKNOWN);
        ca.set("world", (Mixed)world, Target.UNKNOWN);
        if (includeYawAndPitch) {
            float yawRaw = l.getYaw() % 360.0f;
            if (yawRaw < 0.0f) {
                yawRaw += 360.0f;
            }
            CDouble yaw = new CDouble(yawRaw, Target.UNKNOWN);
            CDouble pitch = new CDouble(l.getPitch(), Target.UNKNOWN);
            ca.set("4", (Mixed)yaw, Target.UNKNOWN);
            ca.set("5", (Mixed)pitch, Target.UNKNOWN);
            ca.set("yaw", (Mixed)yaw, Target.UNKNOWN);
            ca.set("pitch", (Mixed)pitch, Target.UNKNOWN);
        }
        return ca;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MCLocation location(Mixed c, MCWorld w, Target t) {
        if (!c.isInstanceOf(CArray.TYPE)) {
            throw new CREFormatException("Expecting an array, received " + c.typeof().getSimpleName(), t);
        }
        CArray array2 = (CArray)c;
        MCWorld world = w;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (!array2.inAssociativeMode()) {
            if (array2.size() == 3L) {
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
            } else if (array2.size() == 4L) {
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
                world = Static.getServer().getWorld(array2.get(3, t).val());
            } else if (array2.size() == 5L) {
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
                yaw = (float)ArgumentValidation.getNumber(array2.get(3, t), t);
                pitch = (float)ArgumentValidation.getNumber(array2.get(4, t), t);
            } else {
                if (array2.size() != 6L) throw new CREFormatException("Expecting a Location array, but the array did not meet the format specifications", t);
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
                world = Static.getServer().getWorld(array2.get(3, t).val());
                yaw = (float)ArgumentValidation.getNumber(array2.get(4, t), t);
                pitch = (float)ArgumentValidation.getNumber(array2.get(5, t), t);
            }
        } else {
            if (array2.containsKey("x")) {
                x = ArgumentValidation.getNumber(array2.get("x", t), t);
            }
            if (array2.containsKey("y")) {
                y = ArgumentValidation.getNumber(array2.get("y", t), t);
            }
            if (array2.containsKey("z")) {
                z = ArgumentValidation.getNumber(array2.get("z", t), t);
            }
            if (array2.containsKey("world")) {
                world = Static.getServer().getWorld(array2.get("world", t).val());
            }
            if (array2.containsKey("yaw")) {
                yaw = (float)ArgumentValidation.getDouble(array2.get("yaw", t), t);
            }
            if (array2.containsKey("pitch")) {
                pitch = (float)ArgumentValidation.getDouble(array2.get("pitch", t), t);
            }
        }
        if (world != null) return StaticLayer.GetLocation(world, x, y, z, yaw, pitch);
        throw new CREInvalidWorldException("The specified world doesn't exist, or no world was provided", t);
    }

    public Construct item(MCItemStack is, Target t) {
        if (is == null || is.isEmpty()) {
            return CNull.NULL;
        }
        CArray ret = CArray.GetAssociativeArray(t);
        ret.set("name", (Mixed)new CString(is.getType().getName(), t), t);
        ret.set("qty", (Mixed)new CInt(is.getAmount(), t), t);
        ret.set("meta", (Mixed)this.itemMeta(is, t), t);
        return ret;
    }

    public MCItemStack item(Mixed i, Target t) {
        return this.item(i, t, false);
    }

    public MCItemStack item(Mixed i, Target t, boolean legacy) {
        MCItemStack ret;
        String mat;
        if (i instanceof CNull) {
            return ObjectGenerator.EmptyItem();
        }
        if (!i.isInstanceOf(CArray.TYPE)) {
            throw new CREFormatException("Expected an array!", t);
        }
        CArray item = (CArray)i;
        if (!item.isAssociative()) {
            throw new CREFormatException("Expected an associative array!", t);
        }
        int data = 0;
        int qty = 1;
        if (item.containsKey("qty") && (qty = ArgumentValidation.getInt32(item.get("qty", t), t)) <= 0) {
            return ObjectGenerator.EmptyItem();
        }
        boolean bl = legacy = legacy || item.containsKey("type") || item.containsKey("data");
        if (legacy) {
            String entityName;
            MCMaterial newmaterial;
            Mixed spawntype;
            Mixed meta;
            MCMaterial material;
            if (item.containsKey("data")) {
                data = ArgumentValidation.getInt32(item.get("data", t), t);
            }
            if (item.containsKey("name")) {
                mat = item.get("name", t).val();
                material = mat.equals("MAP") || mat.equals("POTION") ? StaticLayer.GetMaterialFromLegacy(mat, 0) : StaticLayer.GetMaterialFromLegacy(mat, data);
            } else {
                int seperatorIndex;
                Mixed type = item.get("type", t);
                if (type.isInstanceOf(CString.TYPE) && (seperatorIndex = type.val().indexOf(58)) != -1) {
                    try {
                        data = Integer.parseInt(type.val().substring(seperatorIndex + 1));
                    }
                    catch (NumberFormatException e) {
                        throw new CRERangeException("The item data \"" + type.val().substring(seperatorIndex + 1) + "\" is not a valid integer.", t);
                    }
                    type = new CString(type.val().substring(0, seperatorIndex), t);
                }
                mat = type.val();
                int id = ArgumentValidation.getInt32(type, t);
                material = id == 358 || id == 373 ? StaticLayer.GetMaterialFromLegacy(id, 0) : StaticLayer.GetMaterialFromLegacy(id, data);
            }
            if ((material == null || material.getName().equals("AIR")) && (material = StaticLayer.GetMaterial(mat)) == null) {
                throw new CREFormatException("Could not find legacy item material from \"" + mat + "\" with data \"" + data + "\"", t);
            }
            if (material.getName().equals("PIG_SPAWN_EGG") && item.containsKey("meta") && (meta = item.get("meta", t)).isInstanceOf(CArray.TYPE) && ((CArray)meta).containsKey("spawntype") && !((spawntype = ((CArray)meta).get("spawntype", t)) instanceof CNull) && (newmaterial = (entityName = spawntype.val().toUpperCase()).equals("MUSHROOM_COW") ? StaticLayer.GetMaterial("MOOSHROOM_SPAWN_EGG") : (entityName.equals("PIG_ZOMBIE") ? StaticLayer.GetMaterial("ZOMBIE_PIGMAN_SPAWN_EGG") : StaticLayer.GetMaterial(entityName + "_SPAWN_EGG"))) != null) {
                material = newmaterial;
            }
            if (!material.isItem()) {
                material = MCMaterial.get("AIR");
            }
            ret = StaticLayer.GetItemStack(material, qty);
            MSLog.GetLogger().w(MSLog.Tags.DEPRECATION, "Converted \"" + mat + "\" with data \"" + data + "\" to " + material.getName(), t);
        } else {
            mat = item.get("name", t).val();
            ret = StaticLayer.GetItemStack(mat, qty);
        }
        if (ret == null) {
            throw new CREFormatException("Could not find item material from \"" + mat + "\"", t);
        }
        if (ret.isEmpty()) {
            return ret;
        }
        if (item.containsKey("meta")) {
            ret.setItemMeta(this.itemMeta(item.get("meta", t), ret.getType(), t));
        }
        if (legacy) {
            if (ret.getType().getName().equals("FILLED_MAP")) {
                meta = (MCMapMeta)ret.getItemMeta();
                meta.setMapId(data);
                ret.setItemMeta(meta);
            } else if (data > 0 && ret.getType().getMaxDurability() > 0) {
                meta = ret.getItemMeta();
                meta.setDamage(data);
                ret.setItemMeta(meta);
            }
        }
        if (item.containsKey("enchants")) {
            try {
                Map<MCEnchantment, Integer> enchants = this.enchants((CArray)item.get("enchants", t), t);
                for (Map.Entry<MCEnchantment, Integer> entry : enchants.entrySet()) {
                    ret.addUnsafeEnchantment(entry.getKey(), entry.getValue());
                }
                MSLog.GetLogger().w(MSLog.Tags.DEPRECATION, "Converted legacy enchants array not in meta.", t);
            }
            catch (ClassCastException ex) {
                throw new CREFormatException("Enchants must be an array of enchantment arrays.", t);
            }
        }
        return ret;
    }

    private static MCItemStack EmptyItem() {
        return StaticLayer.GetItemStack("AIR", 0);
    }

    public Construct itemMeta(MCItemStack is, Target t) {
        String sound;
        Construct lore;
        if (is == null || !is.hasItemMeta()) {
            return CNull.NULL;
        }
        CArray ma = CArray.GetAssociativeArray(t);
        MCItemMeta meta = is.getItemMeta();
        MCMaterial material = is.getType();
        Construct display = meta.hasDisplayName() ? new CString(meta.getDisplayName(), t) : CNull.NULL;
        if (meta.hasLore()) {
            lore = new CArray(t);
            for (String l : meta.getLore()) {
                ((CArray)lore).push(new CString(l, t), t);
            }
        } else {
            lore = CNull.NULL;
        }
        ma.set("display", (Mixed)display, t);
        ma.set("lore", (Mixed)lore, t);
        ma.set("enchants", (Mixed)this.enchants(meta.getEnchants(), t), t);
        ma.set("repair", (Mixed)new CInt(meta.getRepairCost(), t), t);
        if (meta.hasCustomModelData()) {
            ma.set("model", (Mixed)new CInt(meta.getCustomModelData(), t), t);
        } else {
            ma.set("model", (Mixed)CNull.NULL, t);
        }
        Set<MCItemFlag> itemFlags = meta.getItemFlags();
        CArray flagArray = new CArray(t);
        if (!itemFlags.isEmpty()) {
            for (MCItemFlag flag : itemFlags) {
                flagArray.push(new CString(flag.name(), t), t);
            }
        }
        ma.set("flags", (Mixed)flagArray, t);
        List<MCAttributeModifier> modifierList = meta.getAttributeModifiers();
        if (modifierList == null) {
            ma.set("modifiers", (Mixed)CNull.NULL, t);
        } else {
            CArray modifiers = new CArray(t);
            for (MCAttributeModifier m : modifierList) {
                modifiers.push(this.attributeModifier(m, t), t);
            }
            ma.set("modifiers", (Mixed)modifiers, t);
        }
        if (meta.hasCustomTags()) {
            ma.set("tags", MCTagType.TAG_CONTAINER.construct(meta.getCustomTags()), t);
        } else {
            ma.set("tags", (Mixed)CNull.NULL, t);
        }
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
            if (meta.hasMaxStackSize()) {
                ma.set("maxstacksize", (Mixed)new CInt(meta.getMaxStackSize(), t), t);
            }
            if (meta.hasEnchantmentGlintOverride()) {
                ma.set("glint", (Mixed)CBoolean.get(meta.getEnchantmentGlintOverride()), t);
            }
            if (meta.hasRarity()) {
                ma.set("rarity", (Mixed)new CString(meta.getRarity().name(), t), t);
            }
            if (meta.hasMaxDamage()) {
                ma.set("maxdamage", (Mixed)new CInt(meta.getMaxDamage(), t), t);
            }
            if (meta.hasDamage() || material.getMaxDurability() > 0) {
                ma.set("damage", (Mixed)new CInt(meta.getDamage(), t), t);
                ma.set("unbreakable", (Mixed)CBoolean.get(meta.isUnbreakable()), t);
            } else if (meta.isUnbreakable()) {
                ma.set("unbreakable", (Mixed)CBoolean.TRUE, t);
            }
            if (material.isBlock()) {
                if (meta.hasBlockData()) {
                    Map<String, String> blockData = meta.getExistingBlockData();
                    if (blockData != null) {
                        ma.set("blockdata", (Mixed)this.blockData(material, blockData, t), t);
                    } else {
                        ma.set("blockdata", (Mixed)CNull.NULL, t);
                    }
                } else {
                    ma.set("blockdata", (Mixed)CNull.NULL, t);
                }
            }
            if (meta.hasFood()) {
                MCFoodComponent foodComponent = meta.getFood();
                CArray food = CArray.GetAssociativeArray(t);
                food.set("nutrition", (Mixed)new CInt(foodComponent.getNutrition(), t), t);
                food.set("saturation", (Mixed)new CDouble(foodComponent.getSaturation(), t), t);
                food.set("always", (Mixed)CBoolean.get(foodComponent.getCanAlwaysEat()), t);
                ma.set("food", (Mixed)food, t);
            }
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21) && meta.hasJukeboxPlayable()) {
                ma.set("jukeboxsong", (Mixed)new CString(meta.getJukeboxPlayable(), t), t);
            }
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_3)) {
                if (meta.hasEnchantable()) {
                    ma.set("enchantability", (Mixed)new CInt(meta.getEnchantable(), t), t);
                }
                if (meta.isGlider()) {
                    ma.set("glider", (Mixed)CBoolean.TRUE, t);
                }
                if (meta.hasUseRemainder()) {
                    ma.set("remainder", (Mixed)this.item(meta.getUseRemainder(), t), t);
                }
                if (meta.hasUseCooldown()) {
                    MCCooldownComponent cooldownComponent = meta.getUseCooldown();
                    CArray cooldown = CArray.GetAssociativeArray(t);
                    cooldown.set("seconds", (Mixed)new CDouble(cooldownComponent.getSeconds(), t), t);
                    String group = cooldownComponent.getCooldownGroup();
                    if (group != null) {
                        cooldown.set("group", (Mixed)new CString(group, t), t);
                    }
                    ma.set("cooldown", (Mixed)cooldown, t);
                }
                if (meta.hasItemModel()) {
                    ma.set("itemmodel", (Mixed)new CString(meta.getItemModel(), t), t);
                }
                if (meta.hasTooltipStyle()) {
                    ma.set("tooltipstyle", (Mixed)new CString(meta.getTooltipStyle(), t), t);
                }
                if (meta.hasEquippable()) {
                    Collection<MCEntityType> allowedEntities;
                    String cameraOverlay;
                    MCEquippableComponent equippableComponent = meta.getEquippable();
                    CArray equippable = CArray.GetAssociativeArray(t);
                    MCEquipmentSlot slot = equippableComponent.getSlot();
                    equippable.set("slot", (Mixed)new CString(slot.name(), t), t);
                    String asset = equippableComponent.getAssetId();
                    if (asset != null) {
                        equippable.set("asset", (Mixed)new CString(asset, t), t);
                    }
                    if ((cameraOverlay = equippableComponent.getCameraOverlay()) != null) {
                        equippable.set("overlay", (Mixed)new CString(cameraOverlay, t), t);
                    }
                    if ((allowedEntities = equippableComponent.getAllowedEntities()) != null) {
                        CArray entities = new CArray(t);
                        for (MCEntityType type : allowedEntities) {
                            entities.push(new CString(type.name(), t), t);
                        }
                        equippable.set("entities", (Mixed)entities, t);
                    }
                    if ((sound = equippableComponent.getEquipSound()) != null) {
                        equippable.set("sound", (Mixed)new CString(sound, t), t);
                    }
                    equippable.set("dispensable", (Mixed)CBoolean.get(equippableComponent.isDispensable()), t);
                    equippable.set("swappable", (Mixed)CBoolean.get(equippableComponent.isSwappable()), t);
                    equippable.set("damageable", (Mixed)CBoolean.get(equippableComponent.isDamageOnHurt()), t);
                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_5)) {
                        equippable.set("interactable", (Mixed)CBoolean.get(equippableComponent.isEquipOnInteract()), t);
                    }
                    ma.set("equippable", (Mixed)equippable, t);
                }
            }
        } else if (material.getMaxDurability() > 0) {
            ma.set("damage", (Mixed)new CInt(meta.getDamage(), t), t);
            ma.set("unbreakable", (Mixed)CBoolean.get(meta.isUnbreakable()), t);
        } else if (material.isBlock()) {
            if (meta.hasBlockData()) {
                ma.set("blockdata", (Mixed)this.blockData(meta.getBlockData(material), t), t);
            } else {
                ma.set("blockdata", (Mixed)CNull.NULL, t);
            }
        }
        if (meta instanceof MCBlockStateMeta) {
            MCBlockState bs = ((MCBlockStateMeta)meta).getBlockState(true);
            if (bs instanceof MCBanner) {
                if (((MCBlockStateMeta)meta).hasBlockState()) {
                    MCBanner banner = (MCBanner)bs;
                    ma.set("basecolor", banner.getBaseColor().name(), t);
                    CArray patterns = new CArray(t, banner.numberOfPatterns());
                    for (MCPattern p2 : banner.getPatterns()) {
                        CArray cArray = CArray.GetAssociativeArray(t);
                        cArray.set("shape", (Mixed)new CString(p2.getShape().toString(), t), t);
                        cArray.set("color", (Mixed)new CString(p2.getColor().toString(), t), t);
                        patterns.push(cArray, t);
                    }
                    ma.set("patterns", (Mixed)patterns, t);
                }
            } else if (bs instanceof MCCreatureSpawner) {
                MCCreatureSpawner mccs = (MCCreatureSpawner)bs;
                MCEntityType type = mccs.getSpawnedType();
                if (type == null) {
                    ma.set("spawntype", (Mixed)CNull.NULL, t);
                } else {
                    ma.set("spawntype", type.name());
                }
                ma.set("delay", (Mixed)new CInt(mccs.getDelay(), t), t);
                ma.set("mindelay", (Mixed)new CInt(mccs.getMinDelay(), t), t);
                ma.set("maxdelay", (Mixed)new CInt(mccs.getMaxDelay(), t), t);
                ma.set("spawncount", (Mixed)new CInt(mccs.getSpawnCount(), t), t);
                ma.set("maxnearbyentities", (Mixed)new CInt(mccs.getMaxNearbyEntities(), t), t);
                ma.set("playerrange", (Mixed)new CInt(mccs.getPlayerRange(), t), t);
                ma.set("spawnrange", (Mixed)new CInt(mccs.getSpawnRange(), t), t);
            } else if (bs instanceof MCBrewingStand) {
                MCBrewingStand brewStand = (MCBrewingStand)bs;
                ma.set("brewtime", (Mixed)new CInt(brewStand.getBrewingTime(), t), t);
                ma.set("fuel", (Mixed)new CInt(brewStand.getFuelLevel(), t), t);
                MCBrewerInventory inv = brewStand.getInventory();
                CArray invData = CArray.GetAssociativeArray(t);
                if (inv.getFuel().getAmount() != 0) {
                    invData.set("fuel", (Mixed)ObjectGenerator.GetGenerator().item(inv.getFuel(), t), t);
                }
                if (inv.getIngredient().getAmount() != 0) {
                    invData.set("ingredient", (Mixed)ObjectGenerator.GetGenerator().item(inv.getIngredient(), t), t);
                }
                if (inv.getLeftBottle().getAmount() != 0) {
                    invData.set("leftbottle", (Mixed)ObjectGenerator.GetGenerator().item(inv.getLeftBottle(), t), t);
                }
                if (inv.getMiddleBottle().getAmount() != 0) {
                    invData.set("middlebottle", (Mixed)ObjectGenerator.GetGenerator().item(inv.getMiddleBottle(), t), t);
                }
                if (inv.getRightBottle().getAmount() != 0) {
                    invData.set("rightbottle", (Mixed)ObjectGenerator.GetGenerator().item(inv.getRightBottle(), t), t);
                }
                ma.set("inventory", (Mixed)invData, t);
            } else if (bs instanceof MCFurnace) {
                MCFurnace furnace = (MCFurnace)bs;
                ma.set("burntime", (Mixed)new CInt(furnace.getBurnTime(), t), t);
                ma.set("cooktime", (Mixed)new CInt(furnace.getCookTime(), t), t);
                MCFurnaceInventory inv = furnace.getInventory();
                CArray invData = CArray.GetAssociativeArray(t);
                if (inv.getResult().getAmount() != 0) {
                    invData.set("result", (Mixed)ObjectGenerator.GetGenerator().item(inv.getResult(), t), t);
                }
                if (inv.getFuel().getAmount() != 0) {
                    invData.set("fuel", (Mixed)ObjectGenerator.GetGenerator().item(inv.getFuel(), t), t);
                }
                if (inv.getSmelting().getAmount() != 0) {
                    invData.set("smelting", (Mixed)ObjectGenerator.GetGenerator().item(inv.getSmelting(), t), t);
                }
                ma.set("inventory", (Mixed)invData, t);
            } else if (bs instanceof MCDecoratedPot) {
                MCDecoratedPot decoratedPot = (MCDecoratedPot)bs;
                CArray sherds = CArray.GetAssociativeArray(t);
                Map<MCDecoratedPot.Side, MCMaterial> potSherds = decoratedPot.getSherds();
                for (Map.Entry<MCDecoratedPot.Side, MCMaterial> side : potSherds.entrySet()) {
                    sherds.set(side.getKey().name().toLowerCase(), side.getValue().name());
                }
                ma.set("sherds", (Mixed)sherds, t);
                if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_4)) {
                    ma.set("item", (Mixed)this.item(decoratedPot.getItemStack(), t), t);
                }
            } else if (bs instanceof MCInventoryHolder) {
                MCInventory inv = ((MCInventoryHolder)((Object)bs)).getInventory();
                CArray box = CArray.GetAssociativeArray(t);
                for (int i = 0; i < inv.getSize(); ++i) {
                    Construct item = ObjectGenerator.GetGenerator().item(inv.getItem(i), t);
                    if (item instanceof CNull) continue;
                    box.set(i, (Mixed)item, t);
                }
                ma.set("inventory", (Mixed)box, t);
            } else if (bs instanceof MCSign) {
                MCSign sign = (MCSign)bs;
                ma.set("waxed", (Mixed)CBoolean.get(sign.isWaxed()), t);
                CArray lines = new CArray(t);
                for (String string : sign.getLines()) {
                    lines.push(new CString(string, t), t);
                }
                ma.set("signtext", (Mixed)lines, t);
                ma.set("glowing", (Mixed)CBoolean.get(sign.isGlowingText()), t);
                MCDyeColor color2 = sign.getDyeColor();
                if (color2 == null) {
                    ma.set("color", (Mixed)CNull.NULL, t);
                } else {
                    ma.set("color", color2.name(), t);
                }
                MCSignText backText = sign.getBackText();
                if (backText != null) {
                    CArray back = new CArray(t);
                    for (String line : backText.getLines()) {
                        back.push(new CString(line, t), t);
                    }
                    ma.set("backtext", (Mixed)back, t);
                    ma.set("backglowing", (Mixed)CBoolean.get(backText.isGlowingText()), t);
                    MCDyeColor mCDyeColor = backText.getDyeColor();
                    if (mCDyeColor == null) {
                        ma.set("backcolor", (Mixed)CNull.NULL, t);
                    } else {
                        ma.set("backcolor", mCDyeColor.name(), t);
                    }
                }
            } else if (bs instanceof MCCommandBlock) {
                MCCommandBlock cmdBlock = (MCCommandBlock)bs;
                ma.set("command", cmdBlock.getCommand());
                ma.set("customname", cmdBlock.getName());
            } else if (bs instanceof MCBeehive) {
                MCBeehive beehive = (MCBeehive)bs;
                ma.set("beecount", (Mixed)new CInt(beehive.getEntityCount(), t), t);
            }
        } else if (meta instanceof MCArmorMeta) {
            MCArmorMeta armorMeta = (MCArmorMeta)meta;
            if (armorMeta.hasTrim()) {
                CArray trim2 = CArray.GetAssociativeArray(t);
                trim2.set("material", armorMeta.getTrimMaterial().name());
                trim2.set("pattern", armorMeta.getTrimPattern().name());
                ma.set("trim", (Mixed)trim2, t);
            } else {
                ma.set("trim", (Mixed)CNull.NULL, t);
            }
            if (armorMeta instanceof MCColorableArmorMeta) {
                ma.set("color", (Mixed)this.color(((MCColorableArmorMeta)armorMeta).getColor(), t), t);
            }
        } else if (meta instanceof MCFireworkEffectMeta) {
            MCFireworkEffectMeta mcfem = (MCFireworkEffectMeta)meta;
            MCFireworkEffect effect = mcfem.getEffect();
            if (effect == null) {
                ma.set("effect", (Mixed)CNull.NULL, t);
            } else {
                ma.set("effect", (Mixed)this.fireworkEffect(effect, t), t);
            }
        } else if (meta instanceof MCFireworkMeta) {
            MCFireworkMeta mcfm = (MCFireworkMeta)meta;
            CArray firework = CArray.GetAssociativeArray(t);
            firework.set("strength", (Mixed)new CInt(mcfm.getStrength(), t), t);
            CArray fe = new CArray(t);
            for (MCFireworkEffect effect : mcfm.getEffects()) {
                fe.push(this.fireworkEffect(effect, t), t);
            }
            firework.set("effects", (Mixed)fe, t);
            ma.set("firework", (Mixed)firework, t);
        } else if (meta instanceof MCLeatherArmorMeta) {
            CArray color3 = this.color(((MCLeatherArmorMeta)meta).getColor(), t);
            ma.set("color", (Mixed)color3, t);
        } else if (meta instanceof MCBookMeta) {
            Construct pages;
            MCBookMeta bookMeta = (MCBookMeta)meta;
            if (material.getAbstracted() == MCMaterial.MCVanillaMaterial.WRITTEN_BOOK) {
                CNull title2;
                if (bookMeta.hasTitle()) {
                    CString title3 = new CString(bookMeta.getTitle(), t);
                } else {
                    title2 = CNull.NULL;
                }
                Construct author = bookMeta.hasAuthor() ? new CString(bookMeta.getAuthor(), t) : CNull.NULL;
                ma.set("title", (Mixed)title2, t);
                ma.set("author", (Mixed)author, t);
                ma.set("generation", bookMeta.getGeneration().name(), t);
            }
            if (bookMeta.hasPages()) {
                pages = new CArray(t);
                for (String p3 : bookMeta.getPages()) {
                    ((CArray)pages).push(new CString(p3, t), t);
                }
            } else {
                pages = CNull.NULL;
            }
            ma.set("pages", (Mixed)pages, t);
        } else if (meta instanceof MCSkullMeta) {
            MCPlayerProfile profile = ((MCSkullMeta)meta).getProfile();
            if (profile != null) {
                if (profile.getName() != null) {
                    ma.set("owner", (Mixed)new CString(profile.getName(), t), t);
                } else {
                    ma.set("owner", (Mixed)CNull.NULL, t);
                }
                if (profile.getId() != null) {
                    ma.set("owneruuid", (Mixed)new CString(profile.getId().toString(), t), t);
                } else {
                    ma.set("owneruuid", (Mixed)CNull.NULL, t);
                }
                MCProfileProperty texture = profile.getProperty("textures");
                if (texture != null) {
                    ma.set("texture", (Mixed)new CString(texture.getValue(), t), t);
                } else {
                    ma.set("texture", (Mixed)CNull.NULL, t);
                }
            } else if (((MCSkullMeta)meta).hasOwner()) {
                ma.set("owner", (Mixed)new CString(((MCSkullMeta)meta).getOwner(), t), t);
                MCOfflinePlayer ofp = ((MCSkullMeta)meta).getOwningPlayer();
                if (ofp != null) {
                    ma.set("owneruuid", (Mixed)new CString(ofp.getUniqueID().toString(), t), t);
                } else {
                    ma.set("owneruuid", (Mixed)CNull.NULL, t);
                }
            } else {
                ma.set("owner", (Mixed)CNull.NULL, t);
                ma.set("owneruuid", (Mixed)CNull.NULL, t);
            }
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19_3)) {
                sound = ((MCSkullMeta)meta).getNoteBlockSound();
                if (sound == null) {
                    ma.set("noteblocksound", (Mixed)CNull.NULL, t);
                } else {
                    ma.set("noteblocksound", (Mixed)new CString(sound, t), t);
                }
            }
        } else if (meta instanceof MCEnchantmentStorageMeta) {
            Construct stored = ((MCEnchantmentStorageMeta)meta).hasStoredEnchants() ? this.enchants(((MCEnchantmentStorageMeta)meta).getStoredEnchants(), t) : CNull.NULL;
            ma.set("stored", (Mixed)stored, t);
        } else if (meta instanceof MCPotionMeta) {
            MCPotionMeta potionmeta = (MCPotionMeta)meta;
            CArray effects = this.potions(potionmeta.getCustomEffects(), t);
            ma.set("potions", (Mixed)effects, t);
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                MCPotionType potionType = potionmeta.getBasePotionType();
                if (potionType == null) {
                    ma.set("potiontype", (Mixed)CNull.NULL, t);
                } else {
                    ma.set("potiontype", potionType.name());
                }
            } else {
                MCPotionData potiondata = potionmeta.getBasePotionData();
                if (potiondata != null) {
                    ma.set("base", (Mixed)this.potionData(potiondata, t), t);
                }
            }
            if (potionmeta.hasColor()) {
                ma.set("color", (Mixed)this.color(potionmeta.getColor(), t), t);
            } else {
                ma.set("color", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCSuspiciousStewMeta) {
            MCSuspiciousStewMeta susstew = (MCSuspiciousStewMeta)meta;
            CArray effects = this.potions(susstew.getCustomEffects(), t);
            ma.set("potions", (Mixed)effects, t);
        } else if (meta instanceof MCBannerMeta) {
            MCBannerMeta bannermeta = (MCBannerMeta)meta;
            CArray patterns = new CArray(t, bannermeta.numberOfPatterns());
            for (MCPattern p4 : bannermeta.getPatterns()) {
                CArray pattern = CArray.GetAssociativeArray(t);
                pattern.set("shape", (Mixed)new CString(p4.getShape().toString(), t), t);
                pattern.set("color", (Mixed)new CString(p4.getColor().toString(), t), t);
                patterns.push(pattern, t);
            }
            ma.set("patterns", (Mixed)patterns, t);
        } else if (meta instanceof MCMapMeta) {
            MCMapMeta mm = (MCMapMeta)meta;
            MCColor mapcolor = mm.getColor();
            if (mapcolor == null) {
                ma.set("color", (Mixed)CNull.NULL, t);
            } else {
                ma.set("color", (Mixed)this.color(mapcolor, t), t);
            }
            if (mm.hasMapId()) {
                ma.set("mapid", (Mixed)new CInt(mm.getMapId(), t), t);
            } else {
                ma.set("mapid", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCTropicalFishBucketMeta) {
            MCTropicalFishBucketMeta fm = (MCTropicalFishBucketMeta)meta;
            if (fm.hasVariant()) {
                ma.set("fishcolor", (Mixed)new CString(fm.getBodyColor().name(), t), t);
                ma.set("fishpatterncolor", (Mixed)new CString(fm.getPatternColor().name(), t), t);
                ma.set("fishpattern", (Mixed)new CString(fm.getPattern().name(), t), t);
            } else {
                ma.set("fishcolor", (Mixed)CNull.NULL, t);
                ma.set("fishpatterncolor", (Mixed)CNull.NULL, t);
                ma.set("fishpattern", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCCrossbowMeta) {
            MCCrossbowMeta cbm = (MCCrossbowMeta)meta;
            if (cbm.hasChargedProjectiles()) {
                CArray projectiles = new CArray(t);
                for (MCItemStack projectile : cbm.getChargedProjectiles()) {
                    projectiles.push(this.item(projectile, t), t);
                }
                ma.set("projectiles", (Mixed)projectiles, t);
            } else {
                ma.set("projectiles", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCCompassMeta) {
            MCCompassMeta cm = (MCCompassMeta)meta;
            if (cm.getTargetLocation() == null) {
                ma.set("target", (Mixed)CNull.NULL, t);
            } else {
                ma.set("target", (Mixed)this.location(cm.getTargetLocation(), false), t);
            }
            ma.set("lodestone", (Mixed)CBoolean.get(cm.isLodestoneTracked()), t);
        } else if (meta instanceof MCBundleMeta) {
            MCBundleMeta bm = (MCBundleMeta)meta;
            List<MCItemStack> items = bm.getItems();
            CArray arrayItems = new CArray(t);
            for (MCItemStack item : items) {
                arrayItems.push(ObjectGenerator.GetGenerator().item(item, t), t);
            }
            ma.set("items", (Mixed)arrayItems, t);
        } else if (meta instanceof MCAxolotlBucketMeta) {
            ma.set("variant", ((MCAxolotlBucketMeta)meta).getAxolotlType().name());
        } else if (meta instanceof MCMusicInstrumentMeta) {
            String instrumentKey = ((MCMusicInstrumentMeta)meta).getInstrument();
            if (instrumentKey == null) {
                ma.set("instrument", (Mixed)CNull.NULL, t);
            } else {
                ma.set("instrument", instrumentKey);
            }
        } else if (meta instanceof MCKnowledgeBookMeta) {
            MCKnowledgeBookMeta knowledgeBookMeta = (MCKnowledgeBookMeta)meta;
            if (knowledgeBookMeta.hasRecipes()) {
                CArray recipes = new CArray(t);
                for (MCNamespacedKey key : knowledgeBookMeta.getRecipes()) {
                    recipes.push(new CString(key.toString(), t), t);
                }
                ma.set("recipes", (Mixed)recipes, t);
            } else {
                ma.set("recipes", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCOminousBottleMeta) {
            MCOminousBottleMeta ominousBottleMeta = (MCOminousBottleMeta)meta;
            if (ominousBottleMeta.hasAmplifier()) {
                ma.set("ominousamplifier", (Mixed)new CInt(ominousBottleMeta.getAmplifier(), t), t);
            } else {
                ma.set("ominousamplifier", (Mixed)CNull.NULL, t);
            }
        }
        return ma;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MCItemMeta itemMeta(Mixed c, MCMaterial mat, Target t) throws ConfigRuntimeException {
        CArray array2;
        Iterator<Object> id;
        MCItemMeta meta;
        block198: {
            Iterator<String> key3;
            CArray cinv;
            MCInventory inv;
            MCBlockState bs;
            MCBlockStateMeta bsm;
            block197: {
                MCBanner banner;
                block195: {
                    Iterator<String> iterator;
                    CArray array3;
                    block196: {
                        if (c instanceof CNull) {
                            return null;
                        }
                        if (!c.isInstanceOf(CArray.TYPE)) {
                            throw new CREFormatException("An array was expected but received " + String.valueOf(c) + " instead.", t);
                        }
                        MCItemFactory itemFactory = Static.getServer().getItemFactory();
                        meta = itemFactory.getItemMeta(mat);
                        if (meta == null) {
                            return null;
                        }
                        CArray ma = (CArray)c;
                        if (!ma.isAssociative()) {
                            return meta;
                        }
                        try {
                            Iterator<Object> iterator2;
                            Object cmdBlock;
                            Mixed mBlockData;
                            Mixed damage;
                            Mixed playable;
                            Mixed tagArray;
                            Mixed modifiers;
                            Mixed m;
                            Mixed r;
                            Mixed li;
                            Mixed dni;
                            if (ma.containsKey("display") && !((dni = ma.get("display", t)) instanceof CNull)) {
                                meta.setDisplayName(dni.val());
                            }
                            if (ma.containsKey("lore") && !((li = ma.get("lore", t)) instanceof CNull)) {
                                if (li.isInstanceOf(CString.TYPE)) {
                                    ArrayList<String> ll = new ArrayList<String>();
                                    ll.add(li.val());
                                    meta.setLore(ll);
                                } else {
                                    if (!li.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Lore was expected to be an array or a string.", t);
                                    CArray la = (CArray)li;
                                    ArrayList<String> arrayList = new ArrayList<String>();
                                    int j = 0;
                                    while ((long)j < la.size()) {
                                        arrayList.add(la.get(j, t).val());
                                        ++j;
                                    }
                                    meta.setLore(arrayList);
                                }
                            }
                            if (ma.containsKey("enchants")) {
                                Mixed enchants = ma.get("enchants", t);
                                if (!enchants.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Enchants field was expected to be an array of Enchantment arrays", t);
                                for (Map.Entry entry : this.enchants((CArray)enchants, t).entrySet()) {
                                    meta.addEnchant((MCEnchantment)entry.getKey(), (Integer)entry.getValue(), true);
                                }
                            }
                            if (ma.containsKey("repair") && !((r = ma.get("repair", t)) instanceof CNull)) {
                                meta.setRepairCost(ArgumentValidation.getInt32(r, t));
                            }
                            if (ma.containsKey("model") && !((m = ma.get("model", t)) instanceof CNull)) {
                                meta.setCustomModelData(ArgumentValidation.getInt32(m, t));
                            }
                            if (ma.containsKey("flags")) {
                                void var9_15;
                                Mixed flags = ma.get("flags", t);
                                if (!flags.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Itemflags was expected to be an array of flags.", t);
                                CArray flagArray = (CArray)flags;
                                boolean bl = false;
                                while ((long)var9_15 < flagArray.size()) {
                                    Mixed flag = flagArray.get((int)var9_15, t);
                                    meta.addItemFlags(MCItemFlag.valueOf(flag.val().toUpperCase()));
                                    ++var9_15;
                                }
                            }
                            if (ma.containsKey("modifiers") && !((modifiers = ma.get("modifiers", t)) instanceof CNull)) {
                                if (!modifiers.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Attribute modifiers were expected to be an array.", t);
                                CArray modifierArray = (CArray)modifiers;
                                if (modifierArray.isAssociative()) {
                                    throw new CREFormatException("Array of attribute modifiers cannot be associative.", t);
                                }
                                ArrayList<MCAttributeModifier> arrayList = new ArrayList<MCAttributeModifier>();
                                for (String key2 : modifierArray.stringKeySet()) {
                                    arrayList.add(this.attributeModifier(ArgumentValidation.getArray(modifierArray.get(key2, t), t), t));
                                }
                                meta.setAttributeModifiers(arrayList);
                            }
                            if (ma.containsKey("tags") && !((tagArray = ma.get("tags", t)) instanceof CNull)) {
                                MCTagType.TAG_CONTAINER.convert(meta.getCustomTags(), tagArray);
                            }
                            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                                Mixed mixedFood;
                                Mixed rarity;
                                Mixed maxdamage;
                                Mixed glint;
                                Mixed maxstacksize;
                                if (ma.containsKey("maxstacksize") && !((maxstacksize = ma.get("maxstacksize", t)) instanceof CNull)) {
                                    meta.setMaxStackSize(ArgumentValidation.getInt32(maxstacksize, t));
                                }
                                if (ma.containsKey("glint") && !((glint = ma.get("glint", t)) instanceof CNull)) {
                                    meta.setEnchantmentGlintOverride(ArgumentValidation.getBooleanObject(glint, t));
                                }
                                if (ma.containsKey("maxdamage") && !((maxdamage = ma.get("maxdamage", t)) instanceof CNull)) {
                                    meta.setMaxDamage(ArgumentValidation.getInt32(maxdamage, t));
                                }
                                if (ma.containsKey("rarity") && !((rarity = ma.get("rarity", t)) instanceof CNull)) {
                                    try {
                                        meta.setRarity(MCItemRarity.valueOf(rarity.val()));
                                    }
                                    catch (IllegalArgumentException ex) {
                                        throw new CREFormatException("Rarity does not exist: " + rarity.val(), t);
                                    }
                                }
                                if (ma.containsKey("food") && !((mixedFood = ma.get("food", t)) instanceof CNull)) {
                                    if (!mixedFood.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected food to be an associative array.", t);
                                    CArray foodArray = (CArray)mixedFood;
                                    if (!foodArray.isAssociative()) {
                                        throw new CREFormatException("Food array must be associative.", t);
                                    }
                                    MCFoodComponent mCFoodComponent = meta.getFood();
                                    if (foodArray.containsKey("nutrition")) {
                                        mCFoodComponent.setNutrition(ArgumentValidation.getInt32(foodArray.get("nutrition", t), t));
                                    }
                                    if (foodArray.containsKey("saturation")) {
                                        mCFoodComponent.setSaturation(ArgumentValidation.getDouble32(foodArray.get("saturation", t), t));
                                    }
                                    if (foodArray.containsKey("always")) {
                                        mCFoodComponent.setCanAlwaysEat(ArgumentValidation.getBooleanObject(foodArray.get("always", t), t));
                                    }
                                    meta.setFood(mCFoodComponent);
                                }
                            }
                            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21) && ma.containsKey("jukeboxsong") && !((playable = ma.get("jukeboxsong", t)) instanceof CNull)) {
                                meta.setJukeboxPlayable(playable.val());
                            }
                            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_3)) {
                                Mixed equippableMixed;
                                Mixed tooltipstyle;
                                Mixed itemmodel;
                                Mixed mixedCooldown;
                                Mixed remainder;
                                Mixed enchantability;
                                if (ma.containsKey("enchantability") && !((enchantability = ma.get("enchantability", t)) instanceof CNull)) {
                                    meta.setEnchantable(ArgumentValidation.getInt32(enchantability, t));
                                }
                                if (ma.containsKey("glider")) {
                                    Mixed glider = ma.get("glider", t);
                                    if (glider instanceof CNull) {
                                        meta.setGlider(false);
                                    } else {
                                        meta.setGlider(ArgumentValidation.getBooleanObject(glider, t));
                                    }
                                }
                                if (ma.containsKey("remainder") && !((remainder = ma.get("remainder", t)) instanceof CNull)) {
                                    meta.setUseRemainder(this.item(remainder, t));
                                }
                                if (ma.containsKey("cooldown") && !((mixedCooldown = ma.get("cooldown", t)) instanceof CNull)) {
                                    Mixed group;
                                    if (!mixedCooldown.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected an array for item cooldown.", t);
                                    CArray cooldownArray = (CArray)mixedCooldown;
                                    if (!cooldownArray.isAssociative()) {
                                        throw new CREFormatException("Cooldown array must be associative.", t);
                                    }
                                    MCCooldownComponent mCCooldownComponent = meta.getUseCooldown();
                                    if (cooldownArray.containsKey("seconds")) {
                                        mCCooldownComponent.setSeconds(ArgumentValidation.getDouble32(cooldownArray.get("seconds", t), t));
                                    }
                                    if (cooldownArray.containsKey("group") && !((group = cooldownArray.get("group", t)) instanceof CNull)) {
                                        mCCooldownComponent.setCooldownGroup(group.val());
                                    }
                                    meta.setUseCooldown(mCCooldownComponent);
                                }
                                if (ma.containsKey("itemmodel") && !((itemmodel = ma.get("itemmodel", t)) instanceof CNull)) {
                                    meta.setItemModel(itemmodel.val());
                                }
                                if (ma.containsKey("tooltipstyle") && !((tooltipstyle = ma.get("tooltipstyle", t)) instanceof CNull)) {
                                    meta.setTooltipStyle(tooltipstyle.val());
                                }
                                if (ma.containsKey("equippable") && !((equippableMixed = ma.get("equippable", t)) instanceof CNull)) {
                                    Mixed soundMixed;
                                    Mixed assetMixed;
                                    Mixed cameraOverlayMixed;
                                    Mixed entitiesMixed;
                                    if (!equippableMixed.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected an array for item equippable component.", t);
                                    CArray equippableArray = (CArray)equippableMixed;
                                    if (!equippableArray.isAssociative()) {
                                        throw new CREFormatException("Equippable array must be associative.", t);
                                    }
                                    MCEquippableComponent mCEquippableComponent = meta.getEquippable();
                                    try {
                                        String slotName = equippableArray.get("slot", t).val().toUpperCase();
                                        mCEquippableComponent.setSlot(MCEquipmentSlot.valueOf(slotName));
                                    }
                                    catch (IllegalArgumentException ex) {
                                        throw new CREFormatException("Not a valid equipment slot: " + equippableArray.get("slot", t).val(), t);
                                    }
                                    if (equippableArray.containsKey("entities") && !((entitiesMixed = equippableArray.get("entities", t)) instanceof CNull) && entitiesMixed.isInstanceOf(CArray.TYPE)) {
                                        CArray entitiesArray = (CArray)entitiesMixed;
                                        if (entitiesArray.isAssociative()) {
                                            throw new CREFormatException("Allowed entities array must not be associative.", t);
                                        }
                                        ArrayList<MCEntityType> arrayList = new ArrayList<MCEntityType>();
                                        for (Mixed type : entitiesArray) {
                                            arrayList.add(MCEntityType.valueOf(type.val()));
                                        }
                                        mCEquippableComponent.setAllowedEntities(arrayList);
                                    }
                                    if (equippableArray.containsKey("overlay") && !((cameraOverlayMixed = equippableArray.get("overlay", t)) instanceof CNull)) {
                                        mCEquippableComponent.setCameraOverlay(cameraOverlayMixed.val());
                                    }
                                    if (equippableArray.containsKey("damageable")) {
                                        mCEquippableComponent.setDamageOnHurt(ArgumentValidation.getBooleanObject(equippableArray.get("damageable", t), t));
                                    }
                                    if (equippableArray.containsKey("dispensable")) {
                                        mCEquippableComponent.setDispensable(ArgumentValidation.getBooleanObject(equippableArray.get("dispensable", t), t));
                                    }
                                    if (equippableArray.containsKey("asset") && !((assetMixed = equippableArray.get("asset", t)) instanceof CNull)) {
                                        mCEquippableComponent.setAssetId(assetMixed.val());
                                    }
                                    if (equippableArray.containsKey("sound") && !((soundMixed = equippableArray.get("sound", t)) instanceof CNull)) {
                                        mCEquippableComponent.setEquipSound(soundMixed.val());
                                    }
                                    if (equippableArray.containsKey("swappable")) {
                                        mCEquippableComponent.setSwappable(ArgumentValidation.getBooleanObject(equippableArray.get("swappable", t), t));
                                    }
                                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_5) && equippableArray.containsKey("interactable")) {
                                        mCEquippableComponent.setEquipOnInteract(ArgumentValidation.getBooleanObject(equippableArray.get("interactable", t), t));
                                    }
                                    meta.setEquippable(mCEquippableComponent);
                                }
                            }
                            if (ma.containsKey("damage") && !((damage = ma.get("damage", t)) instanceof CNull)) {
                                meta.setDamage(ArgumentValidation.getInt32(damage, t));
                            }
                            if (ma.containsKey("unbreakable")) {
                                meta.setUnbreakable(ArgumentValidation.getBooleanish(ma.get("unbreakable", t), t));
                            }
                            if (ma.containsKey("blockdata") && (mBlockData = ma.get("blockdata", t)) instanceof CArray) {
                                meta.setBlockData(this.blockData((CArray)mBlockData, mat, t));
                            }
                            if (meta instanceof MCBlockStateMeta) {
                                bsm = (MCBlockStateMeta)meta;
                                bs = bsm.getBlockState();
                                if (bs instanceof MCBanner) {
                                    banner = (MCBanner)bs;
                                    if (!ma.containsKey("basecolor")) return meta;
                                    String baseString = ma.get("basecolor", t).val().toUpperCase();
                                    try {
                                        banner.setBaseColor(MCDyeColor.valueOf(baseString));
                                    }
                                    catch (IllegalArgumentException ex) {
                                        if (!baseString.equals("SILVER")) throw ex;
                                        banner.setBaseColor(MCDyeColor.LIGHT_GRAY);
                                    }
                                    if (!ma.containsKey("patterns")) break block195;
                                    array3 = ArgumentValidation.getArray(ma.get("patterns", t), t);
                                    iterator = array3.stringKeySet().iterator();
                                    break block196;
                                }
                                if (bs instanceof MCCreatureSpawner) {
                                    Mixed m2;
                                    MCCreatureSpawner mccs = (MCCreatureSpawner)bs;
                                    if (ma.containsKey("spawntype") && (m2 = ma.get("spawntype", t)) != CNull.NULL) {
                                        MCEntityType type = MCEntityType.valueOf(m2.val().toUpperCase());
                                        mccs.setSpawnedType(type);
                                    }
                                    if (ma.containsKey("delay")) {
                                        int delay = ArgumentValidation.getInt32(ma.get("delay", t), t);
                                        mccs.setDelay(delay);
                                    }
                                    if (ma.containsKey("mindelay")) {
                                        int delay = ArgumentValidation.getInt32(ma.get("mindelay", t), t);
                                        mccs.setMinDelay(delay);
                                    }
                                    if (ma.containsKey("maxdelay")) {
                                        int delay = ArgumentValidation.getInt32(ma.get("maxdelay", t), t);
                                        mccs.setMaxDelay(delay);
                                    }
                                    if (ma.containsKey("spawncount")) {
                                        int count = ArgumentValidation.getInt32(ma.get("spawncount", t), t);
                                        mccs.setSpawnCount(count);
                                    }
                                    if (ma.containsKey("maxnearbyentities")) {
                                        int max2 = ArgumentValidation.getInt32(ma.get("maxnearbyentities", t), t);
                                        mccs.setMaxNearbyEntities(max2);
                                    }
                                    if (ma.containsKey("spawnrange")) {
                                        int range2 = ArgumentValidation.getInt32(ma.get("spawnrange", t), t);
                                        mccs.setSpawnRange(range2);
                                    }
                                    if (ma.containsKey("playerrange")) {
                                        int range3 = ArgumentValidation.getInt32(ma.get("playerrange", t), t);
                                        mccs.setPlayerRange(range3);
                                    }
                                    bsm.setBlockState(bs);
                                    return meta;
                                }
                                if (bs instanceof MCBrewingStand) {
                                    MCBrewingStand brewStand = (MCBrewingStand)bs;
                                    if (ma.containsKey("brewtime")) {
                                        brewStand.setBrewingTime(ArgumentValidation.getInt32(ma.get("brewtime", t), t));
                                    }
                                    if (ma.containsKey("fuel")) {
                                        brewStand.setFuelLevel(ArgumentValidation.getInt32(ma.get("fuel", t), t));
                                    }
                                    if (ma.containsKey("inventory")) {
                                        CArray invData = ArgumentValidation.getArray(ma.get("inventory", t), t);
                                        MCBrewerInventory inv2 = brewStand.getInventory();
                                        if (invData.containsKey("fuel")) {
                                            inv2.setFuel(ObjectGenerator.GetGenerator().item(invData.get("fuel", t), t));
                                        }
                                        if (invData.containsKey("ingredient")) {
                                            inv2.setIngredient(ObjectGenerator.GetGenerator().item(invData.get("ingredient", t), t));
                                        }
                                        if (invData.containsKey("leftbottle")) {
                                            inv2.setLeftBottle(ObjectGenerator.GetGenerator().item(invData.get("leftbottle", t), t));
                                        }
                                        if (invData.containsKey("middlebottle")) {
                                            inv2.setMiddleBottle(ObjectGenerator.GetGenerator().item(invData.get("middlebottle", t), t));
                                        }
                                        if (invData.containsKey("rightbottle")) {
                                            inv2.setRightBottle(ObjectGenerator.GetGenerator().item(invData.get("rightbottle", t), t));
                                        }
                                    }
                                    bsm.setBlockState(bs);
                                    return meta;
                                }
                                if (bs instanceof MCFurnace) {
                                    MCFurnace furnace = (MCFurnace)bs;
                                    if (ma.containsKey("burntime")) {
                                        furnace.setBurnTime(ArgumentValidation.getInt16(ma.get("burntime", t), t));
                                    }
                                    if (ma.containsKey("cooktime")) {
                                        furnace.setCookTime(ArgumentValidation.getInt16(ma.get("cooktime", t), t));
                                    }
                                    if (ma.containsKey("inventory")) {
                                        CArray invData = ArgumentValidation.getArray(ma.get("inventory", t), t);
                                        MCFurnaceInventory inv3 = furnace.getInventory();
                                        if (invData.containsKey("result")) {
                                            inv3.setResult(ObjectGenerator.GetGenerator().item(invData.get("result", t), t));
                                        }
                                        if (invData.containsKey("fuel")) {
                                            inv3.setFuel(ObjectGenerator.GetGenerator().item(invData.get("fuel", t), t));
                                        }
                                        if (invData.containsKey("smelting")) {
                                            inv3.setSmelting(ObjectGenerator.GetGenerator().item(invData.get("smelting", t), t));
                                        }
                                    }
                                    bsm.setBlockState(bs);
                                    return meta;
                                }
                                if (bs instanceof MCDecoratedPot) {
                                    MCDecoratedPot mCDecoratedPot = (MCDecoratedPot)bs;
                                    if (ma.containsKey("sherds")) {
                                        Mixed sherds = ma.get("sherds", t);
                                        if (!sherds.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected associative array for decorated pot meta.", t);
                                        CArray sherdArray = (CArray)sherds;
                                        if (!sherdArray.isAssociative()) {
                                            throw new CREFormatException("Expected associative array for decorated pot meta.", t);
                                        }
                                        for (String key3 : sherdArray.stringKeySet()) {
                                            mCDecoratedPot.setSherd(MCDecoratedPot.Side.valueOf(key3.toUpperCase()), MCMaterial.valueOf(sherdArray.get(key3, t).val()));
                                        }
                                    }
                                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_4) && ma.containsKey("item")) {
                                        mCDecoratedPot.setItemStack(this.item(ma.get("item", t), t));
                                    }
                                    bsm.setBlockState(bs);
                                    return meta;
                                }
                                if (bs instanceof MCInventoryHolder) {
                                    if (!ma.containsKey("inventory")) return meta;
                                    inv = ((MCInventoryHolder)((Object)bs)).getInventory();
                                    Mixed cInvRaw = ma.get("inventory", t);
                                    if (!cInvRaw.isInstanceOf(CArray.TYPE)) {
                                        if (cInvRaw instanceof CNull) return meta;
                                        throw new CREFormatException(bs.getClass().getSimpleName().replaceFirst("MC", "") + " inventory expected to be an array or null.", t);
                                    }
                                    cinv = (CArray)cInvRaw;
                                    key3 = cinv.stringKeySet().iterator();
                                    break block197;
                                } else {
                                    if (bs instanceof MCSign) {
                                        MCSignText backText;
                                        Mixed dye;
                                        MCSign sign = (MCSign)bs;
                                        if (ma.containsKey("waxed")) {
                                            sign.setWaxed(ArgumentValidation.getBooleanObject(ma.get("waxed", t), t));
                                        }
                                        if (ma.containsKey("signtext")) {
                                            Mixed possibleLines = ma.get("signtext", t);
                                            if (!possibleLines.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected array for sign text", t);
                                            CArray lines = (CArray)possibleLines;
                                            int i = 0;
                                            while ((long)i < lines.size()) {
                                                sign.setLine(i, lines.get(i, t).val());
                                                ++i;
                                            }
                                        }
                                        if (ma.containsKey("glowing")) {
                                            sign.setGlowingText(ArgumentValidation.getBooleanObject(ma.get("glowing", t), t));
                                        }
                                        if (ma.containsKey("color") && !((dye = ma.get("color", t)) instanceof CNull)) {
                                            sign.setDyeColor(MCDyeColor.valueOf(dye.val()));
                                        }
                                        if ((backText = sign.getBackText()) != null) {
                                            Mixed dye2;
                                            if (ma.containsKey("backtext")) {
                                                Mixed possibleLines = ma.get("backtext", t);
                                                if (!possibleLines.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected array for sign back text", t);
                                                CArray lines = (CArray)possibleLines;
                                                int i = 0;
                                                while ((long)i < lines.size()) {
                                                    backText.setLine(i, lines.get(i, t).val());
                                                    ++i;
                                                }
                                            }
                                            if (ma.containsKey("backglowing")) {
                                                backText.setGlowingText(ArgumentValidation.getBooleanObject(ma.get("backglowing", t), t));
                                            }
                                            if (ma.containsKey("backcolor") && !((dye2 = ma.get("backcolor", t)) instanceof CNull)) {
                                                backText.setDyeColor(MCDyeColor.valueOf(dye2.val()));
                                            }
                                        }
                                        bsm.setBlockState(bs);
                                        return meta;
                                    }
                                    if (bs instanceof MCCommandBlock) {
                                        cmdBlock = (MCCommandBlock)bs;
                                        if (ma.containsKey("command")) {
                                            cmdBlock.setCommand(ma.get("command", t).val());
                                        }
                                        if (ma.containsKey("customname")) {
                                            cmdBlock.setName(ma.get("customname", t).val());
                                        }
                                        bsm.setBlockState(bs);
                                        return meta;
                                    }
                                    if (!(bs instanceof MCBeehive)) return meta;
                                    MCBeehive beehive = (MCBeehive)bs;
                                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) return meta;
                                    if (ma.containsKey("beecount")) {
                                        int beeCount = ArgumentValidation.getInt32(ma.get("beecount", t), t);
                                        beehive.addBees(beeCount);
                                    }
                                    bsm.setBlockState(bs);
                                    return meta;
                                }
                            }
                            if (meta instanceof MCArmorMeta) {
                                Mixed mtrim;
                                MCArmorMeta armorMeta = (MCArmorMeta)meta;
                                if (ma.containsKey("trim") && !((mtrim = ma.get("trim", t)) instanceof CNull)) {
                                    if (!mtrim.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected an array or null for armor trim meta.", t);
                                    CArray trim2 = (CArray)mtrim;
                                    if (!trim2.isAssociative()) {
                                        throw new CREFormatException("Expected associative array for armor trim meta.", t);
                                    }
                                    MCTrimPattern mCTrimPattern = MCTrimPattern.valueOf(trim2.get("pattern", t).val());
                                    MCTrimMaterial material = MCTrimMaterial.valueOf(trim2.get("material", t).val());
                                    armorMeta.setTrim(mCTrimPattern, material);
                                }
                                if (!(armorMeta instanceof MCColorableArmorMeta)) return meta;
                                if (!ma.containsKey("color")) return meta;
                                Mixed ci = ma.get("color", t);
                                if (ci instanceof CNull) {
                                    return meta;
                                }
                                if (!ci.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Color was expected to be an array.", t);
                                ((MCColorableArmorMeta)armorMeta).setColor(this.color((CArray)ci, t));
                                return meta;
                            }
                            if (meta instanceof MCFireworkEffectMeta) {
                                MCFireworkEffectMeta femeta = (MCFireworkEffectMeta)meta;
                                if (!ma.containsKey("effect")) return meta;
                                Mixed cfem = ma.get("effect", t);
                                if (cfem.isInstanceOf(CArray.TYPE)) {
                                    femeta.setEffect(this.fireworkEffect((CArray)cfem, t));
                                    return meta;
                                }
                                if (cfem instanceof CNull) return meta;
                                throw new CREFormatException("FireworkCharge effect was expected to be an array or null.", t);
                            }
                            if (meta instanceof MCFireworkMeta) {
                                MCFireworkMeta fmeta = (MCFireworkMeta)meta;
                                if (!ma.containsKey("firework")) return meta;
                                Mixed construct = ma.get("firework", t);
                                if (!construct.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Firework was expected to be an array.", t);
                                CArray cArray = (CArray)construct;
                                if (cArray.containsKey("strength")) {
                                    fmeta.setStrength(ArgumentValidation.getInt32(cArray.get("strength", t), t));
                                }
                                if (!cArray.containsKey("effects")) {
                                    fmeta.addEffect(this.fireworkEffect(cArray, t));
                                    return meta;
                                }
                                Mixed effects = cArray.get("effects", t);
                                if (!effects.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Firework effects was expected to be an array.", t);
                                cmdBlock = ((CArray)effects).asList().iterator();
                                while (cmdBlock.hasNext()) {
                                    Mixed effect = (Mixed)cmdBlock.next();
                                    if (!effect.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Firework effect was expected to be an array.", t);
                                    fmeta.addEffect(this.fireworkEffect((CArray)effect, t));
                                }
                                return meta;
                            }
                            if (meta instanceof MCLeatherArmorMeta) {
                                if (!ma.containsKey("color")) return meta;
                                Mixed ci = ma.get("color", t);
                                if (ci instanceof CNull) {
                                    return meta;
                                }
                                if (!ci.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Color was expected to be an array.", t);
                                ((MCLeatherArmorMeta)meta).setColor(this.color((CArray)ci, t));
                                return meta;
                            }
                            if (meta instanceof MCBookMeta) {
                                MCBookMeta bookMeta = (MCBookMeta)meta;
                                if (mat.getAbstracted() == MCMaterial.MCVanillaMaterial.WRITTEN_BOOK) {
                                    Mixed author;
                                    Mixed title2;
                                    bookMeta.setTitle("");
                                    bookMeta.setAuthor("");
                                    if (ma.containsKey("title") && !((title2 = ma.get("title", t)) instanceof CNull)) {
                                        bookMeta.setTitle(title2.val());
                                    }
                                    if (ma.containsKey("author") && !((author = ma.get("author", t)) instanceof CNull)) {
                                        bookMeta.setAuthor(author.val());
                                    }
                                    if (ma.containsKey("generation")) {
                                        Mixed generation = ma.get("generation", t);
                                        bookMeta.setGeneration(MCBookMeta.Generation.valueOf(generation.val()));
                                    }
                                }
                                if (!ma.containsKey("pages")) return meta;
                                Mixed pages = ma.get("pages", t);
                                if (pages instanceof CNull) {
                                    return meta;
                                }
                                if (!pages.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Pages field was expected to be an array.", t);
                                CArray pa = (CArray)pages;
                                ArrayList<String> arrayList = new ArrayList<String>();
                                int j = 0;
                                while (true) {
                                    if ((long)j >= pa.size()) {
                                        bookMeta.setPages(arrayList);
                                        return meta;
                                    }
                                    arrayList.add(pa.get(j, t).val());
                                    ++j;
                                }
                            }
                            if (meta instanceof MCSkullMeta) {
                                Mixed mixed;
                                String name = null;
                                id = null;
                                if (ma.containsKey("owner")) {
                                    name = Construct.nval(ma.get("owner", t));
                                }
                                if (ma.containsKey("owneruuid") && (mixed = ma.get("owneruuid", t)) instanceof CString) {
                                    id = Static.GetUUID(mixed, t);
                                }
                                if (name != null && !name.isEmpty() || id != null) {
                                    MCPlayerProfile mCPlayerProfile = Static.getServer().getPlayerProfile((UUID)((Object)id), name);
                                    if (mCPlayerProfile != null) {
                                        Mixed texture;
                                        if (ma.containsKey("texture") && (texture = ma.get("texture", t)) instanceof CString) {
                                            mCPlayerProfile.setProperty(new MCProfileProperty("textures", texture.val(), null));
                                        }
                                        ((MCSkullMeta)meta).setProfile(mCPlayerProfile);
                                    } else {
                                        MCOfflinePlayer ofp = null;
                                        if (id != null) {
                                            ofp = Static.getServer().getOfflinePlayer((UUID)((Object)id));
                                        }
                                        if (ofp != null) {
                                            ((MCSkullMeta)meta).setOwningPlayer(ofp);
                                        } else if (name != null && !name.isEmpty()) {
                                            ((MCSkullMeta)meta).setOwner(name);
                                        }
                                    }
                                }
                                if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19_3)) return meta;
                                if (!ma.containsKey("noteblocksound")) return meta;
                                Mixed mixed2 = ma.get("noteblocksound", t);
                                if (mixed2 instanceof CNull) return meta;
                                ((MCSkullMeta)meta).setNoteBlockSound(mixed2.val());
                                return meta;
                            }
                            if (meta instanceof MCEnchantmentStorageMeta) {
                                if (!ma.containsKey("stored")) return meta;
                                Mixed stored = ma.get("stored", t);
                                if (stored instanceof CNull) {
                                    return meta;
                                }
                                if (!stored.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Stored field was expected to be an array of Enchantment arrays", t);
                                id = this.enchants((CArray)stored, t).entrySet().iterator();
                                while (id.hasNext()) {
                                    Map.Entry entry = (Map.Entry)id.next();
                                    ((MCEnchantmentStorageMeta)meta).addStoredEnchant((MCEnchantment)entry.getKey(), (Integer)entry.getValue(), true);
                                }
                                return meta;
                            }
                            if (meta instanceof MCPotionMeta) {
                                Mixed potiondata;
                                if (ma.containsKey("potions")) {
                                    Mixed effects = ma.get("potions", t);
                                    if (!effects.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Effects was expected to be an array of potion arrays.", t);
                                    for (MCLivingEntity.MCEffect mCEffect : this.potions((CArray)effects, t)) {
                                        ((MCPotionMeta)meta).addCustomEffect(mCEffect.getPotionEffectType(), mCEffect.getStrength(), mCEffect.getTicksRemaining(), mCEffect.isAmbient(), mCEffect.hasParticles(), mCEffect.showIcon(), true, t);
                                    }
                                }
                                if (ma.containsKey("potiontype") && Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_2)) {
                                    Mixed potiontype = ma.get("potiontype", t);
                                    if (!(potiontype instanceof CNull)) {
                                        ((MCPotionMeta)meta).setBasePotionType(MCPotionType.valueOf(potiontype.val()));
                                    }
                                } else if (ma.containsKey("base") && (potiondata = ma.get("base", t)).isInstanceOf(CArray.TYPE)) {
                                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                                        ((MCPotionMeta)meta).setBasePotionType(this.legacyPotionData((CArray)potiondata, t));
                                    } else {
                                        ((MCPotionMeta)meta).setBasePotionData(this.potionData((CArray)potiondata, t));
                                    }
                                }
                                if (!ma.containsKey("color")) return meta;
                                Mixed color2 = ma.get("color", t);
                                if (color2.isInstanceOf(CArray.TYPE)) {
                                    ((MCPotionMeta)meta).setColor(this.color((CArray)color2, t));
                                    return meta;
                                }
                                if (!color2.isInstanceOf(CString.TYPE)) return meta;
                                ((MCPotionMeta)meta).setColor(StaticLayer.GetConvertor().GetColor(color2.val(), t));
                                return meta;
                            }
                            if (meta instanceof MCSuspiciousStewMeta) {
                                if (!ma.containsKey("potions")) return meta;
                                Mixed effects = ma.get("potions", t);
                                if (!effects.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected an array of potion arrays.", t);
                                id = this.potions((CArray)effects, t).iterator();
                                while (id.hasNext()) {
                                    MCLivingEntity.MCEffect mCEffect = (MCLivingEntity.MCEffect)id.next();
                                    ((MCSuspiciousStewMeta)meta).addCustomEffect(mCEffect.getPotionEffectType(), mCEffect.getStrength(), mCEffect.getTicksRemaining(), mCEffect.isAmbient(), mCEffect.hasParticles(), mCEffect.showIcon(), true, t);
                                }
                                return meta;
                            }
                            if (meta instanceof MCBannerMeta) {
                                if (!ma.containsKey("patterns")) return meta;
                                array2 = ArgumentValidation.getArray(ma.get("patterns", t), t);
                                id = array2.stringKeySet().iterator();
                                break block198;
                            }
                            if (meta instanceof MCMapMeta) {
                                if (ma.containsKey("color")) {
                                    Mixed ci = ma.get("color", t);
                                    if (ci.isInstanceOf(CArray.TYPE)) {
                                        ((MCMapMeta)meta).setColor(this.color((CArray)ci, t));
                                    } else if (!(ci instanceof CNull)) {
                                        throw new CREFormatException("Color was expected to be an array.", t);
                                    }
                                }
                                if (!ma.containsKey("mapid")) return meta;
                                Mixed cid = ma.get("mapid", t);
                                if (cid instanceof CNull) return meta;
                                ((MCMapMeta)meta).setMapId(ArgumentValidation.getInt32(cid, t));
                                return meta;
                            }
                            if (meta instanceof MCTropicalFishBucketMeta) {
                                Mixed fishcolor;
                                MCDyeColor color3;
                                Mixed patterncolor;
                                if (ma.containsKey("fishpatterncolor") && !((patterncolor = ma.get("fishpatterncolor", t)) instanceof CNull)) {
                                    color3 = MCDyeColor.valueOf(patterncolor.val().toUpperCase());
                                    ((MCTropicalFishBucketMeta)meta).setPatternColor(color3);
                                }
                                if (ma.containsKey("fishcolor") && !((fishcolor = ma.get("fishcolor", t)) instanceof CNull)) {
                                    color3 = MCDyeColor.valueOf(fishcolor.val().toUpperCase());
                                    ((MCTropicalFishBucketMeta)meta).setBodyColor(color3);
                                }
                                if (!ma.containsKey("fishpattern")) return meta;
                                Mixed pa = ma.get("fishpattern", t);
                                if (pa instanceof CNull) return meta;
                                MCTropicalFish.MCPattern pattern = MCTropicalFish.MCPattern.valueOf(pa.val().toUpperCase());
                                ((MCTropicalFishBucketMeta)meta).setPattern(pattern);
                                return meta;
                            }
                            if (meta instanceof MCCrossbowMeta) {
                                if (!ma.containsKey("projectiles")) return meta;
                                Mixed value = ma.get("projectiles", t);
                                if (value instanceof CNull) return meta;
                                ArrayList<MCItemStack> projectiles = new ArrayList<MCItemStack>();
                                Iterator<Mixed> iterator3 = ArgumentValidation.getArray(value, t).asList().iterator();
                                while (true) {
                                    if (!iterator3.hasNext()) {
                                        ((MCCrossbowMeta)meta).setChargedProjectiles(projectiles);
                                        return meta;
                                    }
                                    Mixed m3 = iterator3.next();
                                    projectiles.add(this.item(m3, t));
                                }
                            }
                            if (meta instanceof MCCompassMeta) {
                                Mixed loc;
                                if (ma.containsKey("target") && !((loc = ma.get("target", t)) instanceof CNull)) {
                                    ((MCCompassMeta)meta).setTargetLocation(this.location(loc, null, t));
                                }
                                if (!ma.containsKey("lodestone")) return meta;
                                ((MCCompassMeta)meta).setLodestoneTracked(ArgumentValidation.getBooleanObject(ma.get("lodestone", t), t));
                                return meta;
                            }
                            if (meta instanceof MCBundleMeta) {
                                if (!ma.containsKey("items")) return meta;
                                Mixed value = ma.get("items", t);
                                if (!(value instanceof CArray)) {
                                    if (value instanceof CNull) return meta;
                                    throw new CREFormatException("Items was expected to be an array or null.", t);
                                }
                                MCBundleMeta bm = (MCBundleMeta)meta;
                                CArray cArray = (CArray)value;
                                iterator2 = cArray.stringKeySet().iterator();
                                while (iterator2.hasNext()) {
                                    String key4 = iterator2.next();
                                    Mixed entry = cArray.get(key4, t);
                                    if (entry instanceof CNull) continue;
                                    bm.addItem(ObjectGenerator.GetGenerator().item(entry, t));
                                }
                                return meta;
                            }
                            if (meta instanceof MCAxolotlBucketMeta) {
                                if (!ma.containsKey("variant")) return meta;
                                Mixed value = ma.get("variant", t);
                                if (value instanceof CNull) return meta;
                                ((MCAxolotlBucketMeta)meta).setAxolotlType(MCAxolotlType.valueOf(value.val().toUpperCase()));
                                return meta;
                            }
                            if (meta instanceof MCMusicInstrumentMeta) {
                                if (!ma.containsKey("instrument")) return meta;
                                Mixed value = ma.get("instrument", t);
                                if (value instanceof CNull) return meta;
                                ((MCMusicInstrumentMeta)meta).setInstrument(value.val());
                                return meta;
                            }
                            if (!(meta instanceof MCKnowledgeBookMeta)) {
                                if (!(meta instanceof MCOminousBottleMeta)) return meta;
                                if (!ma.containsKey("ominousamplifier")) return meta;
                                Mixed value = ma.get("ominousamplifier", t);
                                if (value instanceof CNull) return meta;
                                ((MCOminousBottleMeta)meta).setAmplifier(ArgumentValidation.getInt32(value, t));
                                return meta;
                            }
                            MCKnowledgeBookMeta mCKnowledgeBookMeta = (MCKnowledgeBookMeta)meta;
                            if (!ma.containsKey("recipes")) return meta;
                            Mixed value = ma.get("recipes", t);
                            if (!value.isInstanceOf(CArray.TYPE)) {
                                if (value instanceof CNull) return meta;
                                throw new CREFormatException("Expected array or null for recipes but got " + value.val(), t);
                            }
                            CArray array4 = (CArray)value;
                            ArrayList<MCNamespacedKey> arrayList = new ArrayList<MCNamespacedKey>((int)array4.size());
                            iterator2 = ((CArray)value).asList().iterator();
                            while (true) {
                                if (!iterator2.hasNext()) {
                                    mCKnowledgeBookMeta.setRecipes(arrayList);
                                    return meta;
                                }
                                Mixed entry = (Mixed)iterator2.next();
                                arrayList.add(StaticLayer.GetConvertor().GetNamespacedKey(entry.val()));
                            }
                        }
                        catch (Exception ex) {
                            throw new CREFormatException(ex.getMessage(), t, ex);
                        }
                    }
                    while (iterator.hasNext()) {
                        String key5 = iterator.next();
                        CArray pattern = ArgumentValidation.getArray(array3.get(key5, t), t);
                        MCPatternShape shape = MCPatternShape.valueOf(pattern.get("shape", t).val().toUpperCase());
                        String color4 = pattern.get("color", t).val().toUpperCase();
                        try {
                            MCDyeColor dyecolor = MCDyeColor.valueOf(color4);
                            banner.addPattern(StaticLayer.GetConvertor().GetPattern(dyecolor, shape));
                        }
                        catch (IllegalArgumentException ex) {
                            if (!color4.equals("SILVER")) throw ex;
                            banner.addPattern(StaticLayer.GetConvertor().GetPattern(MCDyeColor.LIGHT_GRAY, shape));
                        }
                    }
                }
                bsm.setBlockState(banner);
                return meta;
            }
            while (true) {
                if (!key3.hasNext()) {
                    bsm.setBlockState(bs);
                    return meta;
                }
                String key6 = key3.next();
                try {
                    int index = Integer.parseInt(key6);
                    if (index < 0 || index >= inv.getSize()) {
                        ConfigRuntimeException.DoWarning("Out of range value (" + index + ") found in " + bs.getClass().getSimpleName().replaceFirst("MC", "") + " inventory array, so ignoring.");
                    }
                    inv.setItem(index, ObjectGenerator.GetGenerator().item(cinv.get(key6, t), t));
                }
                catch (NumberFormatException ex) {
                    ConfigRuntimeException.DoWarning("Expecting integer value for key in " + bs.getClass().getSimpleName().replaceFirst("MC", "") + " inventory array, but \"" + key6 + "\" was found. Ignoring.");
                }
            }
        }
        while (id.hasNext()) {
            String string = (String)id.next();
            CArray pattern = ArgumentValidation.getArray(array2.get(string, t), t);
            MCPatternShape shape = MCPatternShape.valueOf(pattern.get("shape", t).val().toUpperCase());
            String color5 = pattern.get("color", t).val().toUpperCase();
            try {
                MCDyeColor dyecolor = MCDyeColor.valueOf(color5);
                ((MCBannerMeta)meta).addPattern(StaticLayer.GetConvertor().GetPattern(dyecolor, shape));
            }
            catch (IllegalArgumentException ex) {
                if (!color5.equals("SILVER")) throw ex;
                ((MCBannerMeta)meta).addPattern(StaticLayer.GetConvertor().GetPattern(MCDyeColor.LIGHT_GRAY, shape));
            }
        }
        return meta;
    }

    public CArray exception(ConfigRuntimeException e, Environment env, Target t) {
        AbstractCREException ex = AbstractCREException.getAbstractCREException(e);
        return ex.getExceptionObject();
    }

    public AbstractCREException exception(CArray exception, Target t, Environment env) throws ClassNotFoundException {
        return AbstractCREException.getFromCArray(exception, t, env);
    }

    public CArray color(MCColor color2, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        ca.set("r", (Mixed)new CInt(color2.getRed(), t), t);
        ca.set("g", (Mixed)new CInt(color2.getGreen(), t), t);
        ca.set("b", (Mixed)new CInt(color2.getBlue(), t), t);
        return ca;
    }

    public MCColor color(CArray color2, Target t) {
        int red = color2.containsKey("r") ? ArgumentValidation.getInt32(color2.get("r", t), t) : (color2.containsKey("red") ? ArgumentValidation.getInt32(color2.get("red", t), t) : ArgumentValidation.getInt32(color2.get(0, t), t));
        int green = color2.containsKey("g") ? ArgumentValidation.getInt32(color2.get("g", t), t) : (color2.containsKey("green") ? ArgumentValidation.getInt32(color2.get("green", t), t) : ArgumentValidation.getInt32(color2.get(1, t), t));
        int blue = color2.containsKey("b") ? ArgumentValidation.getInt32(color2.get("b", t), t) : (color2.containsKey("blue") ? ArgumentValidation.getInt32(color2.get("blue", t), t) : ArgumentValidation.getInt32(color2.get(2, t), t));
        if (color2.size() > 3L) {
            int alpha = color2.containsKey("a") ? ArgumentValidation.getInt32(color2.get("a", t), t) : (color2.containsKey("alpha") ? ArgumentValidation.getInt32(color2.get("alpha", t), t) : ArgumentValidation.getInt32(color2.get(3, t), t));
            try {
                return StaticLayer.GetConvertor().GetColor(red, green, blue, alpha);
            }
            catch (IllegalArgumentException ex) {
                throw new CRERangeException(ex.getMessage(), t, ex);
            }
        }
        try {
            return StaticLayer.GetConvertor().GetColor(red, green, blue);
        }
        catch (IllegalArgumentException ex) {
            throw new CRERangeException(ex.getMessage(), t, ex);
        }
    }

    public CArray transparentColor(MCColor color2, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        ca.set("r", (Mixed)new CInt(color2.getRed(), t), t);
        ca.set("g", (Mixed)new CInt(color2.getGreen(), t), t);
        ca.set("b", (Mixed)new CInt(color2.getBlue(), t), t);
        ca.set("a", (Mixed)new CInt(color2.getAlpha(), t), t);
        return ca;
    }

    public CArray vector(Vector3D vector) {
        return this.vector(vector, Target.UNKNOWN);
    }

    public CArray vector(Vector3D vector, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        ca.set(0, (Mixed)new CDouble(vector.X(), t), t);
        ca.set(1, (Mixed)new CDouble(vector.Y(), t), t);
        ca.set(2, (Mixed)new CDouble(vector.Z(), t), t);
        ca.set("x", (Mixed)new CDouble(vector.X(), t), t);
        ca.set("y", (Mixed)new CDouble(vector.Y(), t), t);
        ca.set("z", (Mixed)new CDouble(vector.Z(), t), t);
        return ca;
    }

    public Vector3D vector(Mixed c, Target t) {
        return this.vector(Vector3D.ZERO, c, t);
    }

    public Vector3D vector(Vector3D v, Mixed c, Target t) {
        if (c.isInstanceOf(CArray.TYPE)) {
            CArray va = (CArray)c;
            double x = v.X();
            double y = v.Y();
            double z = v.Z();
            if (!va.isAssociative()) {
                if (va.size() == 3L) {
                    x = ArgumentValidation.getNumber(va.get(0, t), t);
                    y = ArgumentValidation.getNumber(va.get(1, t), t);
                    z = ArgumentValidation.getNumber(va.get(2, t), t);
                } else if (va.size() == 2L) {
                    x = ArgumentValidation.getNumber(va.get(0, t), t);
                    y = ArgumentValidation.getNumber(va.get(1, t), t);
                } else if (va.size() == 1L) {
                    x = ArgumentValidation.getNumber(va.get(0, t), t);
                }
            } else {
                if (va.containsKey("x")) {
                    x = ArgumentValidation.getNumber(va.get("x", t), t);
                }
                if (va.containsKey("y")) {
                    y = ArgumentValidation.getNumber(va.get("y", t), t);
                }
                if (va.containsKey("z")) {
                    z = ArgumentValidation.getNumber(va.get("z", t), t);
                }
            }
            return new Vector3D(x, y, z);
        }
        if (c instanceof CNull) {
            return v;
        }
        throw new CREFormatException("Expecting an array, received " + c.typeof().getSimpleName(), t);
    }

    public CArray enchants(Map<MCEnchantment, Integer> map, Target t) {
        CArray ret = CArray.GetAssociativeArray(t);
        for (Map.Entry<MCEnchantment, Integer> entry : map.entrySet()) {
            CArray enchant = CArray.GetAssociativeArray(t);
            enchant.set("elevel", (Mixed)new CInt(entry.getValue().intValue(), t), t);
            ret.set(entry.getKey().name().toLowerCase(), (Mixed)enchant, t);
        }
        return ret;
    }

    public Map<MCEnchantment, Integer> enchants(CArray enchantArray, Target t) {
        HashMap<MCEnchantment, Integer> ret = new HashMap<MCEnchantment, Integer>();
        for (String key : enchantArray.stringKeySet()) {
            String setype;
            MCEnchantment etype = null;
            Mixed value = enchantArray.get(key, t);
            if (enchantArray.isAssociative()) {
                try {
                    etype = MCEnchantment.valueOf(key.toUpperCase());
                    if (value.isInstanceOf(CInt.TYPE)) {
                        ret.put(etype, ArgumentValidation.getInt32(value, t));
                        continue;
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new CREEnchantmentException("Unknown enchantment type: " + key, t);
                }
            }
            if (!value.isInstanceOf(CArray.TYPE)) continue;
            CArray ea = (CArray)value;
            if (etype == null && (etype = MCEnchantment.valueOf(setype = ea.get("etype", t).val())) == null) {
                throw new CREEnchantmentException("Unknown enchantment type: " + setype, t);
            }
            int elevel = ArgumentValidation.getInt32(ea.get("elevel", t), t);
            ret.put(etype, elevel);
        }
        return ret;
    }

    public CArray attributeModifier(MCAttributeModifier m, Target t) {
        MCEquipmentSlot equipmentSlot;
        MCEquipmentSlotGroup equipmentSlotGroup;
        CArray modifier = CArray.GetAssociativeArray(t);
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21)) {
            modifier.set("id", m.getKey().toString());
        } else {
            modifier.set("name", m.getAttributeName());
            modifier.set("uuid", m.getUniqueId().toString());
        }
        modifier.set("attribute", m.getAttribute().name());
        modifier.set("operation", m.getOperation().name());
        modifier.set("amount", (Mixed)new CDouble(m.getAmount(), t), t);
        Construct slot = CNull.NULL;
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6) && (equipmentSlotGroup = m.getEquipmentSlotGroup()) != null) {
            slot = new CString(equipmentSlotGroup.name(), t);
        }
        if (slot == CNull.NULL && (equipmentSlot = m.getEquipmentSlot()) != null) {
            slot = new CString(equipmentSlot.name(), t);
        }
        modifier.set("slot", (Mixed)slot, t);
        return modifier;
    }

    public MCAttributeModifier attributeModifier(CArray m, Target t) {
        Mixed s;
        MCAttributeModifier.Operation operation;
        MCAttribute attribute;
        if (!m.isAssociative()) {
            throw new CREFormatException("Attribute modifier array must be associative.", t);
        }
        MCNamespacedKey id = null;
        UUID uuid2 = null;
        String name = "";
        MCEquipmentSlotGroup slotGroup = null;
        MCEquipmentSlot slot = null;
        try {
            attribute = MCAttribute.valueOf(m.get("attribute", t).val());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid attribute name: " + String.valueOf(m.get("attribute", t)), t);
        }
        try {
            operation = MCAttributeModifier.Operation.valueOf(m.get("operation", t).val());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid operation name: " + String.valueOf(m.get("operation", t)), t);
        }
        double amount = ArgumentValidation.getDouble(m.get("amount", t), t);
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21) && m.containsKey("id")) {
            id = StaticLayer.GetConvertor().GetNamespacedKey(m.get("id", t).val());
        } else {
            if (m.containsKey("name")) {
                name = m.get("name", t).val();
            }
            if (m.containsKey("uuid")) {
                try {
                    uuid2 = UUID.fromString(m.get("uuid", t).val());
                }
                catch (IllegalArgumentException ex) {
                    throw new CREFormatException("Invalid UUID format: " + String.valueOf(m.get("uuid", t)), t);
                }
            }
        }
        if (m.containsKey("slot") && !((s = m.get("slot", t)) instanceof CNull)) {
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                switch (s.val()) {
                    case "ANY": {
                        MCEquipmentSlotGroup mCEquipmentSlotGroup = MCEquipmentSlotGroup.ANY;
                        break;
                    }
                    case "HAND": {
                        MCEquipmentSlotGroup mCEquipmentSlotGroup = MCEquipmentSlotGroup.HAND;
                        break;
                    }
                    case "ARMOR": {
                        MCEquipmentSlotGroup mCEquipmentSlotGroup = MCEquipmentSlotGroup.ARMOR;
                        break;
                    }
                    case "BODY": {
                        MCEquipmentSlotGroup mCEquipmentSlotGroup = MCEquipmentSlotGroup.BODY;
                        break;
                    }
                    case "SADDLE": {
                        MCEquipmentSlotGroup mCEquipmentSlotGroup = MCEquipmentSlotGroup.SADDLE;
                        break;
                    }
                    default: {
                        MCEquipmentSlotGroup mCEquipmentSlotGroup = slotGroup = null;
                    }
                }
            }
            if (slotGroup == null) {
                try {
                    slot = MCEquipmentSlot.valueOf(s.val());
                }
                catch (IllegalArgumentException ex) {
                    throw new CREFormatException("Invalid equipment slot name: " + String.valueOf(m.get("slot", t)), t);
                }
            }
        }
        if (slotGroup != null) {
            if (id != null) {
                return StaticLayer.GetConvertor().GetAttributeModifier(attribute, id, amount, operation, slotGroup);
            }
            return StaticLayer.GetConvertor().GetAttributeModifier(attribute, uuid2, name, amount, operation, slotGroup);
        }
        if (id != null) {
            return StaticLayer.GetConvertor().GetAttributeModifier(attribute, id, amount, operation, slot);
        }
        return StaticLayer.GetConvertor().GetAttributeModifier(attribute, uuid2, name, amount, operation, slot);
    }

    public CArray potion(MCLivingEntity.MCEffect eff, Target t) {
        CArray effect = CArray.GetAssociativeArray(t);
        effect.set("id", (Mixed)new CInt(eff.getPotionEffectType().getId(), t), t);
        effect.set("strength", (Mixed)new CInt(eff.getStrength(), t), t);
        effect.set("seconds", (Mixed)new CDouble((double)eff.getTicksRemaining() / 20.0, t), t);
        effect.set("ambient", (Mixed)CBoolean.get(eff.isAmbient()), t);
        effect.set("particles", (Mixed)CBoolean.get(eff.hasParticles()), t);
        effect.set("icon", (Mixed)CBoolean.get(eff.showIcon()), t);
        return effect;
    }

    public CArray potions(List<MCLivingEntity.MCEffect> effectList, Target t) {
        CArray ea = CArray.GetAssociativeArray(t);
        for (MCLivingEntity.MCEffect eff : effectList) {
            CArray effect = this.potion(eff, t);
            ea.set(eff.getPotionEffectType().name().toLowerCase(), (Mixed)effect, t);
        }
        return ea;
    }

    public List<MCLivingEntity.MCEffect> potions(CArray ea, Target t) {
        ArrayList<MCLivingEntity.MCEffect> ret = new ArrayList<MCLivingEntity.MCEffect>();
        for (String key : ea.stringKeySet()) {
            if (ea.get(key, t).isInstanceOf(CArray.TYPE)) {
                MCPotionEffectType type;
                boolean icon;
                boolean particles;
                boolean ambient;
                double seconds;
                int strength;
                CArray effect;
                block11: {
                    effect = (CArray)ea.get(key, t);
                    strength = 0;
                    seconds = 30.0;
                    ambient = false;
                    particles = true;
                    icon = true;
                    try {
                        if (ea.isAssociative()) {
                            type = MCPotionEffectType.valueOf(key.toUpperCase());
                            break block11;
                        }
                        if (effect.containsKey("id")) {
                            type = MCPotionEffectType.getById(ArgumentValidation.getInt32(effect.get("id", t), t));
                            break block11;
                        }
                        throw new CREFormatException("No potion type was given.", t);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CREFormatException(ex.getMessage(), t);
                    }
                }
                if (effect.containsKey("strength")) {
                    strength = ArgumentValidation.getInt32(effect.get("strength", t), t);
                }
                if (effect.containsKey("seconds") && (seconds = ArgumentValidation.getDouble(effect.get("seconds", t), t)) * 20.0 > 2.147483647E9) {
                    throw new CRERangeException("Seconds cannot be greater than 107374182", t);
                }
                if (effect.containsKey("ambient")) {
                    ambient = ArgumentValidation.getBoolean(effect.get("ambient", t), t);
                }
                if (effect.containsKey("particles")) {
                    particles = ArgumentValidation.getBoolean(effect.get("particles", t), t);
                }
                if (effect.containsKey("icon")) {
                    icon = ArgumentValidation.getBoolean(effect.get("icon", t), t);
                }
                ret.add(new MCLivingEntity.MCEffect(type, strength, (int)(seconds * 20.0), ambient, particles, icon));
                continue;
            }
            throw new CREFormatException("Expected a potion array at index" + key, t);
        }
        return ret;
    }

    public CArray potionData(MCPotionData mcpd, Target t) {
        CArray base = CArray.GetAssociativeArray(t);
        base.set("type", mcpd.getType().name(), t);
        base.set("extended", (Mixed)CBoolean.get(mcpd.isExtended()), t);
        base.set("upgraded", (Mixed)CBoolean.get(mcpd.isUpgraded()), t);
        return base;
    }

    public MCPotionData potionData(CArray pd, Target t) {
        MCPotionType type;
        try {
            type = MCPotionType.valueOf(pd.get("type", t).val().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid potion type: " + pd.get("type", t).val(), t);
        }
        boolean extended = false;
        boolean upgraded = false;
        if (pd.containsKey("extended")) {
            Mixed cext = pd.get("extended", t);
            if (cext.isInstanceOf(CBoolean.TYPE)) {
                extended = ((CBoolean)cext).getBoolean();
            } else {
                throw new CREFormatException("Expected potion value for key \"extended\" to be a boolean", t);
            }
        }
        if (pd.containsKey("upgraded")) {
            Mixed cupg = pd.get("upgraded", t);
            if (cupg.isInstanceOf(CBoolean.TYPE)) {
                upgraded = ((CBoolean)cupg).getBoolean();
            } else {
                throw new CREFormatException("Expected potion value for key \"upgraded\" to be a boolean", t);
            }
        }
        try {
            return StaticLayer.GetPotionData(type, extended, upgraded);
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException(ex.getMessage(), t, ex);
        }
    }

    public MCPotionType legacyPotionData(CArray potionArray, Target t) {
        Mixed cupg;
        Mixed cext;
        MCPotionType type;
        try {
            type = MCPotionType.valueOf(potionArray.get("type", t).val().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid potion type: " + potionArray.get("type", t).val(), t);
        }
        if (type == null) {
            return null;
        }
        boolean extended = false;
        boolean upgraded = false;
        if (potionArray.containsKey("extended") && (cext = potionArray.get("extended", t)).isInstanceOf(CBoolean.TYPE)) {
            extended = ((CBoolean)cext).getBoolean();
        }
        if (potionArray.containsKey("upgraded") && (cupg = potionArray.get("upgraded", t)).isInstanceOf(CBoolean.TYPE)) {
            upgraded = ((CBoolean)cupg).getBoolean();
        }
        if (extended) {
            try {
                type = MCPotionType.valueOf("LONG_" + type.name());
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException("Could not find extended potion type for: " + potionArray.get("type", t).val(), t);
            }
        }
        if (upgraded) {
            try {
                type = MCPotionType.valueOf("STRONG_" + type.name());
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException("Could not find upgraded potion type for: " + potionArray.get("type", t).val(), t);
            }
        }
        return type;
    }

    public CArray fireworkEffect(MCFireworkEffect mcfe, Target t) {
        CArray fe = CArray.GetAssociativeArray(t);
        fe.set("flicker", (Mixed)CBoolean.get(mcfe.hasFlicker()), t);
        fe.set("trail", (Mixed)CBoolean.get(mcfe.hasTrail()), t);
        MCFireworkType type = mcfe.getType();
        if (type != null) {
            fe.set("type", (Mixed)new CString(mcfe.getType().name(), t), t);
        } else {
            fe.set("type", (Mixed)CNull.NULL, t);
        }
        CArray colors = new CArray(t);
        for (MCColor c : mcfe.getColors()) {
            colors.push(ObjectGenerator.GetGenerator().color(c, t), t);
        }
        fe.set("colors", (Mixed)colors, t);
        CArray fadeColors = new CArray(t);
        for (MCColor c : mcfe.getFadeColors()) {
            fadeColors.push(ObjectGenerator.GetGenerator().color(c, t), t);
        }
        fe.set("fade", (Mixed)fadeColors, t);
        return fe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MCFireworkEffect fireworkEffect(CArray fe, Target t) {
        String[] split2;
        CArray ccolors;
        Mixed colors;
        MCFireworkBuilder builder = StaticLayer.GetConvertor().GetFireworkBuilder();
        if (fe.containsKey("flicker")) {
            builder.setFlicker(ArgumentValidation.getBoolean(fe.get("flicker", t), t));
        }
        if (fe.containsKey("trail")) {
            builder.setTrail(ArgumentValidation.getBoolean(fe.get("trail", t), t));
        }
        if (fe.containsKey("colors")) {
            colors = fe.get("colors", t);
            if (colors.isInstanceOf(CArray.TYPE)) {
                ccolors = (CArray)colors;
                if (ccolors.size() == 0L) {
                    builder.addColor(MCColor.WHITE);
                } else {
                    for (Mixed color2 : ccolors.asList()) {
                        MCColor mccolor;
                        if (color2.isInstanceOf(CString.TYPE)) {
                            mccolor = StaticLayer.GetConvertor().GetColor(color2.val(), t);
                        } else {
                            if (!color2.isInstanceOf(CArray.TYPE)) {
                                if (!color2.isInstanceOf(CInt.TYPE) || ccolors.size() != 3L) throw new CREFormatException("Expecting individual color to be an array or string, but found " + String.valueOf(color2.typeof()), t);
                                builder.addColor(this.color(ccolors, t));
                                break;
                            }
                            mccolor = this.color((CArray)color2, t);
                        }
                        builder.addColor(mccolor);
                    }
                }
            } else {
                if (!colors.isInstanceOf(CString.TYPE)) throw new CREFormatException("Expecting an array or string for colors parameter, but found " + String.valueOf(colors.typeof()), t);
                split2 = colors.val().split("\\|");
                if (split2.length == 0) {
                    builder.addColor(MCColor.WHITE);
                } else {
                    for (String string : split2) {
                        builder.addColor(StaticLayer.GetConvertor().GetColor(string, t));
                    }
                }
            }
        } else {
            builder.addColor(MCColor.WHITE);
        }
        if (fe.containsKey("fade")) {
            colors = fe.get("fade", t);
            if (colors.isInstanceOf(CArray.TYPE)) {
                ccolors = (CArray)colors;
                for (Mixed color2 : ccolors.asList()) {
                    MCColor mccolor;
                    if (color2.isInstanceOf(CArray.TYPE)) {
                        mccolor = this.color((CArray)color2, t);
                    } else {
                        if (!color2.isInstanceOf(CString.TYPE)) {
                            if (!color2.isInstanceOf(CInt.TYPE) || ccolors.size() != 3L) throw new CREFormatException("Expecting individual color to be an array or string, but found " + String.valueOf(color2.typeof()), t);
                            builder.addFadeColor(this.color(ccolors, t));
                            break;
                        }
                        mccolor = StaticLayer.GetConvertor().GetColor(color2.val(), t);
                    }
                    builder.addFadeColor(mccolor);
                }
            } else {
                if (!colors.isInstanceOf(CString.TYPE)) throw new CREFormatException("Expecting an array or string for fade parameter, but found " + String.valueOf(colors.typeof()), t);
                split2 = colors.val().split("\\|");
                for (String string : split2) {
                    builder.addFadeColor(StaticLayer.GetConvertor().GetColor(string, t));
                }
            }
        }
        if (!fe.containsKey("type")) return builder.build();
        try {
            builder.setType(MCFireworkType.valueOf(fe.get("type", t).val().toUpperCase()));
            return builder.build();
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException(ex.getMessage(), t, ex);
        }
    }

    public Construct recipe(MCRecipe r, Target t) {
        if (r == null) {
            return CNull.NULL;
        }
        CArray ret = CArray.GetAssociativeArray(t);
        ret.set("type", (Mixed)new CString(r.getRecipeType().name(), t), t);
        ret.set("result", (Mixed)this.item(r.getResult(), t), t);
        ret.set("key", r.getKey(), t);
        ret.set("group", r.getGroup(), t);
        if (r instanceof MCCookingRecipe) {
            MCCookingRecipe recipe = (MCCookingRecipe)r;
            ret.set("input", this.recipeChoice(recipe.getInput()), t);
            ret.set("experience", (Mixed)new CDouble(recipe.getExperience(), t), t);
            ret.set("cookingtime", (Mixed)new CInt(recipe.getCookingTime(), t), t);
        } else if (r instanceof MCShapelessRecipe) {
            MCShapelessRecipe shapeless = (MCShapelessRecipe)r;
            CArray il = new CArray(t);
            for (MCRecipeChoice choice : shapeless.getIngredients()) {
                il.push(this.recipeChoice(choice), t);
            }
            ret.set("ingredients", (Mixed)il, t);
        } else if (r instanceof MCShapedRecipe) {
            MCShapedRecipe shaped = (MCShapedRecipe)r;
            CArray shape = new CArray(t);
            for (String line : shaped.getShape()) {
                shape.push(new CString(line, t), t);
            }
            ret.set("shape", (Mixed)shape, t);
            CArray imap = CArray.GetAssociativeArray(t);
            for (Map.Entry<Character, MCRecipeChoice> entry : shaped.getIngredientMap().entrySet()) {
                if (entry.getValue() == null) {
                    imap.set(entry.getKey().toString(), (Mixed)CNull.NULL, t);
                    continue;
                }
                imap.set(entry.getKey().toString(), this.recipeChoice(entry.getValue()), t);
            }
            ret.set("ingredients", (Mixed)imap, t);
        } else if (r instanceof MCStonecuttingRecipe) {
            MCStonecuttingRecipe recipe = (MCStonecuttingRecipe)r;
            ret.set("input", this.recipeChoice(recipe.getInput()), t);
        } else if (r instanceof MCSmithingRecipe) {
            MCSmithingRecipe recipe = (MCSmithingRecipe)r;
            MCMaterial[] base = recipe.getBase();
            if (base.length == 1) {
                ret.set("base", (Mixed)new CString(base[0].getName(), t), t);
            } else {
                CArray mats = new CArray(t);
                for (MCMaterial mat : base) {
                    mats.push(new CString(mat.getName(), t), t);
                }
                ret.set("base", (Mixed)mats, t);
            }
            MCMaterial[] additions = recipe.getAddition();
            if (additions.length == 1) {
                ret.set("addition", (Mixed)new CString(additions[0].getName(), t), t);
            } else {
                CArray mats = new CArray(t);
                for (MCMaterial mat : additions) {
                    mats.push(new CString(mat.getName(), t), t);
                }
                ret.set("addition", (Mixed)mats, t);
            }
        }
        return ret;
    }

    public MCRecipe recipe(Mixed c, Target t) {
        MCRecipe ret;
        MCRecipeType recipeType;
        if (!c.isInstanceOf(CArray.TYPE)) {
            throw new CRECastException("Expected array but received " + c.typeof().getSimpleName(), t);
        }
        CArray recipe = (CArray)c;
        String recipeKey = recipe.get("key", t).val();
        try {
            recipeType = MCRecipeType.valueOf(recipe.get("type", t).val());
        }
        catch (IllegalArgumentException e) {
            throw new CREIllegalArgumentException("Invalid recipe type.", t);
        }
        MCItemStack result = this.item(recipe.get("result", t), t);
        try {
            ret = StaticLayer.GetNewRecipe(recipeKey, recipeType, result);
        }
        catch (IllegalArgumentException ex) {
            throw new CREIllegalArgumentException(ex.getMessage(), t);
        }
        if (recipe.containsKey("group")) {
            ret.setGroup(recipe.get("group", t).val());
        }
        switch (recipeType) {
            case SHAPED: {
                CArray shaped = ArgumentValidation.getArray(recipe.get("shape", t), t);
                String[] shape = new String[(int)shaped.size()];
                if (shaped.size() < 1L || shaped.size() > 3L || shaped.inAssociativeMode()) {
                    throw new CREFormatException("Shape array is invalid.", t);
                }
                int i = 0;
                for (Mixed mixed : shaped.asList()) {
                    if (mixed.isInstanceOf(CString.TYPE) && mixed.val().length() >= 1 && mixed.val().length() <= 3) {
                        shape[i] = mixed.val();
                        ++i;
                        continue;
                    }
                    throw new CREFormatException("Shape array is invalid.", t);
                }
                ((MCShapedRecipe)ret).setShape(shape);
                CArray shapedIngredients = ArgumentValidation.getArray(recipe.get("ingredients", t), t);
                if (!shapedIngredients.inAssociativeMode()) {
                    throw new CREIllegalArgumentException("Ingredients array is invalid.", t);
                }
                for (String key : shapedIngredients.stringKeySet()) {
                    Mixed ingredient = shapedIngredients.get(key, t);
                    if (ingredient.isInstanceOf(CArray.TYPE)) {
                        if (((CArray)ingredient).isAssociative()) {
                            ((MCShapedRecipe)ret).setIngredient(key.charAt(0), this.recipeItem(ingredient, t));
                            continue;
                        }
                        ((MCShapedRecipe)ret).setIngredient(key.charAt(0), this.recipeChoice((CArray)ingredient, t));
                        continue;
                    }
                    if (ingredient instanceof CNull) continue;
                    ((MCShapedRecipe)ret).setIngredient(key.charAt(0), this.recipeMaterial(ingredient, t));
                }
                return ret;
            }
            case SHAPELESS: {
                CArray cArray = ArgumentValidation.getArray(recipe.get("ingredients", t), t);
                if (cArray.inAssociativeMode()) {
                    throw new CREIllegalArgumentException("Ingredients array is invalid.", t);
                }
                for (Mixed ingredient : cArray.asList()) {
                    if (ingredient.isInstanceOf(CArray.TYPE)) {
                        if (((CArray)ingredient).isAssociative()) {
                            if (((CArray)ingredient).containsKey("meta")) {
                                MCRecipeChoice.ExactChoice exactChoice = new MCRecipeChoice.ExactChoice();
                                exactChoice.addItem(this.recipeItem(ingredient, t));
                                ((MCShapelessRecipe)ret).addIngredient(exactChoice);
                                continue;
                            }
                            MCItemStack stack = this.recipeItem(ingredient, t);
                            ((MCShapelessRecipe)ret).addIngredient(stack.getType(), stack.getAmount());
                            continue;
                        }
                        ((MCShapelessRecipe)ret).addIngredient(this.recipeChoice((CArray)ingredient, t));
                        continue;
                    }
                    ((MCShapelessRecipe)ret).addIngredient(this.recipeMaterial(ingredient, t));
                }
                return ret;
            }
            case BLASTING: 
            case CAMPFIRE: 
            case FURNACE: 
            case SMOKING: {
                Mixed input = recipe.get("input", t);
                if (input.isInstanceOf(CArray.TYPE)) {
                    if (((CArray)input).isAssociative()) {
                        ((MCCookingRecipe)ret).setInput(this.recipeItem(input, t));
                    } else {
                        ((MCCookingRecipe)ret).setInput(this.recipeChoice((CArray)input, t));
                    }
                } else {
                    ((MCCookingRecipe)ret).setInput(this.recipeMaterial(input, t));
                }
                if (recipe.containsKey("experience")) {
                    ((MCCookingRecipe)ret).setExperience(ArgumentValidation.getDouble32(recipe.get("experience", t), t));
                }
                if (recipe.containsKey("cookingtime")) {
                    ((MCCookingRecipe)ret).setCookingTime(ArgumentValidation.getInt32(recipe.get("cookingtime", t), t));
                }
                return ret;
            }
            case STONECUTTING: {
                Mixed stoneCutterInput = recipe.get("input", t);
                if (stoneCutterInput.isInstanceOf(CArray.TYPE)) {
                    if (((CArray)stoneCutterInput).isAssociative()) {
                        ((MCStonecuttingRecipe)ret).setInput(this.recipeItem(stoneCutterInput, t));
                    } else {
                        ((MCStonecuttingRecipe)ret).setInput(this.recipeChoice((CArray)stoneCutterInput, t));
                    }
                } else {
                    ((MCStonecuttingRecipe)ret).setInput(this.recipeMaterial(stoneCutterInput, t));
                }
                return ret;
            }
        }
        throw new CREIllegalArgumentException("Could not find valid recipe type.", t);
    }

    private MCMaterial recipeMaterial(Mixed arg, Target t) {
        MCMaterial mat = StaticLayer.GetMaterial(arg.val());
        if (mat == null || mat.isAir() || !mat.isItem()) {
            throw new CREIllegalArgumentException("Recipe input ingredient is invalid: " + arg.val(), t);
        }
        return mat;
    }

    private MCRecipeChoice recipeChoice(CArray ingredient, Target t) {
        MCRecipeChoice.MaterialChoice materialChoice = new MCRecipeChoice.MaterialChoice();
        MCRecipeChoice.ExactChoice exactChoice = new MCRecipeChoice.ExactChoice();
        for (Mixed choice : ingredient.asList()) {
            if (choice.isInstanceOf(CArray.TYPE)) {
                exactChoice.addItem(this.recipeItem(choice, t));
                continue;
            }
            materialChoice.addMaterial(this.recipeMaterial(choice, t));
        }
        if (!exactChoice.getItems().isEmpty()) {
            for (MCMaterial mat : materialChoice.getMaterials()) {
                exactChoice.addItem(StaticLayer.GetItemStack(mat, 1));
            }
            return exactChoice;
        }
        return materialChoice;
    }

    private Mixed recipeChoice(MCRecipeChoice ingredient) {
        if (ingredient instanceof MCRecipeChoice.MaterialChoice) {
            MCRecipeChoice.MaterialChoice materialChoice = (MCRecipeChoice.MaterialChoice)ingredient;
            if (materialChoice.getMaterials().size() == 1) {
                return new CString(materialChoice.getMaterials().get(0).getName(), Target.UNKNOWN);
            }
            CArray materialArray = new CArray(Target.UNKNOWN);
            for (MCMaterial mat : materialChoice.getMaterials()) {
                materialArray.push(new CString(mat.getName(), Target.UNKNOWN), Target.UNKNOWN);
            }
            return materialArray;
        }
        if (ingredient instanceof MCRecipeChoice.ExactChoice) {
            MCRecipeChoice.ExactChoice exactChoice = (MCRecipeChoice.ExactChoice)ingredient;
            if (exactChoice.getItems().size() == 1) {
                return this.item(exactChoice.getItems().get(0), Target.UNKNOWN);
            }
            CArray itemArray = new CArray(Target.UNKNOWN);
            for (MCItemStack itemStack : exactChoice.getItems()) {
                itemArray.push(this.item(itemStack, Target.UNKNOWN), Target.UNKNOWN);
            }
            return itemArray;
        }
        throw new RuntimeException("Invalid MCRecipeChoice type");
    }

    private MCItemStack recipeItem(Mixed arg, Target t) {
        MCItemStack item = this.item(arg, t);
        if (item.isEmpty()) {
            throw new CREIllegalArgumentException("Recipe input ingredient is invalid: " + arg.val(), t);
        }
        return item;
    }

    public MCMaterial material(String name, Target t) {
        MCMaterial mat = StaticLayer.GetMaterial(name.toUpperCase());
        if (mat == null) {
            throw new CREFormatException("Unknown material type: " + name, t);
        }
        return mat;
    }

    public MCMaterial material(Mixed name, Target t) {
        return this.material(name.val(), t);
    }

    public MCBlockData blockData(CArray ca, Target t) {
        return this.blockData(ca, null, t);
    }

    public MCBlockData blockData(CArray ca, MCMaterial blockType, Target t) {
        StringBuilder b = new StringBuilder().append("[");
        boolean first = true;
        String block = null;
        for (String key : ca.stringKeySet()) {
            if (key.equals("block")) {
                block = ca.get("block", t).val();
                if (!Character.isUpperCase(block.charAt(0))) continue;
                block = block.toLowerCase();
                continue;
            }
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append(key).append('=').append(ca.get(key, t).val());
        }
        b.append("]");
        if (block == null) {
            if (blockType == null) {
                throw new CREFormatException("Missing block type for block data.", t);
            }
            block = blockType.name().toLowerCase();
        }
        b.insert(0, block);
        return Static.getServer().createBlockData(b.toString());
    }

    public CArray blockData(MCBlockData blockdata, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        String full = blockdata.getAsString().substring(10);
        int bracketPos = full.indexOf(91, 3);
        if (bracketPos != -1) {
            String[] states;
            ca.set("block", (Mixed)new CString(full.substring(0, bracketPos), t), t);
            for (String s : states = full.substring(bracketPos + 1, full.length() - 1).split(",")) {
                int equalsPos = s.indexOf(61);
                ca.set(s.substring(0, equalsPos), (Mixed)this.blockState(s.substring(equalsPos + 1)), t);
            }
        } else {
            ca.set("block", (Mixed)new CString(full, t), t);
        }
        return ca;
    }

    public CArray blockData(MCMaterial mat, Map<String, String> blockData, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        ca.set("block", (Mixed)new CString(mat.getName().toLowerCase(Locale.ROOT), t), t);
        for (Map.Entry<String, String> entry : blockData.entrySet()) {
            ca.set(entry.getKey(), (Mixed)this.blockState(entry.getValue()), t);
        }
        return ca;
    }

    private Construct blockState(String value) {
        char ch = value.charAt(0);
        if (ch >= '0' && ch <= '9') {
            try {
                return new CInt(Long.parseLong(value), Target.UNKNOWN);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            if (value.equals("true")) {
                return CBoolean.TRUE;
            }
            if (value.equals("false")) {
                return CBoolean.FALSE;
            }
        }
        return new CString(value, Target.UNKNOWN);
    }

    public Object particleData(MCParticle particleType, MCLocation l, CArray pa, Target t) {
        switch (particleType.getAbstracted()) {
            case BLOCK_DUST: 
            case BLOCK_CRACK: 
            case BLOCK_CRUMBLE: 
            case BLOCK_MARKER: 
            case DUST_PILLAR: 
            case FALLING_DUST: {
                if (!pa.containsKey("block")) break;
                String value = pa.get("block", t).val();
                MCMaterial mat = StaticLayer.GetMaterial(value);
                if (mat != null) {
                    try {
                        return mat.createBlockData();
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CREIllegalArgumentException(value + " is not a block.", t);
                    }
                }
                throw new CREIllegalArgumentException("Could not find material from " + value, t);
            }
            case ITEM_CRACK: {
                if (!pa.containsKey("item")) break;
                Mixed value = pa.get("item", t);
                if (value.isInstanceOf(CArray.TYPE)) {
                    return this.item(pa.get("item", t), t);
                }
                MCMaterial mat = StaticLayer.GetMaterial(value.val());
                if (mat != null) {
                    if (mat.isItem()) {
                        return StaticLayer.GetItemStack(mat, 1);
                    }
                    throw new CREIllegalArgumentException(String.valueOf(value) + " is not an item type.", t);
                }
                throw new CREIllegalArgumentException("Could not find material from " + String.valueOf(value), t);
            }
            case SPELL_MOB: 
            case REDSTONE: 
            case FLASH: {
                if (!pa.containsKey("color")) break;
                Mixed c = pa.get("color", t);
                if (c.isInstanceOf(CArray.TYPE)) {
                    return this.color((CArray)c, t);
                }
                return StaticLayer.GetConvertor().GetColor(c.val(), t);
            }
            case DRAGON_BREATH: {
                if (!pa.containsKey("power")) break;
                Mixed d = pa.get("power", t);
                if (d.isInstanceOf(CDouble.TYPE)) {
                    return Float.valueOf((float)((CDouble)d).getDouble());
                }
                if (d instanceof CNull) break;
                throw new CREIllegalArgumentException("Expected double for power but found " + String.valueOf(d), t);
            }
            case SPELL: 
            case SPELL_INSTANT: {
                MCColor spellColor = MCColor.WHITE;
                if (pa.containsKey("color")) {
                    Mixed c = pa.get("color", t);
                    spellColor = c.isInstanceOf(CArray.TYPE) ? this.color((CArray)c, t) : StaticLayer.GetConvertor().GetColor(c.val(), t);
                }
                float power = 1.0f;
                if (pa.containsKey("power")) {
                    Mixed d = pa.get("power", t);
                    if (d.isInstanceOf(CDouble.TYPE)) {
                        power = (float)((CDouble)d).getDouble();
                    } else if (!(d instanceof CNull)) {
                        throw new CREIllegalArgumentException("Expected double for power but found " + String.valueOf(d), t);
                    }
                }
                return new MCParticleData.Spell(spellColor, power);
            }
            case DUST_COLOR_TRANSITION: {
                if (pa.containsKey("color")) {
                    Mixed c = pa.get("color", t);
                    MCColor fromColor = c.isInstanceOf(CArray.TYPE) ? this.color((CArray)c, t) : StaticLayer.GetConvertor().GetColor(c.val(), t);
                    if (pa.containsKey("tocolor")) {
                        Mixed sc = pa.get("tocolor", t);
                        if (sc.isInstanceOf(CArray.TYPE)) {
                            return new MCParticleData.DustTransition(fromColor, this.color((CArray)sc, t));
                        }
                        return new MCParticleData.DustTransition(fromColor, StaticLayer.GetConvertor().GetColor(sc.val(), t));
                    }
                    return new MCParticleData.DustTransition(fromColor, MCColor.WHITE);
                }
                if (!pa.containsKey("tocolor")) break;
                Mixed sc = pa.get("tocolor", t);
                if (sc.isInstanceOf(CArray.TYPE)) {
                    return new MCParticleData.DustTransition(MCColor.WHITE, this.color((CArray)sc, t));
                }
                return new MCParticleData.DustTransition(MCColor.WHITE, StaticLayer.GetConvertor().GetColor(sc.val(), t));
            }
            case VIBRATION: {
                if (!pa.containsKey("destination")) break;
                Mixed d = pa.get("destination", t);
                if (d.isInstanceOf(CArray.TYPE)) {
                    return new MCParticleData.VibrationBlockDestination(this.location(d, l.getWorld(), t), 5);
                }
                return new MCParticleData.VibrationEntityDestination(Static.getEntity(d, t), 5);
            }
            case SHRIEK: {
                if (!pa.containsKey("delay")) break;
                Mixed d = pa.get("delay", t);
                if (d.isInstanceOf(CInt.TYPE)) {
                    return (int)((CInt)d).getInt();
                }
                if (d instanceof CNull) break;
                throw new CREIllegalArgumentException("Expected integer for delay but found " + String.valueOf(d), t);
            }
            case SCULK_CHARGE: {
                if (!pa.containsKey("angle")) break;
                Mixed d = pa.get("angle", t);
                if (d.isInstanceOf(CDouble.TYPE)) {
                    return Float.valueOf((float)((CDouble)d).getDouble());
                }
                if (d instanceof CNull) break;
                throw new CREIllegalArgumentException("Expected double for angle but found " + String.valueOf(d), t);
            }
            case TRAIL: {
                Mixed c;
                Mixed d;
                MCLocation target = l;
                if (pa.containsKey("target") && (d = pa.get("target", t)).isInstanceOf(CArray.TYPE)) {
                    target = this.location(d, l.getWorld(), t);
                }
                MCColor color2 = pa.containsKey("color") ? ((c = pa.get("color", t)).isInstanceOf(CArray.TYPE) ? this.color((CArray)c, t) : StaticLayer.GetConvertor().GetColor(c.val(), t)) : StaticLayer.GetConvertor().GetColor(252, 120, 18);
                int duration = pa.containsKey("duration") ? ArgumentValidation.getInt32(pa.get("duration", t), t) : new Random().nextInt(40) + 10;
                return new MCParticleData.Trail(target, color2, duration);
            }
        }
        return null;
    }

    public MCMetadataValue metadataValue(Mixed value, MCPlugin plugin) {
        return this.metadataValue(Static.getJavaObject(value), plugin);
    }

    public MCMetadataValue metadataValue(Object value, MCPlugin plugin) {
        return StaticLayer.GetMetadataValue(value, plugin);
    }

    public CArray regMatchValue(MatchResult matchResult, Target t) {
        CArray ret = CArray.GetAssociativeArray(t);
        ret.set(0, (Mixed)new CString(matchResult.group(0), t), t);
        for (int i = 1; i <= matchResult.groupCount(); ++i) {
            if (matchResult.group(i) == null) {
                ret.set(i, (Mixed)CNull.NULL, t);
                continue;
            }
            ret.set(i, (Mixed)new CString(matchResult.group(i), t), t);
        }
        return ret;
    }
}

