/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.SmartComment;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.EarlyBindingKeyword;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.natives.interfaces.MAnnotation;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ObjectModifier;
import com.laytonsmith.core.objects.ObjectType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ObjectDefinitionKeyword
extends EarlyBindingKeyword {
    @Override
    public int process(TokenStream stream, Environment env, int keywordPosition) throws ConfigCompileException {
        int startRemovalFrom = keywordPosition;
        AccessModifier accessModifier = null;
        HashSet<ObjectModifier> objectModifiers = new HashSet<ObjectModifier>();
        SmartComment smartComment = null;
        for (int i = keywordPosition; i >= 0; --i) {
            ObjectModifier possibleObjectModifier;
            Token keyword2 = (Token)stream.get(i);
            if (keyword2.type == Token.TType.COMMENT) continue;
            if (keyword2.type == Token.TType.SMART_COMMENT && smartComment == null) {
                smartComment = new SmartComment(keyword2.value);
            }
            if (keyword2.type != Token.TType.KEYWORD) break;
            AccessModifier possibleAccessModifier = AccessModifier.valueOf(keyword2.value.toUpperCase());
            if (possibleAccessModifier != null) {
                if (accessModifier != null) {
                    throw new ConfigCompileException("Unexpected access modifier", keyword2.target);
                }
                accessModifier = possibleAccessModifier;
            }
            if ((possibleObjectModifier = ObjectModifier.valueOf(keyword2.value.toUpperCase())) == null) continue;
            if (objectModifiers.contains((Object)possibleObjectModifier)) {
                throw new ConfigCompileException("Duplicated object modifier", keyword2.target);
            }
            objectModifiers.add(possibleObjectModifier);
        }
        StringBuilder className = new StringBuilder();
        int advance = ObjectDefinitionKeyword.getClassName(stream, keywordPosition + 1, className);
        ArrayList implementsTypes = new ArrayList();
        boolean inImplementsKeyword = false;
        for (int i = advance; i < stream.size(); ++i) {
        }
        return keywordPosition;
    }

    private static int getClassName(TokenStream list, int start, StringBuilder builder) throws ConfigCompileException {
        Token lastToken = null;
        block5: for (int i = start; i < list.size(); ++i) {
            Token t;
            lastToken = t = (Token)list.get(i);
            switch (t.type) {
                case STRING: {
                    builder.append(t.toString());
                    continue block5;
                }
                case CONCAT: {
                    builder.append(t.toString());
                    continue block5;
                }
                case LCURLY_BRACKET: 
                case KEYWORD: {
                    return i;
                }
            }
        }
        throw new ConfigCompileException("Unexpected end of class definition", lastToken == null ? Target.UNKNOWN : lastToken.target);
    }

    protected List<ParseTree> processInternals(List<MAnnotation> annotations, AccessModifier accessModifier, Set<ObjectModifier> objectModifiers, CClassType objectName, CClassType[] superclasses, CClassType[] interfaces, ParseTree contents) {
        return null;
    }

    protected abstract ObjectType getObjectType(Set<ObjectModifier> var1);

    protected abstract Set<ObjectModifier> illegalModifiers();
}

