/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.database;

import com.laytonsmith.core.Profiles;
import com.laytonsmith.database.SQLProfile;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Map;
import org.postgresql.Driver;

@Profiles.ProfileType(type="postgresql")
public class PostgreSQLProfile
extends SQLProfile {
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final boolean ssl;

    public PostgreSQLProfile(String id, Map<String, String> elements) throws Profiles.InvalidProfileException {
        super(id, elements);
        if (!elements.containsKey("database")) {
            throw new Profiles.InvalidProfileException("Required \"database\" tag is missing for profile \"" + id + "\"");
        }
        this.database = elements.get("database");
        this.username = elements.containsKey("username") ? elements.get("username") : null;
        this.password = elements.containsKey("password") ? elements.get("password") : null;
        this.host = elements.containsKey("host") ? elements.get("host") : "localhost";
        if (elements.containsKey("port")) {
            try {
                this.port = Integer.parseInt(elements.get("port"));
            }
            catch (NumberFormatException ex) {
                throw new Profiles.InvalidProfileException(ex.getMessage());
            }
        } else {
            this.port = 5432;
        }
        this.ssl = elements.containsKey("ssl");
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean getAutogeneratedKeys(String query2) {
        return query2.matches("(?i)insert into.*");
    }

    @Override
    public String getConnectionString() throws SQLException {
        try {
            Class.forName(Driver.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Could not load PostgreSQL, check your installation and try again");
        }
        try {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.database + "?" + (String)(this.username == null ? "" : "&user=" + URLEncoder.encode(this.username, "UTF-8")) + (String)(this.password == null ? "" : "&password=" + URLEncoder.encode(this.password, "UTF-8")) + (!this.ssl ? "" : "&ssl=true");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error();
        }
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.host + ":" + this.port + " username=" + this.username;
    }
}

