/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.SQLDataSource;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@datasource(value="mssql")
public final class MSSQLServerDataSource
extends SQLDataSource {
    private String host;
    private String instance;
    private int port;
    private String username;
    private String password;
    private String database;
    private String table;
    private Map<String, String> extraParameters = new HashMap<String, String>();
    private String connectionString;

    private MSSQLServerDataSource() {
    }

    public MSSQLServerDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
        Object split2;
        try {
            Class.forName(SQLServerDriver.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new DataSourceException("Could not instantiate a MSSQL data source, no driver appears to exist.", ex);
        }
        this.host = uri.getHost();
        if (this.host == null) {
            throw new DataSourceException("Invalid URI specified for data source \"" + uri.toString() + "\"");
        }
        if (this.host.contains("\\")) {
            String[] split22 = this.host.split("\\\\");
            this.host = split22[0];
            this.instance = split22[1];
        }
        this.port = uri.getPort();
        if (this.port < 0) {
            this.port = 1433;
        }
        if (uri.getUserInfo() != null) {
            split2 = uri.getUserInfo().split(":");
            this.username = split2[0];
            if (((String[])split2).length > 1) {
                this.password = split2[1];
            }
        }
        if (uri.getPath().split("/").length != 3 || !uri.getPath().startsWith("/")) {
            throw new DataSourceException("Invalid path information for mssql connection \"" + uri.toString() + "\". Path requires a database name and a table name, for instance \"/testDatabase/tableName");
        }
        split2 = uri.getPath().split("/");
        this.database = split2[1];
        this.table = split2[2];
        this.extraParameters.putAll(WebUtility.getQueryMap(uri.getQuery()));
        this.connectionString = "jdbc:sqlserver://" + this.host;
        if (this.instance != null) {
            this.connectionString = this.connectionString + "\\" + this.instance;
        }
        this.connectionString = this.connectionString + ":" + this.port;
        this.connectionString = this.connectionString + ";";
        if (this.username != null) {
            this.connectionString = this.connectionString + "user=" + this.username + ";";
        }
        if (this.password != null) {
            this.connectionString = this.connectionString + "password=" + this.password + ";";
        }
        this.connectionString = this.connectionString + "databaseName=" + this.database + ";";
        for (Map.Entry entry : this.extraParameters.entrySet()) {
            this.connectionString = this.connectionString + (String)entry.getKey() + "=" + (String)entry.getValue() + ";";
        }
        try {
            this.connect();
            for (String query2 : this.getTableCreationQueries(this.database, this.table)) {
                try (Statement statement = this.getConnection().createStatement();){
                    statement.executeUpdate(query2);
                }
            }
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException("Could not connect to MySQL data source \"" + (this.password != null ? uri.toString().replace(this.password, "<password>") : uri.toString()) + "\" (using \"" + (this.password != null ? this.getConnectionString().replace(this.password, "<password>") : this.getConnectionString()) + "\" to connect): " + ex.getMessage(), ex);
        }
    }

    @Override
    protected String getTable() {
        return this.table;
    }

    @Override
    protected String getConnectionString() {
        return this.connectionString;
    }

    @Override
    protected void startTransaction0(DaemonManager dm) {
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute("BEGIN TRANSACTION");
        }
        catch (SQLException ex) {
            Logger.getLogger(MSSQLServerDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void stopTransaction0(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute(rollback ? "ROLLBACK" : "COMMIT");
        }
        catch (SQLException ex) {
            Logger.getLogger(MSSQLServerDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private InputStream getKeyHash(String key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(key.getBytes());
            return StreamUtils.GetInputStream(digest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
    }

    @Override
    protected boolean set0(DaemonManager dm, String[] key, String value) throws ReadOnlyException, DataSourceException, IOException {
        try {
            this.connect();
            if (value == null) {
                this.clearKey0(dm, key);
            } else {
                try (PreparedStatement statement = this.getConnection().prepareStatement("EXEC [dbo].[" + this.table + "_upsert] @keyHash = ?, @key = ?, @value = ?");){
                    String joinedKey = StringUtils.Join(key, ".");
                    statement.setBinaryStream(1, this.getKeyHash(joinedKey));
                    statement.setString(2, joinedKey);
                    statement.setString(3, value);
                    statement.executeUpdate();
                }
            }
            this.updateLastConnected();
            return true;
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    protected Map<String[], String> getValues0(String[] leadKey) throws DataSourceException {
        try {
            HashMap<String[], String> map;
            this.connect();
            try (PreparedStatement statement = this.connection.prepareStatement("SELECT [key], [value] FROM [dbo].[" + this.table + "] WHERE [key] LIKE ?");){
                statement.setString(1, StringUtils.Join(leadKey, ".") + "%");
                map = new HashMap<String[], String>();
                try (ResultSet results = statement.executeQuery();){
                    while (results.next()) {
                        map.put(results.getString(this.getKeyColumn()).split("\\."), results.getString(this.getValueColumn()));
                    }
                }
                this.updateLastConnected();
            }
            return map;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void clearKey0(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        try {
            this.connect();
            try (PreparedStatement statement = this.getConnection().prepareStatement("DELETE FROM [dbo].[" + this.table + "] WHERE [key_hash]=?");){
                String joinedKey = StringUtils.Join(key, ".");
                statement.setBinaryStream(1, this.getKeyHash(joinedKey));
                statement.executeUpdate();
            }
            this.updateLastConnected();
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    protected String get0(String[] key) throws DataSourceException {
        try {
            String ret;
            this.connect();
            try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT TOP(1) [" + this.getValueColumn() + "] FROM [dbo].[" + this.getTable() + "] WHERE [key_hash]=?");){
                String joinedKey = StringUtils.Join(key, ".");
                statement.setBinaryStream(1, this.getKeyHash(joinedKey));
                ret = null;
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        ret = result.getString(this.getValueColumn());
                    }
                }
            }
            this.updateLastConnected();
            return ret;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    @Override
    public String docs() {
        String docs = "MSSQL {mssql://[user[:password]@]host[\\instanceName][:port]/database/table?extraParameters} This type stores data in a MSSQL database. Unlike the file based systems, this is extremely efficient, but requires a database connection already set up to work. This also always allows for simultaneous connections from multiple data sink/sources at once, which is not possible without the potential for corruption in file based data sources, without risking either data corruption, or extremely low efficiency. To set up the database properly, it is required to run several commands, these are run automatically on first run, but you may choose to manually run the following sequence yourself: <%SYNTAX|sql|" + StringUtils.Join(this.getTableCreationQueries("testDatabase", "testTable"), "%>\n\n<%SYNTAX|sql|") + "%>\n\nThe allowed extra parameters in the connection string follows the general values described [https://docs.microsoft.com/en-us/sql/connect/jdbc/setting-the-connection-properties?view=sql-server-ver15 here], but the format follows a standard URI query string syntax, and the protocol is \"mssql\" rather than \"jdbc:sqlserver\". For instance, the following connection string <code>jdbc:sqlserver://localhost\\MSSQLDB;user=username;password=1234;applicationIntent=ReadOnly;applicationName=myApp</code> with a PN connection to a table named \"myTable\" would be written as <code>mssql://user:password@localhost\\myInstance:1433/myDatabase/myTable?applicationIntent=ReadOnly&applicationName=myApp</code>. The host information is not optional in MethodScript. The port, if not specified, defaults to 1433. Additional configuration is needed for Windows Authentication, and for general configuration of SQL Server, but it is the same for general SQL connections using query(). Please see the detailed information under the SQL Server section on the [[SQL]] page for further information.";
        return docs;
    }

    public String[] getTableCreationQueries(String database, String tableName) {
        return new String[]{"USE [" + database + "]\n", "/****** Object:  Table [dbo].[" + tableName + "] ******/\nSET ANSI_NULLS ON\n", "SET QUOTED_IDENTIFIER ON\n", "IF NOT (EXISTS (SELECT * \n                 FROM INFORMATION_SCHEMA.TABLES \n                 WHERE TABLE_SCHEMA = 'dbo' \n                 AND  TABLE_NAME = '" + tableName + "'))\nBEGIN\n\n\tCREATE TABLE [dbo].[" + tableName + "](\n\t\t-- This is the binary hash of the unlimited length key column, so the table may have a primary key.\n\t\t[key_hash] [BINARY](16) NOT NULL,\n\t\t-- The key itself, stored for plaintext readability, and full text searches for getting values.\n\t\t[key] [VARCHAR](MAX) NOT NULL,\n\t\t-- The value itself, which may be null.\n\t\t[value] [NVARCHAR](MAX) NULL,\n\t CONSTRAINT [PK_" + tableName + "] PRIMARY KEY CLUSTERED \n\t(\n\t\t[key_hash] ASC\n\t)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]\n\t) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]\nEND\n", "DROP PROCEDURE IF EXISTS [dbo].[" + tableName + "_upsert]\n", "CREATE PROCEDURE [dbo].[" + tableName + "_upsert] ( @keyHash BINARY(16), @key VARCHAR(MAX), @value NVARCHAR(MAX) )\nAS \n  SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n  BEGIN TRAN\n \n    IF EXISTS ( SELECT * FROM [dbo].[" + tableName + "] WITH (UPDLOCK) WHERE [key_hash] = @keyHash )\n \n      UPDATE [dbo].[" + tableName + "]\n         SET [value] = @value\n       WHERE [key] = @key;\n \n    ELSE \n \n      INSERT [dbo].[" + tableName + "] ( [key_hash], [key], [value] )\n      VALUES (  @keyHash, @key, @value );\n \n  COMMIT"};
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_4;
    }
}

