/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.SmartComment;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.MethodScriptComplete;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Procedure;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Command;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.InvalidEnvironmentException;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientPermissionException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidProcedureException;
import com.laytonsmith.core.exceptions.CRE.CREStackOverflowError;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.LoopBreakException;
import com.laytonsmith.core.exceptions.LoopContinueException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.extensions.Extension;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.ProfilePoint;
import com.laytonsmith.core.profiler.Profiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Script {
    public static boolean debugOutput = false;
    private List<Token> left;
    private List<Token> fullRight;
    private List<Construct> cleft;
    private final List<ParseTree> cright = new ArrayList<ParseTree>();
    private boolean nolog = false;
    private Map<String, Variable> leftVars;
    boolean hasBeenCompiled = false;
    boolean compilerError = false;
    private final long compileTime;
    private String label;
    private Set<Class<? extends Environment.EnvironmentImpl>> envs;
    private FileOptions fileOptions;
    private SmartComment smartComment;
    private static final SimpleVersion GARBAGE_VERSION = new SimpleVersion(0, 0, 0, "version-error");

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Token t : this.left) {
            b.append(t.val()).append(" ");
        }
        b.append("; compiled: ").append(this.hasBeenCompiled).append("; errors? ").append(this.compilerError);
        return b.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public String getSignature() {
        StringBuilder b = new StringBuilder();
        b.append(this.getLabel()).append(":");
        for (Token t : this.left) {
            b.append(t.val()).append(" ");
        }
        return b.toString();
    }

    public String getSignatureWithoutLabel() {
        StringBuilder b = new StringBuilder();
        for (Token t : this.left) {
            b.append(t.val()).append(" ");
        }
        return b.toString();
    }

    public String getCommandName() {
        return this.left.get(0).val().substring(1);
    }

    public SmartComment getSmartComment() {
        if (this.smartComment == null) {
            return new SmartComment("");
        }
        return this.smartComment;
    }

    public Target getTarget() {
        return this.left.get(0).getTarget();
    }

    public Script(List<Token> left, List<Token> right, String label, Set<Class<? extends Environment.EnvironmentImpl>> envs, FileOptions fileOptions, SmartComment smartComment) {
        this.left = left;
        this.fullRight = right;
        this.leftVars = new HashMap<String, Variable>();
        this.label = label;
        this.envs = envs;
        this.compileTime = System.currentTimeMillis();
        this.fileOptions = fileOptions;
        this.smartComment = smartComment;
    }

    private Script() {
        this.compileTime = System.currentTimeMillis();
    }

    public long getCompileTime() {
        return this.compileTime;
    }

    public FileOptions getScriptFileOptions() {
        return this.fileOptions;
    }

    public static Script GenerateScript(ParseTree tree, String label, SmartComment comment) {
        Script s = new Script();
        s.hasBeenCompiled = true;
        s.compilerError = false;
        s.cright.add(tree);
        s.label = label;
        s.smartComment = comment;
        return s;
    }

    public boolean uncompilable() {
        return this.compilerError;
    }

    public void run(List<Variable> vars, Environment myEnv, MethodScriptComplete done) {
        block19: {
            myEnv.getEnv(GlobalEnv.class).SetLabel(this.label);
            myEnv.getEnv(GlobalEnv.class).SetAliasComment(this.smartComment);
            MCCommandSender p2 = myEnv.getEnv(CommandHelperEnvironment.class).GetCommandSender();
            if (!this.hasBeenCompiled || this.compilerError) {
                Target target = Target.UNKNOWN;
                if (this.left.size() >= 1) {
                    try {
                        target = new Target(this.left.get((int)0).lineNum, this.left.get((int)0).file, this.left.get((int)0).column);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                throw ConfigRuntimeException.CreateUncatchableException("Unable to run command, script not yet compiled, or a compiler error occurred for that command. To see the compile error, run /reloadaliases", target);
            }
            this.enforceLabelPermissions(myEnv);
            try {
                for (ParseTree rootNode : this.cright) {
                    if (rootNode == null) continue;
                    for (Mixed tempNode : rootNode.getAllData()) {
                        if (!(tempNode instanceof Variable)) continue;
                        if (this.leftVars == null) {
                            throw ConfigRuntimeException.CreateUncatchableException("$variables may not be used in this context. Only @variables may be.", tempNode.getTarget());
                        }
                        Construct c = Static.resolveDollarVar(this.leftVars.get(((Variable)tempNode).getVariableName()), vars);
                        ((Variable)tempNode).setVal(new CString(c.toString(), tempNode.getTarget()));
                    }
                    myEnv.getEnv(StaticRuntimeEnv.class).getIncludeCache().executeAutoIncludes(myEnv, this);
                    MethodScriptCompiler.execute(rootNode, myEnv, done, this);
                }
            }
            catch (ConfigRuntimeException ex) {
                throw ex;
            }
            catch (CancelCommandException ex) {
            }
            catch (LoopBreakException e) {
                if (p2 != null) {
                    p2.sendMessage("The break() function must be used inside a for() or foreach() loop");
                }
                StreamUtils.GetSystemOut().println("The break() function must be used inside a for() or foreach() loop");
            }
            catch (LoopContinueException e) {
                if (p2 != null) {
                    p2.sendMessage("The continue() function must be used inside a for() or foreach() loop");
                }
                StreamUtils.GetSystemOut().println("The continue() function must be used inside a for() or foreach() loop");
            }
            catch (FunctionReturnException e) {
                if (myEnv.getEnv(GlobalEnv.class).GetEvent() != null) {
                    throw e;
                }
                if (p2 != null) {
                    p2.sendMessage("The return() function must be used inside a procedure.");
                }
                StreamUtils.GetSystemOut().println("The return() function must be used inside a procedure.");
            }
            catch (Throwable t) {
                StreamUtils.GetSystemOut().println("An unexpected exception occurred during the execution of a script.");
                t.printStackTrace();
                if (p2 == null) break block19;
                p2.sendMessage("An unexpected exception occurred during the execution of your script. Please check the console for more information.");
            }
        }
        if (done != null) {
            done.done(null);
        }
    }

    public Mixed seval(ParseTree c, Environment env) {
        Mixed ret = this.eval(c, env);
        while (ret instanceof IVariable) {
            IVariable cur = (IVariable)ret;
            ret = env.getEnv(GlobalEnv.class).GetVarList().get(cur.getVariableName(), cur.getTarget(), env).ival();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Mixed eval(ParseTree c, Environment env) throws CancelCommandException {
        CFunction possibleFunction;
        Construct co;
        GlobalEnv globalEnv = env.getEnv(GlobalEnv.class);
        if (globalEnv.IsInterrupted()) {
            throw new CancelCommandException("", Target.UNKNOWN);
        }
        Mixed m = c.getData();
        if (m instanceof Construct && (co = (Construct)m).getCType() != Construct.ConstructType.FUNCTION) {
            if (co.getCType() == Construct.ConstructType.VARIABLE) {
                return new CString(m.val(), m.getTarget());
            }
            return m;
        }
        try {
            possibleFunction = (CFunction)m;
        }
        catch (ClassCastException e) {
            throw ConfigRuntimeException.CreateUncatchableException("Expected to find CFunction at runtime but found: " + m.val(), m.getTarget());
        }
        StackTraceManager stManager = globalEnv.GetStackTraceManager();
        boolean addedRootStackElement = false;
        try {
            Mixed ret;
            Profiler profiler;
            Mixed mixed;
            Mixed[] args;
            Function f;
            block64: {
                Mixed ret22;
                Profiler profiler2;
                if (stManager.isStackEmpty() && m.getTarget() != Target.UNKNOWN) {
                    stManager.addStackTraceElement(new ConfigRuntimeException.StackTraceElement("<<main code>>", m.getTarget()));
                    addedRootStackElement = true;
                }
                stManager.setCurrentTarget(c.getTarget());
                globalEnv.SetScript(this);
                if (possibleFunction.hasProcedure()) {
                    Mixed ret32;
                    Procedure p2 = globalEnv.GetProcs().get(m.val());
                    if (p2 == null) {
                        throw new CREInvalidProcedureException("Unknown procedure \"" + m.val() + "\"", m.getTarget());
                    }
                    ProfilePoint pp = null;
                    Profiler profiler3 = env.getEnv(StaticRuntimeEnv.class).GetProfiler();
                    if (profiler3.isLoggable(LogLevel.INFO)) {
                        pp = profiler3.start(m.val() + " execution", LogLevel.INFO);
                    }
                    try {
                        if (debugOutput) {
                            this.doDebugOutput(p2.getName(), c.getChildren());
                        }
                        ret32 = p2.cexecute(c.getChildren(), env, m.getTarget());
                    }
                    finally {
                        if (pp != null) {
                            pp.stop();
                        }
                    }
                    Mixed mixed2 = ret32;
                    return mixed2;
                }
                try {
                    f = possibleFunction.getFunction();
                }
                catch (ConfigCompileException e) {
                    throw ConfigRuntimeException.CreateUncatchableException("Unable to find function at runtime: " + m.val(), m.getTarget());
                }
                globalEnv.SetFileOptions(c.getFileOptions());
                args = new Mixed[c.numberOfChildren()];
                if (f.isRestricted() && !Static.hasCHPermission(f.getName(), env)) {
                    throw new CREInsufficientPermissionException("You do not have permission to use the " + f.getName() + " function.", m.getTarget());
                }
                if (debugOutput) {
                    this.doDebugOutput(f.getName(), c.getChildren());
                }
                if (!f.useSpecialExec()) break block64;
                ProfilePoint p3 = null;
                if (f.shouldProfile() && (profiler2 = env.getEnv(StaticRuntimeEnv.class).GetProfiler()).isLoggable(f.profileAt())) {
                    p3 = profiler2.start(f.profileMessageS(c.getChildren()), f.profileAt());
                }
                try {
                    ret22 = f.execs(m.getTarget(), env, this, c.getChildren().toArray(new ParseTree[args.length]));
                }
                finally {
                    if (p3 != null) {
                        p3.stop();
                    }
                }
                Mixed mixed3 = ret22;
                return mixed3;
            }
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.eval(c.getChildAt(i), env);
                while (f.preResolveVariables() && (mixed = args[i]) instanceof IVariable) {
                    IVariable cur = (IVariable)mixed;
                    args[i] = globalEnv.GetVarList().get(cur.getVariableName(), cur.getTarget(), env).ival();
                }
            }
            stManager.setCurrentTarget(c.getTarget());
            ProfilePoint p4 = null;
            if (f.shouldProfile() && (profiler = env.getEnv(StaticRuntimeEnv.class).GetProfiler()).isLoggable(f.profileAt())) {
                p4 = profiler.start(f.profileMessage(args), f.profileAt());
            }
            try {
                ret = f.exec(m.getTarget(), env, args);
            }
            finally {
                if (p4 != null) {
                    p4.stop();
                }
            }
            mixed = ret;
            return mixed;
            catch (ConfigRuntimeException | ProgramFlowManipulationException e) {
                if (e instanceof AbstractCREException) {
                    ((AbstractCREException)e).freezeStackTraceElements(stManager);
                }
                throw e;
            }
            catch (InvalidEnvironmentException e) {
                if (!e.isDataSet()) {
                    e.setData(f.getName());
                }
                throw e;
            }
            catch (StackOverflowError e) {
                throw new CREStackOverflowError(null, c.getTarget(), e);
            }
            catch (Throwable e) {
                String modVersion;
                SimpleVersion version;
                if (e instanceof ThreadDeath) {
                    throw e;
                }
                String brand = Implementation.GetServerType().getBranding();
                try {
                    version = Static.getVersion();
                }
                catch (Throwable ex) {
                    version = GARBAGE_VERSION;
                }
                String culprit = brand;
                block32: for (ExtensionTracker tracker : ExtensionManager.getTrackers().values()) {
                    for (FunctionBase b : tracker.getFunctions()) {
                        Iterator<Extension> iterator2;
                        if (!b.getName().equals(f.getName()) || !(iterator2 = tracker.getExtensions().iterator()).hasNext()) continue;
                        Extension extension = iterator2.next();
                        culprit = extension.getName();
                        break block32;
                    }
                }
                String emsg = TermColors.RED + "Uh oh! You've found an error in " + TermColors.CYAN + culprit + TermColors.RED + ".\nThis happened while running your code, so you may be able to find a workaround," + (!(e instanceof Exception) ? " (though since this is an Error, maybe not)" : "") + " but is ultimately an issue in " + culprit + ".\nThe following code caused the error:\n" + TermColors.WHITE;
                ArrayList<String> args2 = new ArrayList<String>();
                HashMap<String, String> vars = new HashMap<String, String>();
                for (int i = 0; i < args.length; ++i) {
                    Mixed cc = args[i];
                    Mixed mixed4 = c.getChildAt(i).getData();
                    if (mixed4 instanceof IVariable) {
                        IVariable ivar = (IVariable)mixed4;
                        String vval = cc.val();
                        if (cc instanceof CString) {
                            vval = ((CString)cc).getQuote();
                        }
                        vars.put(ivar.getVariableName(), vval);
                        args2.add(ivar.getVariableName());
                        continue;
                    }
                    if (cc == null) {
                        args2.add("java-null");
                        continue;
                    }
                    if (cc instanceof CString) {
                        args2.add(new CString(cc.val(), Target.UNKNOWN).getQuote());
                        continue;
                    }
                    if (cc instanceof CClosure) {
                        args2.add("<closure>");
                        continue;
                    }
                    args2.add(cc.val());
                }
                if (!vars.isEmpty()) {
                    emsg = emsg + StringUtils.Join(vars, " = ", "\n") + "\n";
                }
                emsg = emsg + f.getName() + "(";
                emsg = emsg + StringUtils.Join(args2, ", ");
                emsg = emsg + ")\n";
                emsg = emsg + TermColors.RED + "on or around " + TermColors.YELLOW + String.valueOf(m.getTarget().file()) + TermColors.WHITE + ":" + TermColors.CYAN + m.getTarget().line() + TermColors.RED + ".\n";
                try {
                    modVersion = StaticLayer.GetConvertor().GetServer().getAPIVersion();
                }
                catch (Exception ex) {
                    modVersion = Implementation.GetServerType().name();
                }
                Object extensionData = "";
                for (ExtensionTracker tracker : ExtensionManager.getTrackers().values()) {
                    for (Extension extension : tracker.getExtensions()) {
                        try {
                            extensionData = (String)extensionData + TermColors.CYAN + extension.getName() + TermColors.RED + " (" + TermColors.RESET + String.valueOf(extension.getVersion()) + TermColors.RED + ")\n";
                        }
                        catch (AbstractMethodError ex) {
                            extensionData = (String)extensionData + TermColors.CYAN + "Unknown Extension" + TermColors.RED + "\n";
                        }
                    }
                }
                if (((String)extensionData).isEmpty()) {
                    extensionData = "NONE\n";
                }
                emsg = emsg + "Please report this to the developers, and be sure to include the version numbers:\n" + TermColors.CYAN + "Server" + TermColors.RED + " version: " + TermColors.RESET + modVersion + TermColors.RED + ";\n" + TermColors.CYAN + brand + TermColors.RED + " version: " + TermColors.RESET + String.valueOf(version) + TermColors.RED + ";\nLoaded extensions and versions:\n" + (String)extensionData + "Here's the stacktrace:\n" + TermColors.RESET + Static.GetStacktraceString(e);
                StreamUtils.GetSystemErr().println(emsg);
                throw new CancelCommandException(null, Target.UNKNOWN);
            }
        }
        finally {
            if (addedRootStackElement && stManager.isStackSingle()) {
                stManager.popStackTraceElement();
            }
        }
    }

    private void doDebugOutput(String nodeName, List<ParseTree> children) {
        ArrayList<String> args = new ArrayList<String>();
        for (ParseTree t : children) {
            if (t.isConst()) {
                if (t.getData() instanceof CString) {
                    args.add(new CString(t.getData().val(), Target.UNKNOWN).getQuote());
                    continue;
                }
                args.add(t.getData().val());
                continue;
            }
            if (t.getData() instanceof IVariable) {
                args.add(((IVariable)t.getData()).getVariableName());
                continue;
            }
            if (t.getData() instanceof Variable) {
                args.add(((Variable)t.getData()).getVariableName());
                continue;
            }
            args.add("[[Dynamic Element]]");
        }
        StreamUtils.GetSystemOut().println(TermColors.BG_RED + "[[DEBUG]] " + nodeName + "(" + StringUtils.Join(args, ", ") + ")" + TermColors.RESET);
    }

    public boolean match(String command) {
        String[] cmds = command.split(" ");
        return this.match(cmds);
    }

    public boolean match(String[] args) {
        Variable v;
        Construct construct;
        if (this.cleft == null) {
            return false;
        }
        boolean caseSensitive = Prefs.CaseSensitive();
        for (int j = 0; j < this.cleft.size(); ++j) {
            Construct construct2;
            Variable v2;
            Mixed c = this.cleft.get(j);
            if (args.length <= j) {
                return c instanceof Variable && (v2 = (Variable)c).isOptional();
            }
            if (!(c instanceof Variable)) {
                String arg = args[j];
                if ((!caseSensitive || c.val().equals(arg)) && (caseSensitive || c.val().equalsIgnoreCase(arg))) continue;
                return false;
            }
            if (!((Variable)c).isOptional()) continue;
            return args.length <= this.cleft.size() || (construct2 = this.cleft.get(this.cleft.size() - 1)) instanceof Variable && (v2 = (Variable)construct2).isFinal();
        }
        return args.length == this.cleft.size() || (construct = this.cleft.get(this.cleft.size() - 1)) instanceof Variable && (v = (Variable)construct).isFinal();
    }

    public List<Variable> getVariables(String command) {
        String[] cmds = command.split(" ");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cmds));
        StringBuilder lastVar = new StringBuilder();
        ArrayList<Variable> vars = new ArrayList<Variable>();
        Variable v = null;
        for (int j = 0; j < this.cleft.size(); ++j) {
            try {
                if (Construct.IsCType(this.cleft.get(j), Construct.ConstructType.VARIABLE)) {
                    if (((Variable)this.cleft.get(j)).getVariableName().equals("$")) {
                        for (int k = j; k < args.size(); ++k) {
                            lastVar.append(((String)args.get(k)).trim()).append(" ");
                        }
                        v = new Variable(((Variable)this.cleft.get(j)).getVariableName(), lastVar.toString().trim(), Target.UNKNOWN);
                    } else {
                        v = new Variable(((Variable)this.cleft.get(j)).getVariableName(), (String)args.get(j), Target.UNKNOWN);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                v = new Variable(((Variable)this.cleft.get(j)).getVariableName(), ((Variable)this.cleft.get(j)).getDefault(), Target.UNKNOWN);
            }
            if (v == null) continue;
            vars.add(v);
        }
        return vars;
    }

    public Script compile(Environment env) throws ConfigCompileException, ConfigCompileGroupException {
        try {
            this.verifyLeft();
            this.compileLeft();
            this.compileRight(env);
        }
        catch (ConfigCompileException e) {
            this.compilerError = true;
            throw e;
        }
        this.compilerError = false;
        this.hasBeenCompiled = true;
        return this;
    }

    private boolean verifyLeft() throws ConfigCompileException {
        boolean insideOptVar = false;
        boolean afterNoDefOptVar = false;
        String lastVar = null;
        ArrayList<Token> tempLeft = new ArrayList<Token>();
        for (int i = 0; i < this.left.size(); ++i) {
            Object t = this.left.get(i);
            if (i == 0 && ((Token)t).type == Token.TType.NEWLINE) continue;
            if (((Token)t).type.isSymbol() && this.left.size() - 1 > i && this.left.get((int)(i + 1)).type != Token.TType.WHITESPACE) {
                StringBuilder b = new StringBuilder();
                b.append(((Token)t).value);
                Token m = this.left.get(++i);
                while (m.type.isSymbol() && m.type != Token.TType.WHITESPACE) {
                    b.append(m.value);
                    m = this.left.get(++i);
                }
                if (m.type != Token.TType.WHITESPACE && m.type != Token.TType.LABEL) {
                    b.append(m.value);
                }
                t = new Token(Token.TType.STRING, b.toString(), ((Token)t).target.copy());
                if (m.type == Token.TType.LABEL) {
                    tempLeft.add((Token)t);
                    tempLeft.add(m);
                    continue;
                }
            }
            if (((Token)t).type.isSymbol()) {
                t = new Token(Token.TType.STRING, ((Token)t).value, ((Token)t).target.copy());
            }
            if (((Token)t).type == Token.TType.WHITESPACE) continue;
            tempLeft.add((Token)t);
        }
        boolean hasLabel = false;
        for (Token aTempLeft : tempLeft) {
            if (aTempLeft.type != Token.TType.LABEL) continue;
            hasLabel = true;
            break;
        }
        if (hasLabel) {
            StringBuilder b = new StringBuilder();
            int count = 0;
            while (((Token)tempLeft.get((int)count)).type != Token.TType.LABEL) {
                b.append(((Token)tempLeft.get(count)).val());
                ++count;
            }
            tempLeft.set(0, new Token(Token.TType.STRING, b.toString(), Target.UNKNOWN));
            for (int i = 0; i < count - 1; ++i) {
                tempLeft.remove(1);
            }
        }
        this.left = tempLeft;
        for (int j = 0; j < this.left.size(); ++j) {
            Token afterToken;
            Token t = this.left.get(j);
            Token lastToken = j - 1 >= 0 ? this.left.get(j - 1) : new Token(Token.TType.UNKNOWN, "", t.getTarget().copy());
            Token nextToken = j + 1 < this.left.size() ? this.left.get(j + 1) : new Token(Token.TType.UNKNOWN, "", t.getTarget().copy());
            Token token = afterToken = j + 2 < this.left.size() ? this.left.get(j + 2) : new Token(Token.TType.UNKNOWN, "", t.getTarget().copy());
            if (j == 0 && nextToken.type == Token.TType.LABEL) {
                this.label = t.val();
                --j;
                this.left.remove(0);
                this.left.remove(0);
                continue;
            }
            if (t.type == Token.TType.LABEL) continue;
            if (t.type.equals((Object)Token.TType.FINAL_VAR) && this.left.size() - j >= 5) {
                throw new ConfigCompileException("FINAL_VAR must be the last argument in the alias", t.target);
            }
            if (t.type.equals((Object)Token.TType.VARIABLE) || t.type.equals((Object)Token.TType.FINAL_VAR)) {
                Variable v = new Variable(t.val(), null, t.target);
                lastVar = t.val();
                v.setOptional(lastToken.type.equals((Object)Token.TType.LSQUARE_BRACKET));
                this.leftVars.put(t.val(), v);
                if (v.isOptional()) {
                    afterNoDefOptVar = true;
                } else {
                    v.setDefault("");
                }
            }
            if (!(j != 0 || t.value.startsWith("/") || nextToken.type == Token.TType.LABEL && afterToken.type == Token.TType.COMMAND)) {
                throw new ConfigCompileException("Expected command (/command) at start of alias. Instead, found " + String.valueOf((Object)t.type) + " (" + t.val() + ")", t.target);
            }
            if (lastToken.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                insideOptVar = true;
                if (!t.type.equals((Object)Token.TType.FINAL_VAR) && !t.type.equals((Object)Token.TType.VARIABLE)) {
                    throw new ConfigCompileException("Unexpected " + t.type.toString() + " (" + t.val() + "), was expecting a $variable", t.target);
                }
            }
            if (afterNoDefOptVar && !insideOptVar && (t.type.equals((Object)Token.TType.VARIABLE) || t.type.equals((Object)Token.TType.FINAL_VAR))) {
                throw new ConfigCompileException("You cannot have anything other than optional arguments after your first optional argument.", t.target);
            }
            if (!(t.type.equals((Object)Token.TType.LSQUARE_BRACKET) || t.type.equals((Object)Token.TType.OPT_VAR_ASSIGN) || t.type.equals((Object)Token.TType.RSQUARE_BRACKET) || t.type.equals((Object)Token.TType.VARIABLE) || t.type.equals((Object)Token.TType.LIT) || t.type.equals((Object)Token.TType.COMMAND) || t.type.equals((Object)Token.TType.FINAL_VAR) || j - 1 <= 0 || this.left.get((int)(j - 1)).type.equals((Object)Token.TType.OPT_VAR_ASSIGN))) {
                throw new ConfigCompileException("Unexpected " + String.valueOf((Object)t.type) + " (" + t.val() + ")", t.target);
            }
            if (!(!lastToken.type.equals((Object)Token.TType.COMMAND) || t.type.equals((Object)Token.TType.VARIABLE) || t.type.equals((Object)Token.TType.LSQUARE_BRACKET) || t.type.equals((Object)Token.TType.FINAL_VAR) || t.type.equals((Object)Token.TType.LIT) || t.type.equals((Object)Token.TType.STRING))) {
                throw new ConfigCompileException("Unexpected " + String.valueOf((Object)t.type) + " (" + t.val() + ") after command", t.target);
            }
            if (insideOptVar && t.type.equals((Object)Token.TType.OPT_VAR_ASSIGN)) {
                if (!(nextToken.type.isAtomicLit() && afterToken.type.equals((Object)Token.TType.RSQUARE_BRACKET) || nextToken.type.equals((Object)Token.TType.RSQUARE_BRACKET))) {
                    throw new ConfigCompileException("Unexpected token in optional variable", t.target);
                }
                if (nextToken.type.isAtomicLit()) {
                    this.leftVars.get(lastVar).setDefault(nextToken.val());
                }
            }
            if (!t.type.equals((Object)Token.TType.RSQUARE_BRACKET)) continue;
            if (!insideOptVar) {
                throw new ConfigCompileException("Unexpected " + t.type.toString(), t.target);
            }
            insideOptVar = false;
        }
        return true;
    }

    private boolean compileLeft() {
        this.cleft = new ArrayList<Construct>();
        if (this.label != null && this.label.startsWith("!")) {
            if (this.label.length() > 1) {
                this.label = this.label.substring(1);
            }
            this.nolog = true;
        }
        for (int i = 0; i < this.left.size(); ++i) {
            Variable v;
            Token t = this.left.get(i);
            if (t.value.startsWith("/")) {
                this.cleft.add(new Command(t.val(), t.target));
                continue;
            }
            if (t.type == Token.TType.VARIABLE) {
                this.cleft.add(new Variable(t.val(), null, t.target));
                continue;
            }
            if (t.type.equals((Object)Token.TType.FINAL_VAR)) {
                v = new Variable(t.val(), null, t.target);
                v.setFinal(true);
                this.cleft.add(v);
                continue;
            }
            if (t.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                if (i + 2 < this.left.size() && this.left.get((int)(i + 2)).type.equals((Object)Token.TType.OPT_VAR_ASSIGN)) {
                    v = new Variable(this.left.get(i + 1).val(), this.left.get(i + 3).val(), t.target);
                    v.setOptional(true);
                    if (this.left.get((int)(i + 1)).type.equals((Object)Token.TType.FINAL_VAR)) {
                        v.setFinal(true);
                    }
                    this.cleft.add(v);
                    i += 4;
                    continue;
                }
                t = this.left.get(i + 1);
                v = new Variable(t.val(), null, t.target);
                v.setOptional(true);
                if (t.val().equals("$")) {
                    v.setFinal(true);
                }
                this.cleft.add(v);
                i += 2;
                continue;
            }
            this.cleft.add(new CString(t.val(), t.getTarget()));
        }
        return true;
    }

    public List<Construct> getParameters() {
        return new ArrayList<Construct>(this.cleft);
    }

    public void compileRight(Environment env) throws ConfigCompileException, ConfigCompileGroupException {
        ArrayList<Token> temp = new ArrayList<Token>();
        ArrayList<ArrayList<Token>> right = new ArrayList<ArrayList<Token>>();
        for (Token token : this.fullRight) {
            if (token.type == Token.TType.SEPERATOR) {
                right.add(temp);
                temp = new ArrayList();
                continue;
            }
            if (token.type == Token.TType.WHITESPACE) continue;
            temp.add(token);
        }
        right.add(temp);
        for (List list : right) {
            StaticAnalysis analysis = new StaticAnalysis(true);
            this.cright.add(MethodScriptCompiler.compile(new TokenStream(list, this.fileOptions), env, this.envs, analysis));
        }
    }

    public List<ParseTree> getTrees() {
        return new ArrayList<ParseTree>(this.cright);
    }

    public void checkAmbiguous(List<Script> scripts) throws ConfigCompileException {
        List<Construct> thisCommand = this.cleft;
        block0: for (Script script : scripts) {
            Construct c2;
            if (script.fileOptions.hasCompilerOption(FileOptions.CompilerOption.AllowAmbiguousCommands)) continue;
            List<Construct> thatCommand = script.cleft;
            if (thatCommand == null) {
                return;
            }
            if (this.cleft == script.cleft) continue;
            for (int k = 0; k < thisCommand.size(); ++k) {
                Construct c1 = thisCommand.get(k);
                if (k < thatCommand.size()) {
                    Construct c22 = thatCommand.get(k);
                    if (c1.getCType() != c22.getCType() || c1.getCType() != Construct.ConstructType.STRING && c1.getCType() != Construct.ConstructType.COMMAND || Construct.nval(c1) == Construct.nval(c22) || Construct.nval(c1) != null && Construct.nval(c1).equals(Construct.nval(c22))) continue;
                    continue block0;
                }
                if (c1 instanceof Variable && (!(c1 instanceof Variable) || ((Variable)c1).isOptional())) break;
                continue block0;
            }
            if (thatCommand.size() > thisCommand.size() && (!((c2 = thatCommand.get(thisCommand.size())) instanceof Variable) || c2 instanceof Variable && !((Variable)c2).isOptional())) continue;
            Object commandThis = "";
            for (Construct c : thisCommand) {
                commandThis = (String)commandThis + c.val() + " ";
            }
            Object commandThat = "";
            for (Construct c : thatCommand) {
                commandThat = (String)commandThat + c.val() + " ";
            }
            script.compilerError = true;
            this.compilerError = true;
            throw new ConfigCompileException("The command " + ((String)commandThis).trim() + " is ambiguous because it matches the signature of " + ((String)commandThat).trim() + " defined at " + String.valueOf(thatCommand.get(0).getTarget()), thisCommand.get(0).getTarget());
        }
    }

    public void enforceLabelPermissions(Environment currentEnv) {
        String label = currentEnv.getEnv(GlobalEnv.class).GetLabel();
        if (label == null || label.equals("*")) {
            return;
        }
        MCPlayer p2 = currentEnv.getEnv(CommandHelperEnvironment.class).GetPlayer();
        if (p2 == null) {
            currentEnv.getEnv(GlobalEnv.class).SetLabel("*");
        } else if (label.startsWith("~")) {
            String[] groups2;
            for (String group : groups2 = label.substring(1).split("/")) {
                if (group.startsWith("-") && p2.inGroup(group.substring(1))) {
                    throw new CREInsufficientPermissionException("You do not have permission to use that script.", Target.UNKNOWN);
                }
                if (!p2.inGroup(group)) continue;
                currentEnv.getEnv(GlobalEnv.class).SetLabel("*");
                return;
            }
        } else if (label.indexOf(46) != -1) {
            if (p2.hasPermission(label)) {
                currentEnv.getEnv(GlobalEnv.class).SetLabel("*");
            }
        } else if (p2.hasPermission("ch.alias." + label) || p2.hasPermission("commandhelper.alias." + label)) {
            currentEnv.getEnv(GlobalEnv.class).SetLabel("*");
        }
    }

    public boolean doLog() {
        return !this.nolog;
    }
}

