/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.perf4j.slf4j;

import com.laytonsmith.libs.org.perf4j.LoggingStopWatch;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JStopWatch
extends LoggingStopWatch {
    public static final int TRACE_LEVEL = 5000;
    public static final int DEBUG_LEVEL = 10000;
    public static final int INFO_LEVEL = 20000;
    public static final int WARN_LEVEL = 30000;
    public static final int ERROR_LEVEL = 40000;
    private transient Logger logger;
    private int normalPriority;
    private int exceptionPriority;

    public Slf4JStopWatch() {
        this("", null, LoggerFactory.getLogger((String)"com.laytonsmith.libs.org.perf4j.TimingLogger"), 20000, 30000);
    }

    public Slf4JStopWatch(Logger logger) {
        this("", null, logger, 20000, 30000);
    }

    public Slf4JStopWatch(Logger logger, int normalPriority) {
        this("", null, logger, normalPriority, 30000);
    }

    public Slf4JStopWatch(Logger logger, int normalPriority, int exceptionPriority) {
        this("", null, logger, normalPriority, exceptionPriority);
    }

    public Slf4JStopWatch(String tag) {
        this(tag, null, LoggerFactory.getLogger((String)"com.laytonsmith.libs.org.perf4j.TimingLogger"), 20000, 30000);
    }

    public Slf4JStopWatch(String tag, Logger logger) {
        this(tag, null, logger, 20000, 30000);
    }

    public Slf4JStopWatch(String tag, Logger logger, int normalPriority) {
        this(tag, null, logger, normalPriority, 30000);
    }

    public Slf4JStopWatch(String tag, Logger logger, int normalPriority, int exceptionPriority) {
        this(tag, null, logger, normalPriority, exceptionPriority);
    }

    public Slf4JStopWatch(String tag, String message) {
        this(tag, message, LoggerFactory.getLogger((String)"com.laytonsmith.libs.org.perf4j.TimingLogger"), 20000, 30000);
    }

    public Slf4JStopWatch(String tag, String message, Logger logger) {
        this(tag, message, logger, 20000, 30000);
    }

    public Slf4JStopWatch(String tag, String message, Logger logger, int normalPriority) {
        this(tag, message, logger, normalPriority, 30000);
    }

    public Slf4JStopWatch(String tag, String message, Logger logger, int normalPriority, int exceptionPriority) {
        this(System.currentTimeMillis(), -1L, tag, message, logger, normalPriority, exceptionPriority);
    }

    public Slf4JStopWatch(long startTime, long elapsedTime, String tag, String message, Logger logger, int normalPriority, int exceptionPriority) {
        super(startTime, elapsedTime, tag, message);
        this.logger = logger;
        this.normalPriority = normalPriority;
        this.exceptionPriority = exceptionPriority;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Slf4JStopWatch setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public int getNormalPriority() {
        return this.normalPriority;
    }

    public Slf4JStopWatch setNormalPriority(int normalPriority) {
        this.normalPriority = normalPriority;
        return this;
    }

    public int getExceptionPriority() {
        return this.exceptionPriority;
    }

    public Slf4JStopWatch setExceptionPriority(int exceptionPriority) {
        this.exceptionPriority = exceptionPriority;
        return this;
    }

    public Slf4JStopWatch setTimeThreshold(long timeThreshold) {
        super.setTimeThreshold(timeThreshold);
        return this;
    }

    public Slf4JStopWatch setTag(String tag) {
        super.setTag(tag);
        return this;
    }

    public Slf4JStopWatch setMessage(String message) {
        super.setMessage(message);
        return this;
    }

    public Slf4JStopWatch setNormalAndSlowSuffixesEnabled(boolean normalAndSlowSuffixesEnabled) {
        super.setNormalAndSlowSuffixesEnabled(normalAndSlowSuffixesEnabled);
        return this;
    }

    public Slf4JStopWatch setNormalSuffix(String normalSuffix) {
        super.setNormalSuffix(normalSuffix);
        return this;
    }

    public Slf4JStopWatch setSlowSuffix(String slowSuffix) {
        super.setSlowSuffix(slowSuffix);
        return this;
    }

    public boolean isLogging() {
        return this.isLogging(this.normalPriority);
    }

    protected void log(String stopWatchAsString, Throwable exception) {
        this.log(stopWatchAsString, exception, exception == null ? this.normalPriority : this.exceptionPriority);
    }

    protected boolean isLogging(int atLevel) {
        switch (atLevel) {
            case 5000: {
                return this.logger.isTraceEnabled();
            }
            case 10000: {
                return this.logger.isDebugEnabled();
            }
            case 20000: {
                return this.logger.isInfoEnabled();
            }
            case 30000: {
                return this.logger.isWarnEnabled();
            }
            case 40000: {
                return this.logger.isErrorEnabled();
            }
        }
        return this.isLogging(this.closestKnownLevel(atLevel));
    }

    protected void log(String stopWatchAsString, Throwable exception, int atLevel) {
        switch (atLevel) {
            case 5000: {
                this.logger.trace(stopWatchAsString, exception);
                break;
            }
            case 10000: {
                this.logger.debug(stopWatchAsString, exception);
                break;
            }
            case 20000: {
                this.logger.info(stopWatchAsString, exception);
                break;
            }
            case 30000: {
                this.logger.warn(stopWatchAsString, exception);
                break;
            }
            case 40000: {
                this.logger.error(stopWatchAsString, exception);
                break;
            }
            default: {
                this.log(stopWatchAsString, exception, this.closestKnownLevel(atLevel));
            }
        }
    }

    private int closestKnownLevel(int level) {
        if (level <= 5000) {
            return 5000;
        }
        if (level <= 10000) {
            return 10000;
        }
        if (level <= 20000) {
            return 20000;
        }
        if (level <= 30000) {
            return 30000;
        }
        return 40000;
    }

    public static int mapLevelName(String levelName) {
        if ("TRACE".equals(levelName = levelName.toUpperCase())) {
            return 5000;
        }
        if ("DEBUG".equals(levelName)) {
            return 10000;
        }
        if ("INFO".equals(levelName)) {
            return 20000;
        }
        if ("WARN".equals(levelName)) {
            return 30000;
        }
        if ("ERROR".equals(levelName)) {
            return 40000;
        }
        if ("FATAL".equals(levelName)) {
            return 40000;
        }
        return 20000;
    }

    public Slf4JStopWatch clone() {
        return (Slf4JStopWatch)super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeUTF(this.logger.getName());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.logger = LoggerFactory.getLogger((String)stream.readUTF());
    }
}

