/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.largeobject;

import com.laytonsmith.libs.org.postgresql.core.BaseConnection;
import com.laytonsmith.libs.org.postgresql.fastpath.Fastpath;
import com.laytonsmith.libs.org.postgresql.fastpath.FastpathArg;
import com.laytonsmith.libs.org.postgresql.largeobject.LargeObject;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LargeObjectManager {
    private Fastpath fp;
    private BaseConnection conn;
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int READWRITE = 393216;

    private LargeObjectManager() {
    }

    public LargeObjectManager(BaseConnection conn) throws SQLException {
        ResultSet res;
        this.conn = conn;
        this.fp = conn.getFastpathAPI();
        String sql = conn.getMetaData().supportsSchemasInTableDefinitions() ? "SELECT p.proname,p.oid  FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n  WHERE p.pronamespace=n.oid AND n.nspname='pg_catalog' AND (" : "SELECT proname,oid FROM pg_proc WHERE ";
        sql = sql + " proname = 'lo_open' or proname = 'lo_close' or proname = 'lo_creat' or proname = 'lo_unlink' or proname = 'lo_lseek' or proname = 'lo_tell' or proname = 'loread' or proname = 'lowrite' or proname = 'lo_truncate'";
        if (conn.getMetaData().supportsSchemasInTableDefinitions()) {
            sql = sql + ")";
        }
        if ((res = conn.createStatement().executeQuery(sql)) == null) {
            throw new PSQLException(GT.tr("Failed to initialize LargeObject API"), PSQLState.SYSTEM_ERROR);
        }
        this.fp.addFunctions(res);
        res.close();
        conn.getLogger().debug("Large Object initialised");
    }

    public LargeObject open(int oid) throws SQLException {
        return this.open((long)oid);
    }

    public LargeObject open(long oid) throws SQLException {
        return this.open(oid, 393216);
    }

    public LargeObject open(int oid, int mode2) throws SQLException {
        return this.open((long)oid, mode2);
    }

    public LargeObject open(long oid, int mode2) throws SQLException {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return new LargeObject(this.fp, oid, mode2);
    }

    public int create() throws SQLException {
        return this.create(393216);
    }

    public long createLO() throws SQLException {
        return this.createLO(393216);
    }

    public long createLO(int mode2) throws SQLException {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(mode2)};
        return this.fp.getOID("lo_creat", args2);
    }

    public int create(int mode2) throws SQLException {
        long oid = this.createLO(mode2);
        return (int)oid;
    }

    public void delete(long oid) throws SQLException {
        FastpathArg[] args2 = new FastpathArg[]{Fastpath.createOIDArg(oid)};
        this.fp.fastpath("lo_unlink", false, args2);
    }

    public void unlink(int oid) throws SQLException {
        this.delete((long)oid);
    }

    public void unlink(long oid) throws SQLException {
        this.delete(oid);
    }

    public void delete(int oid) throws SQLException {
        this.delete((long)oid);
    }
}

