/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREStackOverflowError;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.LoopManipulationException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.natives.interfaces.Booleanish;
import com.laytonsmith.core.natives.interfaces.Callable;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@typeof(value="ms.lang.closure")
public class CClosure
extends Construct
implements Callable,
Booleanish {
    public static final long serialVersionUID = 1L;
    protected ParseTree node;
    protected final Environment env;
    protected final String[] names;
    protected final Mixed[] defaults;
    protected final CClassType[] types;
    protected final CClassType returnType;
    public static final CClassType TYPE = CClassType.get(CClosure.class);

    public CClosure(ParseTree node, Environment env, CClassType returnType, String[] names, Mixed[] defaults, CClassType[] types, Target t) {
        super(node != null ? node.toString() : "", Construct.ConstructType.CLOSURE, t);
        this.node = node;
        this.env = env;
        this.names = names;
        this.defaults = defaults;
        this.types = types;
        if (types.length > 0) {
            for (int i = 0; i < types.length - 1; ++i) {
                if (!types[i].isVarargs()) continue;
                throw new CREFormatException("Varargs can only be added to the last argument.", t);
            }
        }
        this.returnType = returnType;
        for (String pName : names) {
            if (!pName.equals("@arguments")) continue;
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(node.getFileOptions(), new CompilerWarning("This closure overrides the builtin @arguments parameter", t, FileOptions.SuppressWarning.OverrideArguments));
            break;
        }
    }

    @Override
    public String val() {
        StringBuilder b = new StringBuilder();
        this.condense(this.getNode(), b);
        return b.toString();
    }

    private void condense(ParseTree node, StringBuilder b) {
        if (node == null) {
            return;
        }
        if (node.getData() instanceof CFunction) {
            CFunction func = (CFunction)node.getData();
            if (CFunction.IsFunction(func, Compiler.centry.class)) {
                b.append(node.getChildAt(0));
                this.condense(node.getChildAt(1), b);
            } else {
                b.append(func.val()).append("(");
                for (int i = 0; i < node.numberOfChildren(); ++i) {
                    this.condense(node.getChildAt(i), b);
                    if (i == node.numberOfChildren() - 1 || ((CFunction)node.getData()).val().equals("__autoconcat__")) continue;
                    b.append(",");
                }
                b.append(")");
            }
        } else if (node.getData().isInstanceOf(CString.TYPE)) {
            String data = ArgumentValidation.getString(node.getData(), node.getTarget());
            b.append("'").append(data.replace("\\", "\\\\").replaceAll("\t", "\\\\t").replaceAll("\n", "\\\\n").replace("'", "\\'")).append("'");
        } else if (node.getData() instanceof IVariable) {
            b.append(((IVariable)node.getData()).getVariableName());
        } else {
            b.append(node.getData().val());
        }
    }

    public ParseTree getNode() {
        return this.node;
    }

    @Override
    public CClosure clone() throws CloneNotSupportedException {
        CClosure clone = (CClosure)super.clone();
        if (this.node != null) {
            clone.node = this.node.clone();
        }
        return clone;
    }

    @Override
    public synchronized Environment getEnv() {
        return this.env;
    }

    public Mixed executeCallable(Mixed ... values2) {
        return this.executeCallable(null, Target.UNKNOWN, values2);
    }

    @Override
    public Mixed executeCallable(Environment env, Target t, Mixed ... values2) throws ConfigRuntimeException, ProgramFlowManipulationException, CancelCommandException {
        try {
            this.execute(values2);
        }
        catch (FunctionReturnException e) {
            return e.getReturn();
        }
        return CVoid.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Mixed ... values2) throws ConfigRuntimeException, ProgramFlowManipulationException, FunctionReturnException, CancelCommandException {
        Environment environment;
        if (this.node == null) {
            return;
        }
        try {
            CClosure cClosure = this;
            synchronized (cClosure) {
                environment = this.env.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CClosure.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        StackTraceManager stManager = environment.getEnv(GlobalEnv.class).GetStackTraceManager();
        stManager.addStackTraceElement(new ConfigRuntimeException.StackTraceElement("<<closure>>", this.getTarget()));
        try {
            CArray arguments = new CArray(this.node.getData().getTarget());
            CArray vararg = null;
            CClassType varargType = null;
            if (values2 != null) {
                for (int i = 0; i < Math.max(values2.length, this.names.length); ++i) {
                    String name;
                    Mixed value = i < values2.length ? values2[i] : this.defaults[i].clone();
                    arguments.push(value, this.node.getData().getTarget());
                    int isVarArg = 0;
                    if (this.names.length <= i && (this.names.length == 0 || !this.types[this.names.length - 1].isVarargs())) continue;
                    if (i < this.names.length - 1 || !this.types[this.types.length - 1].isVarargs()) {
                        name = this.names[i];
                    } else {
                        name = this.names[this.names.length - 1];
                        if (vararg == null) {
                            vararg = new CArray(value.getTarget());
                            environment.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, name, vararg, value.getTarget()));
                            varargType = this.types[this.types.length - 1];
                        }
                        isVarArg = 1;
                    }
                    if (isVarArg != 0) {
                        if (!InstanceofUtil.isInstanceof(value, varargType, this.env)) {
                            throw new CRECastException("Expected type " + String.valueOf(varargType) + " but found " + String.valueOf(value.typeof()), this.getTarget());
                        }
                        vararg.push(value, value.getTarget());
                        continue;
                    }
                    IVariable var = new IVariable(this.types[i], name, value, this.getTarget(), environment);
                    environment.getEnv(GlobalEnv.class).GetVarList().set(var);
                }
            }
            boolean hasArgumentsParam = false;
            for (String pName : this.names) {
                if (!pName.equals("@arguments")) continue;
                hasArgumentsParam = true;
                break;
            }
            if (!hasArgumentsParam) {
                environment.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, "@arguments", arguments, this.node.getData().getTarget()));
            }
            ParseTree newNode = new ParseTree(new CFunction("g", this.getTarget()), this.node.getFileOptions());
            ArrayList<ParseTree> children = new ArrayList<ParseTree>();
            children.add(this.node);
            newNode.setChildren(children);
            try {
                MethodScriptCompiler.execute(newNode, environment, null, environment.getEnv(GlobalEnv.class).GetScript());
            }
            catch (LoopManipulationException e) {
                LoopManipulationException lme = e;
                Target t = lme.getTarget();
                ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("A " + lme.getName() + "() bubbled up to the top of a closure, which is unexpected behavior.", t), environment);
            }
            catch (FunctionReturnException ex) {
                Mixed ret = ex.getReturn();
                if (!InstanceofUtil.isInstanceof(ret, this.returnType, environment)) {
                    throw new CRECastException("Expected closure to return a value of type " + this.returnType.val() + " but a value of type " + String.valueOf(ret.typeof()) + " was returned instead", ret.getTarget());
                }
                throw ex;
            }
            catch (CancelCommandException ex) {
            }
            catch (ConfigRuntimeException ex) {
                if (ex instanceof AbstractCREException) {
                    ((AbstractCREException)ex).freezeStackTraceElements(stManager);
                }
                throw ex;
            }
            catch (StackOverflowError e) {
                throw new CREStackOverflowError(null, this.node.getTarget(), e);
            }
            finally {
                stManager.popStackTraceElement();
            }
            if (!this.returnType.equals(Auto.TYPE) && !this.returnType.equals(CVoid.TYPE)) {
                throw new CRECastException("Expecting closure to return a value of type " + this.returnType.val() + ", but no value was returned.", this.node.getTarget());
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CClosure.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String docs() {
        return "A closure is a data type that contains executable code. This is similar to a procedure, but the value is first class, and can be stored in variables, and executed.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Callable.TYPE, Booleanish.TYPE};
    }

    @Override
    public boolean getBooleanValue(Target t) {
        return true;
    }
}

