/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.params;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.Protocol;
import com.laytonsmith.libs.redis.clients.jedis.args.ClientType;
import com.laytonsmith.libs.redis.clients.jedis.params.IParams;
import com.laytonsmith.libs.redis.clients.jedis.util.KeyValue;
import java.util.ArrayList;
import java.util.function.Consumer;

public class ClientKillParams
implements IParams {
    private final ArrayList<KeyValue<Protocol.Keyword, Object>> params = new ArrayList();

    public static ClientKillParams clientKillParams() {
        return new ClientKillParams();
    }

    private ClientKillParams addParam(Protocol.Keyword key, Object value) {
        this.params.add(KeyValue.of(key, value));
        return this;
    }

    public ClientKillParams id(String clientId) {
        return this.addParam(Protocol.Keyword.ID, clientId);
    }

    public ClientKillParams id(byte[] clientId) {
        return this.addParam(Protocol.Keyword.ID, clientId);
    }

    public ClientKillParams type(ClientType type) {
        return this.addParam(Protocol.Keyword.TYPE, type);
    }

    public ClientKillParams addr(String ipPort) {
        return this.addParam(Protocol.Keyword.ADDR, ipPort);
    }

    public ClientKillParams addr(byte[] ipPort) {
        return this.addParam(Protocol.Keyword.ADDR, ipPort);
    }

    public ClientKillParams addr(String ip, int port) {
        return this.addParam(Protocol.Keyword.ADDR, ip + ':' + port);
    }

    public ClientKillParams skipMe(SkipMe skipMe) {
        return this.addParam(Protocol.Keyword.SKIPME, (Object)skipMe);
    }

    public ClientKillParams user(String username) {
        return this.addParam(Protocol.Keyword.USER, username);
    }

    public ClientKillParams laddr(String ipPort) {
        return this.addParam(Protocol.Keyword.LADDR, ipPort);
    }

    public ClientKillParams laddr(String ip, int port) {
        return this.addParam(Protocol.Keyword.LADDR, ip + ':' + port);
    }

    public ClientKillParams maxAge(long maxAge) {
        return this.addParam(Protocol.Keyword.MAXAGE, maxAge);
    }

    @Override
    public void addParams(CommandArguments args2) {
        this.params.forEach((Consumer<KeyValue<Protocol.Keyword, Object>>)((Consumer<KeyValue>)kv -> args2.add(kv.getKey()).add(kv.getValue())));
    }

    public static enum SkipMe {
        YES,
        NO;

    }
}

