/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.msserialconnection;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.pieter12345.msserialconnection.SerialDataReceivedEvent;
import java.util.Map;
import java.util.TreeMap;

public class SerialConnectionEvents {
    public static String docs() {
        return "Contains events related to serial connections.";
    }

    @api
    public static class serial_data_received
    extends AbstractEvent {
        public String getName() {
            return "serial_data_received";
        }

        public String docs() {
            return "{} Fired when data is received through a serial connection. {string serialport: The serial port name | byte_array data: The raw received data} {}";
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            TreeMap<String, Mixed> map = new TreeMap<String, Mixed>();
            if (!(event instanceof SerialDataReceivedEvent)) {
                throw new EventException("Cannot convert event to " + SerialDataReceivedEvent.class.getSimpleName() + ".");
            }
            SerialDataReceivedEvent serialDataReceivedEvent = (SerialDataReceivedEvent)event;
            map.put("serialport", (Mixed)new CString(serialDataReceivedEvent.getSerialPort().getPortName(), null));
            map.put("data", (Mixed)CByteArray.wrap((byte[])serialDataReceivedEvent.getData(), null));
            return map;
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            return true;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }
}

