/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.msserialconnection;

import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractGenericEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.pieter12345.msserialconnection.SerialDataAvailableEvent;
import io.github.pieter12345.msserialconnection.SerialOutputBufferEmptyEvent;
import java.util.Map;
import java.util.TreeMap;

public class SerialConnectionEvents {
    public static String docs() {
        return "Contains events related to serial connections.";
    }

    @api
    public static class serial_output_buffer_empty
    extends AbstractGenericEvent<SerialOutputBufferEmptyEvent> {
        public String getName() {
            return "serial_output_buffer_empty";
        }

        public String docs() {
            return "{} Fired when the output buffer of a serial connection has become empty (i.e. all writing operations have finished). {string serialport: The serial port name} {}";
        }

        public SerialOutputBufferEmptyEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public Map<String, Mixed> evaluate(SerialOutputBufferEmptyEvent event) throws EventException {
            TreeMap<String, Mixed> map = new TreeMap<String, Mixed>();
            map.put("serialport", (Mixed)new CString(event.getSerialPort().getPortName(), null));
            return map;
        }

        public boolean matches(Map<String, Mixed> prefilter, SerialOutputBufferEmptyEvent event) throws PrefilterNonMatchException {
            return true;
        }

        public boolean modifyEvent(String key, Mixed value, SerialOutputBufferEmptyEvent event) {
            return false;
        }

        public Version since() {
            return new SimpleVersion(2, 0, 0);
        }
    }

    @api
    public static class serial_data_available
    extends AbstractGenericEvent<SerialDataAvailableEvent> {
        public String getName() {
            return "serial_data_available";
        }

        public String docs() {
            return "{} Fired when data is received through a serial connection. {string serialport: The serial port name | int rxBufferByteCount: The number of bytes available for reading} {}";
        }

        public SerialDataAvailableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public Map<String, Mixed> evaluate(SerialDataAvailableEvent event) throws EventException {
            TreeMap<String, Mixed> map = new TreeMap<String, Mixed>();
            map.put("serialport", (Mixed)new CString(event.getSerialPort().getPortName(), null));
            map.put("rxBufferByteCount", (Mixed)new CInt((long)event.getRXBufferByteCount(), null));
            return map;
        }

        public boolean matches(Map<String, Mixed> prefilter, SerialDataAvailableEvent event) throws PrefilterNonMatchException {
            return true;
        }

        public boolean modifyEvent(String key, Mixed value, SerialDataAvailableEvent event) {
            return false;
        }

        public Version since() {
            return new SimpleVersion(1, 0, 0);
        }
    }
}

