/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.skcompat;

import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Locatable;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import com.sk89q.worldedit.function.pattern.TypeApplyingPattern;
import com.sk89q.worldedit.world.block.BlockTypes;

public class SKPattern {
    Pattern pattern;

    public Pattern getHandle() {
        return this.pattern;
    }

    public void generateBlockPattern(CString source, Actor user, Target t) {
        ParserContext context = new ParserContext();
        context.setActor(user);
        try {
            this.pattern = (Pattern)WorldEdit.getInstance().getPatternFactory().parseFromInput(source.val(), context);
        }
        catch (InputParseException ex) {
            throw new CREFormatException(ex.getMessage(), t);
        }
    }

    public void generateBlockPattern(CArray source, Actor user, Target t) {
        if (source.isAssociative()) {
            throw new CREFormatException("Expected a normal array", t);
        }
        if (source.size() == 0L) {
            this.pattern = new TypeApplyingPattern(((Locatable)user).getExtent(), BlockTypes.AIR.getDefaultState());
            return;
        }
        this.pattern = new RandomPattern();
        for (Mixed entry : source.asList()) {
            ParserContext context = new ParserContext();
            context.setActor(user);
            CArray src = ArgumentValidation.getArray((Mixed)entry, (Target)t);
            if (!src.containsKey("block")) {
                throw new CREFormatException("Block name required", t);
            }
            double weight = 1.0;
            if (src.containsKey("weight")) {
                weight = ArgumentValidation.getDouble((Mixed)src.get("weight", t), (Target)t);
            }
            try {
                Pattern p = (Pattern)WorldEdit.getInstance().getBlockFactory().parseFromInput(src.get("block", t).val(), context);
                ((RandomPattern)this.pattern).add(p, weight);
            }
            catch (InputParseException ex) {
                throw new CREFormatException(ex.getMessage(), t);
            }
        }
    }
}

