/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.skcompat;

import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.github.jbaero.skcompat.SKRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SKWorldGuard {
    public static RegionManager GetRegionManager(MCWorld world, Target t) {
        RegionManager mgr = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)((World)world.getHandle())));
        if (mgr == null) {
            throw new CREPluginInternalException("Could not find region manager for world: " + world.getName(), t);
        }
        return mgr;
    }

    public static SKRegion GetRegion(MCWorld w, String regionName, Target t) {
        World world = (World)w.getHandle();
        RegionManager mgr = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        if (mgr == null) {
            throw new CREPluginInternalException("Could not find region manager for world: " + w.getName(), t);
        }
        ProtectedRegion region = mgr.getRegion(regionName);
        if (region == null) {
            throw new CREPluginInternalException("Region could not be found!", t);
        }
        return new SKRegion(world, region);
    }

    public static Collection<String> RegionsAt(MCWorld world, int x, int y, int z) {
        RegionManager mgr = SKWorldGuard.GetRegionManager(world, Target.UNKNOWN);
        BlockVector3 pt = BlockVector3.at((int)x, (int)y, (int)z);
        ApplicableRegionSet set = mgr.getApplicableRegions(pt);
        ArrayList<ProtectedRegion> sortedRegions = new ArrayList<ProtectedRegion>();
        for (ProtectedRegion r : set) {
            boolean placed = false;
            for (int i = 0; i < sortedRegions.size(); ++i) {
                if (((ProtectedRegion)sortedRegions.get(i)).volume() >= r.volume()) continue;
                sortedRegions.add(i, r);
                placed = true;
                break;
            }
            if (placed) continue;
            sortedRegions.add(r);
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (ProtectedRegion r : sortedRegions) {
            ret.add(r.getId());
        }
        return ret;
    }

    public static boolean TestState(ApplicableRegionSet set, MCPlayer p, StateFlag flag) {
        if (p == null) {
            return set.testState(null, new StateFlag[]{flag});
        }
        return set.testState((RegionAssociable)WorldGuardPlugin.inst().wrapPlayer((Player)p.getHandle()), new StateFlag[]{flag});
    }

    public static <V> V QueryValue(ApplicableRegionSet set, MCPlayer p, Flag<V> flag) {
        if (p == null) {
            return (V)set.queryValue(null, flag);
        }
        return (V)set.queryValue((RegionAssociable)WorldGuardPlugin.inst().wrapPlayer((Player)p.getHandle()), flag);
    }

    public static Collection<String> RegionsAt(MCLocation loc) {
        return SKWorldGuard.RegionsAt(loc.getWorld(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static ProtectedRegion CreateProtectedRegion(String region) {
        return new GlobalProtectedRegion(region);
    }

    public static ProtectedRegion CreateProtectedRegion(String newRegionName, ProtectedRegion oldRegion) {
        if (oldRegion instanceof ProtectedCuboidRegion) {
            return new ProtectedCuboidRegion(newRegionName, oldRegion.getMinimumPoint(), oldRegion.getMaximumPoint());
        }
        return new ProtectedPolygonalRegion(newRegionName, oldRegion.getPoints(), oldRegion.getMinimumPoint().getBlockY(), oldRegion.getMaximumPoint().getBlockY());
    }

    public static ProtectedRegion CreateProtectedRegion(String region, List<BlockVector3> points) {
        return new ProtectedCuboidRegion(region, points.get(0), points.get(1));
    }

    public static ProtectedRegion CreateProtectedRegion(String region, List<BlockVector2> points2D, int minY, int maxY) {
        return new ProtectedPolygonalRegion(region, points2D, minY, maxY);
    }
}

