/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.skcompat;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientArgumentsException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.SimpleFlagRegistry;
import com.sk89q.worldguard.protection.flags.registry.UnknownFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import io.github.jbaero.skcompat.SKCompat;
import io.github.jbaero.skcompat.SKFlags;
import io.github.jbaero.skcompat.SKRegion;
import io.github.jbaero.skcompat.SKWorldGuard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class CHWorldGuard {
    public static String docs() {
        return "Provides various methods for hooking into WorldGuard";
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class sk_can_build
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPlayerOfflineException.class, CREFormatException.class, CREInvalidWorldException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCLocation loc;
            MCPlayer p;
            if (args.length == 1) {
                p = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (p == null) {
                    throw new CREPlayerOfflineException("A player was expected.", t);
                }
                loc = ObjectGenerator.GetGenerator().location(args[0], p.getWorld(), t);
            } else {
                p = Static.GetPlayer((Mixed)args[0], (Target)t);
                loc = ObjectGenerator.GetGenerator().location(args[1], p.getWorld(), t);
            }
            LocalPlayer player = WorldGuardPlugin.inst().wrapPlayer((Player)p.getHandle());
            com.sk89q.worldedit.world.World world = BukkitAdapter.adapt((World)((World)loc.getWorld().getHandle()));
            if (WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(player, world)) {
                return CBoolean.TRUE;
            }
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            return CBoolean.get((boolean)query.testState(BukkitAdapter.adapt((Location)((Location)loc.getHandle())), player, new StateFlag[]{Flags.BUILD}));
        }

        public String getName() {
            return "sk_can_build";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "boolean {[player,] locationArray} Returns whether or not player can build at the location, according to WorldGuard. If player is not given, the current player is used.";
        }
    }

    @api
    public static class sk_region_setparent
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_setparent";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {world, region, [parentRegion]} Sets parent region for a given region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCWorld world = Static.getServer().getWorld(args[0].val());
            String regionName = args[1].val();
            if ("__global__".equalsIgnoreCase(regionName)) {
                throw new CREPluginInternalException("You cannot set parents for a __global__ cuboid.", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion child = mgr.getRegion(regionName);
            if (child == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", regionName, world.getName()), t);
            }
            if (args.length == 2) {
                try {
                    child.setParent(null);
                }
                catch (Exception exception) {}
            } else {
                String parentName = args[2].val();
                ProtectedRegion parent = mgr.getRegion(parentName);
                if (parent == null) {
                    throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", parentName, world.getName()), t);
                }
                try {
                    child.setParent(parent);
                }
                catch (Exception e) {
                    throw new CREPluginInternalException(e.getMessage(), t);
                }
            }
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while setting parent for protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_setpriority
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_setpriority";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {[world], region, priority} Sets priority for a given region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            int priority;
            String region;
            MCWorld world = null;
            if (args.length == 2) {
                region = args[0].val();
                MCPlayer m = null;
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                }
                priority = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            } else {
                region = args[1].val();
                world = Static.getServer().getWorld(args[0].val());
                priority = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            if ("__global__".equalsIgnoreCase(region)) {
                throw new CREPluginInternalException("The region cannot be named __global__.", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion regionExists = mgr.getRegion(region);
            if (regionExists == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", region, world.getName()), t);
            }
            regionExists.setPriority(priority);
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while setting priority for protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_flags
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_flags";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "array {region, world} Returns an associative array with the flags of the region in format: array(flag-name: flag-value, ...). If the world or region cannot be found, a PluginInternalException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String regionName = args[0].val();
            MCWorld world = Static.getWorld((Mixed)args[1], (Target)t);
            SKRegion region = SKWorldGuard.GetRegion(world, regionName, t);
            CArray flagSet = new CArray(t);
            for (Map.Entry<String, String> flag : region.getFlags().entrySet()) {
                flagSet.set(flag.getKey(), flag.getValue(), t);
            }
            return flagSet;
        }
    }

    @api
    public static class sk_region_check_flag
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_check_flag";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "mixed {locationArray, flagName, [player]} Gets the value of a flag at a location. The flagName should be any supported flag from [https://worldguard.readthedocs.io/en/latest/regions/flags/ this list]. Player defaults to the current player.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREFormatException.class, CREPluginInternalException.class, CRENotFoundException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            if ("build".equalsIgnoreCase(args[1].val())) {
                throw new CREPluginInternalException(String.format("Can't use build flag with %s function.", this.getName()), t);
            }
            MCPlayer p = null;
            MCWorld w = null;
            if (args.length == 2) {
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    p = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
            } else {
                p = Static.GetPlayer((String)args[2].val(), (Target)t);
            }
            if (p != null) {
                w = p.getWorld();
            }
            MCLocation l = ObjectGenerator.GetGenerator().location(args[0], w, t);
            Flag<?> foundFlag = SKFlags.GetFlag(args[1].val(), t);
            RegionManager mgr = SKWorldGuard.GetRegionManager(l.getWorld(), t);
            ApplicableRegionSet set = mgr.getApplicableRegions(BukkitAdapter.asBlockVector((Location)((Location)l.getHandle())));
            if (foundFlag instanceof StateFlag) {
                return CBoolean.get((boolean)SKWorldGuard.TestState(set, p, (StateFlag)foundFlag));
            }
            Object flagValue = SKWorldGuard.QueryValue(set, p, foundFlag);
            return SKFlags.ConvertFlagValue(foundFlag, flagValue, t);
        }
    }

    @api
    public static class sk_region_flag
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_flag";
        }

        public Integer[] numArgs() {
            return new Integer[]{4, 5};
        }

        public String docs() {
            return "void {world, region, flagName, flagValue, [group]} Add/change/remove flag for selected region. FlagName should be any supported flag from [https://worldguard.readthedocs.io/en/latest/regions/flags/ this list]. For the flagValue, use types which are supported by WorldGuard. Add group argument if you want to add WorldGuard group flag (read more about group flag types [http://worldguard.enginehub.org/en/latest/regions/flags/#region-groups here]). Set flagValue as null (and don't set group) to delete the flag from the region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            RegionManager mgr;
            MCWorld world = Static.getServer().getWorld(args[0].val());
            MCCommandSender sender = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender();
            String regionName = args[1].val();
            String flagName = args[2].val();
            String flagValue = null;
            if (args.length >= 4 && !(args[3] instanceof CNull) && !args[3].val().isEmpty()) {
                flagValue = args[3].val();
            }
            if ((mgr = SKWorldGuard.GetRegionManager(world, t)).getRegion(regionName) == null) {
                if ("__global__".equalsIgnoreCase(regionName)) {
                    SKWorldGuard.GetRegionManager(world, t).addRegion(SKWorldGuard.CreateProtectedRegion(regionName));
                } else {
                    throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", regionName, world.getName()), t);
                }
            }
            SKRegion region = SKWorldGuard.GetRegion(world, regionName, t);
            if (flagValue != null) {
                region.setFlag(flagName, sender, flagValue, t);
            } else if (args.length < 5) {
                region.clearFlag(flagName, t);
                if (SKFlags.GetFlag(flagName, t).getRegionGroupFlag() != null) {
                    region.clearGroupFlag(flagName, t);
                }
            }
            if (args.length == 5) {
                String group = args[4].val();
                region.setGroupFlag(flagName, sender, group, t);
            }
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while defining flags", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_register_flag
    extends SKCompat.SKFunction {
        private static boolean dirtyFlags = false;

        public String getName() {
            return "sk_register_flag";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {name, [type]} Registers a new region flag. If WorldGuard flags are already initialized and a new flag is being added, this will force a WorldGuard config reload. Currently supported types are BOOLEAN, DOUBLE, INTEGER, LOCATION, and STRING (default).";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIllegalArgumentException.class, CREFormatException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String flagName = args[0].val();
            String flagType = args.length == 2 ? args[1].val() : "STRING";
            Flag<?> flag = SKFlags.CreateFlag(flagName, flagType, t);
            SimpleFlagRegistry registry = (SimpleFlagRegistry)WorldGuard.getInstance().getFlagRegistry();
            Flag existingFlag = registry.get(flagName);
            if (existingFlag != null && !(existingFlag instanceof UnknownFlag)) {
                if (!flag.getClass().isInstance(existingFlag)) {
                    throw new CREIllegalArgumentException("A different type of flag already exists with the name " + flagName, t);
                }
                return CVoid.VOID;
            }
            try {
                if (!registry.isInitialized()) {
                    registry.register(flag);
                } else {
                    Map flags = (Map)ReflectionUtils.get(SimpleFlagRegistry.class, (Object)registry, (String)"flags");
                    flags.put(flagName, flag);
                    if (!dirtyFlags) {
                        dirtyFlags = true;
                        StaticLayer.GetConvertor().runOnMainThreadLater(null, () -> {
                            dirtyFlags = false;
                            SKFlags.FLAG_CACHE.clear();
                            Static.getLogger().info("Reloading WorldGuard region data for custom flags.");
                            WorldGuard.getInstance().getPlatform().getRegionContainer().reload();
                        });
                    }
                }
            }
            catch (Exception ex) {
                throw new CREException(ex.getMessage(), t);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_members
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_members";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "array {region, world} Returns an array of members of this region. If the world or region cannot be found, a PluginInternalException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String regionName = args[0].val();
            String worldName = args[1].val();
            MCWorld world = Static.getServer().getWorld(worldName);
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion region = mgr.getRegion(regionName);
            if (region == null) {
                throw new CREPluginInternalException("Region could not be found!", t);
            }
            ArrayList membersPlayers = new ArrayList(region.getMembers().getUniqueIds());
            ArrayList membersNames = new ArrayList(region.getMembers().getPlayers());
            ArrayList membersGroups = new ArrayList(region.getMembers().getGroups());
            CArray members = CArray.GetAssociativeArray((Target)t);
            CArray players = new CArray(t);
            CArray names = new CArray(t);
            CArray groups = new CArray(t);
            for (Object member : membersPlayers) {
                players.push((Mixed)new CString(((UUID)member).toString(), t), t);
            }
            for (Object member : membersNames) {
                names.push((Mixed)new CString((String)member, t), t);
            }
            for (Object member : membersGroups) {
                groups.push((Mixed)new CString((String)member, t), t);
            }
            members.set("players", (Mixed)players, t);
            members.set("names", (Mixed)names, t);
            members.set("groups", (Mixed)groups, t);
            return members;
        }
    }

    @api
    public static class sk_region_remmember
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_remmember";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {region, [world], [member] | region, [world], [array(member, [...])]} Remove member(s) from given region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCWorld world = null;
            MCPlayer m = null;
            String[] members = null;
            String region = args[0].val();
            if (args.length == 1) {
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                    members = new String[]{m.getName()};
                }
            } else if (args.length == 2) {
                world = Static.getServer().getWorld(args[0].val());
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    members = new String[]{m.getName()};
                }
            } else {
                world = Static.getServer().getWorld(args[1].val());
                if (args[2] instanceof CArray) {
                    CArray arg = (CArray)args[2];
                    members = new String[(int)arg.size()];
                    int i = 0;
                    while ((long)i < arg.size()) {
                        members[i] = arg.get(i, t).val();
                        ++i;
                    }
                } else {
                    members = new String[]{args[2].val()};
                }
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion regionExists = mgr.getRegion(region);
            if (regionExists == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", region, world.getName()), t);
            }
            if (members == null) {
                throw new CREInsufficientArgumentsException("Members not specified.", t);
            }
            for (String member : members) {
                if (member.startsWith("g:")) {
                    regionExists.getMembers().removeGroup(member.substring(2));
                    continue;
                }
                regionExists.getMembers().removePlayer(Static.GetUser((String)member, (Target)t).getUniqueID());
            }
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while deleting members(s) from protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_addmember
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_addmember";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {region, [world], [member] | region, [world], [array(member, [...])]} Add member(s) to given region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCWorld world = null;
            MCPlayer m = null;
            String[] members = null;
            String region = args[0].val();
            if (args.length == 1) {
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                    members = new String[]{m.getName()};
                }
            } else if (args.length == 2) {
                world = Static.getServer().getWorld(args[0].val());
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    members = new String[]{m.getName()};
                }
            } else {
                world = Static.getServer().getWorld(args[1].val());
                if (args[2] instanceof CArray) {
                    CArray arg = (CArray)args[2];
                    members = new String[(int)arg.size()];
                    int i = 0;
                    while ((long)i < arg.size()) {
                        members[i] = arg.get(i, t).val();
                        ++i;
                    }
                } else {
                    members = new String[]{args[2].val()};
                }
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion regionExists = mgr.getRegion(region);
            if (regionExists == null) {
                if ("__global__".equalsIgnoreCase(region)) {
                    regionExists = SKWorldGuard.CreateProtectedRegion(region);
                    mgr.addRegion(regionExists);
                } else {
                    throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", region, world.getName()), t);
                }
            }
            if (members == null) {
                throw new CREInsufficientArgumentsException("Members not specified.", t);
            }
            for (String member : members) {
                if (member.startsWith("g:")) {
                    regionExists.getMembers().addGroup(member.substring(2));
                    continue;
                }
                regionExists.getMembers().addPlayer(Static.GetUser((String)member, (Target)t).getUniqueID());
            }
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while adding member(s) to protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_owners
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_owners";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "array {region, world} Returns an array of owners of this region. If the world or region cannot be found, a PluginInternalException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String regionName = args[0].val();
            String worldName = args[1].val();
            MCWorld world = Static.getServer().getWorld(worldName);
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion region = mgr.getRegion(regionName);
            if (region == null) {
                throw new CREPluginInternalException("Region could not be found!", t);
            }
            ArrayList ownersPlayers = new ArrayList(region.getOwners().getUniqueIds());
            ArrayList ownersNames = new ArrayList(region.getOwners().getPlayers());
            ArrayList ownersGroups = new ArrayList(region.getOwners().getGroups());
            CArray owners = CArray.GetAssociativeArray((Target)t);
            CArray players = new CArray(t);
            CArray names = new CArray(t);
            CArray groups = new CArray(t);
            for (Object owner : ownersPlayers) {
                players.push((Mixed)new CString(((UUID)owner).toString(), t), t);
            }
            for (Object owner : ownersNames) {
                names.push((Mixed)new CString((String)owner, t), t);
            }
            for (Object owner : ownersGroups) {
                groups.push((Mixed)new CString((String)owner, t), t);
            }
            owners.set("players", (Mixed)players, t);
            owners.set("names", (Mixed)names, t);
            owners.set("groups", (Mixed)groups, t);
            return owners;
        }
    }

    @api
    public static class sk_region_remowner
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_remowner";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {region, [world], [owner] | region, [world], [array(owner, [...])]} Remove owner(s) from given region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCWorld world = null;
            MCPlayer m = null;
            String[] owners = null;
            String region = args[0].val();
            if (args.length == 1) {
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                    owners = new String[]{m.getName()};
                }
            } else if (args.length == 2) {
                world = Static.getServer().getWorld(args[0].val());
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    owners = new String[]{m.getName()};
                }
            } else {
                world = Static.getServer().getWorld(args[1].val());
                if (args[2] instanceof CArray) {
                    CArray arg = (CArray)args[2];
                    owners = new String[(int)arg.size()];
                    int i = 0;
                    while ((long)i < arg.size()) {
                        owners[i] = arg.get(i, t).val();
                        ++i;
                    }
                } else {
                    owners = new String[]{args[2].val()};
                }
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion regionExists = mgr.getRegion(region);
            if (regionExists == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", region, world.getName()), t);
            }
            if (owners == null) {
                throw new CREInsufficientArgumentsException("Owners not specified.", t);
            }
            for (String owner : owners) {
                if (owner.startsWith("g:")) {
                    regionExists.getOwners().removeGroup(owner.substring(2));
                    continue;
                }
                regionExists.getOwners().removePlayer(Static.GetUser((String)owner, (Target)t).getUniqueID());
            }
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while deleting owner(s) from protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_addowner
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_addowner";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {region, [world], [owner] | region, [world], [array(owner, [...])]} Add owner(s) to given region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCWorld world = null;
            MCPlayer m = null;
            String[] owners = null;
            String region = args[0].val();
            if (args.length == 1) {
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                    owners = new String[]{m.getName()};
                }
            } else if (args.length == 2) {
                world = Static.getServer().getWorld(args[0].val());
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    owners = new String[]{m.getName()};
                }
            } else {
                world = Static.getServer().getWorld(args[1].val());
                if (args[2] instanceof CArray) {
                    CArray arg = (CArray)args[2];
                    owners = new String[(int)arg.size()];
                    int i = 0;
                    while ((long)i < arg.size()) {
                        owners[i] = arg.get(i, t).val();
                        ++i;
                    }
                } else {
                    owners = new String[]{args[2].val()};
                }
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion regionExists = mgr.getRegion(region);
            if (regionExists == null) {
                if ("__global__".equalsIgnoreCase(region)) {
                    regionExists = SKWorldGuard.CreateProtectedRegion(region);
                    mgr.addRegion(regionExists);
                } else {
                    throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", region, world.getName()), t);
                }
            }
            if (owners == null) {
                throw new CREInsufficientArgumentsException("New owners not specified.", t);
            }
            for (String owner : owners) {
                if (owner.startsWith("g:")) {
                    regionExists.getOwners().addGroup(owner.substring(2));
                    continue;
                }
                regionExists.getOwners().addPlayer(Static.GetUser((String)owner, (Target)t).getUniqueID());
            }
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while adding owner(s) to protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_exists
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_exists";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "boolean {[world], name} Check if a given region exists.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String region;
            MCWorld world = null;
            if (args.length == 1) {
                region = args[0].val();
                MCPlayer m = null;
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                }
            } else {
                region = args[1].val();
                world = Static.getServer().getWorld(args[0].val());
            }
            if (world == null) {
                throw new CREInvalidWorldException("Unknown world specified", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion regionExists = mgr.getRegion(region);
            if (regionExists != null) {
                return CBoolean.TRUE;
            }
            return CBoolean.FALSE;
        }
    }

    @api
    public static class sk_region_remove
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_remove";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[world], name} Remove existed region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String region;
            MCWorld world = null;
            if (args.length == 1) {
                region = args[0].val();
                MCPlayer m = null;
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                }
            } else {
                region = args[1].val();
                world = Static.getServer().getWorld(args[0].val());
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion regionExists = mgr.getRegion(region);
            if (regionExists == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", region, world.getName()), t);
            }
            mgr.removeRegion(region);
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while removing protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_rename
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_rename";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {[world], oldName, newName} Rename the existing region. Other properties of the region, like owners, members, priority, etc are unaffected.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String newRegionName;
            String oldRegionName;
            MCWorld world = null;
            if (args.length == 2) {
                oldRegionName = args[0].val();
                newRegionName = args[1].val();
                MCPlayer m = null;
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                }
            } else {
                oldRegionName = args[1].val();
                newRegionName = args[2].val();
                world = Static.getServer().getWorld(args[0].val());
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            if ("__global__".equalsIgnoreCase(oldRegionName)) {
                throw new CREPluginInternalException("You cannot change name of __global__ region.", t);
            }
            if ("__global__".equalsIgnoreCase(newRegionName)) {
                throw new CREPluginInternalException("You cannot change name of any region to __global__.", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion oldRegion = mgr.getRegion(oldRegionName);
            if (oldRegion == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", oldRegionName, world.getName()), t);
            }
            ProtectedRegion newRegion = SKWorldGuard.CreateProtectedRegion(newRegionName, oldRegion);
            mgr.addRegion(newRegion);
            newRegion.setMembers(oldRegion.getMembers());
            newRegion.setOwners(oldRegion.getOwners());
            newRegion.setFlags(oldRegion.getFlags());
            newRegion.setPriority(oldRegion.getPriority());
            try {
                newRegion.setParent(oldRegion.getParent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            mgr.removeRegion(oldRegionName);
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while renaming protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_update
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_update";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {[world], name, array(vectorArrayPos1, vectorArrayPos2, [[vectorArrayPosN]...])} Updates the boundaries of a given region. Other properties of the region, like owners, members, priority, etc are unaffected.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String region;
            MCWorld world = null;
            if (args.length == 2) {
                region = args[0].val();
                MCPlayer m = null;
                if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                    m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                }
                if (m != null) {
                    world = Static.getServer().getWorld(m.getWorld().getName());
                }
            } else {
                region = args[1].val();
                world = Static.getServer().getWorld(args[0].val());
            }
            if (world == null) {
                throw new CREInvalidWorldException("No world specified", t);
            }
            if ("__global__".equalsIgnoreCase(region)) {
                throw new CREPluginInternalException("You cannot change position of __global__ region.", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion oldRegion = mgr.getRegion(region);
            if (oldRegion == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", region, world.getName()), t);
            }
            if (!(args[args.length - 1] instanceof CArray)) {
                throw new CREPluginInternalException("Pass an array of points to define a new region", t);
            }
            ArrayList<BlockVector3> points = new ArrayList<BlockVector3>();
            ArrayList<BlockVector2> points2D = new ArrayList<BlockVector2>();
            int minY = 0;
            int maxY = 0;
            CArray arg = (CArray)args[args.length - 1];
            int i = 0;
            while ((long)i < arg.size()) {
                Vector3D vec = ObjectGenerator.GetGenerator().vector(arg.get(i, t), t);
                if (arg.size() == 2L) {
                    points.add(BlockVector3.at((double)vec.X(), (double)vec.Y(), (double)vec.Z()));
                } else {
                    points2D.add(BlockVector2.at((double)vec.X(), (double)vec.Z()));
                    if (i == 0) {
                        minY = maxY = (int)vec.Y();
                    } else if (vec.Y() < (double)minY) {
                        minY = (int)vec.Y();
                    } else if (vec.Y() > (double)maxY) {
                        maxY = (int)vec.Y();
                    }
                }
                ++i;
            }
            ProtectedRegion newRegion = arg.size() == 2L ? SKWorldGuard.CreateProtectedRegion(region, points) : SKWorldGuard.CreateProtectedRegion(region, points2D, minY, maxY);
            mgr.addRegion(newRegion);
            newRegion.setMembers(oldRegion.getMembers());
            newRegion.setOwners(oldRegion.getOwners());
            newRegion.setFlags(oldRegion.getFlags());
            newRegion.setPriority(oldRegion.getPriority());
            try {
                newRegion.setParent(oldRegion.getParent());
            }
            catch (Exception vec) {
                // empty catch block
            }
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while redefining protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_create
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_create";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        public String docs() {
            return "void {[world], name, array(locationArray, [...])} Create region of the given name in the given world. Requires at least two locations. Three or more will create a polygonal region. You can omit the array of locations if you want to create a '__global__' region.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            ProtectedRegion newRegion;
            String region;
            MCWorld w = null;
            ArrayList<BlockVector3> vertices = new ArrayList<BlockVector3>();
            if (args.length == 3 || args.length == 2 && "__global__".equalsIgnoreCase(args[1].val())) {
                w = Static.getServer().getWorld(args[0].val());
                region = args[1].val();
                if (w == null) {
                    throw new CREInvalidWorldException("The specified world \"" + args[0].val() + "\" is not a valid world.", t);
                }
            } else {
                region = args[0].val();
            }
            if (!"__global__".equalsIgnoreCase(region)) {
                CArray point;
                if (args.length == 1 || !(args[args.length - 1] instanceof CArray)) {
                    throw new CREPluginInternalException("Pass an array of LocationArrays for a new region.", t);
                }
                CArray points = (CArray)args[args.length - 1];
                if (points.isEmpty()) {
                    throw new CREPluginInternalException("Expecting an array of LocationArrays but found none.", t);
                }
                int i = 0;
                while ((long)i < points.size()) {
                    if (!(points.get(i, t) instanceof CArray)) {
                        throw new CREPluginInternalException("LocationArrays must be arrays.", t);
                    }
                    point = (CArray)points.get(i, t);
                    if (point.size() >= 3L) {
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        if (!point.inAssociativeMode()) {
                            x = ArgumentValidation.getNumber((Mixed)point.get(0, t), (Target)t);
                            y = ArgumentValidation.getNumber((Mixed)point.get(1, t), (Target)t);
                            z = ArgumentValidation.getNumber((Mixed)point.get(2, t), (Target)t);
                        }
                        if (point.containsKey("x")) {
                            x = ArgumentValidation.getNumber((Mixed)point.get("x", t), (Target)t);
                        }
                        if (point.containsKey("y")) {
                            y = ArgumentValidation.getNumber((Mixed)point.get("y", t), (Target)t);
                        }
                        if (point.containsKey("z")) {
                            z = ArgumentValidation.getNumber((Mixed)point.get("z", t), (Target)t);
                        }
                        vertices.add(BlockVector3.at((double)x, (double)y, (double)z));
                    }
                    ++i;
                }
                if (vertices.isEmpty()) {
                    throw new CREPluginInternalException("Expecting an array of LocationArrays but found no valid Location arrays.", t);
                }
                if (w == null) {
                    i = 0;
                    while ((long)i < points.size()) {
                        point = (CArray)points.get(i, t);
                        if (point.size() >= 4L) {
                            MCWorld world = null;
                            if (!point.inAssociativeMode()) {
                                world = Static.getServer().getWorld(point.get(3, t).val());
                            }
                            if (point.containsKey("world")) {
                                world = Static.getServer().getWorld(point.get("world", t).val());
                            }
                            if (world != null) {
                                if (w == null) {
                                    w = world;
                                } else if (!w.equals((Object)world)) {
                                    throw new CREInvalidWorldException(String.format("Conflicting worlds in LocationArrays. (%s) & (%s)", w.getName(), world.getName()), t);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            if (w == null && ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                w = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer().getWorld();
            }
            if (w == null) {
                throw new CREInvalidWorldException("No world specified.", t);
            }
            RegionManager mgr = SKWorldGuard.GetRegionManager(w, t);
            if (mgr.hasRegion(region)) {
                throw new CREPluginInternalException(String.format("The region (%s) already exists in world (%s), and cannot be created again.", region, w.getName()), t);
            }
            if ("__global__".equalsIgnoreCase(region)) {
                newRegion = SKWorldGuard.CreateProtectedRegion(region);
            } else if (vertices.size() == 2) {
                newRegion = SKWorldGuard.CreateProtectedRegion(region, vertices);
            } else {
                ArrayList<BlockVector2> pointsPoly = new ArrayList<BlockVector2>();
                int minY = 0;
                int maxY = 0;
                for (int i = 0; i < vertices.size(); ++i) {
                    BlockVector3 vector = (BlockVector3)vertices.get(i);
                    int x = vector.getBlockX();
                    int y = vector.getBlockY();
                    int z = vector.getBlockZ();
                    pointsPoly.add(BlockVector2.at((int)x, (int)z));
                    if (i == 0) {
                        minY = maxY = y;
                        continue;
                    }
                    if (y < minY) {
                        minY = y;
                        continue;
                    }
                    if (y <= maxY) continue;
                    maxY = y;
                }
                newRegion = SKWorldGuard.CreateProtectedRegion(region, pointsPoly, minY, maxY);
            }
            mgr.addRegion(newRegion);
            try {
                mgr.save();
            }
            catch (Exception e) {
                throw new CREPluginInternalException("Error while creating protected region", t, (Throwable)e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class sk_region_volume
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_volume";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "int {region, world} Returns the volume of the given region in the given world.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCWorld world = Static.getServer().getWorld(args[1].val());
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            ProtectedRegion region = mgr.getRegion(args[0].val());
            if (region == null) {
                throw new CREPluginInternalException(String.format("The region (%s) does not exist in world (%s).", args[0].val(), args[1].val()), t);
            }
            return new CInt((long)region.volume(), t);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class sk_regions_at
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_regions_at";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "mixed {Locationarray} Returns a list of regions at the specified location. If regions are found, an array of region names are returned, otherwise, an empty array is returned.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREPluginInternalException.class, CREInsufficientArgumentsException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCLocation loc;
            if (!(args[0] instanceof CArray)) {
                throw new CRECastException(this.getName() + " needs a locationarray", t);
            }
            MCWorld w = null;
            MCCommandSender c = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender();
            if (c instanceof MCPlayer) {
                w = ((MCPlayer)c).getWorld();
            }
            if ((loc = ObjectGenerator.GetGenerator().location(args[0], w, t)).getWorld() == null) {
                throw new CREInsufficientArgumentsException(this.getName() + " needs a world", t);
            }
            MCWorld world = Static.getServer().getWorld(loc.getWorld().getName());
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            BlockVector3 pt = BlockVector3.at((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            CArray regions = new CArray(t);
            ArrayList<ProtectedRegion> sortedRegions = new ArrayList<ProtectedRegion>();
            for (ProtectedRegion r : set) {
                boolean placed = false;
                for (int i = 0; i < sortedRegions.size(); ++i) {
                    if (((ProtectedRegion)sortedRegions.get(i)).volume() >= r.volume()) continue;
                    sortedRegions.add(i, r);
                    placed = true;
                    break;
                }
                if (placed) continue;
                sortedRegions.add(r);
            }
            for (ProtectedRegion region : sortedRegions) {
                regions.push((Mixed)new CString(region.getId(), t), t);
            }
            if (regions.size() > 0L) {
                return regions;
            }
            return new CArray(t);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class sk_current_regions
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_current_regions";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "mixed {[player]} Returns the list regions that player is in. If no player specified, then the current player is used. If region is found, an array of region names are returned, else an empty array is returned.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            MCPlayer m = null;
            if (((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetCommandSender() instanceof MCPlayer) {
                m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
            }
            if (args.length == 1) {
                m = Static.GetPlayer((String)args[0].val(), (Target)t);
            }
            if (m == null) {
                throw new CREPlayerOfflineException(this.getName() + " needs a player", t);
            }
            CArray regions = new CArray(t);
            for (String region : SKWorldGuard.RegionsAt(m.getLocation())) {
                regions.push((Mixed)new CString(region, t), t);
            }
            return regions;
        }
    }

    @api
    public static class sk_all_regions
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_all_regions";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "array {[world]} Returns all the regions in all worlds, or just the one world, if specified.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            CArray arr = new CArray(t);
            if (args.length == 1) {
                MCWorld world = Static.getWorld((Mixed)args[0], (Target)t);
                for (String region : SKWorldGuard.GetRegionManager(world, t).getRegions().keySet()) {
                    arr.push((Mixed)new CString(region, t), t);
                }
            } else {
                for (MCWorld world : Static.getServer().getWorlds()) {
                    for (String region : SKWorldGuard.GetRegionManager(world, t).getRegions().keySet()) {
                        arr.push((Mixed)new CString(region, t), t);
                    }
                }
            }
            return arr;
        }
    }

    @api
    public static class sk_region_intersect
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_intersect";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "array {world, first_region, [other_region(s)]} Returns an array of regions names which intersect with defined region. You can pass a single region, an array of regions to verify or omit this parameter and all regions in selected world will be checked.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            ProtectedRegion region;
            String region1 = args[1].val();
            ArrayList<Object> checkRegions = new ArrayList<Object>();
            CArray listRegions = new CArray(t);
            MCWorld world = Static.getServer().getWorld(args[0].val());
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            if (args.length == 2) {
                checkRegions.addAll(mgr.getRegions().values());
            } else if (args[2] instanceof CArray) {
                CArray arg = (CArray)args[2];
                int i = 0;
                while ((long)i < arg.size()) {
                    ProtectedRegion region2 = mgr.getRegion(arg.get(i, t).val());
                    if (region2 == null) {
                        throw new CREPluginInternalException(String.format("Region %s could not be found!", arg.get(i, t).val()), t);
                    }
                    checkRegions.add(region2);
                    ++i;
                }
            } else {
                region = mgr.getRegion(args[2].val());
                if (region == null) {
                    throw new CREPluginInternalException(String.format("Region %s could not be found!", args[2]), t);
                }
                checkRegions.add(region);
            }
            region = mgr.getRegion(region1);
            if (region == null) {
                throw new CREPluginInternalException(String.format("Region %s could not be found!", region1), t);
            }
            try {
                List getRegions = region.getIntersectingRegions(checkRegions);
                if (!getRegions.isEmpty()) {
                    for (ProtectedRegion r : getRegions) {
                        if (args.length == 2 && r.getId().equals(region.getId())) continue;
                        listRegions.push((Mixed)new CString(r.getId(), t), t);
                    }
                    if (listRegions.isEmpty()) {
                        return new CArray(t);
                    }
                    return listRegions;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new CArray(t);
        }
    }

    @api
    public static class sk_region_overlaps
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_overlaps";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public String docs() {
            return "boolean {world, region1, array(region2, [regionN...])} Returns true or false whether or not the specified regions overlap. Third parameter may be a single region or an array of regions.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            ProtectedRegion region;
            String region1 = args[1].val();
            ArrayList<ProtectedRegion> checkRegions = new ArrayList<ProtectedRegion>();
            MCWorld world = Static.getServer().getWorld(args[0].val());
            RegionManager mgr = SKWorldGuard.GetRegionManager(world, t);
            if (args[2] instanceof CArray) {
                CArray arg = (CArray)args[2];
                int i = 0;
                while ((long)i < arg.size()) {
                    ProtectedRegion region2 = mgr.getRegion(arg.get(i, t).val());
                    if (region2 == null) {
                        throw new CREPluginInternalException("Region " + arg.get(i, t).val() + " could not be found!", t);
                    }
                    checkRegions.add(region2);
                    ++i;
                }
            } else {
                region = mgr.getRegion(args[2].val());
                if (region == null) {
                    throw new CREPluginInternalException("Region " + String.valueOf(args[2]) + " could not be found!", t);
                }
                checkRegions.add(region);
            }
            region = mgr.getRegion(region1);
            if (region == null) {
                throw new CREPluginInternalException("Region could not be found!", t);
            }
            try {
                if (!region.getIntersectingRegions(checkRegions).isEmpty()) {
                    return CBoolean.TRUE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return CBoolean.FALSE;
        }
    }

    @api
    public static class sk_region_info
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_region_info";
        }

        @Override
        public Version since() {
            return MSVersion.V3_2_0;
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "array {region, world, [value]} Given a region name, returns an array of information about that region. ---- If value is set, it should be an integer of one of the following indexes, and only that information for that index will be returned. Otherwise if value is not specified (or is -1), it returns an array of information with the following pieces of information in the specified index:<ul> <li>0 - An array of points that define this region</li> <li>1 - An array of owners of this region</li> <li>2 - An array of members of this region</li> <li>3 - An array of arrays of this region's flags, where each array is: array(flag_name, value)</li> <li>4 - This region's priority</li> <li>5 - The volume of this region (in meters cubed)</li></ul>If the region cannot be found, a PluginInternalException is thrown.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class, CRECastException.class, CRERangeException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            CArray groups;
            CArray players;
            String regionName = args[0].val();
            MCWorld world = Static.getWorld((Mixed)args[1], (Target)t);
            int index = -1;
            if (args.length == 3) {
                index = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
            }
            int maxIndex = 5;
            if (index < -1 || index > maxIndex) {
                throw new CRERangeException(this.getName() + " expects the index to be between -1 and " + maxIndex, t);
            }
            SKRegion region = SKWorldGuard.GetRegion(world, regionName, t);
            CArray ret = new CArray(t);
            if (index == 0 || index == -1) {
                CArray pointSet = new CArray(t);
                for (MCLocation mCLocation : region.getBounds()) {
                    CArray point = new CArray(t);
                    point.push((Mixed)new CInt((long)mCLocation.getBlockX(), t), t);
                    point.push((Mixed)new CInt((long)mCLocation.getBlockY(), t), t);
                    point.push((Mixed)new CInt((long)mCLocation.getBlockZ(), t), t);
                    point.push((Mixed)new CString(mCLocation.getWorld().getName(), t), t);
                    pointSet.push((Mixed)point, t);
                }
                ret.push((Mixed)pointSet, t);
            }
            if (index == 1 || index == -1) {
                CArray ownerSet = CArray.GetAssociativeArray((Target)t);
                players = new CArray(t);
                CArray cArray = new CArray(t);
                groups = new CArray(t);
                for (UUID uUID : region.getOwnerPlayers()) {
                    players.push((Mixed)new CString(uUID.toString(), t), t);
                }
                for (String string : region.getOwnerNames()) {
                    cArray.push((Mixed)new CString(string, t), t);
                }
                for (String string : region.getOwnerGroups()) {
                    groups.push((Mixed)new CString(string, t), t);
                }
                ownerSet.set("players", (Mixed)players, t);
                ownerSet.set("names", (Mixed)cArray, t);
                ownerSet.set("groups", (Mixed)groups, t);
                ret.push((Mixed)ownerSet, t);
            }
            if (index == 2 || index == -1) {
                CArray memberSet = CArray.GetAssociativeArray((Target)t);
                players = new CArray(t);
                CArray cArray = new CArray(t);
                groups = new CArray(t);
                for (UUID uUID : region.getMemberPlayers()) {
                    players.push((Mixed)new CString(uUID.toString(), t), t);
                }
                for (String string : region.getMemberNames()) {
                    cArray.push((Mixed)new CString(string, t), t);
                }
                for (String string : region.getMemberGroups()) {
                    groups.push((Mixed)new CString(string, t), t);
                }
                memberSet.set("players", (Mixed)players, t);
                memberSet.set("names", (Mixed)cArray, t);
                memberSet.set("groups", (Mixed)groups, t);
                ret.push((Mixed)memberSet, t);
            }
            if (index == 3 || index == -1) {
                CArray flagSet = new CArray(t);
                for (Map.Entry entry : region.getFlags().entrySet()) {
                    CArray fl = new CArray(t, new Mixed[]{new CString((String)entry.getKey(), t), new CString((String)entry.getValue(), t)});
                    flagSet.push((Mixed)fl, t);
                }
                ret.push((Mixed)flagSet, t);
            }
            if (index == 4 || index == -1) {
                ret.push((Mixed)new CInt((long)region.getPriority(), t), t);
            }
            if (index == 5 || index == -1) {
                ret.push((Mixed)new CDouble((double)region.getVolume(), t), t);
            }
            if (ret.size() == 1L) {
                return ret.get(0, t);
            }
            return ret;
        }
    }
}

