/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.skcompat;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.BooleanFlag;
import com.sk89q.worldguard.protection.flags.DoubleFlag;
import com.sk89q.worldguard.protection.flags.EnumFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.IntegerFlag;
import com.sk89q.worldguard.protection.flags.LocationFlag;
import com.sk89q.worldguard.protection.flags.RegistryFlag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SKFlags {
    static final Map<String, Flag<?>> FLAG_CACHE = new HashMap();

    public static Flag<?> GetFlag(String flagName, Target t) {
        Flag<?> cachedFlag = FLAG_CACHE.get(flagName);
        if (cachedFlag == null) {
            String filteredFlag = flagName.replace("-", "");
            for (Flag flag : WorldGuard.getInstance().getFlagRegistry().getAll()) {
                if (!flag.getName().replace("-", "").equalsIgnoreCase(filteredFlag)) continue;
                FLAG_CACHE.put(flagName, flag);
                return flag;
            }
            throw new CREPluginInternalException(String.format("Unknown flag specified: (%s).", flagName), t);
        }
        return cachedFlag;
    }

    public static Mixed ConvertFlagValue(Flag<?> flag, Object flagValue, Target t) {
        if (flag instanceof StateFlag) {
            StateFlag.State state = ((StateFlag)flag).unmarshal(flagValue);
            if (state != null) {
                return CBoolean.get((state == StateFlag.State.ALLOW ? 1 : 0) != 0);
            }
            return CNull.NULL;
        }
        if (flag instanceof BooleanFlag) {
            Boolean value = ((BooleanFlag)flag).unmarshal(flagValue);
            if (value != null) {
                return CBoolean.get((boolean)value);
            }
            return CNull.NULL;
        }
        if (flag instanceof DoubleFlag) {
            Double value = ((DoubleFlag)flag).unmarshal(flagValue);
            if (value != null) {
                return new CDouble(value.doubleValue(), t);
            }
            return CNull.NULL;
        }
        if (flag instanceof EnumFlag) {
            return new CString(((EnumFlag)flag).unmarshal(flag).name(), t);
        }
        if (flag instanceof IntegerFlag) {
            Integer value = ((IntegerFlag)flag).unmarshal(flagValue);
            if (value != null) {
                return new CInt((long)value.intValue(), t);
            }
            return CNull.NULL;
        }
        if (flag instanceof LocationFlag) {
            Location loc = null;
            if (flagValue instanceof Map) {
                loc = ((LocationFlag)flag).unmarshal(flagValue);
            } else if (flagValue instanceof Location) {
                loc = (Location)flagValue;
            }
            if (loc == null) {
                return CNull.NULL;
            }
            return ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation(BukkitAdapter.adapt((Location)loc)), true);
        }
        if (flag instanceof SetFlag) {
            CArray values = new CArray(t);
            Set setValue = ((SetFlag)flag).unmarshal(flagValue);
            if (setValue != null) {
                for (Object setFlag : setValue) {
                    String value;
                    if (setFlag instanceof String) {
                        value = (String)setFlag;
                        values.push((Mixed)new CString(value, t), t);
                        continue;
                    }
                    if (setFlag instanceof EntityType) {
                        value = ((EntityType)setFlag).getName();
                        values.push((Mixed)new CString(value, t), t);
                        continue;
                    }
                    ConfigRuntimeException.DoWarning((String)"One of the element of flag has unknown type. This is a developer mistake, please file a ticket.");
                }
            }
            return values;
        }
        if (flag instanceof StringFlag) {
            String value = ((StringFlag)flag).unmarshal(flagValue);
            if (value != null) {
                return new CString(value, t);
            }
            return CNull.NULL;
        }
        if (flag instanceof RegistryFlag) {
            Keyed value = ((RegistryFlag)flag).unmarshal(flagValue);
            if (value != null) {
                return new CString(value.toString(), t);
            }
            return CNull.NULL;
        }
        throw new CRENotFoundException("The flag type is unknown. This is a developer mistake, please file a ticket.", t);
    }

    public static Flag<?> CreateFlag(String flagName, String flagType, Target t) {
        if (!Flag.isValidName((String)flagName)) {
            throw new CREFormatException("Invalid flag name.", t);
        }
        try {
            Class<?> flagClass = FlagType.valueOf((String)flagType.toUpperCase()).flagClass;
            return (Flag)ReflectionUtils.newInstance(flagClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{flagName});
        }
        catch (IllegalArgumentException ex) {
            throw new CREIllegalArgumentException("Invalid flag type: " + flagType + ". Must be one of: " + StringUtils.Join((Object[])FlagType.values(), (String)", ", (String)", or "), t);
        }
        catch (ReflectionUtils.ReflectionException ex) {
            throw new CREException("Failed to create new flag.", t);
        }
    }

    private static enum FlagType {
        BOOLEAN(BooleanFlag.class),
        DOUBLE(DoubleFlag.class),
        INTEGER(IntegerFlag.class),
        LOCATION(LocationFlag.class),
        STRING(StringFlag.class);

        final Class<?> flagClass;

        private FlagType(Class<?> flagClass) {
            this.flagClass = flagClass;
        }
    }
}

