/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import java.util.logging.Level;
import net.TheDgtl.Stargate.Blox;
import net.TheDgtl.Stargate.BloxPopulator;
import net.TheDgtl.Stargate.EconomyHandler;
import net.TheDgtl.Stargate.Gate;
import net.TheDgtl.Stargate.RelativeBlockVector;
import net.TheDgtl.Stargate.Stargate;
import net.TheDgtl.Stargate.event.StargateActivateEvent;
import net.TheDgtl.Stargate.event.StargateCloseEvent;
import net.TheDgtl.Stargate.event.StargateCreateEvent;
import net.TheDgtl.Stargate.event.StargateDeactivateEvent;
import net.TheDgtl.Stargate.event.StargateOpenEvent;
import net.TheDgtl.Stargate.event.StargatePortalEvent;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Portal {
    private static final HashMap<Blox, Portal> lookupBlocks = new HashMap();
    private static final HashMap<Blox, Portal> lookupEntrances = new HashMap();
    private static final HashMap<Blox, Portal> lookupControls = new HashMap();
    private static final ArrayList<Portal> allPortals = new ArrayList();
    private static final HashMap<String, ArrayList<String>> allPortalsNet = new HashMap();
    private static final HashMap<String, HashMap<String, Portal>> lookupNamesNet = new HashMap();
    private static final HashMap<String, Portal> bungeePortals = new HashMap();
    private final Blox topLeft;
    private final int modX;
    private final int modZ;
    private final float rotX;
    private final Axis rot;
    private final Blox id;
    private Blox button;
    private Blox[] frame;
    private Blox[] entrances;
    private String name;
    private String destination;
    private String lastDest = "";
    private String network;
    private final Gate gate;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private final World world;
    private boolean verified;
    private boolean fixed;
    private boolean hidden = false;
    private boolean alwaysOn = false;
    private boolean priv = false;
    private boolean free = false;
    private boolean backwards = false;
    private boolean show = false;
    private boolean noNetwork = false;
    private boolean random = false;
    private boolean bungee = false;
    private Player player;
    private Player activePlayer;
    private ArrayList<String> destinations = new ArrayList();
    private boolean isOpen = false;
    private long openTime;

    private Portal(Blox topLeft, int modX, int modZ, float rotX, Blox id, Blox button, String dest, String name, boolean verified, String network, Gate gate, UUID ownerUUID, String ownerName, boolean hidden, boolean alwaysOn, boolean priv, boolean free, boolean backwards, boolean show, boolean noNetwork, boolean random, boolean bungee) {
        this.topLeft = topLeft;
        this.modX = modX;
        this.modZ = modZ;
        this.rotX = rotX;
        this.rot = rotX == 0.0f || rotX == 180.0f ? Axis.X : Axis.Z;
        this.id = id;
        this.destination = dest;
        this.button = button;
        this.verified = verified;
        this.network = network;
        this.name = name;
        this.gate = gate;
        this.ownerUUID = ownerUUID;
        this.ownerName = ownerName;
        this.hidden = hidden;
        this.alwaysOn = alwaysOn;
        this.priv = priv;
        this.free = free;
        this.backwards = backwards;
        this.show = show;
        this.noNetwork = noNetwork;
        this.random = random;
        this.bungee = bungee;
        this.world = topLeft.getWorld();
        boolean bl = this.fixed = dest.length() > 0 || this.random || this.bungee;
        if (this.isAlwaysOn() && !this.isFixed()) {
            this.alwaysOn = false;
            Stargate.debug("Portal", "Can not create a non-fixed always-on gate. Setting AlwaysOn = false");
        }
        if (this.random && !this.isAlwaysOn()) {
            this.alwaysOn = true;
            Stargate.debug("Portal", "Gate marked as random, set to always-on");
        }
        if (verified) {
            this.drawSign();
        }
    }

    public boolean isOpen() {
        return this.isOpen || this.isAlwaysOn();
    }

    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public boolean isShown() {
        return this.show;
    }

    public boolean isNoNetwork() {
        return this.noNetwork;
    }

    public boolean isRandom() {
        return this.random;
    }

    public boolean isBungee() {
        return this.bungee;
    }

    public void setAlwaysOn(boolean alwaysOn) {
        this.alwaysOn = alwaysOn;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setPrivate(boolean priv) {
        this.priv = priv;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public void setBackwards(boolean backwards) {
        this.backwards = backwards;
    }

    public void setShown(boolean show) {
        this.show = show;
    }

    public void setNoNetwork(boolean noNetwork) {
        this.noNetwork = noNetwork;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public float getRotation() {
        return this.rotX;
    }

    public Axis getAxis() {
        return this.rot;
    }

    public Player getActivePlayer() {
        return this.activePlayer;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Portal.filterName(name);
        this.drawSign();
    }

    public Portal getDestination(Player player) {
        if (this.isRandom()) {
            this.destinations = this.getDestinations(player, this.getNetwork());
            if (this.destinations.size() == 0) {
                return null;
            }
            String dest = this.destinations.get(new Random().nextInt(this.destinations.size()));
            this.destinations.clear();
            return Portal.getByName(dest, this.getNetwork());
        }
        return Portal.getByName(this.destination, this.getNetwork());
    }

    public Portal getDestination() {
        return this.getDestination(null);
    }

    public void setDestination(Portal destination) {
        this.setDestination(destination.getName());
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destination;
    }

    public Gate getGate() {
        return this.gate;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwner(UUID owner) {
        this.ownerUUID = owner;
    }

    public boolean isOwner(Player player) {
        if (this.ownerUUID != null) {
            return player.getUniqueId().compareTo(this.ownerUUID) == 0;
        }
        return player.getName().equalsIgnoreCase(this.ownerName);
    }

    public Blox[] getEntrances() {
        if (this.entrances == null) {
            RelativeBlockVector[] space = this.gate.getEntrances();
            this.entrances = new Blox[space.length];
            int i = 0;
            for (RelativeBlockVector vector : space) {
                this.entrances[i++] = this.getBlockAt(vector);
            }
        }
        return this.entrances;
    }

    public Blox[] getFrame() {
        if (this.frame == null) {
            RelativeBlockVector[] border = this.gate.getBorder();
            this.frame = new Blox[border.length];
            int i = 0;
            for (RelativeBlockVector vector : border) {
                this.frame[i++] = this.getBlockAt(vector);
            }
        }
        return this.frame;
    }

    public Blox getSign() {
        return this.id;
    }

    public World getWorld() {
        return this.world;
    }

    public Blox getButton() {
        return this.button;
    }

    public void setButton(Blox button) {
        this.button = button;
    }

    public static ArrayList<String> getNetwork(String network) {
        return allPortalsNet.get(network.toLowerCase());
    }

    public boolean open(boolean force) {
        return this.open(null, force);
    }

    public boolean open(Player openFor, boolean force) {
        StargateOpenEvent event = new StargateOpenEvent(openFor, this, force);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        force = event.getForce();
        if (this.isOpen() && !force) {
            return false;
        }
        Material openType = this.gate.getPortalBlockOpen();
        Axis ax = openType == Material.NETHER_PORTAL ? this.rot : null;
        for (Blox inside : this.getEntrances()) {
            Stargate.blockPopulatorQueue.add(new BloxPopulator(inside, openType, ax));
        }
        this.isOpen = true;
        this.openTime = System.currentTimeMillis() / 1000L;
        Stargate.openList.add(this);
        Stargate.activeList.remove(this);
        if (!this.isAlwaysOn()) {
            this.player = openFor;
            Portal end = this.getDestination();
            if (!(this.random || end == null || end.isFixed() && !end.getDestinationName().equalsIgnoreCase(this.getName()) || end.isOpen())) {
                end.open(openFor, false);
                end.setDestination(this);
                if (end.isVerified()) {
                    end.drawSign();
                }
            }
        }
        return true;
    }

    public void close(boolean force) {
        Portal end;
        if (!this.isOpen) {
            return;
        }
        StargateCloseEvent event = new StargateCloseEvent(this, force);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        force = event.getForce();
        if (this.isAlwaysOn() && !force) {
            return;
        }
        Material closedType = this.gate.getPortalBlockClosed();
        for (Blox inside : this.getEntrances()) {
            Stargate.blockPopulatorQueue.add(new BloxPopulator(inside, closedType));
        }
        this.player = null;
        this.isOpen = false;
        Stargate.openList.remove(this);
        Stargate.activeList.remove(this);
        if (!this.isAlwaysOn() && (end = this.getDestination()) != null && end.isOpen()) {
            end.deactivate();
            end.close(false);
        }
        this.deactivate();
    }

    public boolean isOpenFor(Player player) {
        if (!this.isOpen) {
            return false;
        }
        if (this.isAlwaysOn() || this.player == null) {
            return true;
        }
        return player != null && player.getName().equalsIgnoreCase(this.player.getName());
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isPowered() {
        RelativeBlockVector[] controls;
        for (RelativeBlockVector vector : controls = this.gate.getControls()) {
            BlockData data = this.getBlockAt(vector).getBlock().getBlockData();
            if (!(data instanceof Powerable) || !((Powerable)data).isPowered()) continue;
            return true;
        }
        return false;
    }

    public void teleport(Player player, Portal origin, PlayerMoveEvent event) {
        Location traveller = player.getLocation();
        Location exit = this.getExit(traveller);
        int adjust = 180;
        if (this.isBackwards() != origin.isBackwards()) {
            adjust = 0;
        }
        exit.setYaw(traveller.getYaw() - origin.getRotation() + this.getRotation() + (float)adjust);
        if (!origin.equals(this)) {
            StargatePortalEvent pEvent = new StargatePortalEvent(player, origin, this, exit);
            Stargate.server.getPluginManager().callEvent((Event)pEvent);
            if (pEvent.isCancelled()) {
                origin.teleport(player, origin, event);
                return;
            }
            exit = pEvent.getExit();
        }
        if (event == null) {
            exit.setYaw(this.getRotation());
            player.teleport(exit);
        } else {
            event.setTo(exit);
        }
    }

    public void teleport(Vehicle vehicle) {
        Location traveller = new Location(this.world, vehicle.getLocation().getX(), vehicle.getLocation().getY(), vehicle.getLocation().getZ());
        Location exit = this.getExit(traveller);
        double velocity = vehicle.getVelocity().length();
        vehicle.setVelocity(new Vector());
        Vector newVelocity = new Vector((float)this.modX, 0.0f, (float)this.modZ);
        newVelocity.multiply(velocity);
        List passengers = vehicle.getPassengers();
        if (!passengers.isEmpty()) {
            Vehicle v = (Vehicle)exit.getWorld().spawn(exit, vehicle.getClass());
            Entity passenger = (Entity)passengers.get(0);
            vehicle.eject();
            vehicle.remove();
            passenger.eject();
            passenger.teleport(exit);
            Stargate.server.getScheduler().scheduleSyncDelayedTask((Plugin)Stargate.stargate, () -> {
                v.addPassenger(passenger);
                v.setVelocity(newVelocity);
            }, 1L);
        } else {
            Vehicle mc = (Vehicle)exit.getWorld().spawn(exit, vehicle.getClass());
            if (mc instanceof StorageMinecart) {
                StorageMinecart smc = (StorageMinecart)mc;
                smc.getInventory().setContents(((StorageMinecart)vehicle).getInventory().getContents());
            }
            mc.setVelocity(newVelocity);
            vehicle.remove();
        }
    }

    public Location getExit(Location traveller) {
        Location loc = null;
        if (this.gate.getExit() != null) {
            Blox exit = this.getBlockAt(this.gate.getExit());
            int back = this.isBackwards() ? -1 : 1;
            loc = exit.modRelativeLoc(0.0, 0.0, 1.0, traveller.getYaw(), traveller.getPitch(), this.modX * back, 1, this.modZ * back);
        } else {
            Stargate.log.log(Level.WARNING, "[Stargate] Missing destination point in .gate file " + this.gate.getFilename());
        }
        if (loc != null) {
            BlockData bd = this.getWorld().getBlockAt(loc).getBlockData();
            if (bd instanceof Bisected && ((Bisected)bd).getHalf() == Bisected.Half.BOTTOM) {
                loc.add(0.0, 0.5, 0.0);
            }
            loc.setPitch(traveller.getPitch());
            return loc;
        }
        return traveller;
    }

    public boolean isChunkLoaded() {
        return this.getWorld().isChunkLoaded(this.topLeft.getBlock().getChunk());
    }

    public boolean isVerified() {
        this.verified = true;
        if (!Stargate.verifyPortals) {
            return true;
        }
        for (RelativeBlockVector control : this.gate.getControls()) {
            this.verified = this.verified && this.getBlockAt(control).getBlock().getType().equals((Object)this.gate.getControlBlock());
        }
        return this.verified;
    }

    public boolean wasVerified() {
        if (!Stargate.verifyPortals) {
            return true;
        }
        return this.verified;
    }

    public boolean checkIntegrity() {
        if (!Stargate.verifyPortals) {
            return true;
        }
        return this.gate.matches(this.topLeft, this.modX, this.modZ);
    }

    public ArrayList<String> getDestinations(Player player, String network) {
        ArrayList<String> destinations = new ArrayList<String>();
        for (String dest : allPortalsNet.get(network.toLowerCase())) {
            Portal portal = Portal.getByName(dest, network);
            if (portal == null || portal.isRandom() || portal.isAlwaysOn() && !portal.isShown() || dest.equalsIgnoreCase(this.getName()) || portal.isFixed() && !portal.getDestinationName().equalsIgnoreCase(this.getName())) continue;
            if (player == null) {
                destinations.add(portal.getName());
                continue;
            }
            if (!Stargate.canAccessWorld(player, portal.getWorld().getName()) || !Stargate.canSee(player, portal)) continue;
            destinations.add(portal.getName());
        }
        return destinations;
    }

    public boolean activate(Player player) {
        this.destinations.clear();
        this.destination = "";
        Stargate.activeList.add(this);
        this.activePlayer = player;
        String network = this.getNetwork();
        this.destinations = this.getDestinations(player, network);
        if (Stargate.sortLists) {
            Collections.sort(this.destinations);
        }
        if (Stargate.destMemory && !this.lastDest.isEmpty() && this.destinations.contains(this.lastDest)) {
            this.destination = this.lastDest;
        }
        StargateActivateEvent event = new StargateActivateEvent(this, player, this.destinations, this.destination);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            Stargate.activeList.remove(this);
            return false;
        }
        this.destination = event.getDestination();
        this.destinations = event.getDestinations();
        this.drawSign();
        return true;
    }

    public void deactivate() {
        StargateDeactivateEvent event = new StargateDeactivateEvent(this);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Stargate.activeList.remove(this);
        if (this.isFixed()) {
            return;
        }
        this.destinations.clear();
        this.destination = "";
        this.activePlayer = null;
        this.drawSign();
    }

    public boolean isActive() {
        return this.isFixed() || this.destinations.size() > 0;
    }

    public void cycleDestination(Player player) {
        this.cycleDestination(player, 1);
    }

    public void cycleDestination(Player player, int dir) {
        boolean activate = false;
        if (!this.isActive() || this.getActivePlayer() != player) {
            if (!this.activate(player)) {
                return;
            }
            Stargate.debug("cycleDestination", "Network Size: " + allPortalsNet.get(this.network.toLowerCase()).size());
            Stargate.debug("cycleDestination", "Player has access to: " + this.destinations.size());
            activate = true;
        }
        if (this.destinations.size() == 0) {
            Stargate.sendMessage((CommandSender)player, Stargate.getString("destEmpty"));
            return;
        }
        if (!Stargate.destMemory || !activate || this.lastDest.isEmpty()) {
            int index = this.destinations.indexOf(this.destination);
            if ((index += dir) >= this.destinations.size()) {
                index = 0;
            } else if (index < 0) {
                index = this.destinations.size() - 1;
            }
            this.lastDest = this.destination = this.destinations.get(index);
        }
        this.openTime = System.currentTimeMillis() / 1000L;
        this.drawSign();
    }

    public final void drawSign() {
        BlockState state = this.id.getBlock().getState();
        if (!(state instanceof Sign)) {
            Stargate.log.warning("[Stargate] Sign block is not a Sign object");
            Stargate.debug("Portal::drawSign", "Block: " + this.id.getBlock().getType() + " @ " + this.id.getBlock().getLocation());
            return;
        }
        Sign sign = (Sign)state;
        Stargate.setLine(sign, 0, "-" + this.name + "-");
        int max = this.destinations.size() - 1;
        int done = 0;
        if (!this.isActive()) {
            Stargate.setLine(sign, ++done, Stargate.getString("signRightClick"));
            Stargate.setLine(sign, ++done, Stargate.getString("signToUse"));
            if (!this.noNetwork) {
                Stargate.setLine(sign, ++done, "(" + this.network + ")");
            }
        } else if (this.isBungee()) {
            Stargate.setLine(sign, ++done, Stargate.getString("bungeeSign"));
            Stargate.setLine(sign, ++done, ">" + this.destination + "<");
            Stargate.setLine(sign, ++done, "[" + this.network + "]");
        } else if (this.isFixed()) {
            if (this.isRandom()) {
                Stargate.setLine(sign, ++done, "> " + Stargate.getString("signRandom") + " <");
            } else {
                Stargate.setLine(sign, ++done, ">" + this.destination + "<");
            }
            if (this.noNetwork) {
                Stargate.setLine(sign, ++done, "");
            } else {
                Stargate.setLine(sign, ++done, "(" + this.network + ")");
            }
            Portal dest = Portal.getByName(this.destination, this.network);
            if (dest == null && !this.isRandom()) {
                Stargate.setLine(sign, ++done, Stargate.getString("signDisconnected"));
            } else {
                Stargate.setLine(sign, ++done, "");
            }
        } else {
            boolean green;
            Portal dest;
            int index = this.destinations.indexOf(this.destination);
            if (index == max && max > 1 && ++done <= 3) {
                if (EconomyHandler.useEconomy() && EconomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index - 2), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    Stargate.setLine(sign, done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index - 2));
                } else {
                    Stargate.setLine(sign, done, this.destinations.get(index - 2));
                }
            }
            if (index > 0 && ++done <= 3) {
                if (EconomyHandler.useEconomy() && EconomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index - 1), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    Stargate.setLine(sign, done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index - 1));
                } else {
                    Stargate.setLine(sign, done, this.destinations.get(index - 1));
                }
            }
            if (++done <= 3) {
                if (EconomyHandler.useEconomy() && EconomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destination, this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    Stargate.setLine(sign, done, (green ? ChatColor.DARK_GREEN : "") + ">" + this.destination + "<");
                } else {
                    Stargate.setLine(sign, done, " >" + this.destination + "< ");
                }
            }
            if (max >= index + 1 && ++done <= 3) {
                if (EconomyHandler.useEconomy() && EconomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index + 1), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    Stargate.setLine(sign, done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index + 1));
                } else {
                    Stargate.setLine(sign, done, this.destinations.get(index + 1));
                }
            }
            if (max >= index + 2 && ++done <= 3) {
                if (EconomyHandler.useEconomy() && EconomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index + 2), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    Stargate.setLine(sign, done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index + 2));
                } else {
                    Stargate.setLine(sign, done, this.destinations.get(index + 2));
                }
            }
        }
        ++done;
        while (done <= 3) {
            sign.setLine(done, "");
            ++done;
        }
        sign.update();
    }

    public void unregister(boolean removeAll) {
        Stargate.debug("Unregister", "Unregistering gate " + this.getName());
        this.close(true);
        for (Blox block : this.getFrame()) {
            lookupBlocks.remove(block);
        }
        lookupBlocks.remove(this.id);
        if (this.button != null) {
            lookupBlocks.remove(this.button);
        }
        lookupControls.remove(this.id);
        if (this.button != null) {
            lookupControls.remove(this.button);
        }
        for (Blox entrance : this.getEntrances()) {
            lookupEntrances.remove(entrance);
        }
        if (removeAll) {
            allPortals.remove(this);
        }
        if (this.bungee) {
            bungeePortals.remove(this.getName().toLowerCase());
        } else {
            lookupNamesNet.get(this.getNetwork().toLowerCase()).remove(this.getName().toLowerCase());
            allPortalsNet.get(this.getNetwork().toLowerCase()).remove(this.getName().toLowerCase());
            for (String originName : allPortalsNet.get(this.getNetwork().toLowerCase())) {
                Portal origin = Portal.getByName(originName, this.getNetwork());
                if (origin == null || !origin.getDestinationName().equalsIgnoreCase(this.getName()) || !origin.isVerified()) continue;
                if (origin.isFixed()) {
                    origin.drawSign();
                }
                if (!origin.isAlwaysOn()) continue;
                origin.close(true);
            }
        }
        if (this.id.getBlock().getBlockData() instanceof WallSign) {
            Sign sign = (Sign)this.id.getBlock().getState();
            sign.setLine(0, this.getName());
            sign.setLine(1, "");
            sign.setLine(2, "");
            sign.setLine(3, "");
            sign.update();
        }
        Portal.saveAllGates(this.getWorld());
    }

    private Blox getBlockAt(RelativeBlockVector vector) {
        return this.topLeft.modRelative(vector.getRight(), vector.getDepth(), vector.getDistance(), this.modX, 1, this.modZ);
    }

    private void register() {
        boolean bl = this.fixed = this.destination.length() > 0 || this.random || this.bungee;
        if (this.isBungee()) {
            bungeePortals.put(this.getName().toLowerCase(), this);
        } else {
            if (!lookupNamesNet.containsKey(this.getNetwork().toLowerCase())) {
                Stargate.debug("register", "Network " + this.getNetwork() + " not in lookupNamesNet, adding");
                lookupNamesNet.put(this.getNetwork().toLowerCase(), new HashMap());
            }
            lookupNamesNet.get(this.getNetwork().toLowerCase()).put(this.getName().toLowerCase(), this);
            if (!allPortalsNet.containsKey(this.getNetwork().toLowerCase())) {
                Stargate.debug("register", "Network " + this.getNetwork() + " not in allPortalsNet, adding");
                allPortalsNet.put(this.getNetwork().toLowerCase(), new ArrayList());
            }
            allPortalsNet.get(this.getNetwork().toLowerCase()).add(this.getName().toLowerCase());
        }
        for (Blox block : this.getFrame()) {
            lookupBlocks.put(block, this);
        }
        lookupBlocks.put(this.id, this);
        if (this.button != null) {
            lookupBlocks.put(this.button, this);
        }
        lookupControls.put(this.id, this);
        if (this.button != null) {
            lookupControls.put(this.button, this);
        }
        for (Blox entrance : this.getEntrances()) {
            lookupEntrances.put(entrance, this);
        }
        allPortals.add(this);
    }

    public static Portal createPortal(SignChangeEvent event, Player player) {
        String world;
        Object p;
        boolean bungee;
        Blox id = new Blox(event.getBlock());
        Block idParent = id.getParent();
        if (idParent == null) {
            return null;
        }
        if (Gate.getGatesByControlBlock(idParent).length == 0) {
            return null;
        }
        if (Portal.getByBlock(idParent) != null) {
            Stargate.debug("createPortal", "idParent belongs to existing gate");
            return null;
        }
        Blox parent = new Blox(player.getWorld(), idParent.getX(), idParent.getY(), idParent.getZ());
        Blox topleft = null;
        String name = Portal.filterName(event.getLine(0));
        String destName = Portal.filterName(event.getLine(1));
        String network = Portal.filterName(event.getLine(2));
        String options = Portal.filterName(event.getLine(3)).toLowerCase();
        boolean hidden = options.indexOf(104) != -1;
        boolean alwaysOn = options.indexOf(97) != -1;
        boolean priv = options.indexOf(112) != -1;
        boolean free = options.indexOf(102) != -1;
        boolean backwards = options.indexOf(98) != -1;
        boolean show = options.indexOf(115) != -1;
        boolean noNetwork = options.indexOf(110) != -1;
        boolean random = options.indexOf(114) != -1;
        boolean bl = bungee = options.indexOf(117) != -1;
        if (hidden && !Stargate.canOption(player, "hidden")) {
            hidden = false;
        }
        if (alwaysOn && !Stargate.canOption(player, "alwayson")) {
            alwaysOn = false;
        }
        if (priv && !Stargate.canOption(player, "private")) {
            priv = false;
        }
        if (free && !Stargate.canOption(player, "free")) {
            free = false;
        }
        if (backwards && !Stargate.canOption(player, "backwards")) {
            backwards = false;
        }
        if (show && !Stargate.canOption(player, "show")) {
            show = false;
        }
        if (noNetwork && !Stargate.canOption(player, "nonetwork")) {
            noNetwork = false;
        }
        if (random && !Stargate.canOption(player, "random")) {
            random = false;
        }
        if (alwaysOn && destName.length() == 0) {
            alwaysOn = false;
        }
        if (show && !alwaysOn) {
            show = false;
        }
        if (random) {
            alwaysOn = true;
            show = false;
        }
        if (bungee) {
            alwaysOn = true;
            random = false;
        }
        int modX = 0;
        int modZ = 0;
        float rotX = 0.0f;
        BlockFace buttonfacing = BlockFace.DOWN;
        if (idParent.getX() > id.getBlock().getX()) {
            --modZ;
            rotX = 90.0f;
            buttonfacing = BlockFace.WEST;
        } else if (idParent.getX() < id.getBlock().getX()) {
            ++modZ;
            rotX = 270.0f;
            buttonfacing = BlockFace.EAST;
        } else if (idParent.getZ() > id.getBlock().getZ()) {
            ++modX;
            rotX = 180.0f;
            buttonfacing = BlockFace.NORTH;
        } else if (idParent.getZ() < id.getBlock().getZ()) {
            --modX;
            rotX = 0.0f;
            buttonfacing = BlockFace.SOUTH;
        }
        Gate[] possibleGates = Gate.getGatesByControlBlock(idParent);
        Gate gate = null;
        RelativeBlockVector buttonVector = null;
        for (Gate possibility : possibleGates) {
            if (gate != null || buttonVector != null) continue;
            RelativeBlockVector[] vectors = possibility.getControls();
            RelativeBlockVector otherControl = null;
            for (RelativeBlockVector vector : vectors) {
                Blox tl = parent.modRelative(-vector.getRight(), -vector.getDepth(), -vector.getDistance(), modX, 1, modZ);
                if (gate == null) {
                    if (possibility.matches(tl, modX, modZ, true)) {
                        gate = possibility;
                        topleft = tl;
                        if (otherControl != null) {
                            buttonVector = otherControl;
                        }
                    }
                } else if (otherControl != null) {
                    buttonVector = vector;
                }
                otherControl = vector;
            }
        }
        if (gate == null || buttonVector == null) {
            Stargate.debug("createPortal", "Could not find matching gate layout");
            return null;
        }
        if (bungee) {
            if (!Stargate.enableBungee) {
                Stargate.sendMessage((CommandSender)player, Stargate.getString("bungeeDisabled"));
                return null;
            }
            if (!Stargate.hasPerm(player, "stargate.admin.bungee")) {
                Stargate.sendMessage((CommandSender)player, Stargate.getString("bungeeDeny"));
                return null;
            }
            if (destName.isEmpty() || network.isEmpty()) {
                Stargate.sendMessage((CommandSender)player, Stargate.getString("bungeeEmpty"));
                return null;
            }
        }
        Stargate.debug("createPortal", "h = " + hidden + " a = " + alwaysOn + " p = " + priv + " f = " + free + " b = " + backwards + " s = " + show + " n = " + noNetwork + " r = " + random + " u = " + bungee);
        if (!(bungee || network.length() >= 1 && network.length() <= 11)) {
            network = Stargate.getDefaultNetwork();
        }
        boolean deny = false;
        String denyMsg = "";
        if (!bungee && !Stargate.canCreate(player, network)) {
            Stargate.debug("createPortal", "Player doesn't have create permissions on network. Trying personal");
            if (Stargate.canCreatePersonal(player)) {
                network = player.getName();
                if (network.length() > 11) {
                    network = network.substring(0, 11);
                }
                Stargate.debug("createPortal", "Creating personal portal");
                Stargate.sendMessage((CommandSender)player, Stargate.getString("createPersonal"));
            } else {
                Stargate.debug("createPortal", "Player does not have access to network");
                deny = true;
                denyMsg = Stargate.getString("createNetDeny");
            }
        }
        String gateName = gate.getFilename();
        gateName = gateName.substring(0, gateName.indexOf(46));
        if (!deny && !Stargate.canCreateGate(player, gateName)) {
            Stargate.debug("createPortal", "Player does not have access to gate layout");
            deny = true;
            denyMsg = Stargate.getString("createGateDeny");
        }
        if (!(bungee || deny || destName.length() <= 0 || (p = Portal.getByName(destName, network)) == null || Stargate.canAccessWorld(player, world = ((Portal)p).getWorld().getName()))) {
            Stargate.debug("canCreate", "Player does not have access to destination world");
            deny = true;
            denyMsg = Stargate.getString("createWorldDeny");
        }
        for (RelativeBlockVector v : gate.getBorder()) {
            Blox b = topleft.modRelative(v.getRight(), v.getDepth(), v.getDistance(), modX, 1, modZ);
            if (Portal.getByBlock(b.getBlock()) == null) continue;
            Stargate.debug("createPortal", "Gate conflicts with existing gate");
            Stargate.sendMessage((CommandSender)player, Stargate.getString("createConflict"));
            return null;
        }
        Blox button = null;
        Portal portal = null;
        portal = new Portal(topleft, modX, modZ, rotX, id, button, destName, name, false, network, gate, player.getUniqueId(), player.getName(), hidden, alwaysOn, priv, free, backwards, show, noNetwork, random, bungee);
        int cost = Stargate.getCreateCost(player, gate);
        StargateCreateEvent cEvent = new StargateCreateEvent(player, portal, event.getLines(), deny, denyMsg, cost);
        Stargate.server.getPluginManager().callEvent((Event)cEvent);
        if (cEvent.isCancelled()) {
            return null;
        }
        if (cEvent.getDeny()) {
            Stargate.sendMessage((CommandSender)player, cEvent.getDenyReason());
            return null;
        }
        cost = cEvent.getCost();
        if (portal.getName().length() < 1 || portal.getName().length() > 11) {
            Stargate.debug("createPortal", "Name length error");
            Stargate.sendMessage((CommandSender)player, Stargate.getString("createNameLength"));
            return null;
        }
        if (portal.isBungee()) {
            if (bungeePortals.get(portal.getName().toLowerCase()) != null) {
                Stargate.debug("createPortal::Bungee", "Gate Exists");
                Stargate.sendMessage((CommandSender)player, Stargate.getString("createExists"));
                return null;
            }
        } else {
            if (Portal.getByName(portal.getName(), portal.getNetwork()) != null) {
                Stargate.debug("createPortal", "Name Error");
                Stargate.sendMessage((CommandSender)player, Stargate.getString("createExists"));
                return null;
            }
            ArrayList<String> netList = allPortalsNet.get(portal.getNetwork().toLowerCase());
            if (Stargate.maxGates > 0 && netList != null && netList.size() >= Stargate.maxGates) {
                Stargate.sendMessage((CommandSender)player, Stargate.getString("createFull"));
                return null;
            }
        }
        if (cost > 0) {
            if (!Stargate.chargePlayer(player, cost)) {
                String inFundMsg = Stargate.getString("ecoInFunds");
                inFundMsg = Stargate.replaceVars(inFundMsg, new String[]{"%cost%", "%portal%"}, new String[]{EconomyHandler.format(cost), name});
                Stargate.sendMessage((CommandSender)player, inFundMsg);
                Stargate.debug("createPortal", "Insufficient Funds");
                return null;
            }
            String deductMsg = Stargate.getString("ecoDeduct");
            deductMsg = Stargate.replaceVars(deductMsg, new String[]{"%cost%", "%portal%"}, new String[]{EconomyHandler.format(cost), name});
            Stargate.sendMessage((CommandSender)player, deductMsg, false);
        }
        if (!alwaysOn) {
            button = topleft.modRelative(buttonVector.getRight(), buttonVector.getDepth(), buttonVector.getDistance() + 1, modX, 1, modZ);
            Directional buttondata = (Directional)Bukkit.createBlockData((Material)gate.getButton());
            buttondata.setFacing(buttonfacing);
            button.getBlock().setBlockData((BlockData)buttondata);
            portal.setButton(button);
        }
        portal.register();
        portal.drawSign();
        if (portal.isRandom() || portal.isBungee()) {
            portal.open(true);
        } else if (portal.isAlwaysOn()) {
            Portal dest = Portal.getByName(destName, portal.getNetwork());
            if (dest != null) {
                portal.open(true);
                dest.drawSign();
            }
        } else {
            for (Blox inside : portal.getEntrances()) {
                inside.setType(portal.getGate().getPortalBlockClosed());
            }
        }
        if (!portal.isBungee()) {
            for (String originName : allPortalsNet.get(portal.getNetwork().toLowerCase())) {
                Portal origin = Portal.getByName(originName, portal.getNetwork());
                if (origin == null || !origin.getDestinationName().equalsIgnoreCase(portal.getName()) || !origin.isVerified()) continue;
                if (origin.isFixed()) {
                    origin.drawSign();
                }
                if (!origin.isAlwaysOn()) continue;
                origin.open(true);
            }
        }
        Portal.saveAllGates(portal.getWorld());
        return portal;
    }

    public static Portal getByName(String name, String network) {
        if (!lookupNamesNet.containsKey(network.toLowerCase())) {
            return null;
        }
        return lookupNamesNet.get(network.toLowerCase()).get(name.toLowerCase());
    }

    public static Portal getByEntrance(Location location) {
        return lookupEntrances.get(new Blox(location));
    }

    public static Portal getByEntrance(Block block) {
        return lookupEntrances.get(new Blox(block));
    }

    public static Portal getByAdjacentEntrance(Location loc) {
        int centerX = loc.getBlockX();
        int centerY = loc.getBlockY();
        int centerZ = loc.getBlockZ();
        World world = loc.getWorld();
        Portal portal = lookupEntrances.get(new Blox(world, centerX, centerY, centerZ));
        if (portal != null) {
            return portal;
        }
        portal = lookupEntrances.get(new Blox(world, centerX + 1, centerY, centerZ));
        if (portal != null) {
            return portal;
        }
        portal = lookupEntrances.get(new Blox(world, centerX - 1, centerY, centerZ));
        if (portal != null) {
            return portal;
        }
        portal = lookupEntrances.get(new Blox(world, centerX, centerY, centerZ + 1));
        if (portal != null) {
            return portal;
        }
        portal = lookupEntrances.get(new Blox(world, centerX, centerY, centerZ - 1));
        if (portal != null) {
            return portal;
        }
        return null;
    }

    public static Portal getByControl(Block block) {
        return lookupControls.get(new Blox(block));
    }

    public static Portal getByBlock(Block block) {
        return lookupBlocks.get(new Blox(block));
    }

    public static Portal getBungeeGate(String name) {
        return bungeePortals.get(name.toLowerCase());
    }

    public static void saveAllGates(World world) {
        Stargate.managedWorlds.add(world.getName());
        String loc = Stargate.getSaveLocation() + "/" + world.getName() + ".db";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(loc, false));
            for (Portal portal : allPortals) {
                String wName = portal.world.getName();
                if (!wName.equalsIgnoreCase(world.getName())) continue;
                StringBuilder builder = new StringBuilder();
                Blox sign = portal.id;
                Blox button = portal.button;
                builder.append(portal.name);
                builder.append(':');
                builder.append(sign.toString());
                builder.append(':');
                builder.append(button != null ? button.toString() : "");
                builder.append(':');
                builder.append(portal.modX);
                builder.append(':');
                builder.append(portal.modZ);
                builder.append(':');
                builder.append(portal.rotX);
                builder.append(':');
                builder.append(portal.topLeft.toString());
                builder.append(':');
                builder.append(portal.gate.getFilename());
                builder.append(':');
                builder.append(portal.isFixed() ? portal.getDestinationName() : "");
                builder.append(':');
                builder.append(portal.getNetwork());
                builder.append(':');
                UUID owner = portal.getOwnerUUID();
                if (owner != null) {
                    builder.append(portal.getOwnerUUID().toString());
                } else {
                    builder.append(portal.getOwnerName());
                }
                builder.append(':');
                builder.append(portal.isHidden());
                builder.append(':');
                builder.append(portal.isAlwaysOn());
                builder.append(':');
                builder.append(portal.isPrivate());
                builder.append(':');
                builder.append(portal.world.getName());
                builder.append(':');
                builder.append(portal.isFree());
                builder.append(':');
                builder.append(portal.isBackwards());
                builder.append(':');
                builder.append(portal.isShown());
                builder.append(':');
                builder.append(portal.isNoNetwork());
                builder.append(':');
                builder.append(portal.isRandom());
                builder.append(':');
                builder.append(portal.isBungee());
                bw.append(builder.toString());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            Stargate.log.log(Level.SEVERE, "Exception while writing stargates to " + loc + ": " + e);
        }
    }

    public static void clearGates() {
        lookupBlocks.clear();
        lookupNamesNet.clear();
        lookupEntrances.clear();
        lookupControls.clear();
        allPortals.clear();
        allPortalsNet.clear();
    }

    public static boolean loadAllGates(World world) {
        String location = Stargate.getSaveLocation();
        File db = new File(location, world.getName() + ".db");
        if (db.exists()) {
            int l = 0;
            int portalCount = 0;
            try {
                Scanner scanner = new Scanner(db);
                while (scanner.hasNextLine()) {
                    String ownerName;
                    String network;
                    ++l;
                    String line = scanner.nextLine().trim();
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] split = line.split(":");
                    if (split.length < 8) {
                        Stargate.log.info("[Stargate] Invalid line - " + l);
                        continue;
                    }
                    String name = split[0];
                    Blox sign = new Blox(world, split[1]);
                    Blox button = split[2].length() > 0 ? new Blox(world, split[2]) : null;
                    int modX = Integer.parseInt(split[3]);
                    int modZ = Integer.parseInt(split[4]);
                    float rotX = Float.parseFloat(split[5]);
                    Blox topLeft = new Blox(world, split[6]);
                    Gate gate = Gate.getGateByName(split[7]);
                    if (gate == null) {
                        Stargate.log.info("[Stargate] Gate layout on line " + l + " does not exist [" + split[7] + "]");
                        continue;
                    }
                    String dest = split.length > 8 ? split[8] : "";
                    String string = network = split.length > 9 ? split[9] : Stargate.getDefaultNetwork();
                    if (network.isEmpty()) {
                        network = Stargate.getDefaultNetwork();
                    }
                    String ownerString = split.length > 10 ? split[10] : "";
                    boolean hidden = split.length > 11 && split[11].equalsIgnoreCase("true");
                    boolean alwaysOn = split.length > 12 && split[12].equalsIgnoreCase("true");
                    boolean priv = split.length > 13 && split[13].equalsIgnoreCase("true");
                    boolean free = split.length > 15 && split[15].equalsIgnoreCase("true");
                    boolean backwards = split.length > 16 && split[16].equalsIgnoreCase("true");
                    boolean show = split.length > 17 && split[17].equalsIgnoreCase("true");
                    boolean noNetwork = split.length > 18 && split[18].equalsIgnoreCase("true");
                    boolean random = split.length > 19 && split[19].equalsIgnoreCase("true");
                    boolean bungee = split.length > 20 && split[20].equalsIgnoreCase("true");
                    UUID ownerUUID = null;
                    if (ownerString.length() > 16) {
                        try {
                            ownerUUID = UUID.fromString(ownerString);
                            OfflinePlayer offlineOwner = Bukkit.getServer().getOfflinePlayer(ownerUUID);
                            ownerName = offlineOwner.getName();
                        }
                        catch (IllegalArgumentException ex) {
                            ownerName = ownerString;
                            Stargate.debug("loadAllGates", "Invalid Stargate owner string: " + ownerString);
                        }
                    } else {
                        ownerName = ownerString;
                    }
                    Portal portal = new Portal(topLeft, modX, modZ, rotX, sign, button, dest, name, false, network, gate, ownerUUID, ownerName, hidden, alwaysOn, priv, free, backwards, show, noNetwork, random, bungee);
                    portal.register();
                    portal.close(true);
                }
                scanner.close();
                int OpenCount = 0;
                Iterator<Portal> iter = allPortals.iterator();
                while (iter.hasNext()) {
                    Portal portal = iter.next();
                    if (portal == null) continue;
                    if (!(portal.wasVerified() || portal.isVerified() && portal.checkIntegrity())) {
                        for (RelativeBlockVector control : portal.getGate().getControls()) {
                            if (portal.getBlockAt(control).getBlock().getType().equals((Object)portal.getGate().getControlBlock())) continue;
                            Stargate.debug("loadAllGates", "Control Block Type == " + portal.getBlockAt(control).getBlock().getType().name());
                        }
                        portal.unregister(false);
                        iter.remove();
                        Stargate.log.info("[Stargate] Destroying stargate at " + portal.toString());
                        continue;
                    }
                    ++portalCount;
                    if (!portal.isFixed() || (!Stargate.enableBungee || !portal.isBungee()) && (portal.getDestination() == null || !portal.isAlwaysOn())) continue;
                    portal.open(true);
                    ++OpenCount;
                }
                Stargate.log.info("[Stargate] {" + world.getName() + "} Loaded " + portalCount + " stargates with " + OpenCount + " set as always-on");
                return true;
            }
            catch (Exception e) {
                Stargate.log.log(Level.SEVERE, "Exception while reading stargates from " + db.getName() + ": " + l);
                e.printStackTrace();
            }
        } else {
            Stargate.log.info("[Stargate] {" + world.getName() + "} No stargates for world ");
        }
        return false;
    }

    public static void closeAllGates() {
        Stargate.log.info("Closing all stargates.");
        for (Portal p : allPortals) {
            if (p == null) continue;
            p.close(true);
        }
    }

    public static String filterName(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[\\|:#]", "").trim();
    }

    public String toString() {
        return String.format("Portal [id=%s, network=%s name=%s, type=%s]", this.id, this.network, this.name, this.gate.getFilename());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Portal other = (Portal)obj;
        if (this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        return !(this.network == null ? other.network != null : !this.network.equalsIgnoreCase(other.network));
    }
}

