/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.TheDgtl.Stargate.Stargate;
import org.bukkit.ChatColor;

public class LangLoader {
    private final String UTF8_BOM = "\ufeff";
    private final String datFolder;
    private String lang;
    private HashMap<String, String> strList;
    private final HashMap<String, String> defList;

    public LangLoader(String datFolder, String lang) {
        this.lang = lang;
        this.datFolder = datFolder;
        File tmp = new File(datFolder, lang + ".txt");
        if (!tmp.exists()) {
            tmp.getParentFile().mkdirs();
        }
        this.updateLanguage(lang);
        this.strList = this.load(lang);
        InputStream is = Stargate.class.getResourceAsStream("resources/" + lang + ".txt");
        if (is != null) {
            this.defList = this.load("en", is);
        } else {
            this.defList = null;
            Stargate.log.severe("[Stargate] Error loading backup language. There may be missing text ingame");
        }
    }

    public boolean reload() {
        this.updateLanguage(this.lang);
        this.strList = this.load(this.lang);
        return true;
    }

    public String getString(String name) {
        String val = this.strList.get(name);
        if (val == null && this.defList != null) {
            val = this.defList.get(name);
        }
        if (val == null) {
            return "";
        }
        return val;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLanguage(String lang) {
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<String> valList = new ArrayList<String>();
        HashMap<String, String> curLang = this.load(lang);
        InputStream is = Stargate.class.getResourceAsStream("resources/" + lang + ".txt");
        if (is == null) {
            return;
        }
        boolean updated = false;
        FileOutputStream fos = null;
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            boolean firstLine = true;
            while (line != null) {
                if (firstLine) {
                    line = this.removeUTF8BOM(line);
                }
                firstLine = false;
                int eq = line.indexOf(61);
                if (eq == -1) {
                    keyList.add("");
                    valList.add("");
                    line = br.readLine();
                    continue;
                }
                String key = line.substring(0, eq);
                String val = line.substring(eq);
                if (curLang == null || curLang.get(key) == null) {
                    keyList.add(key);
                    valList.add(val);
                    updated = true;
                } else {
                    keyList.add(key);
                    valList.add("=" + curLang.get(key).replace('\u00a7', '&'));
                    curLang.remove(key);
                }
                line = br.readLine();
            }
            br.close();
            fos = new FileOutputStream(this.datFolder + lang + ".txt");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            BufferedWriter bw = new BufferedWriter(out);
            for (int i = 0; i < keyList.size(); ++i) {
                bw.write((String)keyList.get(i) + (String)valList.get(i));
                bw.newLine();
            }
            bw.newLine();
            if (curLang != null) {
                for (String key : curLang.keySet()) {
                    bw.write(key + "=" + curLang.get(key));
                    bw.newLine();
                }
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        if (updated) {
            Stargate.log.info("[Stargate] Your language file (" + lang + ".txt) has been updated");
        }
    }

    private HashMap<String, String> load(String lang) {
        return this.load(lang, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> load(String lang, InputStream is) {
        HashMap<String, String> strings = new HashMap<String, String>();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            if (is == null) {
                fis = new FileInputStream(this.datFolder + lang + ".txt");
                isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            } else {
                isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            }
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            boolean firstLine = true;
            while (line != null) {
                if (firstLine) {
                    line = this.removeUTF8BOM(line);
                }
                firstLine = false;
                int eq = line.indexOf(61);
                if (eq == -1) {
                    line = br.readLine();
                    continue;
                }
                String key = line.substring(0, eq);
                String val = ChatColor.translateAlternateColorCodes((char)'&', (String)line.substring(eq + 1));
                strings.put(key, val);
                line = br.readLine();
            }
        }
        catch (Exception ex) {
            HashMap<String, String> hashMap = null;
            return hashMap;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return strings;
    }

    public void debug() {
        Set<String> keys = this.strList.keySet();
        for (String key : keys) {
            Stargate.debug("LangLoader::Debug::strList", key + " => " + this.strList.get(key));
        }
        if (this.defList == null) {
            return;
        }
        keys = this.defList.keySet();
        for (String key : keys) {
            Stargate.debug("LangLoader::Debug::defList", key + " => " + this.defList.get(key));
        }
    }

    private String removeUTF8BOM(String s) {
        if (s.startsWith("\ufeff")) {
            s = s.substring(1);
        }
        return s;
    }
}

