/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.nativelib;

import java.io.IOException;
import org.scijava.nativelib.DefaultJniExtractor;
import org.scijava.nativelib.JniExtractor;
import org.scijava.nativelib.NativeLibraryUtil;
import org.scijava.nativelib.WebappJniExtractor;

public class NativeLoader {
    private static JniExtractor jniExtractor = null;

    public static void loadLibrary(String libName, String ... searchPaths) throws IOException {
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            if (NativeLibraryUtil.loadNativeLibrary(jniExtractor, libName, searchPaths)) {
                return;
            }
            throw new IOException("Couldn't load library library " + libName, e);
        }
    }

    public static void extractRegistered() throws IOException {
        jniExtractor.extractRegistered();
    }

    public static JniExtractor getJniExtractor() {
        return jniExtractor;
    }

    public static void setJniExtractor(JniExtractor jniExtractor) {
        NativeLoader.jniExtractor = jniExtractor;
    }

    static {
        try {
            jniExtractor = NativeLoader.class.getClassLoader() == ClassLoader.getSystemClassLoader() ? new DefaultJniExtractor(null) : new WebappJniExtractor("Classloader");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

