/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.msserialconnection;

import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.compiler.signature.FunctionSignature;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.compiler.signature.Param;
import com.laytonsmith.core.compiler.signature.SignatureBuilder;
import com.laytonsmith.core.compiler.signature.Throws;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.pieter12345.msserialconnection.MSSerialConnection;
import io.github.pieter12345.msserialconnection.SerialDataAvailableEvent;
import io.github.pieter12345.msserialconnection.SerialOutputBufferEmptyEvent;
import io.github.pieter12345.msserialconnection.exceptions.CRE.CREIllegalStateException;
import io.github.pieter12345.msserialconnection.exceptions.CRE.CRESerialPortException;
import java.util.HashSet;
import java.util.TreeSet;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class SerialConnectionFunctions {
    public static String docs() {
        return "Provides serial connection API that can be used to communicate with serial devices through COMPORT/USB.";
    }

    public static abstract class SerialConnectionFunction
    extends AbstractFunction {
        private Integer[] numArgs = null;
        private Class<? extends CREThrowable>[] thrown = null;

        public String getName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public Integer[] numArgs() {
            if (this.numArgs != null) {
                return this.numArgs;
            }
            FunctionSignatures signatures = this.getCachedSignatures();
            if (signatures == null) {
                throw new Error("Missing numArgs() or getSignatures() implementation in " + this.getName() + "().");
            }
            TreeSet<Integer> numArgsSet = new TreeSet<Integer>();
            for (FunctionSignature signature : signatures.getSignatures()) {
                int numOptionalParams = 0;
                for (Param param : signature.getParams()) {
                    if (param.isVarParam()) {
                        this.numArgs = new Integer[]{Integer.MAX_VALUE};
                        return this.numArgs;
                    }
                    if (!param.isOptional()) continue;
                    ++numOptionalParams;
                }
                int numParams = signature.getParams().size();
                for (int paramCount = numParams - numOptionalParams; paramCount <= numParams; ++paramCount) {
                    numArgsSet.add(paramCount);
                }
            }
            this.numArgs = numArgsSet.toArray(new Integer[numArgsSet.size()]);
            return this.numArgs;
        }

        public Class<? extends CREThrowable>[] thrown() {
            if (this.thrown != null) {
                return this.thrown;
            }
            FunctionSignatures signatures = this.getCachedSignatures();
            if (signatures == null) {
                throw new Error("Missing thrown() or getSignatures() implementation in " + this.getName() + "().");
            }
            HashSet<Class> possibleExceptionClasses = new HashSet<Class>();
            for (FunctionSignature signature : signatures.getSignatures()) {
                for (Throws throwsEx : signature.getThrows()) {
                    possibleExceptionClasses.add(throwsEx.getExceptionClass());
                }
            }
            this.thrown = possibleExceptionClasses.toArray(new Class[possibleExceptionClasses.size()]);
            return this.thrown;
        }

        public boolean isRestricted() {
            return false;
        }

        public Boolean runAsync() {
            return true;
        }

        public Version since() {
            return new SimpleVersion(1, 0, 0);
        }
    }

    @api
    public static class serial_read_bytes
    extends SerialConnectionFunction {
        public String docs() {
            return "byte_array {string serialPort, int length, [int timeoutMs]} Reads from the given serial connection. Returns the read data when 'length' bytes have been read or when no data has been read for 'timeoutMs' milliseconds (-1 indicates no timeout). Throws IllegalArgumentException when length < 0 or timeoutMs < -1. Throws IllegalStateException when the given serial port is not open. Throws SerialPortException when reading from the serial port fails.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CByteArray.TYPE, "The read data.").param(CString.TYPE, "serialPort", "The serial port identifier.").param(CInt.TYPE, "length", "The maximum amount of data to read.").param(CInt.TYPE, "timeoutMs", "The maximum amount of milliseconds to wait between reads before deciding that no more data is available. -1 indicates no timeout. Defaults to -1.", true).throwsEx(CREIllegalArgumentException.class, "when length < 0 or timeoutMs < -1.").throwsEx(CREIllegalStateException.class, "when the given serial port is not open.").throwsEx(CRESerialPortException.class, "when reading the data from the serial port fails.").build();
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            int timeoutMs;
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            int length = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            int n = timeoutMs = args.length >= 3 ? ArgumentValidation.getInt32((Mixed)args[2], (Target)t) : -1;
            if (length < 0) {
                throw new CREIllegalArgumentException("Length has to be >= 0 in " + this.getName() + ". Received: " + length, t);
            }
            if (timeoutMs < -1) {
                throw new CREIllegalArgumentException("Timeout has to be >= -1 in " + this.getName() + ". Received: " + timeoutMs, t);
            }
            SerialPort serialPort = MSSerialConnection.SERIAL_CONNECTIONS.get(portName);
            if (serialPort == null) {
                throw new CREIllegalStateException("Serial port is not open.", t);
            }
            try {
                int numBytesAvailable;
                int lastNumBytesAvailable = 0;
                long lastReceiveTime = System.currentTimeMillis();
                do {
                    if ((numBytesAvailable = serialPort.getInputBufferBytesCount()) == -1) {
                        throw new CRESerialPortException(serialPort, "Failed to read from serial port.", t);
                    }
                    if (numBytesAvailable >= length) break;
                    if (numBytesAvailable == lastNumBytesAvailable) continue;
                    lastNumBytesAvailable = numBytesAvailable;
                    lastReceiveTime = System.currentTimeMillis();
                } while (System.currentTimeMillis() - lastReceiveTime < (long)timeoutMs);
                byte[] readBytes = serialPort.readBytes(numBytesAvailable >= length ? length : numBytesAvailable);
                return CByteArray.wrap((byte[])readBytes, (Target)t);
            }
            catch (SerialPortException e) {
                throw new Error(e);
            }
        }
    }

    @api
    public static class serial_write_bytes
    extends SerialConnectionFunction {
        public String docs() {
            return "void {string serialPort, byte_array data, [int startInd], [int length]} Writes data to the given serial connection. When 'startInd' is given, writes bytes from the given data array starting at this index. When 'length' is given, writes this amount of bytes from the given data array starting at the start index. Throws IllegalStateException when the given serial port is not open. Throws RangeException when startInd and/or startInd + length is out of array bounds. Throws SerialPortException when writing the data to the serial port fails.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CVoid.TYPE).param(CString.TYPE, "serialPort", "The serial port identifier.").param(CByteArray.TYPE, "data", "The data array to write from.").param(CInt.TYPE, "startInd", "The start index in the data array from which to start writing.", true).param(CInt.TYPE, "length", "The amount of bytes from the data array to write.", true).throwsEx(CREIllegalStateException.class, "when the given serial port is not open.").throwsEx(CRERangeException.class, "when startInd and/or startInd + length is out of array bounds.").throwsEx(CRESerialPortException.class, "when writing the data to the serial port fails.").build();
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            SerialPort serialPort;
            int length;
            int startInd;
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            CByteArray data = ArgumentValidation.getByteArray((Mixed)args[1], (Target)t);
            if (args.length >= 3) {
                startInd = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
                if (startInd < 0 || (long)startInd > data.size()) {
                    throw new CRERangeException("Start index out of bounds in " + this.getName() + ": " + startInd, t);
                }
            } else {
                startInd = 0;
            }
            if (args.length >= 4) {
                length = ArgumentValidation.getInt32((Mixed)args[3], (Target)t);
                if (length < 0) {
                    throw new CRERangeException("Invalid length in " + this.getName() + ": " + length, t);
                }
                if ((long)(startInd + length) > data.size()) {
                    throw new CRERangeException("End index out of bounds in " + this.getName() + ": " + (startInd + length), t);
                }
            } else {
                length = (int)data.size() - startInd;
            }
            if (startInd != 0 || (long)length != data.size()) {
                data = data.getBytes(startInd, Integer.valueOf(length));
            }
            if ((serialPort = MSSerialConnection.SERIAL_CONNECTIONS.get(portName)) == null) {
                throw new CREIllegalStateException("Serial port is not open.", t);
            }
            try {
                if (!serialPort.writeBytes(data.asByteArrayCopy())) {
                    throw new CRESerialPortException(serialPort, "Failed to send data to serial port.", t);
                }
            }
            catch (SerialPortException e) {
                throw new Error(e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class serial_output_buffer_byte_count
    extends SerialConnectionFunction {
        public String docs() {
            return "int {string portName} Returns the number of bytes in the TX (output) buffer.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CInt.TYPE, "The number of bytes in the TX (output) buffer.").param(CString.TYPE, "portName", "The serial port identifier.").throwsEx(CREIllegalStateException.class, "when the given serial port is not open.").build();
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            SerialPort serialPort = MSSerialConnection.SERIAL_CONNECTIONS.get(portName);
            if (serialPort == null) {
                throw new CREIllegalStateException("Serial port is not open.", t);
            }
            try {
                return new CInt((long)serialPort.getOutputBufferBytesCount(), t);
            }
            catch (SerialPortException e) {
                throw new Error();
            }
        }
    }

    @api
    public static class serial_input_buffer_byte_count
    extends SerialConnectionFunction {
        public String docs() {
            return "int {string portName} Returns the number of bytes in the RX (input) buffer.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CInt.TYPE, "The number of bytes in the RX (input) buffer.").param(CString.TYPE, "portName", "The serial port identifier.").throwsEx(CREIllegalStateException.class, "when the given serial port is not open.").build();
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            SerialPort serialPort = MSSerialConnection.SERIAL_CONNECTIONS.get(portName);
            if (serialPort == null) {
                throw new CREIllegalStateException("Serial port is not open.", t);
            }
            try {
                return new CInt((long)serialPort.getInputBufferBytesCount(), t);
            }
            catch (SerialPortException e) {
                throw new Error();
            }
        }
    }

    @api
    public static class serial_disconnect
    extends SerialConnectionFunction {
        public String docs() {
            return "void {string portName} Disconnects the given serial port. Throws IllegalStateException when the given serial port is not open.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CVoid.TYPE).param(CString.TYPE, "portName", "The serial port identifier.").throwsEx(CREIllegalStateException.class, "when the given serial port is not open.").build();
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            SerialPort serialPort = MSSerialConnection.SERIAL_CONNECTIONS.remove(portName);
            if (serialPort == null) {
                throw new CREIllegalStateException("Serial port is not open.", t);
            }
            try {
                serialPort.closePort();
            }
            catch (SerialPortException serialPortException) {
                // empty catch block
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class serial_is_connected
    extends SerialConnectionFunction {
        public String docs() {
            return "boolean {string portName} Returns true if this port was opened by " + serial_connect.class.getSimpleName() + "(), and not yet closed by " + serial_disconnect.class.getSimpleName() + "(). Note that connection failures are not automatically detected, and therefore not considered by this function.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CBoolean.TYPE, "True if the given serial port is open.").param(CString.TYPE, "portName", "The serial port identifier.").build();
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            return CBoolean.GenerateCBoolean((boolean)MSSerialConnection.SERIAL_CONNECTIONS.containsKey(portName), (Target)t);
        }
    }

    @api
    public static class serial_connect
    extends SerialConnectionFunction {
        public String docs() {
            return "void {string portName, int baudRate, int numDataBits, int numStopBits, string parity, boolean setRTS, boolean setDTR} Opens a serial connection to the given serial port using the given parameters. parity has to be one of: PARITY_NONE, PARITY_ODD, PARITY_EVEN, PARITY_MARK and PARITY_SPACE. Many common microprocessors work with settings: numDataBits = 8, numStopBits = 1, parity = PARITY_NONE, setRTS = true and setDTR = true. Look up the specifications of your serial device if this does not work. Throws IllegalArgumentException when parity is not one of: PARITY_NONE, PARITY_ODD, PARITY_EVEN, PARITY_MARK and PARITY_SPACE. Throws IllegalStateException when the given serial port has already been opened by " + MSSerialConnection.class.getSimpleName() + ". Throws SerialPortException when the serial connection could not be set up.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CVoid.TYPE).param(CString.TYPE, "portName", "The serial port identifier.").param(CInt.TYPE, "baudRate", "The serial connection baud rate.").param(CInt.TYPE, "numDataBits", "The number of data bits. Binary data is typically transmitted as eight bits.").param(CInt.TYPE, "numStopBits", "The number of stop bits.").param(CString.TYPE, "parity", "One of: PARITY_NONE, PARITY_ODD, PARITY_EVEN, PARITY_MARK and PARITY_SPACE.").param(CBoolean.TYPE, "setRTS", "Send Request To Send on connect.").param(CBoolean.TYPE, "setDTR", "Send Data Terminal Ready on connect.").throwsEx(CREIllegalArgumentException.class, "when parity has an invalid value.").throwsEx(CREIllegalStateException.class, "when the given serial port is not open.").throwsEx(CRESerialPortException.class, "when the serial connection could not be set up.").build();
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            int baudRate = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            int numDataBits = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
            int numStopBits = ArgumentValidation.getInt32((Mixed)args[3], (Target)t);
            String parityStr = ArgumentValidation.getStringObject((Mixed)args[4], (Target)t);
            boolean setRTS = ArgumentValidation.getBooleanObject((Mixed)args[5], (Target)t);
            boolean setDTR = ArgumentValidation.getBooleanObject((Mixed)args[6], (Target)t);
            int parity = switch (parityStr.toUpperCase()) {
                case "PARITY_NONE" -> 0;
                case "PARITY_ODD" -> 1;
                case "PARITY_EVEN" -> 2;
                case "PARITY_MARK" -> 3;
                case "PARITY_SPACE" -> 4;
                default -> throw new CREIllegalArgumentException("Parity has to be one of: PARITY_NONE, PARITY_ODD, PARITY_EVEN, PARITY_MARK and PARITY_SPACE.", t);
            };
            if (MSSerialConnection.SERIAL_CONNECTIONS.containsKey(portName)) {
                throw new CREIllegalStateException("Serial port already opened by " + MSSerialConnection.class.getSimpleName() + ".", t);
            }
            SerialPort serialPort = new SerialPort(portName);
            try {
                serialPort.openPort();
            }
            catch (SerialPortException e) {
                throw new CRESerialPortException(serialPort, "Failed to open port: " + e.getExceptionType(), t);
            }
            try {
                if (!serialPort.setParams(baudRate, numDataBits, numStopBits, parity, setRTS, setDTR)) {
                    throw new CRESerialPortException(serialPort, "Failed to set serial port connection parameters.", t);
                }
            }
            catch (SerialPortException e) {
                throw new Error(e);
            }
            try {
                serialPort.addEventListener(serialPortEvent -> {
                    switch (serialPortEvent.getEventType()) {
                        case 1: {
                            int rxBufferByteCount = serialPortEvent.getEventValue();
                            EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"serial_data_available", (BindableEvent)new SerialDataAvailableEvent(serialPort, rxBufferByteCount));
                            break;
                        }
                        case 4: {
                            EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"serial_output_buffer_empty", (BindableEvent)new SerialOutputBufferEmptyEvent(serialPort));
                            break;
                        }
                    }
                }, 5);
            }
            catch (SerialPortException e) {
                throw new Error(e);
            }
            MSSerialConnection.SERIAL_CONNECTIONS.put(serialPort.getPortName(), serialPort);
            return CVoid.VOID;
        }
    }

    @api
    public static class serial_get_ports
    extends SerialConnectionFunction {
        public String docs() {
            return "array {} Returns an array containing all serial ports in the system. Returns null when serial port data could not be obtained due to a recently disconnected device.";
        }

        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CArray.TYPE, "An array containing all serial ports in the system.").build();
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray ret = new CArray(t);
            try {
                for (String portName : SerialPortList.getPortNames()) {
                    ret.push((Mixed)new CString(portName, t), t);
                }
            }
            catch (NullPointerException e) {
                return CNull.NULL;
            }
            return ret;
        }
    }
}

