/*
 * Decompiled with CFR 0.152.
 */
package com.methodscript.msxodus;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.methodscript.msxodus.MSXodus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;

public class Xodus {
    private static final String XODUS_ENV = "xodus_environment_store_transaction";

    private static StoreTransaction GetTransactionOrFail(com.laytonsmith.core.environments.Environment env, Target t) {
        StoreTransaction txn = (StoreTransaction)((GlobalEnv)env.getEnv(GlobalEnv.class)).GetCustom(XODUS_ENV);
        if (txn == null) {
            throw new CRENoXodusTransactionException("Cannot operate on an Xodus database outside of a transaction, call an xodus_transaction_* function first.", t);
        }
        return txn;
    }

    public static CArray EntityToArray(Entity entity) {
        CArray ret = CArray.GetAssociativeArray((Target)Target.UNKNOWN);
        CArray properties = CArray.GetAssociativeArray((Target)Target.UNKNOWN);
        Iterator<String> iterator = entity.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            Object prop;
            Comparable p = entity.getProperty((String)(prop = iterator.next()));
            properties.set((String)prop, (Mixed)(p == null ? CNull.NULL : new CString(p.toString(), Target.UNKNOWN)), Target.UNKNOWN);
        }
        CArray links = new CArray(Target.UNKNOWN);
        for (String link : entity.getLinkNames()) {
            links.push((Mixed)new CString(link, Target.UNKNOWN), Target.UNKNOWN);
        }
        CArray blobs = new CArray(Target.UNKNOWN);
        for (String blob : entity.getBlobNames()) {
            blobs.push((Mixed)new CString(blob, Target.UNKNOWN), Target.UNKNOWN);
        }
        ret.set("properties", (Mixed)properties, Target.UNKNOWN);
        ret.set("links", (Mixed)links, Target.UNKNOWN);
        ret.set("id", entity.toIdString());
        ret.set("blobs", (Mixed)blobs, Target.UNKNOWN);
        return ret;
    }

    public static Entity EntityFromArray(StoreTransaction trans, CArray entity, Target t) {
        return trans.getEntity(trans.toEntityId(entity.get("id", t).val()));
    }

    public static Entity EntityFromId(StoreTransaction trans, String id) {
        return trans.getEntity(trans.toEntityId(id));
    }

    public static Entity EntityFromMixed(StoreTransaction trans, Mixed entity, Target t) {
        if (entity instanceof CArray) {
            return Xodus.EntityFromArray(trans, (CArray)entity, t);
        }
        return Xodus.EntityFromId(trans, entity.val());
    }

    public static String docs() {
        return "Provides methods for manipulating an Xodus database.";
    }

    @typeof(value="ms.xodus.XodusTransactionException")
    public static class CRENoXodusTransactionException
    extends CREException {
        public static final CClassType TYPE = CClassType.get(CRENoXodusTransactionException.class);

        public CRENoXodusTransactionException(String msg, Target t) {
            super(msg, t);
        }

        public CRENoXodusTransactionException(String msg, Target t, Throwable th) {
            super(msg, t, th);
        }

        public String docs() {
            return "This exception is thrown if an function requiring an xodus transaction is called outside of an exception.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }

        public CClassType[] getSuperclasses() {
            return super.getSuperclasses();
        }

        public CClassType[] getInterfaces() {
            return super.getInterfaces();
        }
    }

    @api
    public static class xodus_read_blob
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIOException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(Target t, com.laytonsmith.core.environments.Environment environment, Mixed ... args) throws ConfigRuntimeException {
            try {
                StoreTransaction st = Xodus.GetTransactionOrFail(environment, t);
                Entity en = Xodus.EntityFromMixed(st, args[0], t);
                String blob = args[1].val();
                InputStream is = en.getBlob(blob);
                if (is == null) {
                    return CNull.NULL;
                }
                byte[] b = StreamUtils.GetBytes((InputStream)is);
                CByteArray ret = CByteArray.wrap((byte[])b, (Target)t);
                return ret;
            }
            catch (IOException ex) {
                throw new CREIOException(ex.getMessage(), t, (Throwable)ex);
            }
        }

        public String getName() {
            return "xodus_read_blob";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "byte_array {entity, blobName} Returns the blob with the given name. The entity may be the entire entity, or just the string id.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }
    }

    @api
    public static class xodus_read_links
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(Target t, com.laytonsmith.core.environments.Environment environment, Mixed ... args) throws ConfigRuntimeException {
            StoreTransaction st = Xodus.GetTransactionOrFail(environment, t);
            Entity en = Xodus.EntityFromMixed(st, args[0], t);
            String link = args[1].val();
            CArray ret = new CArray(t);
            for (Entity e : en.getLinks(link)) {
                ret.push((Mixed)new CString(e.toIdString(), t), t);
            }
            return ret;
        }

        public String getName() {
            return "xodus_read_links";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "array {entity, linkName} Given the entity, returns the ids for the given links, which can then be individually looked up if necessary. The entity may be the entire entity, or just the string id.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }
    }

    @api
    public static class xodus_entity_from_id
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(Target t, com.laytonsmith.core.environments.Environment environment, Mixed ... args) throws ConfigRuntimeException {
            StoreTransaction st = Xodus.GetTransactionOrFail(environment, t);
            String id = args[0].val();
            Entity e = st.getEntity(st.toEntityId(id));
            return Xodus.EntityToArray(e);
        }

        public String getName() {
            return "xodus_entity_from_id";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "array {entityId} Given an entity id string, returns the specified entity. The id reference may be obtained from a previous lookup, or for instance the links specified in the object.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }
    }

    @api
    public static class xodus_get_all
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(Target t, com.laytonsmith.core.environments.Environment environment, Mixed ... args) throws ConfigRuntimeException {
            StoreTransaction txn = Xodus.GetTransactionOrFail(environment, t);
            String type = args[0].val();
            CArray entities = new CArray(t);
            EntityIterable entityIterator = txn.getAll(type);
            for (Entity entity : entityIterator) {
                entities.push((Mixed)Xodus.EntityToArray(entity), t);
            }
            return entities;
        }

        public String getName() {
            return "xodus_get_all";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "array {type} Returns all entities of a particular type.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }
    }

    @api
    public static class xodus_get_types
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(Target t, com.laytonsmith.core.environments.Environment environment, Mixed ... args) throws ConfigRuntimeException {
            StoreTransaction txn = Xodus.GetTransactionOrFail(environment, t);
            CArray types = new CArray(t);
            for (String type : txn.getEntityTypes()) {
                types.push((Mixed)new CString(type, t), t);
            }
            return types;
        }

        public String getName() {
            return "xodus_get_types";
        }

        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        public String docs() {
            return "array {} Returns a list of types in the database.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }
    }

    @api
    public static class xodus_transaction_entity
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(final Target t, final com.laytonsmith.core.environments.Environment environment, Mixed ... args) throws ConfigRuntimeException {
            File xodusEnvironment = new File(args[0].val());
            String storeName = args[1].val();
            final CClosure callback = (CClosure)ArgumentValidation.getObject((Mixed)args[2], (Target)t, CClosure.class);
            boolean readOnly = false;
            if (args.length > 3) {
                readOnly = ArgumentValidation.getBooleanObject((Mixed)args[3], (Target)t);
            }
            if (!xodusEnvironment.isDirectory()) {
                throw new CREXodusException("environment must be a directory, \"" + xodusEnvironment.getAbsolutePath() + "\" is not a directory.", t);
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ClassDiscovery.getDefaultInstance().getDefaultClassLoader());
            try (Environment env = Environments.newInstance(xodusEnvironment, new EnvironmentConfig().setEnvIsReadonly(readOnly));
                 PersistentEntityStoreImpl entityStore = PersistentEntityStores.newInstance(env, storeName);){
                StoreTransactionalComputable<Mixed> exe = new StoreTransactionalComputable<Mixed>(){

                    @Override
                    public Mixed compute(StoreTransaction txn) {
                        ((GlobalEnv)environment.getEnv(GlobalEnv.class)).SetCustom(Xodus.XODUS_ENV, (Object)txn);
                        try {
                            Mixed mixed = callback.executeCallable(environment, t, new Mixed[0]);
                            return mixed;
                        }
                        catch (ConfigRuntimeException e) {
                            ConfigRuntimeException.HandleUncaughtException((ConfigRuntimeException)e, (com.laytonsmith.core.environments.Environment)environment);
                        }
                        catch (ProgramFlowManipulationException programFlowManipulationException) {
                        }
                        finally {
                            ((GlobalEnv)environment.getEnv(GlobalEnv.class)).SetCustom(Xodus.XODUS_ENV, null);
                        }
                        return CNull.NULL;
                    }
                };
                if (readOnly) {
                    entityStore.computeInReadonlyTransaction(exe);
                } else {
                    entityStore.computeInTransaction(exe);
                }
            }
            catch (ExodusException ex) {
                throw new CREXodusException(ex.getMessage(), t, ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "xodus_transaction_entity";
        }

        public Integer[] numArgs() {
            return new Integer[]{3, 4};
        }

        public String docs() {
            return "void {environment, callback, [readOnly=false]} Starts a transaction. The callback can then call one or more other methods within a transaction to manipulate the entity.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }
    }

    @typeof(value="ms.xodus.XodusException")
    public static class CREXodusException
    extends CREException {
        public static final CClassType TYPE = CClassType.get(CREXodusException.class);

        public CREXodusException(String msg, Target t) {
            super(msg, t);
        }

        public CREXodusException(String msg, Target t, Throwable th) {
            super(msg, t, th);
        }

        public String docs() {
            return "This exception is thrown if a generic exception occurs in Xodus.";
        }

        public Version since() {
            return MSXodus.v1_0_0;
        }

        public CClassType[] getSuperclasses() {
            return super.getSuperclasses();
        }

        public CClassType[] getInterfaces() {
            return super.getInterfaces();
        }
    }
}

