/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chcitizens.core.events;

import com.hekta.chcitizens.abstraction.MCCitizensNPC;
import com.hekta.chcitizens.abstraction.MCCitizensNavigator;
import com.hekta.chcitizens.abstraction.enums.MCCitizensCancelReason;
import com.hekta.chcitizens.abstraction.enums.MCCitizensDespawnReason;
import com.hekta.chcitizens.abstraction.events.MCCitizensNPCClickEvent;
import com.hekta.chcitizens.abstraction.events.MCCitizensNPCDespawnEvent;
import com.hekta.chcitizens.abstraction.events.MCCitizensNPCSpawnEvent;
import com.hekta.chcitizens.abstraction.events.MCCitizensNavigationCancelEvent;
import com.hekta.chcitizens.abstraction.events.MCCitizensNavigationCompleteEvent;
import com.hekta.chcitizens.core.CHCitizensStatic;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.BoundEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventBuilder;
import com.laytonsmith.core.events.Prefilters;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;

public final class CitizensEvents {
    private CitizensEvents() {
    }

    public static String docs() {
        return "Contains events related to the Citizens plugin.";
    }

    @api
    public static final class ctz_npc_click
    extends CitizensEvent {
        public String docs() {
            return "{button: <macro> Clicked button left or right | player: <macro> | world: <macro> | type: <macro>} Fires when click an NPC.{button | player | npc: The NPC id | entity: The entityID of the NPC | type: The entity type of the NPC | location: The location of the NPC}{}{}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof MCCitizensNPCClickEvent) {
                MCCitizensNPCClickEvent event = (MCCitizensNPCClickEvent)e;
                boolean left = event.isLeft();
                MCPlayer clicker = event.getClicker();
                MCCitizensNPC npc = event.getNPC();
                MCEntity entity = npc.getEntity();
                Prefilters.match(prefilter, (String)"button", (String)(left ? "left" : "right"), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"player", (String)clicker.getName(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"world", (String)entity.getWorld().getName(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"type", (String)entity.getType().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            if (e instanceof MCCitizensNPCClickEvent) {
                Target t = Target.UNKNOWN;
                MCCitizensNPCClickEvent event = (MCCitizensNPCClickEvent)e;
                HashMap<String, Mixed> ret = new HashMap<String, Mixed>();
                boolean left = event.isLeft();
                MCCitizensNPC npc = event.getNPC();
                MCEntity entity = npc.getEntity();
                ret.put("button", (Mixed)new CString(left ? "left" : "right", t));
                ret.put("player", (Mixed)new CString(event.getClicker().getName(), t));
                ret.put("npc", (Mixed)new CInt((long)npc.getId(), t));
                ret.put("entity", (Mixed)new CString(npc.getUniqueId().toString(), t));
                ret.put("type", (Mixed)new CString(entity.getType().name(), t));
                ret.put("location", (Mixed)ObjectGenerator.GetGenerator().location((MCLocation)new BukkitMCLocation((AbstractionObject)entity.getLocation())));
                return ret;
            }
            throw new EventException("Cannot convert event to MCCitizensNPCClickEvent.");
        }
    }

    @api
    public static final class ctz_npc_spawn
    extends CitizensEvent {
        public String docs() {
            return "{type: <macro> The entity type of the NPC | world: <macro>} Fires when an NPC is clicked. {npc: The NPC id | entity: The entityID of the NPC | type: The entity type of the NPC | location: The location where the NPC will spawn} {} {}";
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            MCCitizensNPC npc = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)manualObject.get("npc", t), (Target)t), t);
            MCLocation location = ObjectGenerator.GetGenerator().location(manualObject.get("location", t), npc.isSpawned() ? npc.getEntity().getWorld() : null, t);
            return EventBuilder.instantiate(MCCitizensNPCSpawnEvent.class, (Object[])new Object[]{npc, location});
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            if (event instanceof MCCitizensNPCSpawnEvent) {
                MCCitizensNPCSpawnEvent npcse = (MCCitizensNPCSpawnEvent)event;
                MCEntity entity = npcse.getNPC().getEntity();
                Prefilters.match(prefilter, (String)"world", (String)entity.getWorld().getName(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"type", (String)entity.getType().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            if (event instanceof MCCitizensNPCSpawnEvent) {
                MCCitizensNPCSpawnEvent npcse = (MCCitizensNPCSpawnEvent)event;
                Map mapEvent = this.evaluate_helper(event);
                MCCitizensNPC npc = npcse.getNPC();
                mapEvent.put("npc", new CInt((long)npc.getId(), Target.UNKNOWN));
                MCEntity entity = npc.getEntity();
                mapEvent.put("entity", new CString(entity.getUniqueId().toString(), Target.UNKNOWN));
                mapEvent.put("type", new CString(entity.getType().name(), Target.UNKNOWN));
                mapEvent.put("location", ObjectGenerator.GetGenerator().location(npcse.getLocation()));
                return mapEvent;
            }
            throw new EventException("Cannot convert event to NPCSpawnEvent.");
        }

        public void preExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
            if (activeEvent.getUnderlyingEvent() instanceof MCCitizensNPCSpawnEvent) {
                MCEntity entity = ((MCCitizensNPCSpawnEvent)activeEvent.getUnderlyingEvent()).getNPC().getEntity();
                Static.InjectEntity((MCEntity)entity);
            }
        }

        public void postExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
            if (activeEvent.getUnderlyingEvent() instanceof MCCitizensNPCSpawnEvent) {
                MCEntity entity = ((MCCitizensNPCSpawnEvent)activeEvent.getUnderlyingEvent()).getNPC().getEntity();
                Static.UninjectEntity((MCEntity)entity);
            }
        }
    }

    @api
    public static final class ctz_npc_navigation_complete
    extends CitizensEvent {
        public String docs() {
            return "{type: <macro> The entity type of the NPC | world: <macro>} Fires when an NPC reaches its destination. {npc: The NPC id | entity: The entityID of the NPC | type: The entity type of the NPC | location: The location where the NPC is} {} {}";
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)manualObject.get("npc", t), (Target)t), t).getNavigator();
            return EventBuilder.instantiate(MCCitizensNavigationCompleteEvent.class, (Object[])new Object[]{navigator});
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            if (event instanceof MCCitizensNavigationCompleteEvent && !(event instanceof MCCitizensNavigationCancelEvent)) {
                MCCitizensNavigationCompleteEvent nce = (MCCitizensNavigationCompleteEvent)event;
                MCEntity entity = nce.getNPC().getEntity();
                Prefilters.match(prefilter, (String)"world", (String)entity.getWorld().getName(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"type", (String)entity.getType().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            if (event instanceof MCCitizensNavigationCompleteEvent) {
                MCCitizensNavigationCompleteEvent nce = (MCCitizensNavigationCompleteEvent)event;
                Map mapEvent = this.evaluate_helper(event);
                MCCitizensNPC npc = nce.getNPC();
                mapEvent.put("npc", new CInt((long)npc.getId(), Target.UNKNOWN));
                MCEntity entity = npc.getEntity();
                mapEvent.put("entity", new CString(entity.getUniqueId().toString(), Target.UNKNOWN));
                mapEvent.put("type", new CString(entity.getType().name(), Target.UNKNOWN));
                mapEvent.put("location", ObjectGenerator.GetGenerator().location(entity.getLocation()));
                return mapEvent;
            }
            throw new EventException("Cannot convert event to NavigationCompleteEvent.");
        }
    }

    @api
    public static final class ctz_npc_navigation_cancel
    extends CitizensEvent {
        public String docs() {
            return "{cause: <macro> The cause of the cancellation | type: <macro> The entity type of the NPC | world: <macro>} Fires when an NPC's navigation is cancelled. {npc: The NPC id | entity: the entityID of the NPC | type: The entity type of the NPC | location: The location where the NPC is (null if not spawned) | cause: The cause of the cancellation (one of " + StringUtils.Join((Object[])MCCitizensCancelReason.values(), (String)", ", (String)", or ", (String)" or ") + ")} {} {}";
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            MCCitizensCancelReason reason;
            try {
                reason = MCCitizensCancelReason.valueOf(manualObject.get("reason", t).val().toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                throw new CREFormatException(manualObject.get("reason", t).val() + " is not a valid cancel reason.", t);
            }
            MCCitizensNavigator navigator = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)manualObject.get("npc", t), (Target)t), t).getNavigator();
            return EventBuilder.instantiate(MCCitizensNavigationCancelEvent.class, (Object[])new Object[]{navigator, reason});
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            if (event instanceof MCCitizensNavigationCancelEvent) {
                MCCitizensNavigationCancelEvent nce = (MCCitizensNavigationCancelEvent)event;
                Prefilters.match(prefilter, (String)"cause", (String)nce.getCancelReason().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                MCEntity entity = nce.getNPC().getEntity();
                Prefilters.match(prefilter, (String)"world", (String)entity.getWorld().getName(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"type", (String)entity.getType().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            if (event instanceof MCCitizensNavigationCancelEvent) {
                MCCitizensNavigationCancelEvent nce = (MCCitizensNavigationCancelEvent)event;
                Map mapEvent = this.evaluate_helper(event);
                MCCitizensNPC npc = nce.getNPC();
                mapEvent.put("npc", new CInt((long)npc.getId(), Target.UNKNOWN));
                MCEntity entity = npc.getEntity();
                mapEvent.put("entity", new CString(entity.getUniqueId().toString(), Target.UNKNOWN));
                mapEvent.put("type", new CString(entity.getType().name(), Target.UNKNOWN));
                if (npc.isSpawned()) {
                    mapEvent.put("location", ObjectGenerator.GetGenerator().location(entity.getLocation()));
                } else {
                    mapEvent.put("location", CNull.NULL);
                }
                mapEvent.put("reason", new CString(nce.getCancelReason().name(), Target.UNKNOWN));
                return mapEvent;
            }
            throw new EventException("Cannot convert event to NavigationCancelEvent.");
        }
    }

    @api
    public static final class ctz_npc_despawn
    extends CitizensEvent {
        public String docs() {
            return "{reason: <macro> The reason the NPC is despawning | type: <macro> The entity type of the NPC | world: <macro>} Fires when an NPC despawns. {reason: The reason the NPC is despawning (one of " + StringUtils.Join((Object[])MCCitizensDespawnReason.values(), (String)", ", (String)", or ", (String)" or ") + ") | npc: The NPC id | entity: The entityID of the NPC | type: The entity type of the NPC | location: The location where the NPC is} {} {}";
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            MCCitizensDespawnReason reason;
            MCCitizensNPC npc = CHCitizensStatic.getNPC(ArgumentValidation.getInt32((Mixed)manualObject.get("npc", t), (Target)t), t);
            try {
                reason = MCCitizensDespawnReason.valueOf(manualObject.get("reason", t).val().toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                throw new CREFormatException(manualObject.get("reason", t).val() + " is not a valid despawn reason.", t);
            }
            return EventBuilder.instantiate(MCCitizensNPCDespawnEvent.class, (Object[])new Object[]{npc, reason});
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            if (event instanceof MCCitizensNPCDespawnEvent) {
                MCCitizensNPCDespawnEvent npcde = (MCCitizensNPCDespawnEvent)event;
                Prefilters.match(prefilter, (String)"reason", (String)npcde.getReason().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                MCEntity entity = npcde.getNPC().getEntity();
                if (entity == null) {
                    return false;
                }
                Prefilters.match(prefilter, (String)"world", (String)entity.getWorld().getName(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, (String)"type", (String)entity.getType().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            if (event instanceof MCCitizensNPCDespawnEvent) {
                MCCitizensNPCDespawnEvent npcde = (MCCitizensNPCDespawnEvent)event;
                Map mapEvent = this.evaluate_helper(event);
                MCCitizensNPC npc = npcde.getNPC();
                mapEvent.put("npc", new CInt((long)npc.getId(), Target.UNKNOWN));
                MCEntity entity = npc.getEntity();
                mapEvent.put("entity", new CString(entity.getUniqueId().toString(), Target.UNKNOWN));
                mapEvent.put("type", new CString(entity.getType().name(), Target.UNKNOWN));
                mapEvent.put("location", ObjectGenerator.GetGenerator().location(entity.getLocation()));
                mapEvent.put("reason", new CString(npcde.getReason().name(), Target.UNKNOWN));
                return mapEvent;
            }
            throw new EventException("Cannot convert event to NPCDespawnEvent.");
        }
    }

    protected static abstract class CitizensEvent
    extends AbstractEvent {
        protected CitizensEvent() {
        }

        public String getName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }
    }
}

