/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chdynmap.core.functions;

import com.hekta.chdynmap.abstraction.MCDynmapAreaMarker;
import com.hekta.chdynmap.abstraction.MCDynmapCircleMarker;
import com.hekta.chdynmap.abstraction.MCDynmapIcon;
import com.hekta.chdynmap.abstraction.MCDynmapIconMarker;
import com.hekta.chdynmap.abstraction.MCDynmapMarker;
import com.hekta.chdynmap.abstraction.MCDynmapMarkerFillStyle;
import com.hekta.chdynmap.abstraction.MCDynmapMarkerLineStyle;
import com.hekta.chdynmap.abstraction.MCDynmapMarkerSet;
import com.hekta.chdynmap.abstraction.MCDynmapPolyLineMarker;
import com.hekta.chdynmap.abstraction.enums.MCDynmapMarkerType;
import com.hekta.chdynmap.core.CHDynmapStatic;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Set;

public class DynmapMarkers {
    public static String docs() {
        return "A class of functions to manage the Dynmap markers.";
    }

    @api
    public static class dm_set_marker_max_zoom
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_max_zoom";
        }

        public String docs() {
            return "void {setID, markerID, int} Sets the maximum zoom level of the marker (the marker will be hidden when the zoom level is above this setting). -1 means no maximum. This setting bypass the value returned by the {{function|dm_markerset_max_zoom}} function.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).setMaxZoom(ArgumentValidation.getInt32((Mixed)args[2], (Target)t));
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_max_zoom
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_max_zoom";
        }

        public String docs() {
            return "int {setID, markerID} Returns the maximum zoom level of the marker (the marker will be hidden when the zoom level is above this setting). -1 means no maximum. This setting bypass the value returned by the {{function|dm_markerset_max_zoom}} function.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CInt((long)CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).getMaxZoom(), t);
        }
    }

    @api
    public static class dm_set_marker_min_zoom
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_min_zoom";
        }

        public String docs() {
            return "void {setID, markerID, int} Sets the minimum zoom level of the marker (the marker will be hidden when the zoom level is below this setting). -1 means no minimum. This setting bypass the value returned by the {{function|dm_markerset_min_zoom}} function.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).setMinZoom(ArgumentValidation.getInt32((Mixed)args[2], (Target)t));
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_min_zoom
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_min_zoom";
        }

        public String docs() {
            return "int {setID, markerID} Returns the minimum zoom level of the marker (the marker will be hidden when the zoom level is below this setting). -1 means no minimum. This setting bypass the value returned by the {{function|dm_markerset_min_zoom}} function.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CInt((long)CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).getMinZoom(), t);
        }
    }

    @api
    public static class dm_marker_world
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_world";
        }

        public String docs() {
            return "string {setID, markerID} Returns the world of the marker.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CString(CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).getWorld().getName(), t);
        }
    }

    @api
    public static class dm_marker_type
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_type";
        }

        public String docs() {
            return "string {setID, markerID} Returns the type of the marker. Can be one of " + StringUtils.Join((Object[])MCDynmapMarkerType.values(), (String)", ", (String)", ", (String)" or ") + ", or UNKNOWN.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CString(CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).getType().name(), t);
        }
    }

    @api
    public static class dm_set_marker_range_height
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_range_height";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRECastException.class, CREFormatException.class};
        }

        public String docs() {
            return "void {setID, markerID, array} Sets the range height of a marker (array with \"top\" and \"bottom\" keys). Only for area markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray range = ArgumentValidation.getArray((Mixed)args[2], (Target)t);
            CHDynmapStatic.getAreaMarker(args[0].val(), args[1].val(), t).setRangeY(ArgumentValidation.getDouble((Mixed)range.get("top", t), (Target)t), ArgumentValidation.getDouble((Mixed)range.get("bottom", t), (Target)t));
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_range_height
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_range_height";
        }

        public String docs() {
            return "array {setID, markerID} Returns the range height of the marker. Only for area markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapAreaMarker marker = CHDynmapStatic.getAreaMarker(args[0].val(), args[1].val(), t);
            CArray range = new CArray(t);
            range.set("bottom", (Mixed)new CDouble(marker.getBottomY(), t), t);
            range.set("top", (Mixed)new CDouble(marker.getTopY(), t), t);
            return range;
        }
    }

    @api
    public static class dm_set_marker_radius
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_radius";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRECastException.class, CREFormatException.class};
        }

        public String docs() {
            return "void {setID, markerID, array} Sets the radius of the marker (array with \"x\" and \"z\" keys). Only for circle markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray radius = ArgumentValidation.getArray((Mixed)args[2], (Target)t);
            CHDynmapStatic.getCircleMarker(args[0].val(), args[1].val(), t).setRadius(ArgumentValidation.getDouble((Mixed)radius.get("x", t), (Target)t), ArgumentValidation.getDouble((Mixed)radius.get("z", t), (Target)t));
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_radius
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_radius";
        }

        public String docs() {
            return "array {setID, markerID} Returns the radius of the marker. Only for circle markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapCircleMarker marker = CHDynmapStatic.getCircleMarker(args[0].val(), args[1].val(), t);
            CArray radius = new CArray(t);
            radius.set("x", (Mixed)new CDouble(marker.getRadiusX(), t), t);
            radius.set("z", (Mixed)new CDouble(marker.getRadiusZ(), t), t);
            return radius;
        }
    }

    @api
    public static class dm_marker_persistent
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_persistent";
        }

        public String docs() {
            return "boolean {setID, markerID} Returns if the marker is persistent.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get((boolean)CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).isPersistent());
        }
    }

    @api
    public static class dm_marker_normalized_world
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_normalized_world";
        }

        public String docs() {
            return "string {setID, markerID} Returns the normalized world of the marker (used for directory and URL names in Dynmap).";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CString(CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).getNormalizedWorld(), t);
        }
    }

    @api
    public static class dm_set_marker_markerset
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_markerset";
        }

        public String docs() {
            return "void {setID, markerID, newSetID} Changes the markerset of the marker.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            MCDynmapMarkerSet newSet = CHDynmapStatic.getMarkerSet(args[2].val(), t);
            if (newSet.getMarker(marker.getId()) != null) {
                throw new CREPluginInternalException("An other marker with the same ID already exists in the new markerset.", t);
            }
            marker.setSet(newSet);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_set_marker_loc
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_loc";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRECastException.class, CREFormatException.class, CREInvalidWorldException.class};
        }

        public String docs() {
            return "void {setID, markerID, locationArray} Sets the icon location of a marker. Only for icon markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapIconMarker marker = CHDynmapStatic.getIconMarker(args[0].val(), args[1].val(), t);
            marker.setLocation(ObjectGenerator.GetGenerator().location(args[2], marker.getWorld(), t));
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_loc
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_loc";
        }

        public String docs() {
            return "string {setID, markerID} Returns the location of the marker. Only for icon markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return ObjectGenerator.GetGenerator().location(CHDynmapStatic.getIconMarker(args[0].val(), args[1].val(), t).getLocation());
        }
    }

    @api
    public static class dm_set_marker_line_style
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_line_style";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class, CRECastException.class, CREFormatException.class};
        }

        public String docs() {
            return "void {setID, markerID, array} Sets the marker line style (array with \"color\", \"opacity\" and \"weight\" optional keys, color is a color r g b array, opacity a number between 0 and 1 inclusive and weight is an integer). Only for area, circle and polyline markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarkerLineStyle lineStyle;
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            CArray styleArray = ArgumentValidation.getArray((Mixed)args[2], (Target)t);
            Set keys = styleArray.stringKeySet();
            switch (marker.getType()) {
                case AREA: {
                    lineStyle = ((MCDynmapAreaMarker)marker).getLineStyle();
                    break;
                }
                case CIRCLE: {
                    lineStyle = ((MCDynmapCircleMarker)marker).getLineStyle();
                    break;
                }
                case POLYLINE: {
                    lineStyle = ((MCDynmapPolyLineMarker)marker).getLineStyle();
                    break;
                }
                default: {
                    throw new CRENotFoundException("There is no existing area, circle or polyline markers with this id.", t);
                }
            }
            if (keys.contains("color")) {
                lineStyle.setColor(ObjectGenerator.GetGenerator().color(ArgumentValidation.getArray((Mixed)styleArray.get("color", t), (Target)t), t));
            }
            if (keys.contains("opacity")) {
                double opacity = ArgumentValidation.getDouble((Mixed)styleArray.get("opacity", t), (Target)t);
                if (opacity < 0.0 || opacity > 1.0) {
                    throw new CRERangeException("Opacity must be between 0 and 1 inclusive.", t);
                }
                lineStyle.setOpacity(opacity);
            }
            if (keys.contains("weight")) {
                lineStyle.setWeight(ArgumentValidation.getInt32((Mixed)styleArray.get("weight", t), (Target)t));
            }
            switch (marker.getType()) {
                case AREA: {
                    ((MCDynmapAreaMarker)marker).setLineStyle(lineStyle);
                    break;
                }
                case CIRCLE: {
                    ((MCDynmapCircleMarker)marker).setLineStyle(lineStyle);
                    break;
                }
                case POLYLINE: {
                    ((MCDynmapPolyLineMarker)marker).setLineStyle(lineStyle);
                }
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_line_style
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_line_style";
        }

        public String docs() {
            return "array {setID, markerID} Returns the line style array of the marker. Only for area, circle and polyline markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarkerLineStyle lineStyle;
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            switch (marker.getType()) {
                case AREA: {
                    lineStyle = ((MCDynmapAreaMarker)marker).getLineStyle();
                    break;
                }
                case CIRCLE: {
                    lineStyle = ((MCDynmapCircleMarker)marker).getLineStyle();
                    break;
                }
                case POLYLINE: {
                    lineStyle = ((MCDynmapPolyLineMarker)marker).getLineStyle();
                    break;
                }
                default: {
                    throw new CRENotFoundException("There is no existing area, circle or polyline markers with this id.", t);
                }
            }
            CArray styleArray = new CArray(t);
            styleArray.set("color", (Mixed)ObjectGenerator.GetGenerator().color(lineStyle.getColor(), t), t);
            styleArray.set("opacity", (Mixed)new CDouble(lineStyle.getOpacity(), t), t);
            styleArray.set("weight", (Mixed)new CInt((long)lineStyle.getWeight(), t), t);
            return styleArray;
        }
    }

    @api
    public static class dm_set_marker_label
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_label";
        }

        public String docs() {
            return "void {setID, markerID, label, [isHTML]} Sets the label of the marker, isHTML is a boolean, if true, label will be processed as HTML.";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{3, 4};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            boolean isHTML = args.length == 3 ? false : ArgumentValidation.getBooleanObject((Mixed)args[3], (Target)t);
            marker.setLabel(args[2].val(), isHTML);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_label_is_html
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_label_is_html";
        }

        public String docs() {
            return "boolean {setID, markerID} Returns if the label of the marker is processed as HTML.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get((boolean)CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).isLabelMarkup());
        }
    }

    @api
    public static class dm_marker_label
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_label";
        }

        public String docs() {
            return "string {setID, markerID} Returns the label of the marker.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CString(CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).getLabel(), t);
        }
    }

    @api
    public static class dm_set_marker_icon
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_icon";
        }

        public String docs() {
            return "void {setID, markerID, iconID} Sets the icon of a marker. Only for icon markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapIconMarker marker = CHDynmapStatic.getIconMarker(args[0].val(), args[1].val(), t);
            MCDynmapIcon icon = CHDynmapStatic.getIcon(args[2].val(), t);
            if (!marker.getSet().iconIsAllowed(icon)) {
                throw new CREPluginInternalException("The icon is not allowed for the markerset.", t);
            }
            marker.setIcon(icon);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_icon
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_icon";
        }

        public String docs() {
            return "string {setID, markerID} Returns the icon ID of the marker. Only for icon markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CString(CHDynmapStatic.getIconMarker(args[0].val(), args[1].val(), t).getIcon().getId(), t);
        }
    }

    @api
    public static class dm_set_marker_fill_style
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_fill_style";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRECastException.class, CREFormatException.class};
        }

        public String docs() {
            return "void {setID, markerID, array} Sets the marker fill style (array with \"color\" and \"opacity\" optional keys, color is a color r g b array, and opacity a number between 0 and 1 inclusive). Only for area and circle markers";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarkerFillStyle fillStyle;
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            CArray styleArray = ArgumentValidation.getArray((Mixed)args[2], (Target)t);
            Set keys = styleArray.stringKeySet();
            switch (marker.getType()) {
                case AREA: {
                    fillStyle = ((MCDynmapAreaMarker)marker).getFillStyle();
                    break;
                }
                case CIRCLE: {
                    fillStyle = ((MCDynmapCircleMarker)marker).getFillStyle();
                    break;
                }
                default: {
                    throw new CRENotFoundException("There is no existing area or circle markers with this id.", t);
                }
            }
            if (keys.contains("color")) {
                fillStyle.setColor(ObjectGenerator.GetGenerator().color(ArgumentValidation.getArray((Mixed)styleArray.get("color", t), (Target)t), t));
            }
            if (keys.contains("opacity")) {
                double opacity = ArgumentValidation.getDouble((Mixed)styleArray.get("opacity", t), (Target)t);
                if (opacity < 0.0 || opacity > 1.0) {
                    throw new CRERangeException("Opacity must be between 0 and 1 inclusive.", t);
                }
                fillStyle.setOpacity(opacity);
            }
            switch (marker.getType()) {
                case AREA: {
                    ((MCDynmapAreaMarker)marker).setFillStyle(fillStyle);
                    break;
                }
                case CIRCLE: {
                    ((MCDynmapCircleMarker)marker).setFillStyle(fillStyle);
                }
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_fill_style
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_fill_style";
        }

        public String docs() {
            return "array {setID, markerID} Returns the fill style array of the marker. Only for area and circle markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarkerFillStyle fillStyle;
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            switch (marker.getType()) {
                case AREA: {
                    fillStyle = ((MCDynmapAreaMarker)marker).getFillStyle();
                    break;
                }
                case CIRCLE: {
                    fillStyle = ((MCDynmapCircleMarker)marker).getFillStyle();
                    break;
                }
                default: {
                    throw new CRENotFoundException("There is no existing area or circle markers with this id.", t);
                }
            }
            CArray styleArray = new CArray(t);
            styleArray.set("color", (Mixed)ObjectGenerator.GetGenerator().color(fillStyle.getColor(), t), t);
            styleArray.set("opacity", (Mixed)new CDouble(fillStyle.getOpacity(), t), t);
            return styleArray;
        }
    }

    @api
    public static class dm_set_marker_description
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_description";
        }

        public String docs() {
            return "void {setID, markerID, htmlDescription} Sets the description of the marker (in HTML).";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).setDescription(args[2].val());
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_description
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_label";
        }

        public String docs() {
            return "string {setID, markerID} Returns the description of the marker.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CString(CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).getDescription(), t);
        }
    }

    @api
    public static class dm_set_marker_corners
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_corners";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class, CRECastException.class, CREFormatException.class};
        }

        public String docs() {
            return "void {setID, markerID, array} Sets the location of the marker corners (array of location arrays, world is ignored, and for area markers y is ignored). Only for area and polyline markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            CArray givenCorners = ArgumentValidation.getArray((Mixed)args[2], (Target)t);
            if (givenCorners.inAssociativeMode()) {
                throw new CRECastException("The array must not be associative.", t);
            }
            MCLocation[] corners = new MCLocation[(int)givenCorners.size()];
            MCWorld world = marker.getWorld();
            int i = 0;
            for (Mixed corner : givenCorners.asList()) {
                corners[i] = ObjectGenerator.GetGenerator().location(corner, world, t);
                ++i;
            }
            switch (marker.getType()) {
                case AREA: {
                    ((MCDynmapAreaMarker)marker).setCorners(corners);
                    break;
                }
                case POLYLINE: {
                    ((MCDynmapPolyLineMarker)marker).setCorners(corners);
                    break;
                }
                default: {
                    throw new CRENotFoundException("There is no existing area or polyline markers with this id.", t);
                }
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_corners
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_corners";
        }

        public String docs() {
            return "array {setID, markerID} Returns the corners location of the marker. Only for area and polyline markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCLocation[] corners;
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            switch (marker.getType()) {
                case AREA: {
                    corners = ((MCDynmapAreaMarker)marker).getCorners();
                    break;
                }
                case POLYLINE: {
                    corners = ((MCDynmapPolyLineMarker)marker).getCorners();
                    break;
                }
                default: {
                    throw new CRENotFoundException("There is no existing area or polyline markers with this id.", t);
                }
            }
            CArray cornerArray = new CArray(t);
            for (MCLocation location : corners) {
                cornerArray.push((Mixed)ObjectGenerator.GetGenerator().location(location), t);
            }
            return cornerArray;
        }
    }

    @api
    public static class dm_set_marker_center
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_center";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class, CRECastException.class, CREFormatException.class, CREInvalidWorldException.class};
        }

        public String docs() {
            return "void {setID, markerID, locationArray} Sets the center of a marker. Only for circle markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapCircleMarker marker = CHDynmapStatic.getCircleMarker(args[0].val(), args[1].val(), t);
            marker.setCenter(ObjectGenerator.GetGenerator().location(args[2], marker.getWorld(), t));
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_center
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_center";
        }

        public String docs() {
            return "array {setID, markerID} Returns the location of the marker center. Only for circle markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return ObjectGenerator.GetGenerator().location(CHDynmapStatic.getCircleMarker(args[0].val(), args[1].val(), t).getCenter());
        }
    }

    @api
    public static class dm_set_marker_boosted
    extends DynmapMarkerSetterFunction {
        public String getName() {
            return "dm_set_marker_boosted";
        }

        public String docs() {
            return "void {setID, markerID, boolean} Sets if the marker resolution is boosted. Only for area and circle markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            switch (marker.getType()) {
                case AREA: {
                    ((MCDynmapAreaMarker)marker).setBoosted(ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t));
                    break;
                }
                case CIRCLE: {
                    ((MCDynmapCircleMarker)marker).setBoosted(ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t));
                    break;
                }
                default: {
                    throw new CRENotFoundException("There is no existing area or circle markers with this id.", t);
                }
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_marker_boosted
    extends DynmapMarkerGetterFunction {
        public String getName() {
            return "dm_marker_boosted";
        }

        public String docs() {
            return "array {setID, markerID} Returns if the marker resolution is boosted. Only for area and circle markers.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarker marker = CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t);
            switch (marker.getType()) {
                case AREA: {
                    return CBoolean.get((boolean)((MCDynmapAreaMarker)marker).isBoosted());
                }
                case CIRCLE: {
                    return CBoolean.get((boolean)((MCDynmapCircleMarker)marker).isBoosted());
                }
            }
            throw new CRENotFoundException("There is no existing area or circle markers with this id.", t);
        }
    }

    @api
    public static class dm_delete_marker
    extends DynmapMarkerFunction {
        public String getName() {
            return "dm_delete_marker";
        }

        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class};
        }

        public String docs() {
            return "void {setID, markerID} Deletes a marker in the set.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CHDynmapStatic.getMarker(args[0].val(), args[1].val(), t).delete();
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_create_marker
    extends DynmapMarkerFunction {
        public String getName() {
            return "dm_create_marker";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRECastException.class, CREFormatException.class, CREInvalidWorldException.class};
        }

        public String docs() {
            return "string {setID, [optionArray]} Creates a marker and returns its ID. ---- The option array is associative and not required, and all its keys are optional. <li>KEY - DEFAULT - DESCRIPTION - COMMENT</li> <li>center - world spawn - the center of the marker - only for circle markers, world is ignored</li> <li>corners - world spawn - the corners of the marker - only for area or polyline markers, world is ignored (and also y for area markers)</li> <li>icon - null - the icon ID of the marker, null for the markerset default icon - only for icon markers</li> <li>id - random - ID of the marker, must be unique within the set, if null or not given, an unique ID is generated</li> <li>label - markerID - the label of the marker</li> <li>label_is_html - false - sets if the label is processing as HTML</li> <li>location - world spawn - the location of the marker - only for icon markers, world is ignored</li> <li>persistent - false - sets if the label is persistent (saved and reloaded on restart), the markerset must be persistent - can not be changed later</li> <li>radius - 0 0 - the radius of the marker - only for circle markers</li> <li>type - ICON - the type of the marker, can be one of " + StringUtils.Join((Object[])MCDynmapMarkerType.values(), (String)", ", (String)", or ", (String)" or ") + " - can not be changed later</li> <li>world - first world - the world of the marker</li>";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarker marker;
            double radiusZ;
            double radiusX;
            int i;
            MCLocation[] corners;
            CArray givenCorners;
            MCWorld world;
            String id;
            MCDynmapMarkerType type;
            MCDynmapMarkerSet set = CHDynmapStatic.getMarkerSet(args[0].val(), t);
            CArray optionArray = args.length == 1 ? new CArray(t) : ArgumentValidation.getArray((Mixed)args[1], (Target)t);
            Set keys = optionArray.stringKeySet();
            if (!keys.contains("type") || optionArray.get("type", t) instanceof CNull) {
                type = MCDynmapMarkerType.ICON;
            } else {
                try {
                    type = MCDynmapMarkerType.valueOf(optionArray.get("type", t).val().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    throw new CREPluginInternalException("Invalid marker type: " + optionArray.get("type", t).val(), t);
                }
            }
            if (keys.contains("id")) {
                id = optionArray.get("id", t).val();
                if (set.getMarker(id) != null) {
                    throw new CREPluginInternalException("\"" + id + "\" is already an existing marker.", t);
                }
            } else {
                id = null;
            }
            if (keys.contains("world")) {
                world = Static.getServer().getWorld(optionArray.get("world", t).val());
                if (world == null) {
                    throw new CREInvalidWorldException("Unknown world: " + optionArray.get("world", t).val(), t);
                }
            } else {
                world = (MCWorld)Static.getServer().getWorlds().get(0);
            }
            String label = keys.contains("label") ? optionArray.get("label", t).val() : id;
            boolean labelIsHTML = keys.contains("label_is_html") ? ArgumentValidation.getBooleanObject((Mixed)optionArray.get("label_is_html", t), (Target)t) : false;
            boolean isPersistent = keys.contains("persistent") ? ArgumentValidation.getBooleanObject((Mixed)optionArray.get("persistent", t), (Target)t) : false;
            MCLocation center = type == MCDynmapMarkerType.CIRCLE ? (keys.contains("center") ? ObjectGenerator.GetGenerator().location(optionArray.get("center", t), world, t) : world.getSpawnLocation()) : null;
            if (type == MCDynmapMarkerType.AREA) {
                if (keys.contains("corners")) {
                    givenCorners = ArgumentValidation.getArray((Mixed)optionArray.get("corners", t), (Target)t);
                    corners = new MCLocation[(int)givenCorners.size()];
                    if (givenCorners.inAssociativeMode()) {
                        throw new CRECastException("The corners array must not be associative.", t);
                    }
                    i = 0;
                    for (Mixed corner : givenCorners.asList()) {
                        corners[i] = ObjectGenerator.GetGenerator().location(corner, world, t);
                        ++i;
                    }
                } else {
                    corners = new MCLocation[]{world.getSpawnLocation()};
                }
            } else if (type == MCDynmapMarkerType.POLYLINE) {
                if (keys.contains("corners")) {
                    givenCorners = ArgumentValidation.getArray((Mixed)optionArray.get("corners", t), (Target)t);
                    corners = new MCLocation[(int)givenCorners.size()];
                    if (givenCorners.inAssociativeMode()) {
                        throw new CRECastException("The corners array must not be associative.", t);
                    }
                    i = 0;
                    for (Mixed corner : givenCorners.asList()) {
                        corners[i] = ObjectGenerator.GetGenerator().location(corner, world, t);
                        ++i;
                    }
                } else {
                    corners = new MCLocation[]{world.getSpawnLocation()};
                }
            } else {
                corners = null;
            }
            MCDynmapIcon icon = type == MCDynmapMarkerType.ICON ? (keys.contains("icon") ? CHDynmapStatic.getIcon(optionArray.get("icon", t).val(), t) : set.getDefaultIcon()) : null;
            MCLocation iconLocation = type == MCDynmapMarkerType.ICON ? (keys.contains("location") ? ObjectGenerator.GetGenerator().location(optionArray.get("location", t), world, t) : world.getSpawnLocation()) : null;
            if (type == MCDynmapMarkerType.CIRCLE) {
                if (keys.contains("radius")) {
                    CArray radius = ArgumentValidation.getArray((Mixed)optionArray.get("radius", t), (Target)t);
                    radiusX = ArgumentValidation.getDouble((Mixed)radius.get("x", t), (Target)t);
                    radiusZ = ArgumentValidation.getDouble((Mixed)radius.get("z", t), (Target)t);
                } else {
                    radiusX = 0.0;
                    radiusZ = 0.0;
                }
            } else {
                radiusX = 0.0;
                radiusZ = 0.0;
            }
            switch (type) {
                case AREA: {
                    marker = set.createAreaMarker(id, label, labelIsHTML, world, corners, isPersistent);
                    break;
                }
                case CIRCLE: {
                    marker = set.createCircleMarker(id, label, labelIsHTML, center, radiusX, radiusZ, isPersistent);
                    break;
                }
                case ICON: {
                    marker = set.createIconMarker(id, label, labelIsHTML, iconLocation, icon, isPersistent);
                    break;
                }
                case POLYLINE: {
                    marker = set.createPolyLineMarker(id, label, labelIsHTML, world, corners, isPersistent);
                    break;
                }
                default: {
                    marker = null;
                }
            }
            if (marker == null) {
                throw new CREPluginInternalException("The marker creation failed.", t);
            }
            return new CString(marker.getId(), t);
        }
    }

    @api
    public static class dm_all_markers
    extends DynmapMarkerFunction {
        public String getName() {
            return "dm_all_markers";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class};
        }

        public String docs() {
            return "array {setID, [type]} Returns an associative array containing the ID of all markers in the markerset. If the type is given, only the markers of this type are returne. Type can be one of " + StringUtils.Join((Object[])MCDynmapMarkerType.values(), (String)", ", (String)", or ", (String)" or ") + ".";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCDynmapMarkerType type;
            MCDynmapMarkerSet set = CHDynmapStatic.getMarkerSet(args[0].val(), t);
            if (args.length == 1 || args[1] instanceof CNull) {
                type = null;
            } else {
                try {
                    type = MCDynmapMarkerType.valueOf(args[1].val().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    throw new CREPluginInternalException("Invalid marker type: " + args[1].val() + ".", t);
                }
            }
            CArray markerArray = new CArray(t);
            if (type == null || type == MCDynmapMarkerType.AREA) {
                for (MCDynmapMarker mCDynmapMarker : set.getAreaMarkers()) {
                    markerArray.push((Mixed)new CString(mCDynmapMarker.getId(), t), t);
                }
            }
            if (type == null || type == MCDynmapMarkerType.CIRCLE) {
                for (MCDynmapMarker mCDynmapMarker : set.getCircleMarkers()) {
                    markerArray.push((Mixed)new CString(mCDynmapMarker.getId(), t), t);
                }
            }
            if (type == null || type == MCDynmapMarkerType.ICON) {
                for (MCDynmapMarker mCDynmapMarker : set.getIconMarkers()) {
                    markerArray.push((Mixed)new CString(mCDynmapMarker.getId(), t), t);
                }
            }
            if (type == null || type == MCDynmapMarkerType.POLYLINE) {
                for (MCDynmapMarker mCDynmapMarker : set.getPolyLineMarkers()) {
                    markerArray.push((Mixed)new CString(mCDynmapMarker.getId(), t), t);
                }
            }
            return markerArray;
        }
    }

    public static abstract class DynmapMarkerSetterFunction
    extends DynmapMarkerFunction {
        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class, CRECastException.class};
        }
    }

    public static abstract class DynmapMarkerGetterFunction
    extends DynmapMarkerFunction {
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class};
        }
    }

    public static abstract class DynmapMarkerFunction
    extends AbstractFunction {
        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }
}

