/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chdynmap.abstraction.bukkit;

import com.hekta.chdynmap.abstraction.MCDynmapPlayerSet;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.abstraction;
import java.util.HashSet;
import java.util.Set;
import org.dynmap.markers.PlayerSet;

@abstraction(type=Implementation.Type.BUKKIT)
public class BukkitMCDynmapPlayerSet
implements MCDynmapPlayerSet {
    private final PlayerSet _set;

    public BukkitMCDynmapPlayerSet(PlayerSet playerSet) {
        this._set = playerSet;
    }

    public BukkitMCDynmapPlayerSet(Object object) {
        this((PlayerSet)object);
    }

    public PlayerSet getHandle() {
        return this._set;
    }

    @Override
    public String getId() {
        return this._set.getSetID();
    }

    @Override
    public MCOfflinePlayer[] getPlayers() {
        Set ps = this._set.getPlayers();
        MCOfflinePlayer[] players = new MCOfflinePlayer[ps.size()];
        int i = 0;
        for (String playerName : ps) {
            players[i] = StaticLayer.GetServer().getOfflinePlayer(playerName);
            ++i;
        }
        return players;
    }

    @Override
    public void setPlayers(MCOfflinePlayer[] players) {
        HashSet<String> playerNames = new HashSet<String>();
        for (MCOfflinePlayer player : players) {
            playerNames.add(player.getName());
        }
        this._set.setPlayers(playerNames);
    }

    @Override
    public void setPlayers(Iterable<MCOfflinePlayer> players) {
        HashSet<String> playerNames = new HashSet<String>();
        for (MCOfflinePlayer player : players) {
            playerNames.add(player.getName());
        }
        this._set.setPlayers(playerNames);
    }

    @Override
    public void addPlayer(MCOfflinePlayer player) {
        this._set.addPlayer(player.getName());
    }

    @Override
    public void removePlayer(MCOfflinePlayer player) {
        this._set.removePlayer(player.getName());
    }

    @Override
    public boolean isPlayerInSet(MCOfflinePlayer player) {
        return this._set.isPlayerInSet(player.getName());
    }

    @Override
    public void delete() {
        this._set.deleteSet();
    }

    @Override
    public boolean isSymmetric() {
        return this._set.isSymmetricSet();
    }

    @Override
    public void setSymmetric(boolean isSymmetric) {
        this._set.setSymmetricSet(isSymmetric);
    }

    @Override
    public boolean isPersistent() {
        return this._set.isPersistentSet();
    }
}

