/*
 * Decompiled with CFR 0.152.
 */
package com.hekta.chdynmap.core.functions;

import com.hekta.chdynmap.abstraction.MCDynmapPlayerSet;
import com.hekta.chdynmap.core.CHDynmapStatic;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Set;

public class DynmapPlayerSets {
    public static String docs() {
        return "A class of functions to manage the Dynmap playersets.";
    }

    @api
    public static class dm_set_playerset_symmetric
    extends DynmapPlayerSetSetterFunction {
        public String getName() {
            return "dm_set_playerset_symmetric";
        }

        public String docs() {
            return "void {setID, boolean} Sets if the playerset is symmetric (if true, players in set can see the players in set, if false, privilege is always required).";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CHDynmapStatic.getPlayerSet(args[0].val(), t).setSymmetric(ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t));
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_playerset_symmetric
    extends DynmapPlayerSetGetterFunction {
        public String getName() {
            return "dm_playerset_symmetric";
        }

        public String docs() {
            return "boolean {setID} Returns if the playerset is symmetric (if true players in set can see other the players in set).";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get((boolean)CHDynmapStatic.getPlayerSet(args[0].val(), t).isSymmetric());
        }
    }

    @api
    public static class dm_playerset_persistent
    extends DynmapPlayerSetGetterFunction {
        public String getName() {
            return "dm_playerset_persistent";
        }

        public String docs() {
            return "boolean {setID} Returns if the playerset is persistent.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get((boolean)CHDynmapStatic.getPlayerSet(args[0].val(), t).isPersistent());
        }
    }

    @api
    public static class dm_set_pis_in_playerset
    extends DynmapPlayerSetFunction {
        public String getName() {
            return "dm_set_pis_in_playerset";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CREPlayerOfflineException.class};
        }

        public String docs() {
            return "void {setID, [playerName], boolean} Sets if a player is in the playerset. This will not throw a PlayerOfflineException (except from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean isInSet;
            MCOfflinePlayer player;
            MCDynmapPlayerSet set = CHDynmapStatic.getPlayerSet(args[0].val(), t);
            if (args.length == 2) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
                isInSet = ArgumentValidation.getBooleanObject((Mixed)args[1], (Target)t);
            } else {
                player = Static.getServer().getOfflinePlayer(args[1].val());
                isInSet = ArgumentValidation.getBooleanObject((Mixed)args[2], (Target)t);
            }
            if (isInSet) {
                if (set.isPlayerInSet(player)) {
                    throw new CREPluginInternalException("The player is already in the playerset.", t);
                }
                set.addPlayer(player);
            } else {
                if (!set.isPlayerInSet(player)) {
                    throw new CREPluginInternalException("The player is already not in the playerset.", t);
                }
                set.removePlayer(player);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_pis_in_playerset
    extends DynmapPlayerSetFunction {
        public String getName() {
            return "dm_pis_in_playerset";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CREPlayerOfflineException.class};
        }

        public String docs() {
            return "boolean {setID, [playerName]} Returns if a player is in the playerset. This will not throw a PlayerOfflineException (except from console), so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCOfflinePlayer player;
            if (args.length == 1) {
                MCPlayer psender = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (psender == null) {
                    throw new CREPlayerOfflineException("No player was specified!", t);
                }
                player = psender;
            } else {
                player = Static.getServer().getOfflinePlayer(args[1].val());
            }
            return CBoolean.get((boolean)CHDynmapStatic.getPlayerSet(args[0].val(), t).isPlayerInSet(player));
        }
    }

    @api
    public static class dm_set_players_in_playerset
    extends DynmapPlayerSetSetterFunction {
        public String getName() {
            return "dm_set_players_in_playerset";
        }

        public String docs() {
            return "void {setID, array} Sets the players in the playerset. This will not throw a PlayerOfflineException, so the name must be exact.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray givenPlayers = ArgumentValidation.getArray((Mixed)args[1], (Target)t);
            if (givenPlayers.inAssociativeMode()) {
                throw new CRECastException("The array must not be associative.", t);
            }
            MCOfflinePlayer[] players = new MCOfflinePlayer[(int)givenPlayers.size()];
            int i = 0;
            for (Mixed player : givenPlayers.asList()) {
                players[i] = Static.getServer().getOfflinePlayer(player.val());
                ++i;
            }
            CHDynmapStatic.getPlayerSet(args[0].val(), t).setPlayers(players);
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_players_in_playerset
    extends DynmapPlayerSetGetterFunction {
        public String getName() {
            return "dm_players_in_playerset";
        }

        public String docs() {
            return "array {setID} Returns an array containing all the players in the playerset.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray playerArray = new CArray(t);
            for (MCOfflinePlayer player : CHDynmapStatic.getPlayerSet(args[0].val(), t).getPlayers()) {
                playerArray.push((Mixed)new CString(player.getName(), t), t);
            }
            return playerArray;
        }
    }

    @api
    public static class dm_delete_playerset
    extends DynmapPlayerSetFunction {
        public String getName() {
            return "dm_delete_playerset";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class};
        }

        public String docs() {
            return "void {setID} Deletes a playerset.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CHDynmapStatic.getPlayerSet(args[0].val(), t).delete();
            return CVoid.VOID;
        }
    }

    @api
    public static class dm_create_playerset
    extends DynmapPlayerSetFunction {
        public String getName() {
            return "dm_create_playerset";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRECastException.class, CREFormatException.class};
        }

        public String docs() {
            return "string {newSetID, [optionArray]} Creates a playerset and returns its ID. ---- The ID must be unique among playersets and must only contain numbers, letters, periods (.) and underscores (_). The option array is associative and not required, and all its keys are optional. <li>KEY - DEFAULT - DESCRIPTION - COMMENT</li> <li>persistent - false - sets if the playerset is persistent - can not be changed later</li> <li>players - empty array - an array of players the playerset will contain</li> <li>symmetric - false - sets if the playerset will be symmetric (players in set can see other the players in set)</li>";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCOfflinePlayer[] players;
            String setID = args[0].val();
            CHDynmapStatic.testDynmapIDValidity(setID, t);
            if (CHDynmapStatic.getMarkerAPI(t).getPlayerSet(setID) != null) {
                throw new CREPluginInternalException("\"" + setID + "\" is already an existing playerset.", t);
            }
            CArray optionArray = args.length == 1 ? new CArray(t) : ArgumentValidation.getArray((Mixed)args[1], (Target)t);
            Set keys = optionArray.stringKeySet();
            if (keys.contains("players")) {
                CArray givenPlayers = ArgumentValidation.getArray((Mixed)optionArray.get("players", t), (Target)t);
                players = new MCOfflinePlayer[(int)givenPlayers.size()];
                if (givenPlayers.inAssociativeMode()) {
                    throw new CRECastException("The array must not be associative.", t);
                }
                int i = 0;
                for (Mixed player : givenPlayers.asList()) {
                    players[i] = Static.getServer().getOfflinePlayer(player.val());
                    ++i;
                }
            } else {
                players = new MCOfflinePlayer[]{};
            }
            boolean persistent = keys.contains("persistent") ? ArgumentValidation.getBooleanObject((Mixed)optionArray.get("persistent", t), (Target)t) : false;
            boolean symmetric = keys.contains("symmetric") ? ArgumentValidation.getBooleanObject((Mixed)optionArray.get("symmetric", t), (Target)t) : false;
            MCDynmapPlayerSet set = CHDynmapStatic.getMarkerAPI(t).createPlayerSet(setID, symmetric, players, persistent);
            if (set == null) {
                throw new CREPluginInternalException("The markerset creation failed.", t);
            }
            return new CString(set.getId(), t);
        }
    }

    @api
    public static class dm_all_playersets
    extends DynmapPlayerSetFunction {
        public String getName() {
            return "dm_all_playersets";
        }

        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class};
        }

        public String docs() {
            return "array {} Returns an array containing all the playerset IDs.";
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray setArray = new CArray(t);
            for (MCDynmapPlayerSet set : CHDynmapStatic.getMarkerAPI(t).getPlayerSets()) {
                setArray.push((Mixed)new CString(set.getId(), t), t);
            }
            return setArray;
        }
    }

    public static abstract class DynmapPlayerSetSetterFunction
    extends DynmapPlayerSetFunction {
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class, CRECastException.class};
        }
    }

    public static abstract class DynmapPlayerSetGetterFunction
    extends DynmapPlayerSetFunction {
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CRENotFoundException.class};
        }
    }

    public static abstract class DynmapPlayerSetFunction
    extends AbstractFunction {
        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }
    }
}

