/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chgeyser;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.UUID;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.connection.GeyserConnection;

public class Functions {
    public static String docs() {
        return "Provides Geyser functions for handling Bedrock clients.";
    }

    private static GeyserConnection GetGeyserConnection(Target t, Environment environment, Mixed ... args) {
        UUID uuid;
        if (args.length > 0) {
            uuid = Static.GetPlayer((String)args[0].val(), (Target)t).getUniqueID();
        } else {
            MCPlayer p = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
            if (p == null) {
                return null;
            }
            uuid = p.getUniqueID();
        }
        return GeyserApi.api().connectionByUuid(uuid);
    }

    @api
    public static class geyser_username_prefix
    extends GeyserFunction {
        public String getName() {
            return "geyser_username_prefix";
        }

        public String docs() {
            return "string {} Returns the username prefix defined in floodgate config, or null if one does not exist.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CString(GeyserApi.api().usernamePrefix(), t);
        }
    }

    @api
    public static class geyser_name
    extends GeyserFunction {
        public String getName() {
            return "geyser_name";
        }

        public String docs() {
            return "string {[player]} Returns the player's gamertag. Returns null if player is not using a bedrock client.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            GeyserConnection connection = Functions.GetGeyserConnection(t, environment, args);
            if (connection == null) {
                return CNull.NULL;
            }
            return new CString(connection.bedrockUsername(), t);
        }
    }

    @api
    public static class geyser_xuid
    extends GeyserFunction {
        public String getName() {
            return "geyser_xuid";
        }

        public String docs() {
            return "string {[player]} Returns the player's XUID. Returns null if player is not using a bedrock client.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            GeyserConnection connection = Functions.GetGeyserConnection(t, environment, args);
            if (connection == null) {
                return CNull.NULL;
            }
            return new CString(connection.xuid(), t);
        }
    }

    @api
    public static class geyser_input_mode
    extends GeyserFunction {
        public String getName() {
            return "geyser_input_mode";
        }

        public String docs() {
            return "string {[player]} Returns the player's client input mode. Will be null if player is not using a Bedrock client. Otherwise will return KEYBOARD_MOUSE, TOUCH, CONTROLLER, VR, or UNKNOWN.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            GeyserConnection connection = Functions.GetGeyserConnection(t, environment, args);
            if (connection == null) {
                return CNull.NULL;
            }
            return new CString(connection.inputMode().name(), t);
        }
    }

    @api
    public static class geyser_connected
    extends GeyserFunction {
        public String getName() {
            return "geyser_connected";
        }

        public String docs() {
            return "boolean {[player]} Returns whether a player is connected using a Bedrock client.";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get((Functions.GetGeyserConnection(t, environment, args) != null ? 1 : 0) != 0);
        }
    }

    public static abstract class GeyserFunction
    extends AbstractFunction {
        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_5;
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }
    }
}

