/*
 * Decompiled with CFR 0.152.
 */
package com.aczchef.chgp.functions;

import com.aczchef.chgp.util.Util;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class Functions {

    @api(environments={CommandHelperEnvironment.class})
    public static class has_gp_buildperm
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREFormatException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Player player;
            CArray array;
            if (args.length == 0) {
                throw new CREFormatException("Invalid arguments. Use [player,] location", t);
            }
            if (args.length == 1) {
                if (!(args[0] instanceof CArray)) throw new CREFormatException("Invalid arguments. Use [player,] location", t);
                array = (CArray)args[0];
                MCPlayer p = ((CommandHelperEnvironment)environment.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                if (p == null) {
                    throw new CREPlayerOfflineException("No player provided in this context.", t);
                }
                player = (Player)p.getHandle();
            } else {
                if (args.length != 2 || !(args[0] instanceof CString) || !(args[1] instanceof CArray)) throw new CREFormatException("Invalid arguments. Use [player,] location", t);
                player = Bukkit.getPlayer((String)args[0].val());
                array = (CArray)args[1];
                if (player == null) {
                    throw new CREPlayerOfflineException("Player is not online: " + args[0].val(), t);
                }
            }
            MCLocation loc = ObjectGenerator.GetGenerator().location((Mixed)array, null, t);
            Location location = ((BukkitMCLocation)loc).asLocation();
            Claim claim = GriefPrevention.instance.dataStore.getClaimAt(location, false, null);
            if (claim == null) {
                return CBoolean.TRUE;
            }
            String errorMessage = claim.allowBuild(player, Material.AIR);
            if (errorMessage != null) return CBoolean.FALSE;
            return CBoolean.TRUE;
        }

        public String getName() {
            return "has_gp_buildperm";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "boolean {[player,] location} See if a player can build at a given location.";
        }

        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class get_claim_info
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRECastException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Mixed exec(Target tar, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Claim c;
            if (args[0] instanceof CArray) {
                MCLocation l = ObjectGenerator.GetGenerator().location(args[0], null, tar);
                c = GriefPrevention.instance.dataStore.getClaimAt(Util.Location(l), true, null);
            } else {
                c = GriefPrevention.instance.dataStore.getClaim((long)ArgumentValidation.getInt32((Mixed)args[0], (Target)tar));
            }
            if (c == null) {
                return CNull.NULL;
            }
            CArray data = CArray.GetAssociativeArray((Target)tar);
            CArray corners = new CArray(tar);
            MCLocation corner1 = Util.Location(c.getLesserBoundaryCorner());
            MCLocation corner2 = Util.Location(c.getGreaterBoundaryCorner());
            corners.push((Mixed)ObjectGenerator.GetGenerator().location(corner1, false), tar);
            corners.push((Mixed)ObjectGenerator.GetGenerator().location(corner2, false), tar);
            data.set("corners", (Mixed)corners, tar);
            data.set("owner", (Mixed)new CString(c.getOwnerName(), tar), tar);
            data.set("isadmin", (Mixed)CBoolean.get((boolean)c.isAdminClaim()), tar);
            if (c.getID() == null) {
                data.set("parentId", (Mixed)new CInt(c.parent.getID().longValue(), tar), tar);
            } else {
                data.set("id", (Mixed)new CInt(c.getID().longValue(), tar), tar);
                CArray children = new CArray(tar);
                for (int i = 0; i < c.children.size(); ++i) {
                    CArray childData = new CArray(tar);
                    childData.set("owner", (Mixed)new CString(((Claim)c.children.get(i)).getOwnerName(), tar), tar);
                    children.push((Mixed)childData, tar);
                }
                data.set("subclaims", (Mixed)children, tar);
            }
            ArrayList<String> builders = new ArrayList<String>();
            ArrayList<String> containers = new ArrayList<String>();
            ArrayList<String> accessors = new ArrayList<String>();
            ArrayList<String> managers = new ArrayList<String>();
            c.getPermissions(builders, containers, accessors, managers);
            CArray perms = Util.formPermissions(builders, containers, accessors, managers, tar);
            data.set("permissions", (Mixed)perms, tar);
            return data;
        }

        public String getName() {
            return "get_claim_info";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "array {location | id} Returns an array of data about a claim. The following keys are present in the array: 'corners': (array) An array of two location arrays for each corner of the claim. 'owner': (string) The claim owner's name. 'isadmin': (boolean) Whether or not this is an administrative claim. 'permissions': (array) An associative array of arrays of permissions for 'builders', 'containers', 'accessors', and 'managers'. 'id': (int) The id of the claim (doesn't exist for subclaims). 'parentId': (int) The id of the parent claim (exists for subclaims only). 'subclaims': (array) An array of subclaim arrays, which contain the key 'owner'.";
        }

        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class get_claim_id
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRECastException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return false;
        }

        public Mixed exec(Target tar, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (!(args[0] instanceof CArray)) {
                throw new CRECastException("Expected argument 1 of get_claim_id to be an array", tar);
            }
            MCLocation l = ObjectGenerator.GetGenerator().location(args[0], null, tar);
            Claim c = GriefPrevention.instance.dataStore.getClaimAt(Util.Location(l), true, null);
            if (c == null) {
                return CNull.NULL;
            }
            if (c.getID() == null) {
                return new CInt(c.parent.getID().longValue(), tar);
            }
            return new CInt(c.getID().longValue(), tar);
        }

        public String getName() {
            return "get_claim_id";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "int {location} Gets the id of a claim at given location.";
        }

        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }
}

