/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chpaper.abstraction.paper;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import me.pseudoknight.chpaper.abstraction.paper.PaperEvents;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PaperListeners
implements Listener {
    private static PaperListeners listener;

    public static void register() {
        if (listener == null) {
            listener = new PaperListeners();
        }
        CommandHelperPlugin.self.registerEvents((Listener)listener);
    }

    public static void unregister() {
        BeaconEffectEvent.getHandlerList().unregister((Listener)listener);
        PlayerJumpEvent.getHandlerList().unregister((Listener)listener);
        PlayerElytraBoostEvent.getHandlerList().unregister((Listener)listener);
        EntityRemoveFromWorldEvent.getHandlerList().unregister((Listener)listener);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBeaconEffect(BeaconEffectEvent event) {
        PaperEvents.PaperBeaconEffectEvent be = new PaperEvents.PaperBeaconEffectEvent((Event)event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"beacon_effect", (BindableEvent)be);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJump(PlayerJumpEvent event) {
        PaperEvents.PaperPlayerJumpEvent pj = new PaperEvents.PaperPlayerJumpEvent(event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"player_jump", (BindableEvent)pj);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerArmorChange(PlayerArmorChangeEvent event) {
        PaperEvents.PaperPlayerArmorChangeEvent ac = new PaperEvents.PaperPlayerArmorChangeEvent(event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"player_armor_change", (BindableEvent)ac);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerBoosts(PlayerElytraBoostEvent event) {
        PaperEvents.PaperPlayerElytraBoostEvent peb = new PaperEvents.PaperPlayerElytraBoostEvent(event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"player_elytra_boost", (BindableEvent)peb);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityRemoveFromWorld(EntityRemoveFromWorldEvent event) {
        PaperEvents.PaperEntityRemoveFromWorldEvent peb = new PaperEvents.PaperEntityRemoveFromWorldEvent((Event)event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"entity_remove_from_world", (BindableEvent)peb);
    }
}

