/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chpaper;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.entities.MCFirework;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.BoundEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Prefilters;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;
import me.pseudoknight.chpaper.abstraction.MCBeaconEffectEvent;
import me.pseudoknight.chpaper.abstraction.MCEntityRemoveFromWorldEvent;
import me.pseudoknight.chpaper.abstraction.MCPlayerArmorChangeEvent;
import me.pseudoknight.chpaper.abstraction.MCPlayerElytraBoostEvent;
import me.pseudoknight.chpaper.abstraction.MCPlayerJumpEvent;

public class Events {
    public static String docs() {
        return "This augments CommandHelper with PaperSpigot-specific events";
    }

    @api
    public static class entity_remove_from_world
    extends AbstractEvent {
        public String getName() {
            return "entity_remove_from_world";
        }

        public String docs() {
            return "{id: <string> The entityID | type: <macro> The type of entity removing.} Fired any time an entity is being removed from a world for any reason {type | id: The entityID} {} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            String id;
            if (!(e instanceof MCEntityRemoveFromWorldEvent)) {
                return false;
            }
            MCEntityRemoveFromWorldEvent event = (MCEntityRemoveFromWorldEvent)e;
            if (prefilter.containsKey("id") && !(id = prefilter.get("id").val()).equals(event.getEntityUniqueId().toString())) {
                return false;
            }
            Prefilters.match(prefilter, (String)"type", (String)event.getEntityType().name(), (Prefilters.PrefilterType)Prefilters.PrefilterType.MACRO);
            return true;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            MCEntityRemoveFromWorldEvent event = (MCEntityRemoveFromWorldEvent)e;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Target t = Target.UNKNOWN;
            map.put("type", (Mixed)new CString(event.getEntityType().name(), t));
            map.put("id", (Mixed)new CString(event.getEntityUniqueId().toString(), t));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent e) {
            return false;
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class player_elytra_boost
    extends AbstractEvent {
        public String getName() {
            return "player_elytra_boost";
        }

        public String docs() {
            return "{player: <string match> The player boosting.} This event is called when a player boosts using a firework while gliding.{player | consume: Whether or not the firework item will be consumed. | firework: The entity id of the firework created. | item: The item array of the firework used.}{consume} {}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (!(e instanceof MCPlayerElytraBoostEvent)) {
                return false;
            }
            MCPlayerElytraBoostEvent event = (MCPlayerElytraBoostEvent)e;
            return !prefilter.containsKey("player") || event.getPlayer().getName().equals(prefilter.get("player").val());
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            MCPlayerElytraBoostEvent event = (MCPlayerElytraBoostEvent)e;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Target t = Target.UNKNOWN;
            map.put("player", (Mixed)new CString(event.getPlayer().getName(), t));
            map.put("consume", (Mixed)CBoolean.get((boolean)event.willConsumeItem()));
            map.put("firework", (Mixed)new CString(event.getFirework().getUniqueId().toString(), t));
            map.put("item", (Mixed)ObjectGenerator.GetGenerator().item(event.getItemStack(), t));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent e) {
            MCPlayerElytraBoostEvent event = (MCPlayerElytraBoostEvent)e;
            if (key.equals("consume")) {
                Target t = value.getTarget();
                event.setConsumeItem(ArgumentValidation.getBooleanObject((Mixed)value, (Target)t));
                return true;
            }
            return false;
        }

        public void preExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
            if (activeEvent.getUnderlyingEvent() instanceof MCPlayerElytraBoostEvent) {
                MCFirework entity = ((MCPlayerElytraBoostEvent)activeEvent.getUnderlyingEvent()).getFirework();
                Static.InjectEntity((MCEntity)entity);
            }
        }

        public void postExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
            if (activeEvent.getUnderlyingEvent() instanceof MCPlayerElytraBoostEvent) {
                MCFirework entity = ((MCPlayerElytraBoostEvent)activeEvent.getUnderlyingEvent()).getFirework();
                Static.UninjectEntity((MCEntity)entity);
            }
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class player_armor_change
    extends AbstractEvent {
        public String getName() {
            return "player_armor_change";
        }

        public String docs() {
            return "{player: <string match> The player whose armor slot changed.} This event is called when a player's armor slot changes by any cause, including function.{player | olditem: The item array for the old item (or null) | newitem: The item array for the new item (or null) | slottype: The armor slot changed (HEAD, CHEST, LEGS, FEET)} {} {}";
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (!(e instanceof MCPlayerArmorChangeEvent)) {
                return false;
            }
            MCPlayerArmorChangeEvent event = (MCPlayerArmorChangeEvent)e;
            return !prefilter.containsKey("player") || event.getPlayer().getName().equals(prefilter.get("player").val());
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            MCPlayerArmorChangeEvent event = (MCPlayerArmorChangeEvent)e;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Target t = Target.UNKNOWN;
            map.put("player", (Mixed)new CString(event.getPlayer().getName(), t));
            map.put("olditem", (Mixed)ObjectGenerator.GetGenerator().item(event.getOldItem(), t));
            map.put("newitem", (Mixed)ObjectGenerator.GetGenerator().item(event.getNewItem(), t));
            map.put("slottype", (Mixed)new CString(event.getSlotType(), t));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent e) {
            return false;
        }
    }

    @api
    public static class player_jump
    extends AbstractEvent {
        public String getName() {
            return "player_jump";
        }

        public String docs() {
            return "{player: <string match> The player jumping.} This event is called when a player jumps. {player | from: The location from which the player is jumping. | to: The location the player is moving to.} {from} {}";
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (!(e instanceof MCPlayerJumpEvent)) {
                return false;
            }
            MCPlayerJumpEvent event = (MCPlayerJumpEvent)e;
            return !prefilter.containsKey("player") || event.getPlayer().getName().equals(prefilter.get("player").val());
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            MCPlayerJumpEvent event = (MCPlayerJumpEvent)e;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Target t = Target.UNKNOWN;
            map.put("player", (Mixed)new CString(event.getPlayer().getName(), t));
            map.put("from", (Mixed)ObjectGenerator.GetGenerator().location(event.getFrom()));
            map.put("to", (Mixed)ObjectGenerator.GetGenerator().location(event.getTo()));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent e) {
            MCPlayerJumpEvent event = (MCPlayerJumpEvent)e;
            if (key.equals("from")) {
                Target t = value.getTarget();
                event.setFrom(ObjectGenerator.GetGenerator().location(value, null, t));
                return true;
            }
            return false;
        }
    }

    @api
    public static class beacon_effect
    extends AbstractEvent {
        public String getName() {
            return "beacon_effect";
        }

        public String docs() {
            return "{} This event is called when beacon effect is applied to a player. {player: The player the effect is being applied to. | location: The location of the beacon. | effect: The array of the potion effect being applied to the player. | primary: Whether or not the effect is the primary effect from the beacon.} {effect} {}";
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Version since() {
            return MSVersion.V3_3_2;
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            return e instanceof MCBeaconEffectEvent;
        }

        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            MCBeaconEffectEvent event = (MCBeaconEffectEvent)e;
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            Target t = Target.UNKNOWN;
            map.put("player", (Mixed)new CString(event.getPlayer().getName(), t));
            map.put("location", (Mixed)ObjectGenerator.GetGenerator().location(event.getBlock().getLocation()));
            MCLivingEntity.MCEffect eff = event.getEffect();
            CArray effect = CArray.GetAssociativeArray((Target)t);
            effect.set("id", (Mixed)new CInt((long)eff.getPotionEffectType().getId(), t), t);
            effect.set("strength", (Mixed)new CInt((long)eff.getStrength(), t), t);
            effect.set("seconds", (Mixed)new CDouble((double)eff.getTicksRemaining() / 20.0, t), t);
            effect.set("ambient", (Mixed)CBoolean.get((boolean)eff.isAmbient()), t);
            effect.set("particles", (Mixed)CBoolean.get((boolean)eff.hasParticles()), t);
            map.put("effect", (Mixed)effect);
            map.put("primary", (Mixed)CBoolean.get((boolean)event.isPrimary()));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent e) {
            MCBeaconEffectEvent event = (MCBeaconEffectEvent)e;
            if (key.equals("effect")) {
                Target t = value.getTarget();
                if (value instanceof CArray) {
                    CArray ca = (CArray)value;
                    int id = ArgumentValidation.getInt32((Mixed)ca.get("id", t), (Target)t);
                    int strength = ArgumentValidation.getInt32((Mixed)ca.get("strength", t), (Target)t);
                    double seconds = ArgumentValidation.getDouble((Mixed)ca.get("seconds", t), (Target)t);
                    boolean ambient = ArgumentValidation.getBooleanObject((Mixed)ca.get("ambient", t), (Target)t);
                    boolean particles = ArgumentValidation.getBooleanObject((Mixed)ca.get("particles", t), (Target)t);
                    event.setEffect(id, strength, (int)(seconds * 20.0), ambient, particles);
                    return true;
                }
                throw new CRECastException("Effect must be an array", t);
            }
            return false;
        }
    }
}

