/*
 * Decompiled with CFR 0.152.
 */
package me.pseudoknight.chregionchange;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.BoundEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.sk89q.worldguard.session.MoveType;
import java.util.HashMap;
import java.util.Map;
import me.pseudoknight.chregionchange.RegionChangeBindableEvent;

public class RegionChangeEvents {

    @api
    public static class region_change
    extends AbstractEvent {
        public BindableEvent convert(CArray arg, Target t) {
            throw new UnsupportedOperationException("This is not supported at this time.");
        }

        public String docs() {
            return "{} Fires when a player moves to a block with a different region set than they are currently in. {player | from: locationArray | to: locationArray | fromRegions:  An array that may contain regions the player is leaving | toRegions: An array that may contain regions the player is entering | type: The type of event that triggered this. (RESPAWN, EMBARK, MOVE, GLIDE, SWIM, TELEPORT, RIDE, OTHER_NON_CANCELLABLE, or OTHER_CANCELLABLE)} {} {}";
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            if (event instanceof RegionChangeBindableEvent) {
                RegionChangeBindableEvent e = (RegionChangeBindableEvent)event;
                Target t = Target.UNKNOWN;
                HashMap<String, Mixed> ret = new HashMap<String, Mixed>();
                ret.put("player", (Mixed)new CString(e.getPlayer().getName(), t));
                ret.put("from", (Mixed)ObjectGenerator.GetGenerator().location(e.getFrom()));
                ret.put("to", (Mixed)ObjectGenerator.GetGenerator().location(e.getTo()));
                ret.put("fromRegions", (Mixed)e.getFromRegions(t));
                ret.put("toRegions", (Mixed)e.getToRegions(t));
                ret.put("type", (Mixed)new CString(e.getMoveType().name(), t));
                return ret;
            }
            throw new EventException("Not a proper region change event.");
        }

        public String getName() {
            return "region_change";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            return event instanceof RegionChangeBindableEvent;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        public Version since() {
            return MSVersion.V3_3_1;
        }

        public void preExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
            RegionChangeBindableEvent bindableEvent;
            BindableEvent bindableEvent2 = activeEvent.getUnderlyingEvent();
            if (bindableEvent2 instanceof RegionChangeBindableEvent && (bindableEvent = (RegionChangeBindableEvent)bindableEvent2).getMoveType() == MoveType.RESPAWN) {
                MCPlayer player = bindableEvent.getPlayer();
                Static.InjectPlayer((MCCommandSender)player);
            }
        }

        public void postExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
            RegionChangeBindableEvent bindableEvent;
            BindableEvent bindableEvent2 = activeEvent.getUnderlyingEvent();
            if (bindableEvent2 instanceof RegionChangeBindableEvent && (bindableEvent = (RegionChangeBindableEvent)bindableEvent2).getMoveType() == MoveType.RESPAWN) {
                MCPlayer player = bindableEvent.getPlayer();
                Static.UninjectPlayer((MCCommandSender)player);
            }
        }
    }
}

