/*
 * Decompiled with CFR 0.152.
 */
package com.entityreborn.communication;

import com.entityreborn.communication.Publisher;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class NodePoint {
    protected ZMQ.Socket socket;
    private boolean isInited = false;
    protected Thread owningThread;
    protected boolean alive = true;
    protected int type;

    protected void cleanup() {
        try {
            this.socket.setLinger(1);
            this.socket.close();
            this.socket = null;
        }
        catch (Exception e) {
            Logger.getLogger(NodePoint.class.getName()).log(Level.WARNING, "Exception while closing node:", e);
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void connect(String endpoint) {
        this.socket.setLinger(-1);
        this.socket.connect(endpoint);
    }

    public void disconnect(String endpoint) {
        this.socket.disconnect(endpoint);
    }

    public void listen(String endpoint) {
        this.socket.setLinger(-1);
        this.socket.bind(endpoint);
    }

    public boolean isInitialized() {
        return this.isInited;
    }

    protected void init(ZContext context, int type) {
        if (this.isInited) {
            return;
        }
        this.type = type;
        this.socket = context.createSocket(type);
        this.isInited = true;
    }

    public void start() {
        this.owningThread.start();
    }

    public void stop() {
        this.alive = false;
        if (this instanceof Publisher) {
            this.owningThread.interrupt();
        }
    }

    public ZMQ.Socket getSocket() {
        return this.socket;
    }
}

