/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.extensions.chsc;

import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.events.Prefilters;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Map;

public class Events {
    private static void fireEvent(DaemonManager daemon, final BindableEvent event, final String name) {
        if (daemon == null) {
            return;
        }
        StaticLayer.GetConvertor().runOnMainThreadLater(daemon, new Runnable(){

            @Override
            public void run() {
                EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)name, (BindableEvent)event);
            }
        });
    }

    public static void fireReceived(DaemonManager daemon, String subscriber, String channel, String publisher, String message) {
        if (daemon == null) {
            return;
        }
        RecvEvent event = new RecvEvent(subscriber, channel, publisher, message);
        Events.fireEvent(daemon, event, "comm_received");
    }

    private static class RecvEvent
    implements BindableEvent {
        private final String subscriber;
        private final String channel;
        private final String publisher;
        private final String message;

        public RecvEvent(String subscriber, String channel, String publisher, String message) {
            this.subscriber = subscriber;
            this.channel = channel;
            this.publisher = publisher;
            this.message = message;
        }

        public Object _GetObject() {
            return this;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public String getSubscriber() {
            return this.subscriber;
        }

        public String getMessage() {
            return this.message;
        }
    }

    @api
    public static class srvcom_received
    extends AbstractEvent {
        public String getName() {
            return "comm_received";
        }

        public String docs() {
            return "{channel: <string match> | publisherid: <string match> | subscriberid: <string match>} Fired when a message is received by a SUB socket. {channel: The channel this message was directed to | publisherid: The name of the publisher who sent this message | subscriberid: The name of the subscriber who received this message | message: The message itself} {channel|publisherid|subscriberid}";
        }

        public boolean matches(Map<String, Mixed> prefilter, BindableEvent event) throws PrefilterNonMatchException {
            if (event instanceof RecvEvent) {
                RecvEvent e = (RecvEvent)event;
                Prefilters.match(prefilter, (String)"channel", (String)e.getChannel(), (Prefilters.PrefilterType)Prefilters.PrefilterType.STRING_MATCH);
                Prefilters.match(prefilter, (String)"publisherid", (String)e.getPublisher(), (Prefilters.PrefilterType)Prefilters.PrefilterType.STRING_MATCH);
                Prefilters.match(prefilter, (String)"subscriberid", (String)e.getSubscriber(), (Prefilters.PrefilterType)Prefilters.PrefilterType.STRING_MATCH);
                return true;
            }
            return false;
        }

        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }

        public Map<String, Mixed> evaluate(BindableEvent event) throws EventException {
            if (event instanceof RecvEvent) {
                RecvEvent e = (RecvEvent)event;
                Map map = this.evaluate_helper(event);
                map.put("channel", new CString(e.getChannel(), Target.UNKNOWN));
                map.put("publisherid", new CString(e.getPublisher(), Target.UNKNOWN));
                map.put("subscriberid", new CString(e.getSubscriber(), Target.UNKNOWN));
                map.put("message", new CString(e.getMessage(), Target.UNKNOWN));
                return map;
            }
            throw new EventException("Cannot convert e to RecvEvent");
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }

        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }
}

