/*
 * Decompiled with CFR 0.152.
 */
package com.entityreborn.communication;

import com.entityreborn.communication.Exceptions;
import com.entityreborn.communication.NodePoint;
import com.entityreborn.communication.Util;
import com.laytonsmith.extensions.chsc.Tracking;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.json.simple.JSONObject;
import org.zeromq.ZAuth;
import org.zeromq.ZCertStore;
import org.zeromq.ZContext;
import org.zeromq.ZMQException;

public class Publisher
extends NodePoint
implements Runnable {
    private final String publisherId;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

    public Publisher(String id) {
        if (id.contains("\u0000")) {
            throw new IllegalArgumentException("Cannot use \\0 in a publishers ID!");
        }
        this.publisherId = id;
        this.owningThread = new Thread((Runnable)this, "publisher-" + this.publisherId);
    }

    public void init(ZContext context) {
        super.init(context, 1);
        this.socket.setIdentity(this.publisherId.getBytes());
    }

    public void publish(String channel, String message) throws Exceptions.InvalidChannelException, Exceptions.InvalidNameException {
        this.publish(channel, message, this.publisherId);
    }

    public void publish(String channel, String message, String origpub) throws Exceptions.InvalidNameException, Exceptions.InvalidChannelException {
        String chan = channel.trim();
        if (!Util.isValidName(origpub)) {
            throw new Exceptions.InvalidNameException(origpub);
        }
        if (!Util.isValidChannel(channel)) {
            throw new Exceptions.InvalidChannelException(channel);
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)"channel", (Object)chan);
        obj.put((Object)"publisherid", (Object)origpub);
        obj.put((Object)"message", (Object)message);
        String tosend = obj.toJSONString();
        this.queue.add(tosend);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted() && this.alive) {
            String tosend;
            try {
                tosend = this.queue.take();
            }
            catch (InterruptedException ex) {
                break;
            }
            if (tosend == null) continue;
            try {
                this.socket.send(tosend, 0);
            }
            catch (ZMQException e) {
                break;
            }
        }
        this.cleanup();
    }

    public static void main(String[] args) throws InterruptedException, Exceptions.InvalidChannelException, Exceptions.InvalidNameException {
        ZContext context = new ZContext(1);
        ZAuth auth = new ZAuth(context, (ZCertStore.Fingerprinter)new ZCertStore.Hasher());
        auth.setVerbose(true);
        Tracking.setContext(context);
        Tracking.setAuthenticator(auth);
        NodePoint np = Tracking.getOrCreate(null, 1, "publisher");
        Publisher pub = (Publisher)np;
        Tracking.getAuthenticator().configureCurve("C:\\temp\\certs");
        pub.getSocket().setCurveServer(true);
        pub.getSocket().setCurvePublicKey("lN*r8I=:FuY@FZ&Mdn]HoOE!v@jx7kJ##Pf{S9>l".getBytes());
        pub.getSocket().setCurveSecretKey("^ddCQsU-ofAh(QMhwrvKFzauJ+}H-yzhH[7AK?^C".getBytes());
        pub.init(context);
        pub.listen("tcp://*:5556");
        pub.start();
        for (int i = 0; i < 100; ++i) {
            System.out.println("Publishing " + i);
            pub.publish("SomeChannel", "data " + i);
            Thread.sleep(1000L);
        }
        pub.stop();
        auth.destroy();
        context.destroy();
    }
}

