/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Prefs;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FileOptions {
    @Option(value="Strict Mode On")
    private final Boolean strict;
    @Option(value="Suppressed Warnings")
    private final Set<SuppressWarning> suppressWarnings;
    @Option(value="File Name")
    private final String name;
    @Option(value="Author")
    private final String author;
    @Option(value="Creation Date")
    private final String created;
    @Option(value="File Description")
    private final String description;
    @Option(value="Required Extensions")
    private final Set<String> requiredExtensions;
    @Option(value="Compiler Options")
    private final Set<CompilerOption> compilerOptions;
    @Option(value="Copyright information")
    private final String copyright;
    @Option(value="Distribution License Information")
    private final String license;
    @Option(value="Disables undefined proc errors in the typechecker")
    private final Boolean allDynamicProcs;
    private final Map<String, String> rawOptions;

    public FileOptions(Map<String, String> parsedOptions) {
        this.rawOptions = new HashMap<String, String>(parsedOptions);
        this.strict = this.parseBoolean(this.getDefault(parsedOptions, "strict", null));
        this.suppressWarnings = this.parseEnumSet(this.getDefault(parsedOptions, "suppresswarnings", ""), SuppressWarning.class);
        this.name = this.getDefault(parsedOptions, "name", "").trim();
        this.author = this.getDefault(parsedOptions, "author", "").trim();
        this.created = this.getDefault(parsedOptions, "created", "").trim();
        this.description = this.getDefault(parsedOptions, "description", "").trim();
        this.requiredExtensions = Collections.unmodifiableSet(this.parseSet(this.getDefault(parsedOptions, "requiredextensions", "")));
        this.compilerOptions = this.parseEnumSet(this.getDefault(parsedOptions, "compileroptions", ""), CompilerOption.class);
        this.copyright = this.getDefault(parsedOptions, "copyright", "").trim();
        this.license = this.getDefault(parsedOptions, "license", "").trim();
        this.allDynamicProcs = this.parseBoolean(this.getDefault(parsedOptions, "allDynamicProcs", null));
    }

    private String getDefault(Map<String, String> map, String key, String defaultIfNone) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultIfNone;
    }

    private Boolean parseBoolean(String bool) {
        if (bool == null) {
            return null;
        }
        return !bool.equalsIgnoreCase("false") && !bool.equalsIgnoreCase("off");
    }

    private List<String> parseList(String list) {
        ArrayList<String> l = new ArrayList<String>();
        for (String part : list.split(",")) {
            if (part.trim().isEmpty()) continue;
            l.add(part.trim().toLowerCase());
        }
        return l;
    }

    private Set<String> parseSet(String list) {
        return new HashSet<String>(this.parseList(list));
    }

    private <T extends Enum<T>> Set<T> parseEnumSet(String list, Class<T> type) {
        EnumSet<T> set = EnumSet.noneOf(type);
        List<String> sList = this.parseList(list);
        block0: for (String s : sList) {
            for (Enum e : (Enum[])type.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(s)) continue;
                set.add(e);
                continue block0;
            }
        }
        return set;
    }

    public boolean isStrict() {
        if (this.strict != null) {
            return this.strict;
        }
        return Prefs.StrictMode();
    }

    public boolean isWarningSuppressed(SuppressWarning warning) {
        return this.suppressWarnings.contains(warning);
    }

    public boolean hasCompilerOption(CompilerOption option) {
        return this.compilerOptions.contains(option);
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean requiresExtensions() {
        return !this.requiredExtensions.isEmpty();
    }

    public Set<String> getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public String getLicense() {
        return this.license;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public boolean isAllDynamicProcs() {
        return this.allDynamicProcs;
    }

    public Map<String, String> getRawOptions() {
        return new HashMap<String, String>(this.rawOptions);
    }

    public static List<String> getKnownOptions() {
        ArrayList<String> list = new ArrayList<String>();
        for (Field f : ClassDiscovery.getDefaultInstance().loadFieldsWithAnnotation(Option.class)) {
            list.add(f.getName());
        }
        return list;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Field f : ClassDiscovery.getDefaultInstance().loadFieldsWithAnnotation(Option.class)) {
            String desc = f.getAnnotation(Option.class).value();
            try {
                b.append(desc).append(": ").append(f.get(this)).append("; ");
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
        return b.toString();
    }

    public static enum SuppressWarning implements Documentation
    {
        UnreachableCode("Code that comes after methods such as return() or exit() won't be run, and represents dead code, which should usually be removed, or can represent an error with your branching logic.", MSVersion.V3_3_4, SeverityLevel.MEDIUM),
        HardcodedDynamicParameter("Code that is hardcoded and sent to eval is going to perform worse than simply writing the code normally.", MSVersion.V3_3_4, SeverityLevel.HIGH),
        OverrideArguments("Defining a variable called @arguments overrides the built in @arguments value, making it impossible to access.", MSVersion.V3_3_4, SeverityLevel.HIGH),
        UseBareStrings("Using bare strings can cause code to error or worse silently change behavior when using future versions of MethodScript that introduce new keywords. Therefore, it is always recommended to quote all strings. In strict mode, this is always an error that can't be suppressed.", MSVersion.V3_3_4, SeverityLevel.HIGH),
        IncludedFileNotFound("When an include is encountered by the compiler, it checks to ensure that the file being included exists. It doesn't actually need to exist until runtime, but a warning is issued at compile time if it can't be found.", MSVersion.V3_3_4, SeverityLevel.MEDIUM),
        CodeUpgradeNotices("Code that uses old formats should generally be upgraded to newer versions. This is encouraged to make code more readable, and is not a deprecation notice. This type of warning is only displayed in strict mode, and is even still suppressible.", MSVersion.V3_3_4, SeverityLevel.LOW),
        UseOfSecureString("When storing sensitive information such as passwords, it is advisable to use the secure_string class instead of string. There is first class language support for this in many places, but in general makes it harder to accidentally leak sensitive data in for example log messages, even when passing the data around to code that accepts strings.", MSVersion.V3_3_4, SeverityLevel.MEDIUM),
        FutureNestedCommentChange("In version 3.3.6 or later, nested comment blocks will be allowed. This will cause the code here to suddenly change behavior by opening a new comment block, which will never be closed (as that's impossible with 3.3.5 behavior). If you accept that this will suddenly break in a future upgrade, you may do nothing now and deal with it later by closing the comment, but this (suppressable)  warning is provided now during a phase in period in case you would like to deal with it by removing the opening comment symbol.", MSVersion.V3_3_5, SeverityLevel.HIGH),
        UselessCode("The code or element at this location serves no purpose, and should be removed. Its existence may indicate a problem with the code.", MSVersion.V3_3_5, SeverityLevel.MEDIUM),
        UnexpectedStatement("In strict mode, unexpected statements are an error, but in non-strict mode, they are a warning.", MSVersion.V3_3_5, SeverityLevel.HIGH),
        PossibleUnexpectedExecution("If the parenthesis following a token is on a different line as the previous token, and it in general looks like a value that might be executable, this warning is issued, as it will cause an attempt at executing the previous statement. This warning will be removed in 3.3.7, and code will always attempt to execute, but in the meantime, to get rid of it, place a semicolon at the end of the previous line (if you don't mean for it to be executed) or move the left parenthesis up to the same line (if you  do mean for it to be executed).", MSVersion.V3_3_5, SeverityLevel.HIGH),
        MalformedComment("The comment related to this element is malformed.", MSVersion.V3_3_5, SeverityLevel.HIGH),
        FutureError("This warning will be changed into a compile error in future versions, and should not be suppressed.", MSVersion.V3_3_5, SeverityLevel.HIGH);

        private final String docs;
        private final Version version;
        private final SeverityLevel severityLevel;

        private SuppressWarning(String docs, Version version, SeverityLevel severityLevel) {
            this.docs = docs;
            this.version = version;
            this.severityLevel = severityLevel;
        }

        @Override
        public URL getSourceJar() {
            return ClassDiscovery.GetClassContainer(this.getClass());
        }

        @Override
        public Class<? extends Documentation>[] seeAlso() {
            return new Class[0];
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String docs() {
            return this.docs;
        }

        @Override
        public Version since() {
            return this.version;
        }

        public SeverityLevel getSeverityLevel() {
            return this.severityLevel;
        }
    }

    public static enum CompilerOption implements Documentation
    {
        AllowAmbiguousCommands("Disables compiler validation for ambiguous commands (only applicable to MSA files).", MSVersion.V3_3_4),
        UltraStrict("Provides an extra strict programming environment. Nitpicky details may be covered in ultra strict mode, and will turn almost all warnings into compiler errors. This will also apply all lint settings that would be warnings into errors as well, and is generally the most pedantic version of strict mode available. This is used in native code, but is not necessarily recommended, since it offers no flexibility, however, code that passes ultra strict mode will generally be considered \"ideal\" code, and enshrines the standard code layout. Warnings that are explicitly suppressed are not errors in this mode.", MSVersion.V3_3_4);

        private final String docs;
        private final Version version;

        private CompilerOption(String docs, Version version) {
            this.docs = docs;
            this.version = version;
        }

        @Override
        public URL getSourceJar() {
            return ClassDiscovery.GetClassContainer(this.getClass());
        }

        @Override
        public Class<? extends Documentation>[] seeAlso() {
            return new Class[0];
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String docs() {
            return this.docs;
        }

        @Override
        public Version since() {
            return this.version;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Option {
        public String value();
    }

    public static enum SeverityLevel {
        HIGH,
        MEDIUM,
        LOW;

    }
}

