/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.JavaVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public final class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static final Preferences USER_ROOT = Preferences.userRoot();
    private static final Preferences SYSTEM_ROOT = Preferences.systemRoot();
    private static final Class<? extends Preferences> USER_CLASS = USER_ROOT.getClass();
    private static final boolean USE_LONG_HANDLES = JavaVersion.GetMajorVersion() >= 11;
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    private WinRegistry() {
    }

    public static String readString(long hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646L) {
            return WinRegistry.readString(SYSTEM_ROOT, hkey, key, valueName);
        }
        if (hkey == -2147483647L) {
            return WinRegistry.readString(USER_ROOT, hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(Preferences root, long hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        byte[] valb;
        if (USE_LONG_HANDLES) {
            long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
            if (handles[1] != 0L) {
                return null;
            }
            valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        } else {
            int[] handles = (int[])regOpenKey.invoke((Object)root, (int)hkey, WinRegistry.toCstr(key), 131097);
            if (handles[1] != 0) {
                return null;
            }
            valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        }
        return valb != null ? new String(valb).trim() : null;
    }

    public static Map<String, String> readStringValues(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646L) {
            return WinRegistry.readStringValues(SYSTEM_ROOT, hkey, key);
        }
        if (hkey == -2147483647L) {
            return WinRegistry.readStringValues(USER_ROOT, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static Map<String, String> readStringValues(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        if (USE_LONG_HANDLES) {
            long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
            if (handles[1] != 0L) {
                return null;
            }
            long[] info = (long[])regQueryInfoKey.invoke((Object)root, handles[0]);
            int count = (int)info[0];
            int maxlen = (int)info[3];
            for (int index = 0; index < count; ++index) {
                byte[] name = (byte[])regEnumValue.invoke((Object)root, handles[0], index, maxlen + 1);
                String value = WinRegistry.readString(hkey, key, new String(name));
                results.put(new String(name).trim(), value);
            }
            regCloseKey.invoke((Object)root, handles[0]);
        } else {
            int[] handles = (int[])regOpenKey.invoke((Object)root, (int)hkey, WinRegistry.toCstr(key), 131097);
            if (handles[1] != 0) {
                return null;
            }
            int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
            int count = info[0];
            int maxlen = info[3];
            for (int index = 0; index < count; ++index) {
                byte[] name = (byte[])regEnumValue.invoke((Object)root, handles[0], index, maxlen + 1);
                String value = WinRegistry.readString(hkey, key, new String(name));
                results.put(new String(name).trim(), value);
            }
            regCloseKey.invoke((Object)root, handles[0]);
        }
        return results;
    }

    public static List<String> readStringSubKeys(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646L) {
            return WinRegistry.readStringSubKeys(SYSTEM_ROOT, hkey, key);
        }
        if (hkey == -2147483647L) {
            return WinRegistry.readStringSubKeys(USER_ROOT, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static List<String> readStringSubKeys(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        if (USE_LONG_HANDLES) {
            long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
            if (handles[1] != 0L) {
                return null;
            }
            long[] info = (long[])regQueryInfoKey.invoke((Object)root, handles[0]);
            int count = (int)info[0];
            int maxlen = (int)info[3];
            for (int index = 0; index < count; ++index) {
                byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
                results.add(new String(name).trim());
            }
            regCloseKey.invoke((Object)root, handles[0]);
        } else {
            int[] handles = (int[])regOpenKey.invoke((Object)root, (int)hkey, WinRegistry.toCstr(key), 131097);
            if (handles[1] != 0) {
                return null;
            }
            int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
            int count = info[0];
            int maxlen = info[3];
            for (int index = 0; index < count; ++index) {
                byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
                results.add(new String(name).trim());
            }
            regCloseKey.invoke((Object)root, handles[0]);
        }
        return results;
    }

    public static void createKey(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long rc;
        Preferences prefs;
        if (hkey == -2147483646L) {
            prefs = SYSTEM_ROOT;
        } else if (hkey == -2147483647L) {
            prefs = USER_ROOT;
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        if (USE_LONG_HANDLES) {
            long[] ret = (long[])WinRegistry.createKey(prefs, hkey, key);
            regCloseKey.invoke((Object)prefs, ret[0]);
            rc = ret[1];
        } else {
            int[] ret = (int[])WinRegistry.createKey(prefs, hkey, key);
            regCloseKey.invoke((Object)prefs, ret[0]);
            rc = ret[1];
        }
        if (rc != 0L) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    private static Object createKey(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (USE_LONG_HANDLES) {
            return (long[])regCreateKeyEx.invoke((Object)root, hkey, WinRegistry.toCstr(key));
        }
        return (int[])regCreateKeyEx.invoke((Object)root, (int)hkey, WinRegistry.toCstr(key));
    }

    public static void writeStringValue(long hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646L) {
            WinRegistry.writeStringValue(SYSTEM_ROOT, hkey, key, valueName, value);
        } else if (hkey == -2147483647L) {
            WinRegistry.writeStringValue(USER_ROOT, hkey, key, valueName, value);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
    }

    private static void writeStringValue(Preferences root, long hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (USE_LONG_HANDLES) {
            long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 983103);
            regSetValueEx.invoke((Object)root, handles[0], WinRegistry.toCstr(valueName), WinRegistry.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        } else {
            int[] handles = (int[])regOpenKey.invoke((Object)root, (int)hkey, WinRegistry.toCstr(key), 983103);
            regSetValueEx.invoke((Object)root, handles[0], WinRegistry.toCstr(valueName), WinRegistry.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        }
    }

    public static void deleteKey(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == -2147483646L) {
            rc = WinRegistry.deleteKey(SYSTEM_ROOT, hkey, key);
        } else if (hkey == -2147483647L) {
            rc = WinRegistry.deleteKey(USER_ROOT, hkey, key);
        }
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    private static int deleteKey(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Integer)regDeleteKey.invoke((Object)root, USE_LONG_HANDLES ? hkey : (long)((int)hkey), WinRegistry.toCstr(key));
    }

    public static void deleteValue(long hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == -2147483646L) {
            rc = WinRegistry.deleteValue(SYSTEM_ROOT, hkey, key, value);
        } else if (hkey == -2147483647L) {
            rc = WinRegistry.deleteValue(USER_ROOT, hkey, key, value);
        }
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private static int deleteValue(Preferences root, long hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc;
        if (USE_LONG_HANDLES) {
            long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 983103);
            if (handles[1] != 0L) {
                return (int)handles[1];
            }
            rc = (Integer)regDeleteValue.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        } else {
            int[] handles = (int[])regOpenKey.invoke((Object)root, (int)hkey, WinRegistry.toCstr(key), 983103);
            if (handles[1] != 0) {
                return handles[1];
            }
            rc = (Integer)regDeleteValue.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        }
        return rc;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    static {
        try {
            Class<Number> handleClass = USE_LONG_HANDLES ? Long.TYPE : Integer.TYPE;
            regOpenKey = USER_CLASS.getDeclaredMethod("WindowsRegOpenKey", handleClass, byte[].class, Integer.TYPE);
            regCloseKey = USER_CLASS.getDeclaredMethod("WindowsRegCloseKey", handleClass);
            regQueryValueEx = USER_CLASS.getDeclaredMethod("WindowsRegQueryValueEx", handleClass, byte[].class);
            regEnumValue = USER_CLASS.getDeclaredMethod("WindowsRegEnumValue", handleClass, Integer.TYPE, Integer.TYPE);
            regQueryInfoKey = USER_CLASS.getDeclaredMethod("WindowsRegQueryInfoKey1", handleClass);
            regEnumKeyEx = USER_CLASS.getDeclaredMethod("WindowsRegEnumKeyEx", handleClass, Integer.TYPE, Integer.TYPE);
            regCreateKeyEx = USER_CLASS.getDeclaredMethod("WindowsRegCreateKeyEx", handleClass, byte[].class);
            regSetValueEx = USER_CLASS.getDeclaredMethod("WindowsRegSetValueEx", handleClass, byte[].class, byte[].class);
            regDeleteValue = USER_CLASS.getDeclaredMethod("WindowsRegDeleteValue", handleClass, byte[].class);
            regDeleteKey = USER_CLASS.getDeclaredMethod("WindowsRegDeleteKey", handleClass, byte[].class);
            regOpenKey.setAccessible(true);
            regCloseKey.setAccessible(true);
            regQueryValueEx.setAccessible(true);
            regEnumValue.setAccessible(true);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx.setAccessible(true);
            regDeleteValue.setAccessible(true);
            regDeleteKey.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new Error(e);
        }
    }
}

