/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.List;

public final class GCUtil {
    private static boolean debug = false;

    private GCUtil() {
    }

    public static void main(String[] args) {
        debug = true;
        GCUtil.BlockUntilGC();
    }

    public static void BlockUntilGC() {
        GCUtil.BlockUntilGC(0);
    }

    public static void BlockUntilGC(int timeout) {
        GarbageCollectorMXBean g22;
        block6: {
            long start = System.currentTimeMillis();
            long finish = start + (long)timeout;
            GCUtil.debug(() -> "Starting (now: " + start + "; stopping at: " + finish + ")");
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            for (String arg : arguments) {
                if (!arg.matches("(?i)\\+DisableExplicitGC")) continue;
                GCUtil.debug(() -> "Found +DisableExplicitGC, returning with no action.");
                return;
            }
            List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
            if (gcs.size() == 1) {
                GCUtil.debug(() -> ((GarbageCollectorMXBean)gcs.get(0)).getObjectName().getCanonicalName());
                if (gcs.get(0).getObjectName().getCanonicalName().equals("java.lang:name=Epsilon Heap,type=GarbageCollector")) {
                    throw new UnsupportedOperationException("Cannot continue, Epsilon GC is the only garbage collector.");
                }
            }
            HashMap<GarbageCollectorMXBean, Long> startCounts = new HashMap<GarbageCollectorMXBean, Long>();
            for (GarbageCollectorMXBean gc : gcs) {
                GCUtil.debug(() -> "Found GC " + String.valueOf(gc.getObjectName()) + " with run count " + gc.getCollectionCount());
                startCounts.put(gc, gc.getCollectionCount());
            }
            GCUtil.debug(() -> "Starting free memory: " + GCUtil.h(Runtime.getRuntime().freeMemory()));
            do {
                System.gc();
                for (GarbageCollectorMXBean g22 : gcs) {
                    GCUtil.debug(() -> "Checking " + String.valueOf(g22.getObjectName()) + ". Run count: " + g22.getCollectionCount() + ". Current free memory: " + GCUtil.h(Runtime.getRuntime().freeMemory()) + ". Total GC Count " + ManagementFactory.getGarbageCollectorMXBeans().size() + ". Heap: " + GCUtil.h(Runtime.getRuntime().totalMemory()) + "/" + GCUtil.h(Runtime.getRuntime().maxMemory()));
                    if (g22.getCollectionCount() <= (Long)startCounts.get(g22)) continue;
                    break block6;
                }
            } while (System.currentTimeMillis() <= finish);
            GCUtil.debug(() -> "I've waited too long, so I'm giving up now.");
            return;
        }
        GCUtil.debug(() -> "Found that " + String.valueOf(g22.getObjectName()) + " has run, returning");
    }

    private static String h(long n) {
        return StringUtils.HumanReadableByteCount(n);
    }

    private static void debug(StringProvider msg2) {
        if (debug) {
            System.out.println(msg2.provide());
        }
    }

    private static interface StringProvider {
        public String provide();
    }
}

