/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.taskmanager;

import com.laytonsmith.core.taskmanager.TaskHandler;
import com.laytonsmith.core.taskmanager.TaskManager;
import com.laytonsmith.core.taskmanager.TaskState;
import com.laytonsmith.core.taskmanager.TaskStateChangeListener;
import com.laytonsmith.core.taskmanager.TaskType;
import java.util.ArrayList;
import java.util.List;

public class TaskManagerImpl
implements TaskManager {
    private final List<TaskHandler> tasks = new ArrayList<TaskHandler>();

    @Override
    public synchronized List<TaskHandler> getTasks() {
        return new ArrayList<TaskHandler>(this.tasks);
    }

    @Override
    public synchronized TaskHandler getTask(TaskType type, int id) {
        for (TaskHandler task : this.getTasks()) {
            if (!task.getType().equals(type) || task.getID() != id) continue;
            return task;
        }
        return null;
    }

    @Override
    public synchronized TaskHandler getTask(String type, int id) {
        for (TaskHandler task : this.getTasks()) {
            if (!task.getType().name().equals(type) || task.getID() != id) continue;
            return task;
        }
        return null;
    }

    @Override
    public void killTask(TaskType type, int id) {
        TaskHandler task = this.getTask(type, id);
        if (task != null) {
            task.kill();
        }
    }

    @Override
    public void killTask(String type, int id) {
        TaskHandler task = this.getTask(type, id);
        if (task != null) {
            task.kill();
        }
    }

    @Override
    public synchronized void addTask(TaskHandler task) {
        task.addStateChangeListener(new TaskStateChangeListener(){

            @Override
            public void taskStateChanged(TaskState from, TaskHandler task) {
                if (task.getState().isFinalized()) {
                    TaskManagerImpl.this.tasks.remove(task);
                }
            }
        });
        this.tasks.add(task);
    }
}

