/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.com.mysql.cj.protocol.a.authentication;

import com.laytonsmith.libs.com.mysql.cj.callback.MysqlCallbackHandler;
import com.laytonsmith.libs.com.mysql.cj.callback.UsernameCallback;
import com.laytonsmith.libs.com.mysql.cj.protocol.AuthenticationPlugin;
import com.laytonsmith.libs.com.mysql.cj.protocol.Protocol;
import com.laytonsmith.libs.com.mysql.cj.protocol.Security;
import com.laytonsmith.libs.com.mysql.cj.protocol.a.NativeConstants;
import com.laytonsmith.libs.com.mysql.cj.protocol.a.NativePacketPayload;
import java.util.List;

public class MysqlNativePasswordPlugin
implements AuthenticationPlugin<NativePacketPayload> {
    public static String PLUGIN_NAME = "mysql_native_password";
    private Protocol<NativePacketPayload> protocol = null;
    private MysqlCallbackHandler usernameCallbackHandler = null;
    private String password = null;

    @Override
    public void init(Protocol<NativePacketPayload> prot, MysqlCallbackHandler cbh) {
        this.protocol = prot;
        this.usernameCallbackHandler = cbh;
    }

    @Override
    public void destroy() {
        this.reset();
        this.protocol = null;
        this.usernameCallbackHandler = null;
        this.password = null;
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user2, String password) {
        this.password = password;
        if (user2 == null && this.usernameCallbackHandler != null) {
            this.usernameCallbackHandler.handle(new UsernameCallback(System.getProperty("user.name")));
        }
    }

    @Override
    public boolean nextAuthenticationStep(NativePacketPayload fromServer, List<NativePacketPayload> toServer) {
        toServer.clear();
        NativePacketPayload packet = null;
        String pwd2 = this.password;
        packet = fromServer == null || pwd2 == null || pwd2.length() == 0 ? new NativePacketPayload(new byte[0]) : new NativePacketPayload(Security.scramble411(pwd2, fromServer.readBytes(NativeConstants.StringSelfDataType.STRING_TERM), this.protocol.getServerSession().getCharsetSettings().getPasswordCharacterEncoding()));
        toServer.add(packet);
        return true;
    }
}

