/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCParticleData;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.bukkit.BukkitMCColor;
import com.laytonsmith.abstraction.bukkit.BukkitMCVibration;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;

public class BukkitMCParticle
extends MCParticle<Particle> {
    private static final Map<Particle, MCParticle> BUKKIT_MAP = new EnumMap<Particle, MCParticle>(Particle.class);

    public BukkitMCParticle(MCParticle.MCVanillaParticle vanillaParticle, Particle particle) {
        super(vanillaParticle, particle);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCParticle.MCVanillaParticle.UNKNOWN ? ((Particle)this.getConcrete()).name() : this.getAbstracted().name();
    }

    public static MCParticle valueOfConcrete(Particle test) {
        MCParticle type = BUKKIT_MAP.get(test);
        if (type == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Particle missing in BUKKIT_MAP: " + test.name(), Target.UNKNOWN);
            return new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        for (MCParticle.MCVanillaParticle mCVanillaParticle : MCParticle.MCVanillaParticle.values()) {
            Particle type;
            if (!mCVanillaParticle.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                type = Particle.valueOf((String)mCVanillaParticle.name());
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit Particle for " + mCVanillaParticle.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCParticle wrapper = new BukkitMCParticle(mCVanillaParticle, type);
            BUKKIT_MAP.put(type, wrapper);
            MAP.put(mCVanillaParticle.name(), wrapper);
        }
        for (MCParticle.MCVanillaParticle mCVanillaParticle : Particle.values()) {
            if (mCVanillaParticle.name().startsWith("LEGACY_") || BUKKIT_MAP.containsKey((Object)mCVanillaParticle)) continue;
            MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find MCParticle for " + mCVanillaParticle.name(), Target.UNKNOWN);
            BukkitMCParticle wrapper = new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, (Particle)mCVanillaParticle);
            MAP.put(mCVanillaParticle.name(), wrapper);
            BUKKIT_MAP.put((Particle)mCVanillaParticle, wrapper);
        }
    }

    public Object getParticleData(MCLocation l, Object data) {
        switch (this.getAbstracted()) {
            case BLOCK_DUST: 
            case BLOCK_CRACK: 
            case BLOCK_CRUMBLE: 
            case BLOCK_MARKER: 
            case DUST_PILLAR: 
            case FALLING_DUST: {
                if (data instanceof MCBlockData) {
                    return ((MCBlockData)data).getHandle();
                }
                if (this.getAbstracted() == MCParticle.MCVanillaParticle.BLOCK_MARKER) {
                    return Material.BARRIER.createBlockData();
                }
                return Material.STONE.createBlockData();
            }
            case ITEM_CRACK: {
                ItemStack is = data instanceof MCItemStack ? (ItemStack)((MCItemStack)data).getHandle() : new ItemStack(Material.STONE, 1);
                return is;
            }
            case SPELL_MOB: 
            case TINTED_LEAVES: {
                if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) break;
                if (data instanceof MCColor) {
                    return BukkitMCColor.GetColor((MCColor)data);
                }
                return Color.WHITE;
            }
            case REDSTONE: {
                if (data instanceof MCColor) {
                    return new Particle.DustOptions(BukkitMCColor.GetColor((MCColor)data), 1.0f);
                }
                return new Particle.DustOptions(Color.RED, 1.0f);
            }
            case DUST_COLOR_TRANSITION: {
                if (data instanceof MCParticleData.DustTransition) {
                    MCParticleData.DustTransition transition = (MCParticleData.DustTransition)data;
                    return new Particle.DustTransition(BukkitMCColor.GetColor(transition.from()), BukkitMCColor.GetColor(transition.to()), 1.0f);
                }
                return new Particle.DustTransition(Color.TEAL, Color.RED, 1.0f);
            }
            case VIBRATION: {
                BukkitMCVibration vibe;
                if (data instanceof MCParticleData.VibrationBlockDestination) {
                    MCParticleData.VibrationBlockDestination destination = (MCParticleData.VibrationBlockDestination)data;
                    vibe = new BukkitMCVibration(l, destination.location(), destination.arrivalTime());
                } else if (data instanceof MCParticleData.VibrationEntityDestination) {
                    MCParticleData.VibrationEntityDestination destination = (MCParticleData.VibrationEntityDestination)data;
                    vibe = new BukkitMCVibration(l, destination.entity(), destination.arrivalTime());
                } else {
                    vibe = new BukkitMCVibration(l, l, 5);
                }
                return vibe.getHandle();
            }
            case SCULK_CHARGE: {
                if (data instanceof Float) {
                    return data;
                }
                return Float.valueOf(0.0f);
            }
            case SHRIEK: {
                if (data instanceof Integer) {
                    return data;
                }
                return 0;
            }
            case TRAIL: {
                if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_4)) {
                    if (data instanceof MCParticleData.Trail) {
                        MCParticleData.Trail trail = (MCParticleData.Trail)data;
                        return new Particle.Trail((Location)trail.location().getHandle(), BukkitMCColor.GetColor(trail.color()), trail.duration());
                    }
                    return new Particle.Trail((Location)l.getHandle(), Color.fromRGB((int)252, (int)120, (int)18), new Random().nextInt(40) + 10);
                }
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("org.bukkit.Particle$TargetColor");
                    Constructor<?> constructor = clazz.getConstructor(Location.class, Color.class);
                    constructor.setAccessible(true);
                    if (data instanceof MCParticleData.Trail) {
                        MCParticleData.Trail trail = (MCParticleData.Trail)data;
                        return constructor.newInstance((Location)trail.location().getHandle(), BukkitMCColor.GetColor(trail.color()));
                    }
                    return constructor.newInstance((Location)l.getHandle(), Color.fromRGB((int)252, (int)120, (int)18));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

