/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.core.asm.LLVMEnvironment;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import java.util.Arrays;
import java.util.List;

public final class AsmUtil {
    private AsmUtil() {
    }

    public static String emitIR(Target t, Environment env, String ... lines) {
        return AsmUtil.emitIR(t, env, Arrays.asList(lines));
    }

    public static String emitIR(Target t, Environment env, List<String> lines) {
        LLVMEnvironment llvmenv = env.getEnv(LLVMEnvironment.class);
        StringBuilder b = new StringBuilder();
        for (String line : lines) {
            if ("".equals(line.trim())) continue;
            b.append(AsmUtil.formatLine(t, llvmenv, line, 0));
        }
        return b.toString();
    }

    public static String formatLine(Target t, LLVMEnvironment llvmenv, String line, int commentTab) {
        Object s = "";
        if (!line.endsWith(":")) {
            s = (String)s + "  ";
        }
        s = (String)s + line;
        if (llvmenv.isOutputIRCodeTargetLoggingEnabled()) {
            if (((String)s).length() < commentTab) {
                s = (String)s + StringUtils.stringMultiply(commentTab - ((String)s).length(), " ");
            }
            s = (String)s + " ; " + t.toString();
        }
        s = (String)s + OSUtils.GetLineEnding();
        return s;
    }

    public static String getIRType(String irLine) {
        return irLine.split(" ")[0];
    }
}

